/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.composite.PropertySheet;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;

public class PropertySheetModifier
implements ICellModifier {
    private PropertySheet m_viewer;

    public PropertySheetModifier(PropertySheet viewer) {
        this.m_viewer = viewer;
    }

    public boolean canModify(Object element, String property) {
        if (property == "value" && element instanceof Property) {
            Property nodeProperty = (Property)element;
            if (nodeProperty.getModify() == 1) {
                CellEditor cellEditor = nodeProperty.getCellEditor();
                if (cellEditor.getControl() == null || cellEditor.getControl().isDisposed()) {
                    cellEditor.dispose();
                    cellEditor.create((Composite)this.m_viewer.getTableTree().getTable());
                    nodeProperty.initEditer();
                }
                CellEditor[] cellEditorArray = new CellEditor[2];
                cellEditorArray[1] = cellEditor;
                CellEditor[] editors = cellEditorArray;
                this.m_viewer.setCellEditors(editors);
                return true;
            }
            if (nodeProperty.getEditor().compareTo("com.clustercontrol.composite.TextAreaPropertyDefine") == 0) {
                CellEditor cellEditor = nodeProperty.getCellEditor();
                if (cellEditor.getControl() == null || cellEditor.getControl().isDisposed()) {
                    cellEditor.dispose();
                    cellEditor.create((Composite)this.m_viewer.getTableTree().getTable());
                    nodeProperty.initEditer();
                }
                CellEditor[] cellEditorArray = new CellEditor[2];
                cellEditorArray[1] = cellEditor;
                CellEditor[] editors = cellEditorArray;
                this.m_viewer.setCellEditors(editors);
                return true;
            }
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        if (property == "value" && element instanceof Property) {
            Property nodeProperty = (Property)element;
            return nodeProperty.getModifyValue();
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        if (property == "value" && element instanceof Item && (element = ((Item)element).getData()) instanceof Property) {
            Property nodeProperty = (Property)element;
            nodeProperty.modify(value);
            this.m_viewer.expandToLevel(nodeProperty, 1);
            this.m_viewer.refresh();
        }
    }
}

