/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.composite;

import com.clustercontrol.notify.action.GetNotify;
import com.clustercontrol.notify.dialog.NotifyCreateDialog;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NotifyIdListComposite
extends Composite {
    private Label labelNotifyId = null;
    private Combo comboNotifyId = null;
    private Button buttonRefer = null;

    public NotifyIdListComposite(Composite parent, int style, boolean labelFlg) {
        super(parent, style);
        this.initialize(parent, labelFlg);
    }

    private void initialize(Composite parent, boolean labelFlg) {
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = labelFlg ? 15 : 10;
        this.setLayout((Layout)layout);
        if (labelFlg) {
            this.labelNotifyId = new Label((Composite)this, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 5;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.labelNotifyId.setLayoutData((Object)gridData);
            this.labelNotifyId.setText(String.valueOf(Messages.getString((String)"notify.id")) + " : ");
        }
        this.comboNotifyId = new Combo((Composite)this, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.comboNotifyId.setLayoutData((Object)gridData);
        this.buttonRefer = new Button((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.buttonRefer.setLayoutData((Object)gridData);
        this.buttonRefer.setText(Messages.getString((String)"refer"));
        this.buttonRefer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String notifyId = NotifyIdListComposite.this.comboNotifyId.getText();
                if (notifyId != null && !"".equals(notifyId.trim())) {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    NotifyCreateDialog dialog = new NotifyCreateDialog(shell, notifyId, true);
                    dialog.open();
                }
            }
        });
        this.update();
    }

    public void update() {
        this.comboNotifyId.add("");
        ArrayList list = new GetNotify().getNotifyIdList();
        if (list != null) {
            int index = 0;
            while (index < list.size()) {
                this.comboNotifyId.add((String)list.get(index));
                ++index;
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.comboNotifyId.setEnabled(enabled);
        this.buttonRefer.setEnabled(enabled);
    }

    public String getText() {
        return this.comboNotifyId.getText();
    }

    public void setText(String string) {
        this.comboNotifyId.setText(string);
    }
}

