/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.view;

import com.clustercontrol.performance.composite.CollectionListComposite;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.view.CommonViewPart;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CurrentListView
extends CommonViewPart {
    public static final String ID = Messages.getString("VIEW_CURRENT_LIST");
    private CollectionListComposite tableComposite = null;

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.tableComposite = new CollectionListComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.tableComposite.setLayoutData(gridData);
        this.tableComposite.getTableViewer().getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CurrentListView.this.setEnabledAction(CurrentListView.this.tableComposite.getRunStatus());
            }
        });
        this.refresh();
    }

    public void refresh() {
        this.tableComposite.update();
    }

    public String getSelectedID() {
        return this.tableComposite.getSelectedID();
    }

    public void setEnabledAction(int status) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem stopCollectorAction = (ActionContributionItem)toolbar.find("com.clustercontrol.performance.view.action.StopCollectorAction");
        ActionContributionItem showPropertyAction = (ActionContributionItem)toolbar.find("com.clustercontrol.performance.view.action.ShowPropertyAction");
        ActionContributionItem viewCurrentGraphAction = (ActionContributionItem)toolbar.find("com.clustercontrol.performance.view.action.ViewCurrentGraphAction");
        ActionContributionItem exportCollectedDataAction = (ActionContributionItem)toolbar.find("com.clustercontrol.performance.view.action.ExportCollectedDataAction");
        ActionContributionItem deleteCollectedDataAction = (ActionContributionItem)toolbar.find("com.clustercontrol.performance.view.action.DeleteCollectedDataAction");
        stopCollectorAction.getAction().setEnabled(false);
        showPropertyAction.getAction().setEnabled(false);
        viewCurrentGraphAction.getAction().setEnabled(false);
        exportCollectedDataAction.getAction().setEnabled(false);
        deleteCollectedDataAction.getAction().setEnabled(false);
        if (status == 100) {
            stopCollectorAction.getAction().setEnabled(true);
            showPropertyAction.getAction().setEnabled(true);
            viewCurrentGraphAction.getAction().setEnabled(true);
        } else if (status == 300) {
            showPropertyAction.getAction().setEnabled(true);
            viewCurrentGraphAction.getAction().setEnabled(true);
            exportCollectedDataAction.getAction().setEnabled(true);
            deleteCollectedDataAction.getAction().setEnabled(true);
        } else if (status != 200 && status == 400) {
            stopCollectorAction.getAction().setEnabled(true);
            showPropertyAction.getAction().setEnabled(true);
            viewCurrentGraphAction.getAction().setEnabled(true);
            exportCollectedDataAction.getAction().setEnabled(true);
            deleteCollectedDataAction.getAction().setEnabled(true);
        }
    }
}

