/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.ejb.session;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.collectiverun.bean.DetailTableDefine;
import com.clustercontrol.collectiverun.bean.HistoryTableDefine;
import com.clustercontrol.collectiverun.bean.TypeMstConstant;
import com.clustercontrol.collectiverun.ejb.session.CollectiveRunControllerLocal;
import com.clustercontrol.collectiverun.ejb.session.CollectiveRunControllerUtil;
import com.clustercontrol.collectiverun.factory.HistoryFilterProperty;
import com.clustercontrol.collectiverun.factory.OperationRun;
import com.clustercontrol.collectiverun.factory.ParameterProperty;
import com.clustercontrol.collectiverun.factory.SelectSession;
import com.clustercontrol.collectiverun.util.QuartzUtil;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.apllog.AplLogger;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;

public abstract class CollectiveRunControllerBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(CollectiveRunControllerBean.class);
    public static final String GROUP_NAME = "CRUN_MANAGEMENT";

    public ArrayList getHistoryTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(HistoryTableDefine.STATUS, new TableColumnInfo(Messages.getString((String)"run.status", (Locale)locale), 14, 80, 16384));
        tableDefine.add(HistoryTableDefine.SESSION_ID, new TableColumnInfo(Messages.getString((String)"session.id", (Locale)locale), -1, 140, 16384));
        tableDefine.add(HistoryTableDefine.START_TIME, new TableColumnInfo(Messages.getString((String)"start.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(HistoryTableDefine.END_TIME, new TableColumnInfo(Messages.getString((String)"end.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(HistoryTableDefine.TYPE, new TableColumnInfo(Messages.getString((String)"type", (Locale)locale), -1, 100, 16384));
        tableDefine.add(HistoryTableDefine.NAME, new TableColumnInfo(Messages.getString((String)"name", (Locale)locale), -1, 140, 16384));
        tableDefine.add(HistoryTableDefine.FACILITY_ID, new TableColumnInfo(Messages.getString((String)"facility.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(HistoryTableDefine.SCOPE, new TableColumnInfo(Messages.getString((String)"scope", (Locale)locale), 2, 150, 16384));
        tableDefine.add(HistoryTableDefine.TOTAL, new TableColumnInfo(Messages.getString((String)"total", (Locale)locale), -1, 50, 16384));
        tableDefine.add(HistoryTableDefine.NORMAL, new TableColumnInfo(Messages.getString((String)"successful", (Locale)locale), -1, 50, 16384));
        tableDefine.add(HistoryTableDefine.WARNING, new TableColumnInfo(Messages.getString((String)"warning", (Locale)locale), -1, 50, 16384));
        tableDefine.add(HistoryTableDefine.ABNORMAL, new TableColumnInfo(Messages.getString((String)"failed", (Locale)locale), -1, 50, 16384));
        tableDefine.add(HistoryTableDefine.WAITING, new TableColumnInfo(Messages.getString((String)"waiting", (Locale)locale), -1, 50, 16384));
        tableDefine.add(HistoryTableDefine.RUNNING, new TableColumnInfo(Messages.getString((String)"running", (Locale)locale), -1, 50, 16384));
        return tableDefine;
    }

    public ArrayList getDetailTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(DetailTableDefine.STATUS, new TableColumnInfo(Messages.getString((String)"run.status", (Locale)locale), 14, 80, 16384));
        tableDefine.add(DetailTableDefine.END_STATUS, new TableColumnInfo(Messages.getString((String)"end.status", (Locale)locale), 11, 70, 16384));
        tableDefine.add(DetailTableDefine.RETURN_VALUE, new TableColumnInfo(Messages.getString((String)"return.value", (Locale)locale), -1, 50, 16384));
        tableDefine.add(DetailTableDefine.FACILITY_ID, new TableColumnInfo(Messages.getString((String)"facility.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(DetailTableDefine.FACILITY_NAME, new TableColumnInfo(Messages.getString((String)"facility.name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(DetailTableDefine.START_TIME, new TableColumnInfo(Messages.getString((String)"start.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(DetailTableDefine.END_TIME, new TableColumnInfo(Messages.getString((String)"end.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(DetailTableDefine.MESSAGE, new TableColumnInfo(Messages.getString((String)"message", (Locale)locale), -1, 300, 16384));
        return tableDefine;
    }

    public Property getParameterProperty(String sessionId, Locale locale) {
        ParameterProperty propaerty = new ParameterProperty();
        return propaerty.getProperty(sessionId, locale);
    }

    public Property getParameterProperty(int type, Locale locale) {
        ParameterProperty propaerty = new ParameterProperty();
        return propaerty.getProperty(type, locale);
    }

    public int getParameterType(String sessionId) {
        ParameterProperty propaerty = new ParameterProperty();
        return propaerty.getType(sessionId);
    }

    public Property getHistoryFilterProperty(Locale locale) {
        HistoryFilterProperty history = new HistoryFilterProperty();
        return history.getProperty(locale);
    }

    public ArrayList getHistoryList(Locale locale) throws FinderException, NamingException {
        SelectSession select = new SelectSession();
        return select.getHistoryList(locale);
    }

    public ArrayList getHistoryList(Property property, Locale locale) throws FinderException, NamingException {
        SelectSession select = new SelectSession();
        return select.getHistoryList(property, locale);
    }

    public ArrayList getDetailList(String sessionId, Locale locale) throws FinderException, NamingException {
        SelectSession select = new SelectSession();
        return select.getDetailList(sessionId, locale);
    }

    public void run(int type, Property property, Locale locale) throws Exception {
        String sessionId;
        CollectiveRunControllerLocal controller = CollectiveRunControllerUtil.getLocalHome().create();
        try {
            sessionId = controller.createSession(type, property, locale);
        }
        catch (Exception e) {
            AplLogger apllog = new AplLogger("CR", "cr");
            apllog.put("SYS", "002");
            throw e;
        }
        try {
            controller.run(sessionId);
        }
        catch (Exception e) {
            AplLogger apllog = new AplLogger("CR", "cr");
            apllog.put("SYS", "001");
            throw e;
        }
    }

    public String createSession(int type, Property property, Locale locale) throws CreateException, FinderException, NamingException {
        OperationRun operation = new OperationRun();
        return operation.createSession(TypeMstConstant.typeToId(type), property, locale);
    }

    public void run(String sessionId) throws CreateException, FinderException, NamingException, IOException {
        OperationRun operation = new OperationRun();
        operation.run(sessionId);
    }

    public void endNode(RunResultInfo info) throws FinderException, NamingException {
        OperationRun operation = new OperationRun();
        operation.endNode(info);
    }

    public void checkEndSession() throws FinderException, NamingException {
        OperationRun operation = new OperationRun();
        operation.checkEndSession();
    }

    public void addQuartz(String cronString) throws NamingException, ParseException, SchedulerException {
        QuartzManager manager = QuartzUtil.getQuartzManager();
        try {
            manager.deleteSchedule("CollectiveRunController", GROUP_NAME);
        }
        catch (SchedulerException e) {
            m_log.debug((Object)("addQuartz() : deleteJob error = " + e.getMessage()));
        }
        catch (RemoteException e) {
            // empty catch block
        }
        JobDetail job = new JobDetail("CollectiveRunController", GROUP_NAME, EJBInvokerJob.class);
        String serverName = System.getProperty("jboss.server.name");
        if (serverName.equals("all")) {
            job.getJobDataMap().put("java.naming.provider.url", "jnp://localhost:1100");
        }
        job.setDurability(true);
        job.setRequestsRecovery(true);
        job.getJobDataMap().put("ejb", "CollectiveRunController");
        job.getJobDataMap().put("method", "checkEndSession");
        Object[] jdArgs = new Object[]{};
        job.getJobDataMap().put((Object)"args", (Object)jdArgs);
        CronTrigger cronTrigger = new CronTrigger("CollectiveRunController", GROUP_NAME);
        cronTrigger.setCronExpression(cronString);
        try {
            manager.addSchedule(job, (Trigger)cronTrigger);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void deleteQuartz() throws NamingException, ParseException, SchedulerException {
        QuartzManager manager = QuartzUtil.getQuartzManager();
        try {
            manager.deleteSchedule("CollectiveRunController", GROUP_NAME);
        }
        catch (SchedulerException e) {
            m_log.debug((Object)("deleteQuartz() : deleteJob error = " + e.getMessage()));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

