/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.composite;

import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.repository.action.GetNodeScope;
import com.clustercontrol.repository.action.GetNodeScopeTableDefine;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class NodeScopeComposite
extends Composite {
    private Label facilityIdLabel = null;
    private Label facilityNameLabel = null;
    private CommonTableViewer tableViewer = null;

    public NodeScopeComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.facilityIdLabel = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.facilityIdLabel.setLayoutData((Object)gridData);
        this.facilityNameLabel = new Label((Composite)this, 16384);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.facilityNameLabel.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetNodeScopeTableDefine.get(), 0, 1);
        this.update();
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void update(String facilityId, String facilityName) {
        ArrayList data = null;
        if (facilityId != null) {
            data = new GetNodeScope().getNodeScope(facilityId);
            this.facilityIdLabel.setText(String.valueOf(Messages.getString((String)"facility.id")) + " : " + facilityId);
        } else {
            this.facilityIdLabel.setText(String.valueOf(Messages.getString((String)"facility.id")) + " : ");
        }
        if (facilityName != null) {
            this.facilityNameLabel.setText(String.valueOf(Messages.getString((String)"facility.name")) + " : " + facilityName);
        } else {
            this.facilityNameLabel.setText(String.valueOf(Messages.getString((String)"facility.name")) + " : ");
        }
        if (data == null) {
            data = new ArrayList();
        }
        this.tableViewer.setInput(data);
    }
}

