/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.WorkbenchPlugin;

final class ContextPersistence {
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_PARENT = "parent";
    private static final String ATTRIBUTE_PARENT_ID = "parentId";
    private static final String ATTRIBUTE_PARENT_SCOPE = "parentScope";
    private static final String ELEMENT_ACCELERATOR_SCOPE = "acceleratorScope";
    private static final String ELEMENT_CONTEXT = "context";
    private static final String ELEMENT_SCOPE = "scope";
    private static final String EXTENSION_ACCELERATOR_SCOPES = "org.eclipse.ui.acceleratorScopes";
    private static final String EXTENSION_COMMANDS = "org.eclipse.ui.commands";
    private static final String EXTENSION_CONTEXTS = "org.eclipse.ui.contexts";
    private static final int INDEX_CONTEXT_DEFINITIONS = 0;
    private static boolean listenersAttached = false;

    private static final void addElementToIndexedArray(IConfigurationElement elementToAdd, IConfigurationElement[][] indexedArray, int index, int currentCount) {
        IConfigurationElement[] elements;
        if (currentCount == 0) {
            elements = new IConfigurationElement[1];
            indexedArray[index] = elements;
        } else if (currentCount >= indexedArray[index].length) {
            IConfigurationElement[] copy = new IConfigurationElement[indexedArray[index].length * 2];
            System.arraycopy(indexedArray[index], 0, copy, 0, currentCount);
            elements = copy;
            indexedArray[index] = elements;
        } else {
            elements = indexedArray[index];
        }
        elements[currentCount] = elementToAdd;
    }

    static final void read(final ContextManager contextManager) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        int contextDefinitionCount = 0;
        IConfigurationElement[][] indexedConfigurationElements = new IConfigurationElement[1][];
        IConfigurationElement[] acceleratorScopesExtensionPoint = registry.getConfigurationElementsFor(EXTENSION_ACCELERATOR_SCOPES);
        int i = 0;
        while (i < acceleratorScopesExtensionPoint.length) {
            IConfigurationElement configurationElement = acceleratorScopesExtensionPoint[i];
            String name = configurationElement.getName();
            if (ELEMENT_ACCELERATOR_SCOPE.equals(name)) {
                ContextPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 0, contextDefinitionCount++);
            }
            ++i;
        }
        IConfigurationElement[] commandsExtensionPoint = registry.getConfigurationElementsFor(EXTENSION_COMMANDS);
        int i2 = 0;
        while (i2 < commandsExtensionPoint.length) {
            IConfigurationElement configurationElement = commandsExtensionPoint[i2];
            String name = configurationElement.getName();
            if (ELEMENT_SCOPE.equals(name)) {
                ContextPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 0, contextDefinitionCount++);
            } else if (ELEMENT_CONTEXT.equals(name)) {
                ContextPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 0, contextDefinitionCount++);
            }
            ++i2;
        }
        IConfigurationElement[] contextsExtensionPoint = registry.getConfigurationElementsFor(EXTENSION_CONTEXTS);
        int i3 = 0;
        while (i3 < contextsExtensionPoint.length) {
            IConfigurationElement configurationElement = contextsExtensionPoint[i3];
            String name = configurationElement.getName();
            if (ELEMENT_CONTEXT.equals(name)) {
                ContextPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 0, contextDefinitionCount++);
            }
            ++i3;
        }
        ContextPersistence.readContextsFromExtensionPoint(indexedConfigurationElements[0], contextDefinitionCount, contextManager);
        if (!listenersAttached) {
            registry.addRegistryChangeListener(new IRegistryChangeListener(){

                public final void registryChanged(IRegistryChangeEvent event) {
                    IExtensionDelta[] commandDeltas;
                    IExtensionDelta[] contextDeltas;
                    IExtensionDelta[] acceleratorScopeDeltas = event.getExtensionDeltas("org.eclipse.ui", "acceleratorScopes");
                    if (acceleratorScopeDeltas.length == 0 && (contextDeltas = event.getExtensionDeltas("org.eclipse.ui", "contexts")).length == 0 && (commandDeltas = event.getExtensionDeltas("org.eclipse.ui", "commands")).length == 0) {
                        return;
                    }
                    Display.getDefault().asyncExec(new Runnable(this, contextManager){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ ContextManager val$contextManager;
                        {
                            this.this$1 = var1_1;
                            this.val$contextManager = contextManager;
                        }

                        public void run() {
                            ContextPersistence.read(this.val$contextManager);
                        }
                    });
                }
            }, "org.eclipse.ui");
            listenersAttached = true;
        }
    }

    private static final void readContextsFromExtensionPoint(IConfigurationElement[] configurationElements, int configurationElementCount, ContextManager contextManager) {
        Set contextIds = contextManager.getDefinedContextIds();
        if (contextIds != null) {
            Iterator contextIdItr = contextIds.iterator();
            Context[] contexts = new Context[contextIds.size()];
            int i = 0;
            while (contextIdItr.hasNext()) {
                contexts[i++] = contextManager.getContext((String)contextIdItr.next());
            }
            int j = 0;
            while (j < contexts.length) {
                contexts[j].undefine();
                ++j;
            }
        }
        ArrayList<Status> warningsToLog = new ArrayList<Status>(1);
        int i = 0;
        while (i < configurationElementCount) {
            IConfigurationElement configurationElement = configurationElements[i];
            String contextId = configurationElement.getAttribute(ATTRIBUTE_ID);
            if (contextId == null || contextId.length() == 0) {
                String message = "Contexts need an id: plug-in='" + configurationElement.getNamespace() + "'.";
                Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                warningsToLog.add(status);
            } else {
                String name = configurationElement.getAttribute(ATTRIBUTE_NAME);
                if (name == null || name.length() == 0) {
                    String message = "Contexts need a name: plug-in='" + configurationElement.getNamespace() + "', contextId='" + contextId + "'.";
                    Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                    warningsToLog.add(status);
                } else {
                    String parentId;
                    String description = configurationElement.getAttribute(ATTRIBUTE_DESCRIPTION);
                    if (description != null && description.length() == 0) {
                        description = null;
                    }
                    if (!((parentId = configurationElement.getAttribute(ATTRIBUTE_PARENT_ID)) != null && parentId.length() != 0 || (parentId = configurationElement.getAttribute(ATTRIBUTE_PARENT)) != null && parentId.length() != 0)) {
                        parentId = configurationElement.getAttribute(ATTRIBUTE_PARENT_SCOPE);
                    }
                    if (parentId != null && parentId.length() == 0) {
                        parentId = null;
                    }
                    Context context = contextManager.getContext(contextId);
                    context.define(name, description, parentId);
                }
            }
            ++i;
        }
        if (!warningsToLog.isEmpty()) {
            MultiStatus status = new MultiStatus(WorkbenchPlugin.PI_WORKBENCH, 0, warningsToLog.toArray(new IStatus[warningsToLog.size()]), "Warnings while parsing the contexts from the 'org.eclipse.ui.contexts', 'org.eclipse.ui.commands' and 'org.eclipse.ui.acceleratorScopes' extension points.", null);
            WorkbenchPlugin.log((IStatus)status);
        }
    }

    private ContextPersistence() {
    }
}

