/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import sun.net.ProgressMonitor;
import sun.net.ProgressSource;
import sun.net.www.MessageHeader;
import sun.plugin.cache.Cache;
import sun.plugin.cache.CachedFile;
import sun.plugin.cache.DownloadException;
import sun.plugin.cache.FileCache;
import sun.plugin.cache.FileType;
import sun.plugin.net.protocol.http.HttpUtils;
import sun.plugin.util.Trace;

public class CachedFileLoader {
    private URL url;
    private HttpURLConnection uc = null;
    private long lastModified = 0L;
    private long expiration = 0L;
    private boolean upToDate = false;
    private File dataFile = null;
    private File indexFile = null;
    private boolean cached = false;
    private long size = 0L;
    private MessageHeader headerFields = null;
    private static String[] fieldName = new String[]{"content-length", "last-modified", "expires", "content-type", "content-encoding", "date", "server"};

    public CachedFileLoader(URL uRL) throws IOException {
        this.url = uRL;
    }

    public long getFileSize() {
        return this.size;
    }

    public URL getURL() {
        return this.url;
    }

    public void setDataFile(File file) {
        this.dataFile = file;
    }

    public void setIndexFile(File file) {
        this.indexFile = file;
    }

    public void setLastModify(long l) {
        this.lastModified = l;
    }

    public void setExpiration(long l) {
        this.expiration = l;
    }

    public void setHeaders(MessageHeader messageHeader) {
        this.headerFields = messageHeader;
    }

    public CachedFile load() throws IOException {
        boolean bl = true;
        this.cached = this.getCacheFile();
        if (this.cached) {
            bl = this.loadFromCache();
        } else {
            try {
                bl = this.download();
            }
            catch (IOException iOException) {
                int n;
                if (this.uc != null && ((n = this.uc.getResponseCode()) < 200 || n >= 300)) {
                    HttpUtils.cleanupConnection(this.uc);
                    throw new DownloadException(iOException, this.uc);
                }
                throw iOException;
            }
            if (bl && this.dataFile != null && Cache.cleanupThread != null) {
                try {
                    AccessController.doPrivileged(new Cache.CacheIOAction(){

                        public Object run() throws IOException {
                            Cache.cleanupThread.addedFile(CachedFileLoader.this.dataFile.length() + CachedFileLoader.this.indexFile.length());
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new IOException(privilegedActionException.getMessage());
                }
            }
        }
        if (bl) {
            URL uRL = this.uc != null ? this.uc.getURL() : null;
            return new CachedFile(this.dataFile, this.headerFields, uRL);
        }
        return null;
    }

    private boolean getCacheFile() throws IOException {
        final CachedFileLoader cachedFileLoader = this;
        try {
            return (Boolean)AccessController.doPrivileged(new Cache.CacheIOAction(){

                public Object run() throws IOException {
                    boolean bl = false;
                    bl = FileCache.getMatchingFile(cachedFileLoader);
                    return bl;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IOException(privilegedActionException.getMessage());
        }
    }

    private boolean loadFromCache() {
        boolean bl = false;
        try {
            this.upToDate = this.isUpToDate();
            if (this.upToDate) {
                Cache.msgPrintln("cache.loading", new Object[]{this.url});
                boolean bl2 = ProgressMonitor.getDefault().shouldMeterInput(this.url, "GET");
                if (bl2) {
                    ProgressSource progressSource = new ProgressSource(this.url, "GET", 10000);
                    progressSource.beginTracking();
                    progressSource.updateProgress(10000, 10000);
                    progressSource.finishTracking();
                    progressSource.close();
                }
                Cache.touch(this.indexFile);
                bl = true;
            } else {
                bl = this.updateCache();
            }
        }
        catch (IOException iOException) {
            Cache.msgPrintln("cache.load_warning", new Object[]{this.url});
        }
        return bl;
    }

    private boolean isUpToDate() throws IOException {
        boolean bl = false;
        if (this.expiration != 0L && new Date().before(new Date(this.expiration))) {
            bl = true;
        }
        if (!bl && this.lastModified != 0L) {
            this.uc = (HttpURLConnection)this.url.openConnection();
            this.uc.setUseCaches(false);
            this.uc.setAllowUserInteraction(false);
            this.uc.setIfModifiedSince(this.lastModified);
            this.uc = HttpUtils.followRedirects(this.uc);
            int n = this.uc.getResponseCode();
            if (n == 304) {
                HttpUtils.cleanupConnection(this.uc);
                bl = true;
            } else if (n >= 200 && n <= 299) {
                long l = this.lastModified;
                long l2 = this.expiration;
                this.lastModified = this.uc.getLastModified();
                this.expiration = this.uc.getExpiration();
                if (this.lastModified == l) {
                    HttpUtils.cleanupConnection(this.uc);
                    bl = true;
                } else {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance();
                    String string = dateFormat.format(new Date(l));
                    String string2 = dateFormat.format(new Date(this.lastModified));
                    Cache.msgPrintln("cache.out_of_date", new Object[]{this.url, string, string2});
                    this.size = this.uc.getContentLength();
                    this.initializeHeaderFields(this.uc);
                }
            } else {
                Cache.msgPrintln("cache.response_warning", new Object[]{String.valueOf(n), this.url});
            }
        }
        return bl;
    }

    private boolean download() throws IOException {
        boolean bl = false;
        if (this.uc == null) {
            this.uc = (HttpURLConnection)this.url.openConnection();
            this.uc.setUseCaches(false);
            this.uc.setAllowUserInteraction(false);
            this.uc = HttpUtils.followRedirects(this.uc);
            int n = this.uc.getResponseCode();
            if (n == 200) {
                this.size = this.uc.getContentLength();
                this.lastModified = this.uc.getLastModified();
                this.expiration = this.uc.getExpiration();
                if (this.lastModified == 0L && this.expiration == 0L) {
                    Trace.msgPrintln("cache.header_fields_missing");
                    return false;
                }
                this.initializeHeaderFields(this.uc);
            }
        }
        try {
            bl = (Boolean)AccessController.doPrivileged(new Cache.CacheIOAction(){

                public Object run() throws IOException {
                    return CachedFileLoader.this.createCacheFiles();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IOException(privilegedActionException.getMessage());
        }
        return bl;
    }

    private void initializeHeaderFields(URLConnection uRLConnection) throws IOException {
        this.headerFields = new MessageHeader();
        String string = uRLConnection.getHeaderFieldKey(0);
        String string2 = uRLConnection.getHeaderField(0);
        if (null == string && null != string2) {
            this.headerFields.add(null, string2);
        }
        for (int i = 0; i < fieldName.length; ++i) {
            String string3 = uRLConnection.getHeaderField(fieldName[i]);
            if (string3 == null) continue;
            this.headerFields.add(fieldName[i], string3);
        }
    }

    private boolean updateCache() throws IOException {
        try {
            AccessController.doPrivileged(new Cache.CacheIOAction(){

                public Object run() throws IOException {
                    Cache.removeFromTable(CachedFileLoader.this.indexFile, FileCache.filesInCache);
                    if (!CachedFileLoader.this.dataFile.delete()) {
                        CachedFileLoader.this.dataFile.deleteOnExit();
                    }
                    if (!CachedFileLoader.this.indexFile.delete()) {
                        FileOutputStream fileOutputStream = new FileOutputStream(CachedFileLoader.this.indexFile);
                        fileOutputStream.write(1);
                        fileOutputStream.close();
                        CachedFileLoader.this.indexFile.deleteOnExit();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IOException(privilegedActionException.getMessage());
        }
        try {
            return this.download();
        }
        catch (IOException iOException) {
            int n;
            if (this.uc != null && ((n = this.uc.getResponseCode()) < 200 || n >= 300)) {
                HttpUtils.cleanupConnection(this.uc);
                throw new DownloadException(iOException, this.uc);
            }
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createCacheFiles() throws IOException {
        String string = FileCache.generateCacheFileName(this.url);
        this.dataFile = new File(FileCache.directory, string + Cache.getFileExtension(this.url.toString()));
        this.indexFile = new File(FileCache.directory, string + ".idx");
        RandomAccessFile randomAccessFile = null;
        boolean bl = false;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            randomAccessFile = new RandomAccessFile(this.indexFile, "rw");
            randomAccessFile.writeByte(0);
            randomAccessFile.writeUTF(this.url.toString());
            randomAccessFile.writeLong(this.lastModified);
            randomAccessFile.writeLong(this.expiration);
            randomAccessFile.writeInt(FileType.getType(Cache.getFileExtension(this.url.toString())));
            this.writeHeaders(randomAccessFile);
            inputStream = new BufferedInputStream(this.uc.getInputStream());
            outputStream = new BufferedOutputStream(new FileOutputStream(this.dataFile));
            int n = 0;
            int n2 = 0;
            byte[] byArray = new byte[2048];
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                n2 += n;
                outputStream.write(byArray, 0, n);
            }
            randomAccessFile.seek(0L);
            randomAccessFile.writeByte(16);
            bl = true;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            if (!bl) {
                this.dataFile.delete();
                this.indexFile.delete();
                this.dataFile = null;
                this.indexFile = null;
            }
        }
        Cache.msgPrintln("cache.cached_name", new Object[]{this.dataFile.getName()});
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHeaders(RandomAccessFile randomAccessFile) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        Map<String, List<String>> map = this.headerFields.getHeaders();
        if (!map.isEmpty()) {
            dataOutputStream.writeInt(map.size());
            for (int i = 0; i < map.size(); ++i) {
                String string = this.headerFields.getKey(i);
                if (null == string) {
                    string = "<null>";
                }
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeUTF(this.headerFields.getValue(i));
            }
            dataOutputStream.flush();
        } else {
            dataOutputStream.writeInt(0);
        }
        randomAccessFile.write(byteArrayOutputStream.toByteArray());
    }
}

