/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.ping.dialog;

import com.clustercontrol.bean.PingRunCountConstant;
import com.clustercontrol.bean.PingRunIntervalConstant;
import com.clustercontrol.composite.PositiveNumberVerifyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.composite.MonitorBasicScopeComposite;
import com.clustercontrol.monitor.run.composite.MonitorBlockComposite;
import com.clustercontrol.monitor.run.composite.MonitorRuleComposite;
import com.clustercontrol.monitor.run.composite.NumericValueInfoComposite;
import com.clustercontrol.notify.composite.NotifyInfoComposite;
import com.clustercontrol.ping.action.GetPing;
import com.clustercontrol.ping.bean.MonitorPingInfo;
import com.clustercontrol.util.Messages;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PingCreateDialog
extends CommonDialog {
    public static final int WIDTH_TITLE = 5;
    public static final int WIDTH_VALUE = 2;
    private MonitorInfo inputData = null;
    private ValidateResult validateResult = null;
    private String monitorId = null;
    MonitorBasicScopeComposite m_monitorBasic = null;
    private MonitorRuleComposite m_monitorRule = null;
    protected Combo m_comboRunCount = null;
    protected Combo m_comboRunInterval = null;
    protected Text m_comboTimeout = null;
    private MonitorBlockComposite m_monitorBlock = null;
    private NumericValueInfoComposite m_numericValueInfo = null;
    private NotifyInfoComposite notifyInfo = null;
    private Button confirmValid = null;

    public PingCreateDialog(Shell parent) {
        super(parent);
    }

    public PingCreateDialog(Shell parent, String monitorId) {
        super(parent);
        this.monitorId = monitorId;
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.ping.create.modify"));
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        this.m_monitorBasic = new MonitorBasicScopeComposite(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_monitorBasic.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"monitor.rule")) + " : ");
        Group groupRule = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupRule.setLayoutData((Object)gridData);
        this.m_monitorRule = new MonitorRuleComposite((Composite)groupRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_monitorRule.setLayoutData((Object)gridData);
        label = new Label((Composite)groupRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"check.rule")) + " : ");
        Group groupCheckRule = new Group((Composite)groupRule, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupCheckRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupCheckRule.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"run.count")) + " : ");
        this.m_comboRunCount = new Combo((Composite)groupCheckRule, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboRunCount.setLayoutData((Object)gridData);
        this.m_comboRunCount.add(PingRunCountConstant.STRING_COUNT_01);
        this.m_comboRunCount.add(PingRunCountConstant.STRING_COUNT_02);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"run.interval")) + " : ");
        this.m_comboRunInterval = new Combo((Composite)groupCheckRule, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboRunInterval.setLayoutData((Object)gridData);
        this.m_comboRunInterval.add(PingRunIntervalConstant.STRING_SEC_01);
        this.m_comboRunInterval.add(PingRunIntervalConstant.STRING_SEC_02);
        this.m_comboRunInterval.add(PingRunIntervalConstant.STRING_SEC_05);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"time.out")) + " : ");
        this.m_comboTimeout = new Text((Composite)groupCheckRule, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboTimeout.addVerifyListener((VerifyListener)new PositiveNumberVerifyListener());
        this.m_comboTimeout.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"monitor.block")) + " : ");
        Group groupMonitorBlock = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupMonitorBlock.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupMonitorBlock.setLayoutData((Object)gridData);
        this.m_monitorBlock = new MonitorBlockComposite((Composite)groupMonitorBlock, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_monitorBlock.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"def.result.node")) + " : ");
        Group groupDefResultNode = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupDefResultNode.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupDefResultNode.setLayoutData((Object)gridData);
        this.m_numericValueInfo = new NumericValueInfoComposite((Composite)groupDefResultNode, 0, false, Messages.getString((String)"ping.reach"), Messages.getString((String)"time.period.milli.sec"), Messages.getString((String)"less"), Messages.getString((String)"less"), 3, 2, Float.valueOf(0.0f), Float.valueOf(100.0f), Float.valueOf(0.0f), null);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_numericValueInfo.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"notify.attribute")) + " : ");
        Group groupNotifyAttribute = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupNotifyAttribute.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupNotifyAttribute.setLayoutData((Object)gridData);
        this.notifyInfo = new NotifyInfoComposite((Composite)groupNotifyAttribute, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.notifyInfo.setLayoutData((Object)gridData);
        this.confirmValid = new Button(parent, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.confirmValid.setLayoutData((Object)gridData);
        this.confirmValid.setText(Messages.getString((String)"setting.valid.confirmed"));
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 15;
        line.setLayoutData((Object)gridData);
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        MonitorInfo info = null;
        info = this.monitorId != null ? new GetPing().getPing(this.monitorId) : new MonitorInfo();
        this.setInputData(info);
    }

    public MonitorInfo getInputData() {
        return this.inputData;
    }

    protected void setInputData(MonitorInfo monitor) {
        this.inputData = monitor;
        this.m_monitorBasic.setInputData(monitor);
        this.m_monitorRule.setInputData(monitor);
        MonitorPingInfo pingInfo = (MonitorPingInfo)monitor.getCheckInfo();
        if (pingInfo == null) {
            pingInfo = new MonitorPingInfo();
        }
        if (pingInfo.getRunCount() != null) {
            this.m_comboRunCount.setText(PingRunCountConstant.typeToString((int)pingInfo.getRunCount()));
        }
        if (pingInfo.getRunInterval() != null) {
            this.m_comboRunInterval.setText(PingRunIntervalConstant.typeToString((int)pingInfo.getRunInterval()));
        }
        if (pingInfo.getTimeout() != null) {
            this.m_comboTimeout.setText(pingInfo.getTimeout().toString());
        }
        this.m_monitorBlock.setInputData(monitor);
        this.m_numericValueInfo.setInputData(monitor);
        if (monitor.getNotifyId() != null) {
            this.notifyInfo.setText(monitor.getNotifyId());
        }
        if (monitor.getApplication() != null) {
            this.notifyInfo.setApplication(monitor.getApplication());
        }
        if (monitor.getValid() == 1) {
            this.confirmValid.setSelection(true);
        }
    }

    protected MonitorInfo createInputData() {
        MonitorInfo info = new MonitorInfo();
        info.setMonitorTypeId("PING");
        this.validateResult = this.m_monitorBasic.createInputData(info);
        if (this.validateResult != null) {
            return null;
        }
        this.validateResult = this.m_monitorRule.createInputData(info);
        if (this.validateResult != null) {
            return null;
        }
        MonitorPingInfo pingInfo = new MonitorPingInfo();
        pingInfo.setMonitorTypeId("PING");
        pingInfo.setMonitorId(info.getMonitorId());
        if (this.m_comboRunCount.getText() == null || "".equals(this.m_comboRunCount.getText().trim())) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.ping.10"));
            return null;
        }
        pingInfo.setRunCount(Integer.valueOf(PingRunCountConstant.stringToType((String)this.m_comboRunCount.getText())));
        if (this.m_comboRunInterval.getText() == null || "".equals(this.m_comboRunInterval.getText().trim())) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.ping.11"));
            return null;
        }
        pingInfo.setRunInterval(Integer.valueOf(PingRunIntervalConstant.stringToType((String)this.m_comboRunInterval.getText())));
        if (this.m_comboTimeout.getText() != null && !"".equals(this.m_comboTimeout.getText().trim())) {
            try {
                Integer timeout = new Integer(this.m_comboTimeout.getText().trim());
                pingInfo.setTimeout(timeout);
            }
            catch (NumberFormatException numberFormatException) {
                this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.ping.12"));
                return null;
            }
        } else {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.ping.12"));
            return null;
        }
        info.setCheckInfo((MonitorCheckInfo)pingInfo);
        this.validateResult = this.m_monitorBlock.createInputData(info);
        if (this.validateResult != null) {
            return null;
        }
        this.validateResult = this.m_numericValueInfo.createInputData(info);
        if (this.validateResult != null) {
            return null;
        }
        if (this.notifyInfo.getText() != null && !"".equals(this.notifyInfo.getText().trim())) {
            info.setNotifyId(this.notifyInfo.getText());
        }
        if (this.notifyInfo.getApplication() != null && !"".equals(this.notifyInfo.getApplication().trim())) {
            info.setApplication(this.notifyInfo.getApplication());
        } else if (this.notifyInfo.getText() != null && !"".equals(this.notifyInfo.getText().trim())) {
            info.setNotifyId(this.notifyInfo.getText());
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.10"));
            return null;
        }
        if (this.confirmValid.getSelection()) {
            info.setValid(1);
        } else {
            info.setValid(0);
        }
        return info;
    }

    protected ValidateResult validate() {
        this.inputData = this.createInputData();
        if (this.inputData != null) {
            return super.validate();
        }
        return this.validateResult;
    }

    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    private void setValidateResult(String id, String message) {
        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }
}

