/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans;

import com.sun.beans.MutableExpression;
import java.beans.Expression;
import java.beans.XMLDecoder;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import sun.reflect.misc.FieldUtil;

public class ObjectHandler
extends HandlerBase {
    private Hashtable environment = new Hashtable();
    private Vector expStack = new Vector();
    private StringBuffer chars = new StringBuffer();
    private XMLDecoder is;
    private ClassLoader ldr;
    private int itemsRead = 0;

    public static Class typeNameToClass(String string) {
        if ((string = string.intern()) == "boolean") {
            return Boolean.class;
        }
        if (string == "byte") {
            return Byte.class;
        }
        if (string == "char") {
            return Character.class;
        }
        if (string == "short") {
            return Short.class;
        }
        if (string == "int") {
            return Integer.class;
        }
        if (string == "long") {
            return Long.class;
        }
        if (string == "float") {
            return Float.class;
        }
        if (string == "double") {
            return Double.class;
        }
        if (string == "void") {
            return Void.class;
        }
        return null;
    }

    public static Class typeNameToPrimitiveClass(String string) {
        if ((string = string.intern()) == "boolean") {
            return Boolean.TYPE;
        }
        if (string == "byte") {
            return Byte.TYPE;
        }
        if (string == "char") {
            return Character.TYPE;
        }
        if (string == "short") {
            return Short.TYPE;
        }
        if (string == "int") {
            return Integer.TYPE;
        }
        if (string == "long") {
            return Long.TYPE;
        }
        if (string == "float") {
            return Float.TYPE;
        }
        if (string == "double") {
            return Double.TYPE;
        }
        if (string == "void") {
            return Void.TYPE;
        }
        return null;
    }

    public static Class classForName(String string) throws ClassNotFoundException {
        return ObjectHandler.classForName(string, Thread.currentThread().getContextClassLoader());
    }

    public static Class classForName(String string, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            throw new IllegalArgumentException("ClassLoader cannot be null");
        }
        Class clazz = ObjectHandler.typeNameToPrimitiveClass(string);
        if (clazz != null) {
            return clazz;
        }
        return Class.forName(string, false, classLoader);
    }

    public ObjectHandler() {
    }

    public ObjectHandler(XMLDecoder xMLDecoder) {
        this();
        this.is = xMLDecoder;
    }

    public ObjectHandler(XMLDecoder xMLDecoder, ClassLoader classLoader) {
        this(xMLDecoder);
        this.ldr = classLoader;
    }

    public void reset() {
        this.expStack.clear();
        this.chars.setLength(0);
        MutableExpression mutableExpression = new MutableExpression();
        mutableExpression.setTarget(this.classForName2("java.lang.Object"));
        mutableExpression.setMethodName("null");
        this.expStack.add(mutableExpression);
    }

    private Object getValue(Expression expression) {
        try {
            return expression.getValue();
        }
        catch (Exception exception) {
            if (this.is != null) {
                this.is.getExceptionListener().exceptionThrown(exception);
            }
            return null;
        }
    }

    private void addArg(Object object) {
        this.lastExp().addArg(object);
    }

    private Object pop(Vector vector) {
        int n2 = vector.size() - 1;
        Object e2 = vector.get(n2);
        vector.remove(n2);
        return e2;
    }

    private Object eval() {
        return this.getValue(this.lastExp());
    }

    private MutableExpression lastExp() {
        return (MutableExpression)this.expStack.lastElement();
    }

    public Object dequeueResult() {
        Object[] objectArray = this.lastExp().getArguments();
        return objectArray[this.itemsRead++];
    }

    private boolean isPrimitive(String string) {
        return string != "void" && ObjectHandler.typeNameToClass(string) != null;
    }

    private void simulateException(String string) {
        Exception exception = new Exception(string);
        exception.fillInStackTrace();
        if (this.is != null) {
            this.is.getExceptionListener().exceptionThrown(exception);
        }
    }

    private Class classForName2(String string) {
        try {
            if (this.ldr != null) {
                return ObjectHandler.classForName(string, this.ldr);
            }
            return ObjectHandler.classForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.is != null) {
                this.is.getExceptionListener().exceptionThrown(classNotFoundException);
            }
            return null;
        }
    }

    private HashMap getAttributes(AttributeList attributeList) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (attributeList != null && attributeList.getLength() > 0) {
            for (int i2 = 0; i2 < attributeList.getLength(); ++i2) {
                hashMap.put(attributeList.getName(i2), attributeList.getValue(i2));
            }
        }
        return hashMap;
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        String string2;
        Object object;
        Object object2;
        string = string.intern();
        this.chars.setLength(0);
        HashMap hashMap = this.getAttributes(attributeList);
        MutableExpression mutableExpression = new MutableExpression();
        String string3 = (String)hashMap.get("class");
        if (string3 != null) {
            mutableExpression.setTarget(this.classForName2(string3));
        }
        Object object3 = hashMap.get("property");
        String string4 = (String)hashMap.get("index");
        if (string4 != null) {
            object3 = new Integer(string4);
            mutableExpression.addArg(object3);
        }
        mutableExpression.setProperty(object3);
        String string5 = (String)hashMap.get("method");
        if (string5 == null && object3 == null) {
            string5 = "new";
        }
        mutableExpression.setMethodName(string5);
        if (string == "string") {
            mutableExpression.setTarget(String.class);
            mutableExpression.setMethodName("new");
        } else if (this.isPrimitive(string)) {
            object2 = ObjectHandler.typeNameToClass(string);
            mutableExpression.setTarget(object2);
            mutableExpression.setMethodName("new");
        } else if (string == "class") {
            mutableExpression.setTarget(Class.class);
            mutableExpression.setMethodName("forName");
        } else if (string == "null") {
            mutableExpression.setTarget(Object.class);
            mutableExpression.setMethodName("getSuperclass");
            mutableExpression.setValue(null);
        } else if (string == "void") {
            if (mutableExpression.getTarget() == null) {
                mutableExpression.setTarget(this.eval());
            }
        } else if (string == "array") {
            object2 = (String)hashMap.get("class");
            object = object2 == null ? Object.class : this.classForName2((String)object2);
            string2 = (String)hashMap.get("length");
            if (string2 != null) {
                mutableExpression.setTarget(Array.class);
                mutableExpression.addArg(object);
                mutableExpression.addArg(new Integer(string2));
            } else {
                Class<? extends Object> clazz = Array.newInstance(object, 0).getClass();
                mutableExpression.setTarget(clazz);
            }
        } else if (string == "java") {
            mutableExpression.setValue(this.is);
        } else if (string != "object") {
            this.simulateException("Unrecognized opening tag: " + string + " " + this.attrsToString(attributeList));
            return;
        }
        object2 = (String)hashMap.get("id");
        if (object2 != null) {
            this.environment.put(object2, mutableExpression);
        }
        if ((object = (String)hashMap.get("idref")) != null) {
            mutableExpression.setValue(this.lookup((String)object));
        }
        if ((string2 = (String)hashMap.get("field")) != null) {
            mutableExpression.setValue(this.getFieldValue(mutableExpression.getTarget(), string2));
        }
        this.expStack.add(mutableExpression);
    }

    private Object getFieldValue(Object object, String string) {
        try {
            Class clazz = object.getClass();
            if (clazz == Class.class) {
                clazz = (Class)object;
            }
            Field field = FieldUtil.getField(clazz, string);
            return field.get(object);
        }
        catch (Exception exception) {
            if (this.is != null) {
                this.is.getExceptionListener().exceptionThrown(exception);
            }
            return null;
        }
    }

    private String attrsToString(AttributeList attributeList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < attributeList.getLength(); ++i2) {
            stringBuffer.append(attributeList.getName(i2) + "=\"" + attributeList.getValue(i2) + "\" ");
        }
        return stringBuffer.toString();
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        this.chars.append(new String(cArray, n2, n3));
    }

    public Object lookup(String string) {
        Expression expression = (Expression)this.environment.get(string);
        if (expression == null) {
            this.simulateException("Unbound variable: " + string);
        }
        return this.getValue(expression);
    }

    public void endElement(String string) throws SAXException {
        if ((string = string.intern()) == "java") {
            return;
        }
        if (this.isPrimitive(string) || string == "string" || string == "class") {
            this.addArg(this.chars.toString());
        }
        if (string == "object" || string == "array" || string == "void" || this.isPrimitive(string) || string == "string" || string == "class" || string == "null") {
            Expression expression = (Expression)this.pop(this.expStack);
            Object object = this.getValue(expression);
            if (string != "void") {
                this.addArg(object);
            }
        } else {
            this.simulateException("Unrecognized closing tag: " + string);
        }
    }
}

