/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.ior;

public class ByteBuffer {
    protected byte[] elementData;
    protected int elementCount;
    protected int capacityIncrement;

    public ByteBuffer(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n2);
        }
        this.elementData = new byte[n2];
        this.capacityIncrement = n3;
    }

    public ByteBuffer(int n2) {
        this(n2, 0);
    }

    public ByteBuffer() {
        this(200);
    }

    public void trimToSize() {
        int n2 = this.elementData.length;
        if (this.elementCount < n2) {
            byte[] byArray = this.elementData;
            this.elementData = new byte[this.elementCount];
            System.arraycopy(byArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    private void ensureCapacityHelper(int n2) {
        int n3 = this.elementData.length;
        if (n2 > n3) {
            int n4;
            byte[] byArray = this.elementData;
            int n5 = n4 = this.capacityIncrement > 0 ? n3 + this.capacityIncrement : n3 * 2;
            if (n4 < n2) {
                n4 = n2;
            }
            this.elementData = new byte[n4];
            System.arraycopy(byArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public int capacity() {
        return this.elementData.length;
    }

    public int size() {
        return this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public void append(byte by) {
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = by;
    }

    public void append(int n2) {
        this.ensureCapacityHelper(this.elementCount + 4);
        this.doAppend(n2);
    }

    private void doAppend(int n2) {
        int n3 = n2;
        for (int i2 = 0; i2 < 4; ++i2) {
            this.elementData[this.elementCount + i2] = (byte)(n3 & 0xFF);
            n3 >>= 8;
        }
        this.elementCount += 4;
    }

    public void append(String string) {
        byte[] byArray = string.getBytes();
        this.ensureCapacityHelper(this.elementCount + byArray.length + 4);
        this.doAppend(byArray.length);
        System.arraycopy(byArray, 0, this.elementData, this.elementCount, byArray.length);
        this.elementCount += byArray.length;
    }

    public byte[] toArray() {
        return this.elementData;
    }
}

