/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import com.sun.java.swing.plaf.gtk.GTKRegion;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import java.awt.Graphics;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JCheckBox;
import javax.swing.JToolBar;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthIcon;

class GTKIconFactory {
    private static SynthIcon expandedIcon;
    private static SynthIcon collapsedIcon;
    private static SynthIcon radioButtonIcon;
    private static SynthIcon checkBoxIcon;
    private static SynthIcon menuArrowIcon;
    private static SynthIcon menuCheckIcon;
    private static SynthIcon menuItemArrowIcon;
    private static SynthIcon menuItemCheckIcon;
    private static SynthIcon checkBoxMenuItemArrowIcon;
    private static SynthIcon checkBoxMenuItemCheckIcon;
    private static SynthIcon radioButtonMenuItemArrowIcon;
    private static SynthIcon radioButtonMenuItemCheckIcon;

    GTKIconFactory() {
    }

    public static SynthIcon getTreeExpandedIcon() {
        if (expandedIcon == null) {
            expandedIcon = new SynthExpanderIcon("paintTreeExpandedIcon");
        }
        return expandedIcon;
    }

    public static void paintTreeExpandedIcon(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        ((GTKStyle)synthContext.getStyle()).getEngine(synthContext).paintExpander(synthContext, graphics, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState()), 1, "treeview", n2, n3, n4, n5);
    }

    public static SynthIcon getTreeCollapsedIcon() {
        if (collapsedIcon == null) {
            collapsedIcon = new SynthExpanderIcon("paintTreeCollapsedIcon");
        }
        return collapsedIcon;
    }

    public static void paintTreeCollapsedIcon(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        ((GTKStyle)synthContext.getStyle()).getEngine(synthContext).paintExpander(synthContext, graphics, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState()), 0, "treeview", n2, n3, n4, n5);
    }

    public static SynthIcon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new DelegatingIcon("paintRadioButtonIcon", 13, 13);
        }
        return radioButtonIcon;
    }

    public static void paintRadioButtonIcon(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = synthContext.getComponentState();
        int n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n6);
        int n8 = 1;
        if ((n6 & 0x200) != 0) {
            n7 = 512;
        }
        if (n7 == 512) {
            n8 = 0;
        }
        ((GTKStyle)synthContext.getStyle()).getEngine(synthContext).paintOption(synthContext, graphics, n7, n8, "radiobutton", n2, n3, n4, n5);
    }

    public static SynthIcon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new DelegatingIcon("paintCheckBoxIcon", 13, 13);
        }
        return checkBoxIcon;
    }

    public static void paintCheckBoxIcon(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = synthContext.getComponentState();
        int n7 = 1;
        if (((JCheckBox)synthContext.getComponent()).isSelected()) {
            n7 = 0;
        }
        ((GTKStyle)synthContext.getStyle()).getEngine(synthContext).paintCheck(synthContext, graphics, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState()), n7, "checkbutton", n2, n3, n4, n5);
    }

    public static SynthIcon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new DelegatingIcon("paintMenuArrowIcon", 13, 13);
        }
        return menuArrowIcon;
    }

    public static void paintMenuArrowIcon(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        int n7 = 1;
        if (n6 == 2) {
            n7 = 0;
        }
        int n8 = synthContext.getComponent().getComponentOrientation().isLeftToRight() ? 103 : 102;
        gTKStyle.getEngine(synthContext).paintArrow(synthContext, graphics, n6, n7, n8, "menuitem", n2 + 3, n3 + 3, 7, 7);
    }

    public static SynthIcon getMenuItemArrowIcon() {
        if (menuItemArrowIcon == null) {
            menuItemArrowIcon = new DelegatingIcon("paintMenuItemArrowIcon", 13, 13);
        }
        return menuItemArrowIcon;
    }

    public static void paintMenuItemArrowIcon(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
    }

    public static SynthIcon getCheckBoxMenuItemArrowIcon() {
        if (checkBoxMenuItemArrowIcon == null) {
            checkBoxMenuItemArrowIcon = new DelegatingIcon("paintCheckBoxMenuItemArrowIcon", 13, 13);
        }
        return checkBoxMenuItemArrowIcon;
    }

    public static void paintCheckBoxMenuItemArrowIcon(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
    }

    public static SynthIcon getCheckBoxMenuItemCheckIcon() {
        if (checkBoxMenuItemCheckIcon == null) {
            checkBoxMenuItemCheckIcon = new DelegatingIcon("paintCheckBoxMenuItemCheckIcon", 13, 13);
        }
        return checkBoxMenuItemCheckIcon;
    }

    public static void paintCheckBoxMenuItemCheckIcon(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = synthContext.getComponentState();
        int n7 = 1;
        int n8 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n6);
        if ((n6 & 2) != 0) {
            n8 = 2;
        }
        if ((n6 & 0x200) != 0) {
            n7 = 0;
        }
        gTKStyle.getEngine(synthContext).paintCheck(synthContext, graphics, n8, n7, "check", n2, n3, n4, n5);
    }

    public static SynthIcon getRadioButtonMenuItemArrowIcon() {
        if (radioButtonMenuItemArrowIcon == null) {
            radioButtonMenuItemArrowIcon = new DelegatingIcon("paintRadioButtonMenuItemArrowIcon", 13, 13);
        }
        return radioButtonMenuItemArrowIcon;
    }

    public static void paintRadioButtonMenuItemArrowIcon(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
    }

    public static SynthIcon getRadioButtonMenuItemCheckIcon() {
        if (radioButtonMenuItemCheckIcon == null) {
            radioButtonMenuItemCheckIcon = new DelegatingIcon("paintRadioButtonMenuItemCheckIcon", 13, 13);
        }
        return radioButtonMenuItemCheckIcon;
    }

    public static void paintRadioButtonMenuItemCheckIcon(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = synthContext.getComponentState();
        int n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n6);
        if ((n6 & 2) != 0) {
            n7 = 2;
        }
        int n8 = 1;
        if ((n6 & 0x200) != 0) {
            n8 = 0;
        }
        ((GTKStyle)synthContext.getStyle()).getEngine(synthContext).paintOption(synthContext, graphics, n7, n8, "option", n2, n3, n4, n5);
    }

    public static SynthIcon getToolBarHandleIcon() {
        return new ToolBarHandleIcon();
    }

    public static void paintToolBarHandleIcon(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = ((JToolBar)synthContext.getComponent()).getOrientation() == 0 ? 0 : 1;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKStyle.getEngine(synthContext).paintHandle(synthContext, graphics, n7, 1, "handlebox", n2, n3, n4, n5, n6);
    }

    private static class DelegatingIcon
    extends SynthIcon
    implements UIResource {
        private static final Class[] PARAM_TYPES = new Class[]{SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
        private int width;
        private int height;
        private Object method;

        DelegatingIcon(String string, int n2, int n3) {
            this.method = string;
            this.width = n2;
            this.height = n3;
        }

        public void paintIcon(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
            if (synthContext != null) {
                try {
                    this.getMethod().invoke(GTKIconFactory.class, synthContext, graphics, new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5));
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }

        public int getIconWidth(SynthContext synthContext) {
            return this.width;
        }

        public int getIconHeight(SynthContext synthContext) {
            return this.height;
        }

        private Method getMethod() {
            if (this.method instanceof String) {
                Method[] methodArray = GTKIconFactory.class.getMethods();
                try {
                    this.method = GTKIconFactory.class.getMethod((String)this.method, PARAM_TYPES);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    System.out.println("NSME: " + noSuchMethodException);
                }
            }
            return (Method)this.method;
        }
    }

    private static class SynthExpanderIcon
    extends SynthIcon {
        private static final Class[] PARAM_TYPES = new Class[]{SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
        private int width = -1;
        private int height = -1;
        private Object method;

        SynthExpanderIcon(String string) {
            this.method = string;
        }

        public void paintIcon(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
            if (synthContext != null) {
                try {
                    this.getMethod().invoke(GTKIconFactory.class, synthContext, graphics, new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5));
                    this.updateSizeIfNecessary(synthContext);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }

        public int getIconWidth(SynthContext synthContext) {
            this.updateSizeIfNecessary(synthContext);
            return this.width;
        }

        public int getIconHeight(SynthContext synthContext) {
            this.updateSizeIfNecessary(synthContext);
            return this.height;
        }

        private void updateSizeIfNecessary(SynthContext synthContext) {
            if (this.width == -1 && synthContext != null) {
                this.width = this.height = synthContext.getStyle().getInt(synthContext, "Tree.expanderSize", 10);
            }
        }

        private Method getMethod() {
            if (this.method instanceof String) {
                Method[] methodArray = GTKIconFactory.class.getMethods();
                try {
                    this.method = GTKIconFactory.class.getMethod((String)this.method, PARAM_TYPES);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    System.out.println("NSME: " + noSuchMethodException);
                }
            }
            return (Method)this.method;
        }
    }

    private static class ToolBarHandleIcon
    extends SynthIcon {
        private SynthStyle style;

        private ToolBarHandleIcon() {
        }

        public void paintIcon(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
            if (synthContext != null) {
                synthContext = this.getContext(synthContext);
                GTKIconFactory.paintToolBarHandleIcon(synthContext, graphics, n2, n3, n4, n5);
            }
        }

        public int getIconWidth(SynthContext synthContext) {
            if (((JToolBar)synthContext.getComponent()).getOrientation() == 0) {
                return 10;
            }
            return synthContext.getComponent().getWidth();
        }

        public int getIconHeight(SynthContext synthContext) {
            if (((JToolBar)synthContext.getComponent()).getOrientation() == 0) {
                return synthContext.getComponent().getHeight();
            }
            return 10;
        }

        private SynthContext getContext(SynthContext synthContext) {
            if (this.style == null) {
                this.style = SynthLookAndFeel.getStyleFactory().getStyle(synthContext.getComponent(), GTKRegion.HANDLE_BOX);
            }
            return new SynthContext(synthContext.getComponent(), GTKRegion.HANDLE_BOX, this.style, 1);
        }
    }
}

