/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class WindowsIconFactory
implements Serializable {
    private static Icon frame_closeIcon;
    private static Icon frame_iconifyIcon;
    private static Icon frame_maxIcon;
    private static Icon frame_minIcon;
    private static Icon frame_resizeIcon;
    private static Icon checkBoxIcon;
    private static Icon radioButtonIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon menuItemCheckIcon;
    private static Icon menuItemArrowIcon;
    private static Icon menuArrowIcon;

    public static Icon getMenuItemCheckIcon() {
        if (menuItemCheckIcon == null) {
            menuItemCheckIcon = new MenuItemCheckIcon();
        }
        return menuItemCheckIcon;
    }

    public static Icon getMenuItemArrowIcon() {
        if (menuItemArrowIcon == null) {
            menuItemArrowIcon = new MenuItemArrowIcon();
        }
        return menuItemArrowIcon;
    }

    public static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon();
        }
        return menuArrowIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    public static Icon createFrameCloseIcon() {
        if (frame_closeIcon == null) {
            frame_closeIcon = new FrameButtonIcon("window.closebutton");
        }
        return frame_closeIcon;
    }

    public static Icon createFrameIconifyIcon() {
        if (frame_iconifyIcon == null) {
            frame_iconifyIcon = new FrameButtonIcon("window.minbutton");
        }
        return frame_iconifyIcon;
    }

    public static Icon createFrameMaximizeIcon() {
        if (frame_maxIcon == null) {
            frame_maxIcon = new FrameButtonIcon("window.maxbutton");
        }
        return frame_maxIcon;
    }

    public static Icon createFrameMinimizeIcon() {
        if (frame_minIcon == null) {
            frame_minIcon = new FrameButtonIcon("window.restorebutton");
        }
        return frame_minIcon;
    }

    public static Icon createFrameResizeIcon() {
        if (frame_resizeIcon == null) {
            frame_resizeIcon = new ResizeIcon();
        }
        return frame_resizeIcon;
    }

    private static class CheckBoxIcon
    implements Icon,
    Serializable {
        static final int csize = 13;

        private CheckBoxIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JCheckBox jCheckBox = (JCheckBox)component;
            ButtonModel buttonModel = jCheckBox.getModel();
            XPStyle xPStyle = XPStyle.getXP();
            if (xPStyle != null) {
                int n4 = 0;
                if (!buttonModel.isEnabled()) {
                    n4 = 3;
                } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    n4 = 2;
                } else if (buttonModel.isRollover()) {
                    n4 = 1;
                }
                if (buttonModel.isSelected()) {
                    n4 += 4;
                }
                xPStyle.getSkin("button.checkbox").paintSkin(graphics, n2, n3, n4);
            } else {
                if (!jCheckBox.isBorderPaintedFlat()) {
                    graphics.setColor(UIManager.getColor("CheckBox.shadow"));
                    graphics.drawLine(n2, n3, n2 + 11, n3);
                    graphics.drawLine(n2, n3 + 1, n2, n3 + 11);
                    graphics.setColor(UIManager.getColor("CheckBox.highlight"));
                    graphics.drawLine(n2 + 12, n3, n2 + 12, n3 + 12);
                    graphics.drawLine(n2, n3 + 12, n2 + 11, n3 + 12);
                    graphics.setColor(UIManager.getColor("CheckBox.darkShadow"));
                    graphics.drawLine(n2 + 1, n3 + 1, n2 + 10, n3 + 1);
                    graphics.drawLine(n2 + 1, n3 + 2, n2 + 1, n3 + 10);
                    graphics.setColor(UIManager.getColor("CheckBox.light"));
                    graphics.drawLine(n2 + 1, n3 + 11, n2 + 11, n3 + 11);
                    graphics.drawLine(n2 + 11, n3 + 1, n2 + 11, n3 + 10);
                    if (buttonModel.isPressed() && buttonModel.isArmed() || !buttonModel.isEnabled()) {
                        graphics.setColor(UIManager.getColor("CheckBox.background"));
                    } else {
                        graphics.setColor(UIManager.getColor("CheckBox.interiorBackground"));
                    }
                    graphics.fillRect(n2 + 2, n3 + 2, 9, 9);
                } else {
                    graphics.setColor(UIManager.getColor("CheckBox.shadow"));
                    graphics.drawRect(n2 + 1, n3 + 1, 10, 10);
                    if (buttonModel.isPressed() && buttonModel.isArmed() || !buttonModel.isEnabled()) {
                        graphics.setColor(UIManager.getColor("CheckBox.background"));
                    } else {
                        graphics.setColor(UIManager.getColor("CheckBox.interiorBackground"));
                    }
                    graphics.fillRect(n2 + 2, n3 + 2, 9, 9);
                }
                if (buttonModel.isEnabled()) {
                    graphics.setColor(UIManager.getColor("CheckBox.darkShadow"));
                } else {
                    graphics.setColor(UIManager.getColor("CheckBox.shadow"));
                }
                if (buttonModel.isSelected()) {
                    graphics.drawLine(n2 + 9, n3 + 3, n2 + 9, n3 + 3);
                    graphics.drawLine(n2 + 8, n3 + 4, n2 + 9, n3 + 4);
                    graphics.drawLine(n2 + 7, n3 + 5, n2 + 9, n3 + 5);
                    graphics.drawLine(n2 + 6, n3 + 6, n2 + 8, n3 + 6);
                    graphics.drawLine(n2 + 3, n3 + 7, n2 + 7, n3 + 7);
                    graphics.drawLine(n2 + 4, n3 + 8, n2 + 6, n3 + 8);
                    graphics.drawLine(n2 + 5, n3 + 9, n2 + 5, n3 + 9);
                    graphics.drawLine(n2 + 3, n3 + 5, n2 + 3, n3 + 5);
                    graphics.drawLine(n2 + 3, n3 + 6, n2 + 4, n3 + 6);
                }
            }
        }

        public int getIconWidth() {
            XPStyle xPStyle = XPStyle.getXP();
            if (xPStyle != null) {
                return xPStyle.getSkin("button.checkbox").getWidth();
            }
            return 13;
        }

        public int getIconHeight() {
            XPStyle xPStyle = XPStyle.getXP();
            if (xPStyle != null) {
                return xPStyle.getSkin("button.checkbox").getHeight();
            }
            return 13;
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxMenuItemIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            boolean bl2 = buttonModel.isSelected();
            if (bl2) {
                graphics.drawLine(n2 + 9, (n3 -= this.getIconHeight() / 2) + 3, n2 + 9, n3 + 3);
                graphics.drawLine(n2 + 8, n3 + 4, n2 + 9, n3 + 4);
                graphics.drawLine(n2 + 7, n3 + 5, n2 + 9, n3 + 5);
                graphics.drawLine(n2 + 6, n3 + 6, n2 + 8, n3 + 6);
                graphics.drawLine(n2 + 3, n3 + 7, n2 + 7, n3 + 7);
                graphics.drawLine(n2 + 4, n3 + 8, n2 + 6, n3 + 8);
                graphics.drawLine(n2 + 5, n3 + 9, n2 + 5, n3 + 9);
                graphics.drawLine(n2 + 3, n3 + 5, n2 + 3, n3 + 5);
                graphics.drawLine(n2 + 3, n3 + 6, n2 + 4, n3 + 6);
            }
        }

        public int getIconWidth() {
            return 9;
        }

        public int getIconHeight() {
            return 9;
        }
    }

    private static class FrameButtonIcon
    implements Icon,
    Serializable {
        private String category;

        private FrameButtonIcon(String string) {
            this.category = string;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            int n4 = this.getIconWidth();
            int n5 = this.getIconHeight();
            XPStyle xPStyle = XPStyle.getXP();
            if (xPStyle != null) {
                XPStyle.Skin skin = xPStyle.getSkin(this.category);
                JButton jButton = (JButton)component;
                ButtonModel buttonModel = jButton.getModel();
                int n6 = 0;
                if (!buttonModel.isEnabled()) {
                    n6 = 3;
                } else if (buttonModel.isArmed() && buttonModel.isPressed()) {
                    n6 = 2;
                } else if (buttonModel.isRollover()) {
                    n6 = 1;
                }
                JInternalFrame jInternalFrame = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, jButton);
                if (jInternalFrame != null && !jInternalFrame.isSelected()) {
                    n6 += 4;
                }
                skin.paintSkin(graphics, 0, 0, n4, n5, n6);
            } else {
                graphics.setColor(Color.black);
                int n7 = n4 / 12 + 2;
                int n8 = n5 / 5;
                int n9 = n5 - n8 * 2 - 1;
                int n10 = n4 * 3 / 4 - 3;
                int n11 = Math.max(n5 / 8, 2);
                int n12 = Math.max(n4 / 15, 1);
                if (this.category == "window.closebutton") {
                    int n13 = n4 > 47 ? 6 : (n4 > 37 ? 5 : (n4 > 26 ? 4 : (n4 > 16 ? 3 : (n4 > 12 ? 2 : 1))));
                    n8 = n5 / 12 + 2;
                    if (n13 == 1) {
                        if (n10 % 2 == 1) {
                            ++n7;
                            ++n10;
                        }
                        graphics.drawLine(n7, n8, n7 + n10 - 2, n8 + n10 - 2);
                        graphics.drawLine(n7 + n10 - 2, n8, n7, n8 + n10 - 2);
                    } else if (n13 == 2) {
                        if (n10 > 6) {
                            ++n7;
                            --n10;
                        }
                        graphics.drawLine(n7, n8, n7 + n10 - 2, n8 + n10 - 2);
                        graphics.drawLine(n7 + n10 - 2, n8, n7, n8 + n10 - 2);
                        graphics.drawLine(n7 + 1, n8, n7 + n10 - 1, n8 + n10 - 2);
                        graphics.drawLine(n7 + n10 - 1, n8, n7 + 1, n8 + n10 - 2);
                    } else {
                        graphics.drawLine(n7 += 2, ++n8, n7 + (n10 -= 2) - 1, n8 + n10 - 1);
                        graphics.drawLine(n7 + n10 - 1, n8, n7, n8 + n10 - 1);
                        graphics.drawLine(n7 + 1, n8, n7 + n10 - 1, n8 + n10 - 2);
                        graphics.drawLine(n7 + n10 - 2, n8, n7, n8 + n10 - 2);
                        graphics.drawLine(n7, n8 + 1, n7 + n10 - 2, n8 + n10 - 1);
                        graphics.drawLine(n7 + n10 - 1, n8 + 1, n7 + 1, n8 + n10 - 1);
                        for (int i2 = 4; i2 <= n13; ++i2) {
                            graphics.drawLine(n7 + i2 - 2, n8, n7 + n10 - 1, n8 + n10 - i2 + 1);
                            graphics.drawLine(n7, n8 + i2 - 2, n7 + n10 - i2 + 1, n8 + n10 - 1);
                            graphics.drawLine(n7 + n10 - i2 + 1, n8, n7, n8 + n10 - i2 + 1);
                            graphics.drawLine(n7 + n10 - 1, n8 + i2 - 2, n7 + i2 - 2, n8 + n10 - 1);
                        }
                    }
                } else if (this.category == "window.minbutton") {
                    graphics.fillRect(n7, n8 + n9 - n11, n10 - n10 / 3, n11);
                } else if (this.category == "window.maxbutton") {
                    graphics.fillRect(n7, n8, n10, n11);
                    graphics.fillRect(n7, n8, n12, n9);
                    graphics.fillRect(n7 + n10 - n12, n8, n12, n9);
                    graphics.fillRect(n7, n8 + n9 - n12, n10, n12);
                } else if (this.category == "window.restorebutton") {
                    graphics.fillRect(n7 + n10 / 3, n8, n10 - n10 / 3, n11);
                    graphics.fillRect(n7 + n10 / 3, n8, n12, n9 / 3);
                    graphics.fillRect(n7 + n10 - n12, n8, n12, n9 - n9 / 3);
                    graphics.fillRect(n7 + n10 - n10 / 3, n8 + n9 - n9 / 3 - n12, n10 / 3, n12);
                    graphics.fillRect(n7, n8 + n9 / 3, n10 - n10 / 3, n11);
                    graphics.fillRect(n7, n8 + n9 / 3, n12, n9 - n9 / 3);
                    graphics.fillRect(n7 + n10 - n10 / 3 - n12, n8 + n9 / 3, n12, n9 - n9 / 3);
                    graphics.fillRect(n7, n8 + n9 - n12, n10 - n10 / 3, n12);
                }
            }
        }

        public int getIconWidth() {
            int n2 = XPStyle.getXP() != null ? UIManager.getInt("InternalFrame.titleButtonHeight") - 2 : UIManager.getInt("InternalFrame.titleButtonWidth") - 2;
            if (XPStyle.getXP() != null) {
                n2 -= 2;
            }
            return n2;
        }

        public int getIconHeight() {
            int n2 = UIManager.getInt("InternalFrame.titleButtonHeight") - 4;
            return n2;
        }
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuArrowIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            graphics.translate(n2, n3);
            if (WindowsUtils.isLeftToRight(component)) {
                graphics.drawLine(0, 0, 0, 7);
                graphics.drawLine(1, 1, 1, 6);
                graphics.drawLine(2, 2, 2, 5);
                graphics.drawLine(3, 3, 3, 4);
            } else {
                graphics.drawLine(4, 0, 4, 7);
                graphics.drawLine(3, 1, 3, 6);
                graphics.drawLine(2, 2, 2, 5);
                graphics.drawLine(1, 3, 1, 4);
            }
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return 4;
        }

        public int getIconHeight() {
            return 8;
        }
    }

    private static class MenuItemArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuItemArrowIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        }

        public int getIconWidth() {
            return 4;
        }

        public int getIconHeight() {
            return 8;
        }
    }

    private static class MenuItemCheckIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuItemCheckIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        }

        public int getIconWidth() {
            return 9;
        }

        public int getIconHeight() {
            return 9;
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            XPStyle xPStyle = XPStyle.getXP();
            if (xPStyle != null) {
                XPStyle.Skin skin = xPStyle.getSkin("button.radiobutton");
                int n4 = 0;
                if (!buttonModel.isEnabled()) {
                    n4 = 3;
                } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    n4 = 2;
                } else if (buttonModel.isRollover()) {
                    n4 = 1;
                }
                if (buttonModel.isSelected()) {
                    n4 += 4;
                }
                skin.paintSkin(graphics, n2, n3, n4);
            } else {
                if (buttonModel.isPressed() && buttonModel.isArmed() || !buttonModel.isEnabled()) {
                    graphics.setColor(UIManager.getColor("RadioButton.background"));
                } else {
                    graphics.setColor(UIManager.getColor("RadioButton.interiorBackground"));
                }
                graphics.fillRect(n2 + 2, n3 + 2, 8, 8);
                graphics.setColor(UIManager.getColor("RadioButton.shadow"));
                graphics.drawLine(n2 + 4, n3 + 0, n2 + 7, n3 + 0);
                graphics.drawLine(n2 + 2, n3 + 1, n2 + 3, n3 + 1);
                graphics.drawLine(n2 + 8, n3 + 1, n2 + 9, n3 + 1);
                graphics.drawLine(n2 + 1, n3 + 2, n2 + 1, n3 + 3);
                graphics.drawLine(n2 + 0, n3 + 4, n2 + 0, n3 + 7);
                graphics.drawLine(n2 + 1, n3 + 8, n2 + 1, n3 + 9);
                graphics.setColor(UIManager.getColor("RadioButton.highlight"));
                graphics.drawLine(n2 + 2, n3 + 10, n2 + 3, n3 + 10);
                graphics.drawLine(n2 + 4, n3 + 11, n2 + 7, n3 + 11);
                graphics.drawLine(n2 + 8, n3 + 10, n2 + 9, n3 + 10);
                graphics.drawLine(n2 + 10, n3 + 9, n2 + 10, n3 + 8);
                graphics.drawLine(n2 + 11, n3 + 7, n2 + 11, n3 + 4);
                graphics.drawLine(n2 + 10, n3 + 3, n2 + 10, n3 + 2);
                graphics.setColor(UIManager.getColor("RadioButton.darkShadow"));
                graphics.drawLine(n2 + 4, n3 + 1, n2 + 7, n3 + 1);
                graphics.drawLine(n2 + 2, n3 + 2, n2 + 3, n3 + 2);
                graphics.drawLine(n2 + 8, n3 + 2, n2 + 9, n3 + 2);
                graphics.drawLine(n2 + 2, n3 + 3, n2 + 2, n3 + 3);
                graphics.drawLine(n2 + 1, n3 + 4, n2 + 1, n3 + 7);
                graphics.drawLine(n2 + 2, n3 + 8, n2 + 2, n3 + 8);
                graphics.setColor(UIManager.getColor("RadioButton.light"));
                graphics.drawLine(n2 + 2, n3 + 9, n2 + 3, n3 + 9);
                graphics.drawLine(n2 + 4, n3 + 10, n2 + 7, n3 + 10);
                graphics.drawLine(n2 + 8, n3 + 9, n2 + 9, n3 + 9);
                graphics.drawLine(n2 + 9, n3 + 8, n2 + 9, n3 + 8);
                graphics.drawLine(n2 + 10, n3 + 7, n2 + 10, n3 + 4);
                graphics.drawLine(n2 + 9, n3 + 3, n2 + 9, n3 + 3);
                if (buttonModel.isSelected()) {
                    graphics.setColor(UIManager.getColor("RadioButton.darkShadow"));
                    graphics.fillRect(n2 + 4, n3 + 5, 4, 2);
                    graphics.fillRect(n2 + 5, n3 + 4, 2, 4);
                }
            }
        }

        public int getIconWidth() {
            XPStyle xPStyle = XPStyle.getXP();
            if (xPStyle != null) {
                return xPStyle.getSkin("button.radiobutton").getWidth();
            }
            return 13;
        }

        public int getIconHeight() {
            XPStyle xPStyle = XPStyle.getXP();
            if (xPStyle != null) {
                return xPStyle.getSkin("button.radiobutton").getHeight();
            }
            return 13;
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonMenuItemIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (abstractButton.isSelected()) {
                graphics.fillArc(0, 0, this.getIconWidth() - 2, this.getIconHeight() - 2, 0, 360);
            }
        }

        public int getIconWidth() {
            return 12;
        }

        public int getIconHeight() {
            return 12;
        }
    }

    private static class ResizeIcon
    implements Icon,
    Serializable {
        private ResizeIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            graphics.setColor(UIManager.getColor("InternalFrame.resizeIconHighlight"));
            graphics.drawLine(0, 11, 11, 0);
            graphics.drawLine(4, 11, 11, 4);
            graphics.drawLine(8, 11, 11, 8);
            graphics.setColor(UIManager.getColor("InternalFrame.resizeIconShadow"));
            graphics.drawLine(1, 11, 11, 1);
            graphics.drawLine(2, 11, 11, 2);
            graphics.drawLine(5, 11, 11, 5);
            graphics.drawLine(6, 11, 11, 6);
            graphics.drawLine(9, 11, 11, 9);
            graphics.drawLine(10, 11, 11, 10);
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }
    }
}

