/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.internal;

import java.util.AbstractList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayQueue<T>
extends AbstractList<T> {
    private int capacity;
    private T[] queue;
    private int head;
    private int tail;

    public ArrayQueue(int n2) {
        this.capacity = n2 + 1;
        this.queue = new Object[n2 + 1];
        this.head = 0;
        this.tail = 0;
    }

    public void resize(int n2) {
        int n3 = this.size();
        if (n2 < n3) {
            throw new IndexOutOfBoundsException("Resizing would lose data");
        }
        if (++n2 == this.capacity) {
            return;
        }
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < n3; ++i2) {
            objectArray[i2] = this.get(i2);
        }
        this.capacity = n2;
        this.queue = objectArray;
        this.head = 0;
        this.tail = n3;
    }

    @Override
    public boolean add(T t2) {
        this.queue[this.tail] = t2;
        int n2 = (this.tail + 1) % this.capacity;
        if (n2 == this.head) {
            throw new IndexOutOfBoundsException("Queue full");
        }
        this.tail = n2;
        return true;
    }

    @Override
    public T remove(int n2) {
        if (n2 != 0) {
            throw new IllegalArgumentException("Can only remove head of queue");
        }
        if (this.head == this.tail) {
            throw new IndexOutOfBoundsException("Queue empty");
        }
        T t2 = this.queue[this.head];
        this.queue[this.head] = null;
        this.head = (this.head + 1) % this.capacity;
        return t2;
    }

    @Override
    public T get(int n2) {
        int n3 = this.size();
        if (n2 < 0 || n2 >= n3) {
            String string = "Index " + n2 + ", queue size " + n3;
            throw new IndexOutOfBoundsException(string);
        }
        int n4 = (this.head + n2) % this.capacity;
        return this.queue[n4];
    }

    @Override
    public int size() {
        int n2 = this.tail - this.head;
        if (n2 < 0) {
            n2 += this.capacity;
        }
        return n2;
    }
}

