/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.snmp.SnmpEngine;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.ThreadContext;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import com.sun.jmx.snmp.daemon.SnmpAdaptorServer;
import com.sun.jmx.snmp.daemon.SnmpSubRequestHandler;
import com.sun.jmx.snmp.internal.SnmpIncomingRequest;
import java.util.Enumeration;

class SnmpSubBulkRequestHandler
extends SnmpSubRequestHandler {
    private SnmpAdaptorServer server = null;
    protected int nonRepeat = 0;
    protected int maxRepeat = 0;
    protected int globalR = 0;
    protected int size = 0;

    protected SnmpSubBulkRequestHandler(SnmpEngine snmpEngine, SnmpAdaptorServer snmpAdaptorServer, SnmpIncomingRequest snmpIncomingRequest, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu, int n2, int n3, int n4) {
        super(snmpEngine, snmpIncomingRequest, snmpMibAgent, snmpPdu);
        this.init(snmpAdaptorServer, snmpPdu, n2, n3, n4);
    }

    protected SnmpSubBulkRequestHandler(SnmpAdaptorServer snmpAdaptorServer, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu, int n2, int n3, int n4) {
        super(snmpMibAgent, snmpPdu);
        this.init(snmpAdaptorServer, snmpPdu, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block9: {
            this.size = this.varBind.size();
            try {
                ThreadContext threadContext = ThreadContext.push("SnmpUserData", this.data);
                try {
                    if (this.isTraceOn()) {
                        this.trace("run", "[" + Thread.currentThread() + "]:getBulk operation on " + this.agent.getMibName());
                    }
                    this.agent.getBulk(this.createMibRequest(this.varBind, this.version, this.data), this.nonRepeat, this.maxRepeat);
                }
                finally {
                    ThreadContext.restore(threadContext);
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                this.errorStatus = snmpStatusException.getStatus();
                this.errorIndex = snmpStatusException.getErrorIndex();
                if (this.isDebugOn()) {
                    this.debug("run", "[" + Thread.currentThread() + "]:an Snmp error occured during the operation");
                    this.debug("run", snmpStatusException);
                }
            }
            catch (Exception exception) {
                this.errorStatus = 5;
                if (!this.isDebugOn()) break block9;
                this.debug("run", "[" + Thread.currentThread() + "]:a generic error occured during the operation");
                this.debug("run", exception);
            }
        }
        if (this.isTraceOn()) {
            this.trace("run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    private void init(SnmpAdaptorServer snmpAdaptorServer, SnmpPdu snmpPdu, int n2, int n3, int n4) {
        this.server = snmpAdaptorServer;
        this.nonRepeat = n2;
        this.maxRepeat = n3;
        this.globalR = n4;
        int n5 = this.translation.length;
        SnmpVarBind[] snmpVarBindArray = snmpPdu.varBindList;
        SnmpSubRequestHandler.NonSyncVector nonSyncVector = (SnmpSubRequestHandler.NonSyncVector)this.varBind;
        for (int i2 = 0; i2 < n5; ++i2) {
            this.translation[i2] = i2;
            SnmpVarBind snmpVarBind = new SnmpVarBind(snmpVarBindArray[i2].oid, snmpVarBindArray[i2].value);
            nonSyncVector.addNonSyncElement(snmpVarBind);
        }
    }

    private SnmpVarBind findVarBind(SnmpVarBind snmpVarBind, SnmpVarBind snmpVarBind2) {
        if (snmpVarBind == null) {
            return null;
        }
        if (snmpVarBind2.oid == null) {
            return snmpVarBind;
        }
        if (snmpVarBind.value == SnmpVarBind.endOfMibView) {
            return snmpVarBind2;
        }
        if (snmpVarBind2.value == SnmpVarBind.endOfMibView) {
            return snmpVarBind;
        }
        SnmpValue snmpValue = snmpVarBind2.value;
        int n2 = snmpVarBind.oid.compareTo(snmpVarBind2.oid);
        if (this.isDebugOn()) {
            this.trace("findVarBind", "Comparing OID element : " + snmpVarBind.oid + " with result : " + snmpVarBind2.oid);
            this.trace("findVarBind", "Values element : " + snmpVarBind.value + " result : " + snmpVarBind2.value);
        }
        if (n2 < 0) {
            return snmpVarBind;
        }
        if (n2 == 0) {
            if (this.isDebugOn()) {
                this.trace("findVarBind", " oid overlapping. Oid : " + snmpVarBind.oid + "value :" + snmpVarBind.value);
                this.trace("findVarBind", "Already present varBind : " + snmpVarBind2);
            }
            SnmpOid snmpOid = snmpVarBind2.oid;
            SnmpMibAgent snmpMibAgent = this.server.getAgentMib(snmpOid);
            if (this.isDebugOn()) {
                this.trace("findVarBind", "Deeper agent : " + snmpMibAgent);
            }
            if (snmpMibAgent == this.agent) {
                if (this.isDebugOn()) {
                    this.trace("updateResult", "The current agent is the deeper one. Update the value with the current one");
                }
                return snmpVarBind;
            }
            if (this.isDebugOn()) {
                this.trace("updateResult", "Current is not the deeper, return the previous one.");
            }
            return snmpVarBind2;
        }
        if (this.isDebugOn()) {
            this.trace("findVarBind", "The right varBind is the already present one");
        }
        return snmpVarBind2;
    }

    protected void updateResult(SnmpVarBind[] snmpVarBindArray) {
        int n2;
        int n3;
        Enumeration enumeration = this.varBind.elements();
        int n4 = snmpVarBindArray.length;
        for (n3 = 0; n3 < this.size; ++n3) {
            SnmpVarBind snmpVarBind;
            if (!enumeration.hasMoreElements()) {
                return;
            }
            n2 = this.translation[n3];
            if (n2 >= n4) {
                this.debug("updateResult", "Position `" + n2 + "' is out of bound...");
                continue;
            }
            SnmpVarBind snmpVarBind2 = (SnmpVarBind)enumeration.nextElement();
            if (snmpVarBind2 == null) continue;
            if (this.isDebugOn()) {
                this.trace("updateResult", "Non repeaters Current element : " + snmpVarBind2 + " from agent : " + this.agent);
            }
            if ((snmpVarBind = this.findVarBind(snmpVarBind2, snmpVarBindArray[n2])) == null) continue;
            snmpVarBindArray[n2] = snmpVarBind;
        }
        n3 = this.size - this.nonRepeat;
        for (n2 = 2; n2 <= this.maxRepeat; ++n2) {
            for (int i2 = 0; i2 < n3; ++i2) {
                SnmpVarBind snmpVarBind;
                int n5 = (n2 - 1) * this.globalR + this.translation[this.nonRepeat + i2];
                if (n5 >= n4) {
                    return;
                }
                if (!enumeration.hasMoreElements()) {
                    return;
                }
                SnmpVarBind snmpVarBind3 = (SnmpVarBind)enumeration.nextElement();
                if (snmpVarBind3 == null) continue;
                if (this.isDebugOn()) {
                    this.trace("updateResult", "Repeaters Current element : " + snmpVarBind3 + " from agent : " + this.agent);
                }
                if ((snmpVarBind = this.findVarBind(snmpVarBind3, snmpVarBindArray[n5])) == null) continue;
                snmpVarBindArray[n5] = snmpVarBind;
            }
        }
    }

    protected String makeDebugTag() {
        return "SnmpSubBulkRequestHandler";
    }
}

