/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.Ber;
import java.io.UnsupportedEncodingException;

public final class BerEncoder
extends Ber {
    private int curSeqIndex;
    private int[] seqOffset;
    private static final int INITIAL_SEQUENCES = 16;
    private static final int DEFAULT_BUFSIZE = 1024;
    private static final int BUF_GROWTH_FACTOR = 8;

    public BerEncoder() {
        this(1024);
    }

    public BerEncoder(int n2) {
        this.buf = new byte[n2];
        this.bufsize = n2;
        this.offset = 0;
        this.seqOffset = new int[16];
        this.curSeqIndex = 0;
    }

    public void reset() {
        while (this.offset > 0) {
            this.buf[--this.offset] = 0;
        }
        while (this.curSeqIndex > 0) {
            this.seqOffset[--this.curSeqIndex] = 0;
        }
    }

    public int getDataLen() {
        return this.offset;
    }

    public byte[] getBuf() {
        if (this.curSeqIndex != 0) {
            throw new IllegalStateException("BER encode error: Unbalanced SEQUENCEs.");
        }
        return this.buf;
    }

    public byte[] getTrimmedBuf() {
        int n2 = this.getDataLen();
        byte[] byArray = new byte[n2];
        System.arraycopy(this.getBuf(), 0, byArray, 0, n2);
        return byArray;
    }

    public void beginSeq(int n2) {
        if (this.curSeqIndex >= this.seqOffset.length) {
            int[] nArray = new int[this.seqOffset.length * 2];
            for (int i2 = 0; i2 < this.seqOffset.length; ++i2) {
                nArray[i2] = this.seqOffset[i2];
            }
            this.seqOffset = nArray;
        }
        this.encodeByte(n2);
        this.seqOffset[this.curSeqIndex] = this.offset;
        this.ensureFreeBytes(3);
        this.offset += 3;
        ++this.curSeqIndex;
    }

    public void endSeq() throws Ber.EncodeException {
        --this.curSeqIndex;
        if (this.curSeqIndex < 0) {
            throw new IllegalStateException("BER encode error: Unbalanced SEQUENCEs.");
        }
        int n2 = this.seqOffset[this.curSeqIndex] + 3;
        int n3 = this.offset - n2;
        if (n3 <= 127) {
            this.shiftSeqData(n2, n3, -2);
            this.buf[this.seqOffset[this.curSeqIndex]] = (byte)n3;
        } else if (n3 <= 255) {
            this.shiftSeqData(n2, n3, -1);
            this.buf[this.seqOffset[this.curSeqIndex]] = -127;
            this.buf[this.seqOffset[this.curSeqIndex] + 1] = (byte)n3;
        } else if (n3 <= 65535) {
            this.buf[this.seqOffset[this.curSeqIndex]] = -126;
            this.buf[this.seqOffset[this.curSeqIndex] + 1] = (byte)(n3 >> 8);
            this.buf[this.seqOffset[this.curSeqIndex] + 2] = (byte)n3;
        } else if (n3 <= 0xFFFFFF) {
            this.shiftSeqData(n2, n3, 1);
            this.buf[this.seqOffset[this.curSeqIndex]] = -125;
            this.buf[this.seqOffset[this.curSeqIndex] + 1] = (byte)(n3 >> 16);
            this.buf[this.seqOffset[this.curSeqIndex] + 2] = (byte)(n3 >> 8);
            this.buf[this.seqOffset[this.curSeqIndex] + 3] = (byte)n3;
        } else {
            throw new Ber.EncodeException("SEQUENCE too long");
        }
    }

    private void shiftSeqData(int n2, int n3, int n4) {
        if (n4 > 0) {
            this.ensureFreeBytes(n4);
        }
        System.arraycopy(this.buf, n2, this.buf, n2 + n4, n3);
        this.offset += n4;
    }

    public void encodeByte(int n2) {
        this.ensureFreeBytes(1);
        this.buf[this.offset++] = (byte)n2;
    }

    public void encodeInt(int n2) {
        this.encodeInt(n2, 2);
    }

    public void encodeInt(int n2, int n3) {
        int n4 = -8388608;
        int n5 = 4;
        while (((n2 & n4) == 0 || (n2 & n4) == n4) && n5 > 1) {
            --n5;
            n2 <<= 8;
        }
        this.encodeInt(n2, n3, n5);
    }

    private void encodeInt(int n2, int n3, int n4) {
        if (n4 > 4) {
            throw new IllegalArgumentException("BER encode error: INTEGER too long.");
        }
        this.ensureFreeBytes(2 + n4);
        this.buf[this.offset++] = (byte)n3;
        this.buf[this.offset++] = (byte)n4;
        int n5 = -16777216;
        while (n4-- > 0) {
            this.buf[this.offset++] = (byte)((n2 & n5) >> 24);
            n2 <<= 8;
        }
    }

    public void encodeBoolean(boolean bl2) {
        this.encodeBoolean(bl2, 1);
    }

    public void encodeBoolean(boolean bl2, int n2) {
        this.ensureFreeBytes(3);
        this.buf[this.offset++] = (byte)n2;
        this.buf[this.offset++] = 1;
        this.buf[this.offset++] = bl2 ? -1 : 0;
    }

    public void encodeString(String string, boolean bl2) throws Ber.EncodeException {
        this.encodeString(string, 4, bl2);
    }

    public void encodeString(String string, int n2, boolean bl2) throws Ber.EncodeException {
        int n3;
        this.encodeByte(n2);
        int n4 = 0;
        byte[] byArray = null;
        if (string == null) {
            n3 = 0;
        } else {
            if (bl2) {
                try {
                    byArray = string.getBytes("UTF8");
                    n3 = byArray.length;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new Ber.EncodeException("UTF8 not available on platform");
                }
            }
            try {
                byArray = string.getBytes("8859_1");
                n3 = byArray.length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Ber.EncodeException("8859_1 not available on platform");
            }
        }
        this.encodeLength(n3);
        this.ensureFreeBytes(n3);
        while (n4 < n3) {
            this.buf[this.offset++] = byArray[n4++];
        }
    }

    public void encodeOctetString(byte[] byArray, int n2, int n3, int n4) throws Ber.EncodeException {
        this.encodeByte(n2);
        this.encodeLength(n4);
        if (n4 > 0) {
            this.ensureFreeBytes(n4);
            System.arraycopy(byArray, n3, this.buf, this.offset, n4);
            this.offset += n4;
        }
    }

    public void encodeOctetString(byte[] byArray, int n2) throws Ber.EncodeException {
        this.encodeOctetString(byArray, n2, 0, byArray.length);
    }

    private void encodeLength(int n2) throws Ber.EncodeException {
        this.ensureFreeBytes(4);
        if (n2 < 128) {
            this.buf[this.offset++] = (byte)n2;
        } else if (n2 <= 255) {
            this.buf[this.offset++] = -127;
            this.buf[this.offset++] = (byte)n2;
        } else if (n2 <= 65535) {
            this.buf[this.offset++] = -126;
            this.buf[this.offset++] = (byte)(n2 >> 8);
            this.buf[this.offset++] = (byte)(n2 & 0xFF);
        } else if (n2 <= 0xFFFFFF) {
            this.buf[this.offset++] = -125;
            this.buf[this.offset++] = (byte)(n2 >> 16);
            this.buf[this.offset++] = (byte)(n2 >> 8);
            this.buf[this.offset++] = (byte)(n2 & 0xFF);
        } else {
            throw new Ber.EncodeException("string too long");
        }
    }

    public void encodeStringArray(String[] stringArray, boolean bl2) throws Ber.EncodeException {
        if (stringArray == null) {
            return;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.encodeString(stringArray[i2], bl2);
        }
    }

    private void ensureFreeBytes(int n2) {
        if (this.bufsize - this.offset < n2) {
            int n3 = this.bufsize * 8;
            if (n3 - this.offset < n2) {
                n3 += n2;
            }
            byte[] byArray = new byte[n3];
            System.arraycopy(this.buf, 0, byArray, 0, this.offset);
            this.buf = byArray;
            this.bufsize = n3;
        }
    }
}

