/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.JSSecurityManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class JDK13Services {
    private static final long DEFAULT_CACHING_PERIOD = 60000L;
    private static final String PROPERTIES_FILENAME = "sound.properties";
    private static Map providersCacheMap = new HashMap();
    private static long cachingPeriod = 60000L;
    private static Properties properties;

    private JDK13Services() {
    }

    public static void setCachingPeriod(int n2) {
        cachingPeriod = (long)n2 * 1000L;
    }

    public static synchronized List getProviders(Class clazz) {
        ProviderCache providerCache = (ProviderCache)providersCacheMap.get(clazz);
        if (providerCache == null) {
            providerCache = new ProviderCache();
            providersCacheMap.put(clazz, providerCache);
        }
        if (providerCache.providers == null || System.currentTimeMillis() > providerCache.lastUpdate + cachingPeriod) {
            providerCache.providers = Collections.unmodifiableList(JSSecurityManager.getProviders(clazz));
            providerCache.lastUpdate = System.currentTimeMillis();
        }
        return providerCache.providers;
    }

    public static synchronized String getDefaultProviderClassName(Class clazz) {
        int n2;
        String string = null;
        String string2 = JDK13Services.getDefaultProvider(clazz);
        if (string2 != null && (n2 = string2.indexOf(35)) != 0) {
            string = n2 > 0 ? string2.substring(0, n2) : string2;
        }
        return string;
    }

    public static synchronized String getDefaultInstanceName(Class clazz) {
        int n2;
        String string = null;
        String string2 = JDK13Services.getDefaultProvider(clazz);
        if (string2 != null && (n2 = string2.indexOf(35)) >= 0 && n2 < string2.length() - 1) {
            string = string2.substring(n2 + 1);
        }
        return string;
    }

    private static synchronized String getDefaultProvider(Class clazz) {
        String string = clazz.getName();
        String string2 = JSSecurityManager.getProperty(string);
        if (string2 == null) {
            string2 = JDK13Services.getProperties().getProperty(string);
        }
        if ("".equals(string2)) {
            string2 = null;
        }
        return string2;
    }

    private static synchronized Properties getProperties() {
        if (properties == null) {
            properties = new Properties();
            JSSecurityManager.loadProperties(properties, PROPERTIES_FILENAME);
        }
        return properties;
    }

    private static class ProviderCache {
        public long lastUpdate;
        public List providers;

        private ProviderCache() {
        }
    }
}

