/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.AbstractMidiDeviceProvider;
import com.sun.media.sound.FastShortMessage;
import com.sun.media.sound.FastSysexMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;

class MidiOutDevice
extends AbstractMidiDevice {
    MidiOutDevice(AbstractMidiDeviceProvider.Info info) {
        super(info);
    }

    protected synchronized void implOpen() throws MidiUnavailableException {
        int n2 = ((AbstractMidiDeviceProvider.Info)this.getDeviceInfo()).getIndex();
        this.id = this.nOpen(n2);
        if (this.id == 0L) {
            throw new MidiUnavailableException("Unable to open native device");
        }
    }

    protected synchronized void implClose() {
        long l2 = this.id;
        this.id = 0L;
        super.implClose();
        this.nClose(l2);
    }

    public long getMicrosecondPosition() {
        long l2 = -1L;
        if (this.isOpen()) {
            l2 = this.nGetTimeStamp(this.id);
        }
        return l2;
    }

    protected boolean hasReceivers() {
        return true;
    }

    protected Receiver createReceiver() {
        return new MidiOutReceiver();
    }

    private native long nOpen(int var1) throws MidiUnavailableException;

    private native void nClose(long var1);

    private native void nSendShortMessage(long var1, int var3, long var4);

    private native void nSendLongMessage(long var1, byte[] var3, int var4, long var5);

    private native long nGetTimeStamp(long var1);

    class MidiOutReceiver
    extends AbstractMidiDevice.AbstractReceiver {
        MidiOutReceiver() {
        }

        protected void implSend(MidiMessage midiMessage, long l2) {
            int n2 = midiMessage.getLength();
            int n3 = midiMessage.getStatus();
            if (n2 <= 3 && n3 != 240 && n3 != 247) {
                int n4;
                if (midiMessage instanceof ShortMessage) {
                    if (midiMessage instanceof FastShortMessage) {
                        n4 = ((FastShortMessage)midiMessage).getPackedMsg();
                    } else {
                        ShortMessage shortMessage = (ShortMessage)midiMessage;
                        n4 = n3 & 0xFF | (shortMessage.getData1() & 0xFF) << 8 | (shortMessage.getData2() & 0xFF) << 16;
                    }
                } else {
                    n4 = 0;
                    byte[] byArray = midiMessage.getMessage();
                    if (n2 > 0) {
                        n4 = byArray[0] & 0xFF;
                        if (n2 > 1) {
                            if (n3 == 255) {
                                return;
                            }
                            n4 |= (byArray[1] & 0xFF) << 8;
                            if (n2 > 2) {
                                n4 |= (byArray[2] & 0xFF) << 16;
                            }
                        }
                    }
                }
                MidiOutDevice.this.nSendShortMessage(MidiOutDevice.this.id, n4, l2);
            } else if (midiMessage instanceof FastSysexMessage) {
                MidiOutDevice.this.nSendLongMessage(MidiOutDevice.this.id, ((FastSysexMessage)midiMessage).getReadOnlyMessage(), n2, l2);
            } else {
                MidiOutDevice.this.nSendLongMessage(MidiOutDevice.this.id, midiMessage.getMessage(), n2, l2);
            }
        }

        synchronized void sendPackedMidiMessage(int n2, long l2) {
            if (this.isOpen() && MidiOutDevice.this.id != 0L) {
                MidiOutDevice.this.nSendShortMessage(MidiOutDevice.this.id, n2, l2);
            }
        }
    }
}

