/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.InnerClass;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class InnerClasses
extends Attribute {
    private InnerClass[] inner_classes;
    private int number_of_classes;

    public InnerClasses(InnerClasses innerClasses) {
        this(innerClasses.getNameIndex(), innerClasses.getLength(), innerClasses.getInnerClasses(), innerClasses.getConstantPool());
    }

    public InnerClasses(int n2, int n3, InnerClass[] innerClassArray, ConstantPool constantPool) {
        super((byte)6, n2, n3, constantPool);
        this.setInnerClasses(innerClassArray);
    }

    InnerClasses(int n2, int n3, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n2, n3, (InnerClass[])null, constantPool);
        this.number_of_classes = dataInputStream.readUnsignedShort();
        this.inner_classes = new InnerClass[this.number_of_classes];
        for (int i2 = 0; i2 < this.number_of_classes; ++i2) {
            this.inner_classes[i2] = new InnerClass(dataInputStream);
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitInnerClasses(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.number_of_classes);
        for (int i2 = 0; i2 < this.number_of_classes; ++i2) {
            this.inner_classes[i2].dump(dataOutputStream);
        }
    }

    public final InnerClass[] getInnerClasses() {
        return this.inner_classes;
    }

    public final void setInnerClasses(InnerClass[] innerClassArray) {
        this.inner_classes = innerClassArray;
        this.number_of_classes = innerClassArray == null ? 0 : innerClassArray.length;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.number_of_classes; ++i2) {
            stringBuffer.append(this.inner_classes[i2].toString(this.constant_pool) + "\n");
        }
        return stringBuffer.toString();
    }

    public Attribute copy(ConstantPool constantPool) {
        InnerClasses innerClasses = (InnerClasses)this.clone();
        innerClasses.inner_classes = new InnerClass[this.number_of_classes];
        for (int i2 = 0; i2 < this.number_of_classes; ++i2) {
            innerClasses.inner_classes[i2] = this.inner_classes[i2].copy();
        }
        innerClasses.constant_pool = constantPool;
        return innerClasses;
    }
}

