/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.IndexedInstruction;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.ReturnaddressType;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.generic.TypedInstruction;
import com.sun.org.apache.bcel.internal.generic.Visitor;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class RET
extends Instruction
implements IndexedInstruction,
TypedInstruction {
    private boolean wide;
    private int index;

    RET() {
    }

    public RET(int n2) {
        super((short)169, (short)2);
        this.setIndex(n2);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        if (this.wide) {
            dataOutputStream.writeByte(196);
        }
        dataOutputStream.writeByte(this.opcode);
        if (this.wide) {
            dataOutputStream.writeShort(this.index);
        } else {
            dataOutputStream.writeByte(this.index);
        }
    }

    private final void setWide() {
        this.wide = this.index > 255;
        this.length = this.wide ? (short)4 : (short)2;
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl2) throws IOException {
        this.wide = bl2;
        if (bl2) {
            this.index = byteSequence.readUnsignedShort();
            this.length = (short)4;
        } else {
            this.index = byteSequence.readUnsignedByte();
            this.length = (short)2;
        }
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n2) {
        if (n2 < 0) {
            throw new ClassGenException("Negative index value: " + n2);
        }
        this.index = n2;
        this.setWide();
    }

    public String toString(boolean bl2) {
        return super.toString(bl2) + " " + this.index;
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        return ReturnaddressType.NO_TARGET;
    }

    public void accept(Visitor visitor) {
        visitor.visitRET(this);
    }
}

