/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.Constants;
import com.sun.org.apache.bcel.internal.Repository;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.BasicType;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.Type;

public class ReferenceType
extends Type {
    protected ReferenceType(byte by, String string) {
        super(by, string);
    }

    ReferenceType() {
        super((byte)14, "<null object>");
    }

    public boolean isCastableTo(Type type) {
        if (this.equals(Type.NULL)) {
            return true;
        }
        return this.isAssignmentCompatibleWith(type);
    }

    public boolean isAssignmentCompatibleWith(Type type) {
        if (!(type instanceof ReferenceType)) {
            return false;
        }
        ReferenceType referenceType = (ReferenceType)type;
        if (this.equals(Type.NULL)) {
            return true;
        }
        if (this instanceof ObjectType && ((ObjectType)this).referencesClass()) {
            if (referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesClass()) {
                if (this.equals(referenceType)) {
                    return true;
                }
                if (Repository.instanceOf(((ObjectType)this).getClassName(), ((ObjectType)referenceType).getClassName())) {
                    return true;
                }
            }
            if (referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesInterface() && Repository.implementationOf(((ObjectType)this).getClassName(), ((ObjectType)referenceType).getClassName())) {
                return true;
            }
        }
        if (this instanceof ObjectType && ((ObjectType)this).referencesInterface()) {
            if (referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesClass() && referenceType.equals(Type.OBJECT)) {
                return true;
            }
            if (referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesInterface()) {
                if (this.equals(referenceType)) {
                    return true;
                }
                if (Repository.implementationOf(((ObjectType)this).getClassName(), ((ObjectType)referenceType).getClassName())) {
                    return true;
                }
            }
        }
        if (this instanceof ArrayType) {
            if (referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesClass() && referenceType.equals(Type.OBJECT)) {
                return true;
            }
            if (referenceType instanceof ArrayType) {
                Type type2 = ((ArrayType)this).getElementType();
                Type type3 = ((ArrayType)this).getElementType();
                if (type2 instanceof BasicType && type3 instanceof BasicType && type2.equals(type3)) {
                    return true;
                }
                if (type3 instanceof ReferenceType && type2 instanceof ReferenceType && ((ReferenceType)type2).isAssignmentCompatibleWith((ReferenceType)type3)) {
                    return true;
                }
            }
            if (referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesInterface()) {
                for (int i2 = 0; i2 < Constants.INTERFACES_IMPLEMENTED_BY_ARRAYS.length; ++i2) {
                    if (!referenceType.equals(new ObjectType(Constants.INTERFACES_IMPLEMENTED_BY_ARRAYS[i2]))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public ReferenceType firstCommonSuperclass(ReferenceType referenceType) {
        if (this.equals(Type.NULL)) {
            return referenceType;
        }
        if (referenceType.equals(Type.NULL)) {
            return this;
        }
        if (this.equals(referenceType)) {
            return this;
        }
        if (this instanceof ArrayType || referenceType instanceof ArrayType) {
            return Type.OBJECT;
        }
        if (this instanceof ObjectType && ((ObjectType)this).referencesInterface() || referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesInterface()) {
            return Type.OBJECT;
        }
        ObjectType objectType = (ObjectType)this;
        ObjectType objectType2 = (ObjectType)referenceType;
        JavaClass[] javaClassArray = Repository.getSuperClasses(objectType.getClassName());
        JavaClass[] javaClassArray2 = Repository.getSuperClasses(objectType2.getClassName());
        if (javaClassArray == null || javaClassArray2 == null) {
            return null;
        }
        JavaClass[] javaClassArray3 = new JavaClass[javaClassArray.length + 1];
        JavaClass[] javaClassArray4 = new JavaClass[javaClassArray2.length + 1];
        System.arraycopy(javaClassArray, 0, javaClassArray3, 1, javaClassArray.length);
        System.arraycopy(javaClassArray2, 0, javaClassArray4, 1, javaClassArray2.length);
        javaClassArray3[0] = Repository.lookupClass(objectType.getClassName());
        javaClassArray4[0] = Repository.lookupClass(objectType2.getClassName());
        for (int i2 = 0; i2 < javaClassArray4.length; ++i2) {
            for (int i3 = 0; i3 < javaClassArray3.length; ++i3) {
                if (!javaClassArray3[i3].equals(javaClassArray4[i2])) continue;
                return new ObjectType(javaClassArray3[i3].getClassName());
            }
        }
        return null;
    }
}

