/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.dv.util;

public final class Base64 {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int SIXBIT = 6;
    private static final int FOURBYTE = 4;
    private static final int SIGN = -128;
    private static final char PAD = '=';
    private static final boolean fDebug = false;
    private static final byte[] base64Alphabet;
    private static final char[] lookUpBase64Alphabet;

    protected static boolean isWhiteSpace(char c2) {
        return c2 == ' ' || c2 == '\r' || c2 == '\n' || c2 == '\t';
    }

    protected static boolean isPad(char c2) {
        return c2 == '=';
    }

    protected static boolean isData(char c2) {
        return base64Alphabet[c2] != -1;
    }

    protected static boolean isBase64(char c2) {
        return Base64.isWhiteSpace(c2) || Base64.isPad(c2) || Base64.isData(c2);
    }

    public static String encode(byte[] byArray) {
        byte by;
        int n2;
        int n3;
        if (byArray == null) {
            return null;
        }
        int n4 = byArray.length * 8;
        if (n4 == 0) {
            return "";
        }
        int n5 = n4 % 24;
        int n6 = n4 / 24;
        int n7 = n5 != 0 ? n6 + 1 : n6;
        int n8 = (n7 - 1) / 19 + 1;
        char[] cArray = null;
        cArray = new char[n7 * 4 + n8];
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (n3 = 0; n3 < n8 - 1; ++n3) {
            for (n2 = 0; n2 < 19; ++n2) {
                by4 = byArray[n10++];
                by5 = byArray[n10++];
                by6 = byArray[n10++];
                by3 = (byte)(by5 & 0xF);
                by2 = (byte)(by4 & 3);
                by = (by4 & 0xFFFFFF80) == 0 ? (byte)(by4 >> 2) : (byte)(by4 >> 2 ^ 0xC0);
                byte by7 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 4) : (byte)(by5 >> 4 ^ 0xF0);
                byte by8 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 6) : (byte)(by6 >> 6 ^ 0xFC);
                cArray[n9++] = lookUpBase64Alphabet[by];
                cArray[n9++] = lookUpBase64Alphabet[by7 | by2 << 4];
                cArray[n9++] = lookUpBase64Alphabet[by3 << 2 | by8];
                cArray[n9++] = lookUpBase64Alphabet[by6 & 0x3F];
                ++n11;
            }
            cArray[n9++] = 10;
        }
        while (n11 < n6) {
            by4 = byArray[n10++];
            by5 = byArray[n10++];
            by6 = byArray[n10++];
            by3 = (byte)(by5 & 0xF);
            by2 = (byte)(by4 & 3);
            n3 = (by4 & 0xFFFFFF80) == 0 ? (byte)(by4 >> 2) : (byte)(by4 >> 2 ^ 0xC0);
            n2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 4) : (byte)(by5 >> 4 ^ 0xF0);
            by = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 6) : (byte)(by6 >> 6 ^ 0xFC);
            cArray[n9++] = lookUpBase64Alphabet[n3];
            cArray[n9++] = lookUpBase64Alphabet[n2 | by2 << 4];
            cArray[n9++] = lookUpBase64Alphabet[by3 << 2 | by];
            cArray[n9++] = lookUpBase64Alphabet[by6 & 0x3F];
            ++n11;
        }
        if (n5 == 8) {
            by4 = byArray[n10];
            by2 = (byte)(by4 & 3);
            n3 = (by4 & 0xFFFFFF80) == 0 ? (byte)(by4 >> 2) : (byte)(by4 >> 2 ^ 0xC0);
            cArray[n9++] = lookUpBase64Alphabet[n3];
            cArray[n9++] = lookUpBase64Alphabet[by2 << 4];
            cArray[n9++] = 61;
            cArray[n9++] = 61;
        } else if (n5 == 16) {
            by4 = byArray[n10];
            by5 = byArray[n10 + 1];
            by3 = (byte)(by5 & 0xF);
            by2 = (byte)(by4 & 3);
            n3 = (by4 & 0xFFFFFF80) == 0 ? (byte)(by4 >> 2) : (byte)(by4 >> 2 ^ 0xC0);
            n2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 4) : (byte)(by5 >> 4 ^ 0xF0);
            cArray[n9++] = lookUpBase64Alphabet[n3];
            cArray[n9++] = lookUpBase64Alphabet[n2 | by2 << 4];
            cArray[n9++] = lookUpBase64Alphabet[by3 << 2];
            cArray[n9++] = 61;
        }
        cArray[n9] = 10;
        return new String(cArray);
    }

    public static byte[] decode(String string) {
        int n2;
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n3 = Base64.removeWhiteSpace(cArray);
        if (n3 % 4 != 0) {
            return null;
        }
        int n4 = n3 / 4;
        if (n4 == 0) {
            return new byte[0];
        }
        byte[] byArray = null;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        char c2 = '\u0000';
        char c3 = '\u0000';
        char c4 = '\u0000';
        char c5 = '\u0000';
        int n5 = 0;
        int n6 = 0;
        byArray = new byte[n4 * 3];
        for (n2 = 0; n2 < n4 - 1; ++n2) {
            if (!(Base64.isData(c2 = cArray[n6++]) && Base64.isData(c3 = cArray[n6++]) && Base64.isData(c4 = cArray[n6++]) && Base64.isData(c5 = cArray[n6++]))) {
                return null;
            }
            by = base64Alphabet[c2];
            by2 = base64Alphabet[c3];
            by3 = base64Alphabet[c4];
            by4 = base64Alphabet[c5];
            byArray[n5++] = (byte)(by << 2 | by2 >> 4);
            byArray[n5++] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
            byArray[n5++] = (byte)(by3 << 6 | by4);
        }
        if (!Base64.isData(c2 = cArray[n6++]) || !Base64.isData(c3 = cArray[n6++])) {
            return null;
        }
        by = base64Alphabet[c2];
        by2 = base64Alphabet[c3];
        c4 = cArray[n6++];
        c5 = cArray[n6++];
        if (!Base64.isData(c4) || !Base64.isData(c5)) {
            if (Base64.isPad(c4) && Base64.isPad(c5)) {
                if ((by2 & 0xF) != 0) {
                    return null;
                }
                byte[] byArray2 = new byte[n2 * 3 + 1];
                System.arraycopy(byArray, 0, byArray2, 0, n2 * 3);
                byArray2[n5] = (byte)(by << 2 | by2 >> 4);
                return byArray2;
            }
            if (!Base64.isPad(c4) && Base64.isPad(c5)) {
                by3 = base64Alphabet[c4];
                if ((by3 & 3) != 0) {
                    return null;
                }
                byte[] byArray3 = new byte[n2 * 3 + 2];
                System.arraycopy(byArray, 0, byArray3, 0, n2 * 3);
                byArray3[n5++] = (byte)(by << 2 | by2 >> 4);
                byArray3[n5] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
                return byArray3;
            }
            return null;
        }
        by3 = base64Alphabet[c4];
        by4 = base64Alphabet[c5];
        byArray[n5++] = (byte)(by << 2 | by2 >> 4);
        byArray[n5++] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
        byArray[n5++] = (byte)(by3 << 6 | by4);
        return byArray;
    }

    protected static int removeWhiteSpace(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = cArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (Base64.isWhiteSpace(cArray[i2])) continue;
            cArray[n2++] = cArray[i2];
        }
        return n2;
    }

    static {
        int n2;
        base64Alphabet = new byte[255];
        lookUpBase64Alphabet = new char[64];
        for (n2 = 0; n2 < 255; ++n2) {
            Base64.base64Alphabet[n2] = -1;
        }
        for (n2 = 90; n2 >= 65; --n2) {
            Base64.base64Alphabet[n2] = (byte)(n2 - 65);
        }
        for (n2 = 122; n2 >= 97; --n2) {
            Base64.base64Alphabet[n2] = (byte)(n2 - 97 + 26);
        }
        for (n2 = 57; n2 >= 48; --n2) {
            Base64.base64Alphabet[n2] = (byte)(n2 - 48 + 52);
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
        for (n2 = 0; n2 <= 25; ++n2) {
            Base64.lookUpBase64Alphabet[n2] = (char)(65 + n2);
        }
        n2 = 26;
        int n3 = 0;
        while (n2 <= 51) {
            Base64.lookUpBase64Alphabet[n2] = (char)(97 + n3);
            ++n2;
            ++n3;
        }
        n2 = 52;
        n3 = 0;
        while (n2 <= 61) {
            Base64.lookUpBase64Alphabet[n2] = (char)(48 + n3);
            ++n2;
            ++n3;
        }
        Base64.lookUpBase64Alphabet[62] = 43;
        Base64.lookUpBase64Alphabet[63] = 47;
    }
}

