/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serialize;

import com.sun.org.apache.xerces.internal.dom.DOMMessageFormatter;
import com.sun.org.apache.xerces.internal.util.NamespaceSupport;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.XML11Char;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import com.sun.org.apache.xml.internal.serialize.ElementState;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.xml.sax.SAXException;

public class XML11Serializer
extends XMLSerializer {
    protected static final boolean DEBUG = false;
    protected NamespaceSupport fNSBinder;
    protected NamespaceSupport fLocalNSBinder;
    protected SymbolTable fSymbolTable;
    protected boolean fDOML1 = false;
    protected int fNamespaceCounter = 1;
    protected static final String PREFIX = "NS";
    protected boolean fNamespaces = false;
    private boolean fPreserveSpace;

    public XML11Serializer() {
        this._format.setVersion("1.1");
    }

    public XML11Serializer(OutputFormat outputFormat) {
        super(outputFormat);
        this._format.setVersion("1.1");
    }

    public XML11Serializer(Writer writer, OutputFormat outputFormat) {
        super(writer, outputFormat);
        this._format.setVersion("1.1");
    }

    public XML11Serializer(OutputStream outputStream, OutputFormat outputFormat) {
        super(outputStream, outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setVersion("1.1");
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        try {
            ElementState elementState = this.content();
            if (elementState.inCData || elementState.doCData) {
                if (!elementState.inCData) {
                    this._printer.printText("<![CDATA[");
                    elementState.inCData = true;
                }
                int n4 = this._printer.getNextIndent();
                this._printer.setNextIndent(0);
                for (int i2 = n2; i2 < n3; ++i2) {
                    char c2 = cArray[i2];
                    if (c2 == ']' && i2 + 2 < n3 && cArray[i2 + 1] == ']' && cArray[i2 + 2] == '>') {
                        this._printer.printText("]]]]><![CDATA[>");
                        i2 += 2;
                        continue;
                    }
                    if (!XML11Char.isXML11Valid(c2)) {
                        if (++i2 < n3) {
                            this.surrogates(c2, cArray[i2]);
                            continue;
                        }
                        this.fatalError("The character '" + c2 + "' is an invalid XML character");
                        continue;
                    }
                    if (this._encodingInfo.isPrintable(c2) && XML11Char.isXML11ValidLiteral(c2)) {
                        this._printer.printText(c2);
                        continue;
                    }
                    this._printer.printText("]]>&#x");
                    this._printer.printText(Integer.toHexString(c2));
                    this._printer.printText(";<![CDATA[");
                }
                this._printer.setNextIndent(n4);
            } else if (elementState.preserveSpace) {
                int n5 = this._printer.getNextIndent();
                this._printer.setNextIndent(0);
                this.printText(cArray, n2, n3, true, elementState.unescaped);
                this._printer.setNextIndent(n5);
            } else {
                this.printText(cArray, n2, n3, false, elementState.unescaped);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected void printEscaped(String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (!XML11Char.isXML11Valid(c2)) {
                if (++i2 < n2) {
                    this.surrogates(c2, string.charAt(i2));
                    continue;
                }
                this.fatalError("The character '" + (char)c2 + "' is an invalid XML character");
                continue;
            }
            if (c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == '\u0085' || c2 == '\u2028') {
                this.printHex(c2);
                continue;
            }
            if (c2 == '<') {
                this._printer.printText("&lt;");
                continue;
            }
            if (c2 == '&') {
                this._printer.printText("&amp;");
                continue;
            }
            if (c2 == '\"') {
                this._printer.printText("&quot;");
                continue;
            }
            if (c2 >= ' ' && this._encodingInfo.isPrintable(c2)) {
                this._printer.printText(c2);
                continue;
            }
            this.printHex(c2);
        }
    }

    protected final void printCDATAText(String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == ']' && i2 + 2 < n2 && string.charAt(i2 + 1) == ']' && string.charAt(i2 + 2) == '>') {
                if (this.fDOMErrorHandler != null) {
                    String string2;
                    if ((this.features & 0x10) == 0 && (this.features & 2) == 0) {
                        string2 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "EndingCDATA", null);
                        this.modifyDOMError(string2, (short)3, this.fCurrentNode);
                        boolean bl2 = this.fDOMErrorHandler.handleError(this.fDOMError);
                        if (!bl2) {
                            throw new IOException();
                        }
                    } else {
                        string2 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "SplittingCDATA", null);
                        this.modifyDOMError(string2, (short)1, this.fCurrentNode);
                        this.fDOMErrorHandler.handleError(this.fDOMError);
                    }
                }
                this._printer.printText("]]]]><![CDATA[>");
                i2 += 2;
                continue;
            }
            if (!XML11Char.isXML11Valid(c2)) {
                if (++i2 < n2) {
                    this.surrogates(c2, string.charAt(i2));
                    continue;
                }
                this.fatalError("The character '" + c2 + "' is an invalid XML character");
                continue;
            }
            if (this._encodingInfo.isPrintable(c2) && XML11Char.isXML11ValidLiteral(c2)) {
                this._printer.printText(c2);
                continue;
            }
            this._printer.printText("]]>&#x");
            this._printer.printText(Integer.toHexString(c2));
            this._printer.printText(";<![CDATA[");
        }
    }

    protected final void printXMLChar(int n2) throws IOException {
        if (n2 == 13 || n2 == 133 || n2 == 8232) {
            this.printHex(n2);
        } else if (n2 == 60) {
            this._printer.printText("&lt;");
        } else if (n2 == 38) {
            this._printer.printText("&amp;");
        } else if (n2 == 62) {
            this._printer.printText("&gt;");
        } else if (this._encodingInfo.isPrintable((char)n2) && XML11Char.isXML11ValidLiteral(n2)) {
            this._printer.printText((char)n2);
        } else {
            this.printHex(n2);
        }
    }

    protected final void surrogates(int n2, int n3) throws IOException {
        if (XMLChar.isHighSurrogate(n2)) {
            if (!XMLChar.isLowSurrogate(n3)) {
                this.fatalError("The character '" + (char)n3 + "' is an invalid XML character");
            } else {
                int n4 = XMLChar.supplemental((char)n2, (char)n3);
                if (!XML11Char.isXML11Valid(n4)) {
                    this.fatalError("The character '" + (char)n4 + "' is an invalid XML character");
                } else if (this.content().inCData) {
                    this._printer.printText("]]>&#x");
                    this._printer.printText(Integer.toHexString(n4));
                    this._printer.printText(";<![CDATA[");
                } else {
                    this.printHex(n4);
                }
            }
        } else {
            this.fatalError("The character '" + (char)n2 + "' is an invalid XML character");
        }
    }

    protected void printText(String string, boolean bl2, boolean bl3) throws IOException {
        int n2 = string.length();
        if (bl2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (!XML11Char.isXML11Valid(c2)) {
                    if (++i2 < n2) {
                        this.surrogates(c2, string.charAt(i2));
                        continue;
                    }
                    this.fatalError("The character '" + c2 + "' is an invalid XML character");
                    continue;
                }
                if (bl3 && XML11Char.isXML11ValidLiteral(c2)) {
                    this._printer.printText(c2);
                    continue;
                }
                this.printXMLChar(c2);
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                char c3 = string.charAt(i3);
                if (!XML11Char.isXML11Valid(c3)) {
                    if (++i3 < n2) {
                        this.surrogates(c3, string.charAt(i3));
                        continue;
                    }
                    this.fatalError("The character '" + c3 + "' is an invalid XML character");
                    continue;
                }
                if (bl3 && XML11Char.isXML11ValidLiteral(c3)) {
                    this._printer.printText(c3);
                    continue;
                }
                this.printXMLChar(c3);
            }
        }
    }

    protected void printText(char[] cArray, int n2, int n3, boolean bl2, boolean bl3) throws IOException {
        if (bl2) {
            while (n3-- > 0) {
                char c2 = cArray[n2];
                ++n2;
                if (!XML11Char.isXML11Valid(c2)) {
                    if (++n2 < n3) {
                        this.surrogates(c2, cArray[n2]);
                        continue;
                    }
                    this.fatalError("The character '" + c2 + "' is an invalid XML character");
                    continue;
                }
                if (bl3 && XML11Char.isXML11ValidLiteral(c2)) {
                    this._printer.printText(c2);
                    continue;
                }
                this.printXMLChar(c2);
            }
        } else {
            while (n3-- > 0) {
                char c3 = cArray[n2];
                ++n2;
                if (!XML11Char.isXML11Valid(c3)) {
                    if (++n2 < n3) {
                        this.surrogates(c3, cArray[n2]);
                        continue;
                    }
                    this.fatalError("The character '" + c3 + "' is an invalid XML character");
                    continue;
                }
                if (bl3 && XML11Char.isXML11ValidLiteral(c3)) {
                    this._printer.printText(c3);
                    continue;
                }
                this.printXMLChar(c3);
            }
        }
    }

    public boolean reset() {
        super.reset();
        return true;
    }
}

