/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.gsskerb;

import com.sun.security.sasl.util.AbstractSaslImpl;
import java.util.Map;
import java.util.logging.Level;
import javax.security.sasl.SaslException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

abstract class GssKrb5Base
extends AbstractSaslImpl {
    private static final String KRB5_OID_STR = "1.2.840.113554.1.2.2";
    protected static Oid KRB5_OID;
    protected static final byte[] EMPTY;
    protected GSSContext secCtx = null;
    protected MessageProp msgProp;
    protected static final int JGSS_QOP = 0;

    protected GssKrb5Base(Map map, String string) throws SaslException {
        super(map, string);
    }

    public String getMechanismName() {
        return "GSSAPI";
    }

    public byte[] unwrap(byte[] byArray, int n2, int n3) throws SaslException {
        if (!this.completed) {
            throw new IllegalStateException("GSSAPI authentication not completed");
        }
        if (!this.integrity) {
            throw new IllegalStateException("No security layer negotiated");
        }
        try {
            byte[] byArray2 = this.secCtx.unwrap(byArray, n2, n3, this.msgProp);
            if (logger.isLoggable(Level.FINEST)) {
                GssKrb5Base.traceOutput(this.myClassName, "KRB501:Unwrap", "incoming: ", byArray, n2, n3);
                GssKrb5Base.traceOutput(this.myClassName, "KRB502:Unwrap", "unwrapped: ", byArray2, 0, byArray2.length);
            }
            return byArray2;
        }
        catch (GSSException gSSException) {
            throw new SaslException("Problems unwrapping SASL buffer", gSSException);
        }
    }

    public byte[] wrap(byte[] byArray, int n2, int n3) throws SaslException {
        if (!this.completed) {
            throw new IllegalStateException("GSSAPI authentication not completed");
        }
        if (!this.integrity) {
            throw new IllegalStateException("No security layer negotiated");
        }
        try {
            byte[] byArray2 = this.secCtx.wrap(byArray, n2, n3, this.msgProp);
            if (logger.isLoggable(Level.FINEST)) {
                GssKrb5Base.traceOutput(this.myClassName, "KRB503:Wrap", "outgoing: ", byArray, n2, n3);
                GssKrb5Base.traceOutput(this.myClassName, "KRB504:Wrap", "wrapped: ", byArray2, 0, byArray2.length);
            }
            return byArray2;
        }
        catch (GSSException gSSException) {
            throw new SaslException("Problem performing GSS wrap", gSSException);
        }
    }

    public void dispose() throws SaslException {
        if (this.secCtx != null) {
            try {
                this.secCtx.dispose();
            }
            catch (GSSException gSSException) {
                throw new SaslException("Problem disposing GSS context", gSSException);
            }
            this.secCtx = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    static {
        EMPTY = new byte[0];
        try {
            KRB5_OID = new Oid(KRB5_OID_STR);
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
    }
}

