/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class AffineTransform
implements Cloneable,
Serializable {
    private static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_IDENTITY = 0;
    public static final int TYPE_TRANSLATION = 1;
    public static final int TYPE_UNIFORM_SCALE = 2;
    public static final int TYPE_GENERAL_SCALE = 4;
    public static final int TYPE_MASK_SCALE = 6;
    public static final int TYPE_FLIP = 64;
    public static final int TYPE_QUADRANT_ROTATION = 8;
    public static final int TYPE_GENERAL_ROTATION = 16;
    public static final int TYPE_MASK_ROTATION = 24;
    public static final int TYPE_GENERAL_TRANSFORM = 32;
    static final int APPLY_IDENTITY = 0;
    static final int APPLY_TRANSLATE = 1;
    static final int APPLY_SCALE = 2;
    static final int APPLY_SHEAR = 4;
    private static final int HI_SHIFT = 3;
    private static final int HI_IDENTITY = 0;
    private static final int HI_TRANSLATE = 8;
    private static final int HI_SCALE = 16;
    private static final int HI_SHEAR = 32;
    double m00;
    double m10;
    double m01;
    double m11;
    double m02;
    double m12;
    transient int state;
    private transient int type;
    private static int[] rot90conversion = new int[]{4, 5, 4, 5, 2, 3, 6, 7};

    private AffineTransform(double d2, double d3, double d4, double d5, double d6, double d7, int n2) {
        this.m00 = d2;
        this.m10 = d3;
        this.m01 = d4;
        this.m11 = d5;
        this.m02 = d6;
        this.m12 = d7;
        this.state = n2;
        this.type = -1;
    }

    public AffineTransform() {
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    public AffineTransform(AffineTransform affineTransform) {
        this.m00 = affineTransform.m00;
        this.m10 = affineTransform.m10;
        this.m01 = affineTransform.m01;
        this.m11 = affineTransform.m11;
        this.m02 = affineTransform.m02;
        this.m12 = affineTransform.m12;
        this.state = affineTransform.state;
        this.type = affineTransform.type;
    }

    public AffineTransform(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.m00 = f2;
        this.m10 = f3;
        this.m01 = f4;
        this.m11 = f5;
        this.m02 = f6;
        this.m12 = f7;
        this.updateState();
    }

    public AffineTransform(float[] fArray) {
        this.m00 = fArray[0];
        this.m10 = fArray[1];
        this.m01 = fArray[2];
        this.m11 = fArray[3];
        if (fArray.length > 5) {
            this.m02 = fArray[4];
            this.m12 = fArray[5];
        }
        this.updateState();
    }

    public AffineTransform(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.m00 = d2;
        this.m10 = d3;
        this.m01 = d4;
        this.m11 = d5;
        this.m02 = d6;
        this.m12 = d7;
        this.updateState();
    }

    public AffineTransform(double[] dArray) {
        this.m00 = dArray[0];
        this.m10 = dArray[1];
        this.m01 = dArray[2];
        this.m11 = dArray[3];
        if (dArray.length > 5) {
            this.m02 = dArray[4];
            this.m12 = dArray[5];
        }
        this.updateState();
    }

    public static AffineTransform getTranslateInstance(double d2, double d3) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(d2, d3);
        return affineTransform;
    }

    public static AffineTransform getRotateInstance(double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToRotation(d2);
        return affineTransform;
    }

    public static AffineTransform getRotateInstance(double d2, double d3, double d4) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToRotation(d2, d3, d4);
        return affineTransform;
    }

    public static AffineTransform getScaleInstance(double d2, double d3) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToScale(d2, d3);
        return affineTransform;
    }

    public static AffineTransform getShearInstance(double d2, double d3) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToShear(d2, d3);
        return affineTransform;
    }

    public int getType() {
        if (this.type == -1) {
            this.calculateType();
        }
        return this.type;
    }

    private void calculateType() {
        int n2 = 0;
        this.updateState();
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                n2 = 1;
            }
            case 6: {
                boolean bl2;
                double d2 = this.m00;
                double d3 = this.m01;
                double d4 = this.m10;
                double d5 = this.m11;
                if (d2 * d3 + d4 * d5 != 0.0) {
                    this.type = 32;
                    return;
                }
                boolean bl3 = d2 >= 0.0;
                boolean bl4 = bl2 = d5 >= 0.0;
                if (bl3 == bl2) {
                    if (d2 != d5 || d3 != -d4) {
                        n2 |= 0x14;
                        break;
                    }
                    if (d2 * d5 - d3 * d4 != 1.0) {
                        n2 |= 0x12;
                        break;
                    }
                    n2 |= 0x10;
                    break;
                }
                if (d2 != -d5 || d3 != d4) {
                    n2 |= 0x54;
                    break;
                }
                if (d2 * d5 - d3 * d4 != 1.0) {
                    n2 |= 0x52;
                    break;
                }
                n2 |= 0x50;
                break;
            }
            case 5: {
                n2 = 1;
            }
            case 4: {
                double d6;
                boolean bl5;
                double d7;
                double d8 = this.m01;
                boolean bl6 = d7 >= 0.0;
                double d9 = this.m10;
                boolean bl7 = bl5 = d6 >= 0.0;
                if (bl6 != bl5) {
                    if (d8 != -d9) {
                        n2 |= 0xC;
                        break;
                    }
                    if (d8 != 1.0 && d8 != -1.0) {
                        n2 |= 0xA;
                        break;
                    }
                    n2 |= 8;
                    break;
                }
                if (d8 == d9) {
                    n2 |= 0x4A;
                    break;
                }
                n2 |= 0x4C;
                break;
            }
            case 3: {
                n2 = 1;
            }
            case 2: {
                double d10;
                boolean bl8;
                double d11;
                double d12 = this.m00;
                boolean bl9 = d11 >= 0.0;
                double d13 = this.m11;
                boolean bl10 = bl8 = d10 >= 0.0;
                if (bl9 == bl8) {
                    if (bl9) {
                        if (d12 == d13) {
                            n2 |= 2;
                            break;
                        }
                        n2 |= 4;
                        break;
                    }
                    if (d12 != d13) {
                        n2 |= 0xC;
                        break;
                    }
                    if (d12 != -1.0) {
                        n2 |= 0xA;
                        break;
                    }
                    n2 |= 8;
                    break;
                }
                if (d12 == -d13) {
                    if (d12 == 1.0 || d12 == -1.0) {
                        n2 |= 0x40;
                        break;
                    }
                    n2 |= 0x42;
                    break;
                }
                n2 |= 0x44;
                break;
            }
            case 1: {
                n2 = 1;
            }
            case 0: 
        }
        this.type = n2;
    }

    public double getDeterminant() {
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 6: 
            case 7: {
                return this.m00 * this.m11 - this.m01 * this.m10;
            }
            case 4: 
            case 5: {
                return -(this.m01 * this.m10);
            }
            case 2: 
            case 3: {
                return this.m00 * this.m11;
            }
            case 0: 
            case 1: 
        }
        return 1.0;
    }

    void updateState() {
        if (this.m01 == 0.0 && this.m10 == 0.0) {
            if (this.m00 == 1.0 && this.m11 == 1.0) {
                if (this.m02 == 0.0 && this.m12 == 0.0) {
                    this.state = 0;
                    this.type = 0;
                } else {
                    this.state = 1;
                    this.type = 1;
                }
            } else if (this.m02 == 0.0 && this.m12 == 0.0) {
                this.state = 2;
                this.type = -1;
            } else {
                this.state = 3;
                this.type = -1;
            }
        } else if (this.m00 == 0.0 && this.m11 == 0.0) {
            if (this.m02 == 0.0 && this.m12 == 0.0) {
                this.state = 4;
                this.type = -1;
            } else {
                this.state = 5;
                this.type = -1;
            }
        } else if (this.m02 == 0.0 && this.m12 == 0.0) {
            this.state = 6;
            this.type = -1;
        } else {
            this.state = 7;
            this.type = -1;
        }
    }

    private void stateError() {
        throw new InternalError("missing case in transform state switch");
    }

    public void getMatrix(double[] dArray) {
        dArray[0] = this.m00;
        dArray[1] = this.m10;
        dArray[2] = this.m01;
        dArray[3] = this.m11;
        if (dArray.length > 5) {
            dArray[4] = this.m02;
            dArray[5] = this.m12;
        }
    }

    public double getScaleX() {
        return this.m00;
    }

    public double getScaleY() {
        return this.m11;
    }

    public double getShearX() {
        return this.m01;
    }

    public double getShearY() {
        return this.m10;
    }

    public double getTranslateX() {
        return this.m02;
    }

    public double getTranslateY() {
        return this.m12;
    }

    public void translate(double d2, double d3) {
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                this.m02 = d2 * this.m00 + d3 * this.m01 + this.m02;
                this.m12 = d2 * this.m10 + d3 * this.m11 + this.m12;
                if (this.m02 == 0.0 && this.m12 == 0.0) {
                    this.state = 6;
                    if (this.type != -1) {
                        --this.type;
                    }
                }
                return;
            }
            case 6: {
                this.m02 = d2 * this.m00 + d3 * this.m01;
                this.m12 = d2 * this.m10 + d3 * this.m11;
                if (this.m02 != 0.0 || this.m12 != 0.0) {
                    this.state = 7;
                    this.type |= 1;
                }
                return;
            }
            case 5: {
                this.m02 = d3 * this.m01 + this.m02;
                this.m12 = d2 * this.m10 + this.m12;
                if (this.m02 == 0.0 && this.m12 == 0.0) {
                    this.state = 4;
                    if (this.type != -1) {
                        --this.type;
                    }
                }
                return;
            }
            case 4: {
                this.m02 = d3 * this.m01;
                this.m12 = d2 * this.m10;
                if (this.m02 != 0.0 || this.m12 != 0.0) {
                    this.state = 5;
                    this.type |= 1;
                }
                return;
            }
            case 3: {
                this.m02 = d2 * this.m00 + this.m02;
                this.m12 = d3 * this.m11 + this.m12;
                if (this.m02 == 0.0 && this.m12 == 0.0) {
                    this.state = 2;
                    if (this.type != -1) {
                        --this.type;
                    }
                }
                return;
            }
            case 2: {
                this.m02 = d2 * this.m00;
                this.m12 = d3 * this.m11;
                if (this.m02 != 0.0 || this.m12 != 0.0) {
                    this.state = 3;
                    this.type |= 1;
                }
                return;
            }
            case 1: {
                this.m02 = d2 + this.m02;
                this.m12 = d3 + this.m12;
                if (this.m02 == 0.0 && this.m12 == 0.0) {
                    this.state = 0;
                    this.type = 0;
                }
                return;
            }
            case 0: 
        }
        this.m02 = d2;
        this.m12 = d3;
        if (d2 != 0.0 || d3 != 0.0) {
            this.state = 1;
            this.type = 1;
        }
    }

    public void rotate(double d2) {
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        if (Math.abs(d3) < 1.0E-15) {
            if (d4 < 0.0) {
                this.m00 = -this.m00;
                this.m11 = -this.m11;
                int n2 = this.state;
                if ((n2 & 4) != 0) {
                    this.m01 = -this.m01;
                    this.m10 = -this.m10;
                } else {
                    this.state = this.m00 == 1.0 && this.m11 == 1.0 ? n2 & 0xFFFFFFFD : n2 | 2;
                }
                this.type = -1;
            }
            return;
        }
        if (Math.abs(d4) < 1.0E-15) {
            double d5;
            if (d3 < 0.0) {
                d5 = this.m00;
                this.m00 = -this.m01;
                this.m01 = d5;
                d5 = this.m10;
                this.m10 = -this.m11;
                this.m11 = d5;
            } else {
                d5 = this.m00;
                this.m00 = this.m01;
                this.m01 = -d5;
                d5 = this.m10;
                this.m10 = this.m11;
                this.m11 = -d5;
            }
            int n3 = rot90conversion[this.state];
            if ((n3 & 6) == 2 && this.m00 == 1.0 && this.m11 == 1.0) {
                n3 -= 2;
            }
            this.state = n3;
            this.type = -1;
            return;
        }
        double d6 = this.m00;
        double d7 = this.m01;
        this.m00 = d4 * d6 + d3 * d7;
        this.m01 = -d3 * d6 + d4 * d7;
        d6 = this.m10;
        d7 = this.m11;
        this.m10 = d4 * d6 + d3 * d7;
        this.m11 = -d3 * d6 + d4 * d7;
        this.updateState();
    }

    public void rotate(double d2, double d3, double d4) {
        this.translate(d3, d4);
        this.rotate(d2);
        this.translate(-d3, -d4);
    }

    public void scale(double d2, double d3) {
        int n2 = this.state;
        switch (n2) {
            default: {
                this.stateError();
            }
            case 6: 
            case 7: {
                this.m00 *= d2;
                this.m11 *= d3;
            }
            case 4: 
            case 5: {
                this.m01 *= d3;
                this.m10 *= d2;
                if (this.m01 == 0.0 && this.m10 == 0.0) {
                    this.state = n2 - 4;
                }
                this.type = -1;
                return;
            }
            case 2: 
            case 3: {
                this.m00 *= d2;
                this.m11 *= d3;
                if (this.m00 == 1.0 && this.m11 == 1.0) {
                    this.state = n2 &= 1;
                    this.type = n2 == 0 ? 0 : 1;
                } else {
                    this.type = -1;
                }
                return;
            }
            case 0: 
            case 1: 
        }
        this.m00 = d2;
        this.m11 = d3;
        if (d2 != 1.0 || d3 != 1.0) {
            this.state = n2 | 2;
            this.type = -1;
        }
    }

    public void shear(double d2, double d3) {
        int n2 = this.state;
        switch (n2) {
            default: {
                this.stateError();
            }
            case 6: 
            case 7: {
                double d4 = this.m00;
                double d5 = this.m01;
                this.m00 = d4 + d5 * d3;
                this.m01 = d4 * d2 + d5;
                d4 = this.m10;
                d5 = this.m11;
                this.m10 = d4 + d5 * d3;
                this.m11 = d4 * d2 + d5;
                this.updateState();
                return;
            }
            case 4: 
            case 5: {
                this.m00 = this.m01 * d3;
                this.m11 = this.m10 * d2;
                if (this.m00 != 0.0 || this.m11 != 0.0) {
                    this.state = n2 | 2;
                }
                this.type = -1;
                return;
            }
            case 2: 
            case 3: {
                this.m01 = this.m00 * d2;
                this.m10 = this.m11 * d3;
                if (this.m01 != 0.0 || this.m10 != 0.0) {
                    this.state = n2 | 4;
                }
                this.type = -1;
                return;
            }
            case 0: 
            case 1: 
        }
        this.m01 = d2;
        this.m10 = d3;
        if (this.m01 != 0.0 || this.m10 != 0.0) {
            this.state = n2 | 2 | 4;
            this.type = -1;
        }
    }

    public void setToIdentity() {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m12 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m10 = 0.0;
        this.state = 0;
        this.type = 0;
    }

    public void setToTranslation(double d2, double d3) {
        this.m00 = 1.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m11 = 1.0;
        this.m02 = d2;
        this.m12 = d3;
        if (d2 != 0.0 || d3 != 0.0) {
            this.state = 1;
            this.type = 1;
        } else {
            this.state = 0;
            this.type = 0;
        }
    }

    public void setToRotation(double d2) {
        this.m02 = 0.0;
        this.m12 = 0.0;
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        if (Math.abs(d3) < 1.0E-15) {
            this.m10 = 0.0;
            this.m01 = 0.0;
            if (d4 < 0.0) {
                this.m11 = -1.0;
                this.m00 = -1.0;
                this.state = 2;
                this.type = 8;
            } else {
                this.m11 = 1.0;
                this.m00 = 1.0;
                this.state = 0;
                this.type = 0;
            }
            return;
        }
        if (Math.abs(d4) < 1.0E-15) {
            this.m11 = 0.0;
            this.m00 = 0.0;
            if (d3 < 0.0) {
                this.m01 = 1.0;
                this.m10 = -1.0;
            } else {
                this.m01 = -1.0;
                this.m10 = 1.0;
            }
            this.state = 4;
            this.type = 8;
            return;
        }
        this.m00 = d4;
        this.m01 = -d3;
        this.m10 = d3;
        this.m11 = d4;
        this.state = 6;
        this.type = 16;
    }

    public void setToRotation(double d2, double d3, double d4) {
        this.setToRotation(d2);
        double d5 = this.m10;
        double d6 = 1.0 - this.m00;
        this.m02 = d3 * d6 + d4 * d5;
        this.m12 = d4 * d6 - d3 * d5;
        if (this.m02 != 0.0 || this.m12 != 0.0) {
            this.state |= 1;
            this.type |= 1;
        }
    }

    public void setToScale(double d2, double d3) {
        this.m00 = d2;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m11 = d3;
        this.m02 = 0.0;
        this.m12 = 0.0;
        if (d2 != 1.0 || d3 != 1.0) {
            this.state = 2;
            this.type = -1;
        } else {
            this.state = 0;
            this.type = 0;
        }
    }

    public void setToShear(double d2, double d3) {
        this.m00 = 1.0;
        this.m01 = d2;
        this.m10 = d3;
        this.m11 = 1.0;
        this.m02 = 0.0;
        this.m12 = 0.0;
        if (d2 != 0.0 || d3 != 0.0) {
            this.state = 6;
            this.type = -1;
        } else {
            this.state = 0;
            this.type = 0;
        }
    }

    public void setTransform(AffineTransform affineTransform) {
        this.m00 = affineTransform.m00;
        this.m10 = affineTransform.m10;
        this.m01 = affineTransform.m01;
        this.m11 = affineTransform.m11;
        this.m02 = affineTransform.m02;
        this.m12 = affineTransform.m12;
        this.state = affineTransform.state;
        this.type = affineTransform.type;
    }

    public void setTransform(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.m00 = d2;
        this.m10 = d3;
        this.m01 = d4;
        this.m11 = d5;
        this.m02 = d6;
        this.m12 = d7;
        this.updateState();
    }

    public void concatenate(AffineTransform affineTransform) {
        int n2 = this.state;
        int n3 = affineTransform.state;
        switch (n3 << 3 | n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
            case 56: {
                this.m01 = affineTransform.m01;
                this.m10 = affineTransform.m10;
            }
            case 24: {
                this.m00 = affineTransform.m00;
                this.m11 = affineTransform.m11;
            }
            case 8: {
                this.m02 = affineTransform.m02;
                this.m12 = affineTransform.m12;
                this.state = n3;
                this.type = affineTransform.type;
                return;
            }
            case 48: {
                this.m01 = affineTransform.m01;
                this.m10 = affineTransform.m10;
            }
            case 16: {
                this.m00 = affineTransform.m00;
                this.m11 = affineTransform.m11;
                this.state = n3;
                this.type = affineTransform.type;
                return;
            }
            case 40: {
                this.m02 = affineTransform.m02;
                this.m12 = affineTransform.m12;
            }
            case 32: {
                this.m01 = affineTransform.m01;
                this.m10 = affineTransform.m10;
                this.m11 = 0.0;
                this.m00 = 0.0;
                this.state = n3;
                this.type = affineTransform.type;
                return;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.translate(affineTransform.m02, affineTransform.m12);
                return;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                this.scale(affineTransform.m00, affineTransform.m11);
                return;
            }
            case 38: 
            case 39: {
                double d2 = affineTransform.m01;
                double d3 = affineTransform.m10;
                double d4 = this.m00;
                this.m00 = this.m01 * d3;
                this.m01 = d4 * d2;
                d4 = this.m10;
                this.m10 = this.m11 * d3;
                this.m11 = d4 * d2;
                this.type = -1;
                return;
            }
            case 36: 
            case 37: {
                this.m00 = this.m01 * affineTransform.m10;
                this.m01 = 0.0;
                this.m11 = this.m10 * affineTransform.m01;
                this.m10 = 0.0;
                this.state = n2 ^ 6;
                this.type = -1;
                return;
            }
            case 34: 
            case 35: {
                this.m01 = this.m00 * affineTransform.m01;
                this.m00 = 0.0;
                this.m10 = this.m11 * affineTransform.m10;
                this.m11 = 0.0;
                this.state = n2 ^ 6;
                this.type = -1;
                return;
            }
            case 33: {
                this.m00 = 0.0;
                this.m01 = affineTransform.m01;
                this.m10 = affineTransform.m10;
                this.m11 = 0.0;
                this.state = 5;
                this.type = -1;
                return;
            }
        }
        double d5 = affineTransform.m00;
        double d6 = affineTransform.m01;
        double d7 = affineTransform.m02;
        double d8 = affineTransform.m10;
        double d9 = affineTransform.m11;
        double d10 = affineTransform.m12;
        switch (n2) {
            default: {
                this.stateError();
            }
            case 6: {
                this.state = n2 | n3;
            }
            case 7: {
                double d11 = this.m00;
                double d12 = this.m01;
                this.m00 = d5 * d11 + d8 * d12;
                this.m01 = d6 * d11 + d9 * d12;
                this.m02 += d7 * d11 + d10 * d12;
                d11 = this.m10;
                d12 = this.m11;
                this.m10 = d5 * d11 + d8 * d12;
                this.m11 = d6 * d11 + d9 * d12;
                this.m12 += d7 * d11 + d10 * d12;
                this.type = -1;
                return;
            }
            case 4: 
            case 5: {
                double d13 = this.m01;
                this.m00 = d8 * d13;
                this.m01 = d9 * d13;
                this.m02 += d10 * d13;
                d13 = this.m10;
                this.m10 = d5 * d13;
                this.m11 = d6 * d13;
                this.m12 += d7 * d13;
                break;
            }
            case 2: 
            case 3: {
                double d14 = this.m00;
                this.m00 = d5 * d14;
                this.m01 = d6 * d14;
                this.m02 += d7 * d14;
                d14 = this.m11;
                this.m10 = d8 * d14;
                this.m11 = d9 * d14;
                this.m12 += d10 * d14;
                break;
            }
            case 1: {
                this.m00 = d5;
                this.m01 = d6;
                this.m02 += d7;
                this.m10 = d8;
                this.m11 = d9;
                this.m12 += d10;
                this.state = n3 | 1;
                this.type = -1;
                return;
            }
        }
        this.updateState();
    }

    public void preConcatenate(AffineTransform affineTransform) {
        int n2 = this.state;
        int n3 = affineTransform.state;
        switch (n3 << 3 | n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                this.m02 = affineTransform.m02;
                this.m12 = affineTransform.m12;
                this.state = n2 | 1;
                this.type |= 1;
                return;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                this.m02 += affineTransform.m02;
                this.m12 += affineTransform.m12;
                return;
            }
            case 16: 
            case 17: {
                this.state = n2 | 2;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                double d2 = affineTransform.m00;
                double d3 = affineTransform.m11;
                if ((n2 & 4) != 0) {
                    this.m01 *= d2;
                    this.m10 *= d3;
                    if ((n2 & 2) != 0) {
                        this.m00 *= d2;
                        this.m11 *= d3;
                    }
                } else {
                    this.m00 *= d2;
                    this.m11 *= d3;
                }
                if ((n2 & 1) != 0) {
                    this.m02 *= d2;
                    this.m12 *= d3;
                }
                this.type = -1;
                return;
            }
            case 36: 
            case 37: {
                n2 |= 2;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                this.state = n2 ^ 4;
            }
            case 38: 
            case 39: {
                double d4 = affineTransform.m01;
                double d5 = affineTransform.m10;
                double d6 = this.m00;
                this.m00 = this.m10 * d4;
                this.m10 = d6 * d5;
                d6 = this.m01;
                this.m01 = this.m11 * d4;
                this.m11 = d6 * d5;
                d6 = this.m02;
                this.m02 = this.m12 * d4;
                this.m12 = d6 * d5;
                this.type = -1;
                return;
            }
        }
        double d7 = affineTransform.m00;
        double d8 = affineTransform.m01;
        double d9 = affineTransform.m02;
        double d10 = affineTransform.m10;
        double d11 = affineTransform.m11;
        double d12 = affineTransform.m12;
        switch (n2) {
            default: {
                this.stateError();
            }
            case 7: {
                double d13 = this.m02;
                double d14 = this.m12;
                d9 += d13 * d7 + d14 * d8;
                d12 += d13 * d10 + d14 * d11;
            }
            case 6: {
                this.m02 = d9;
                this.m12 = d12;
                double d13 = this.m00;
                double d14 = this.m10;
                this.m00 = d13 * d7 + d14 * d8;
                this.m10 = d13 * d10 + d14 * d11;
                d13 = this.m01;
                d14 = this.m11;
                this.m01 = d13 * d7 + d14 * d8;
                this.m11 = d13 * d10 + d14 * d11;
                break;
            }
            case 5: {
                double d15 = this.m02;
                double d16 = this.m12;
                d9 += d15 * d7 + d16 * d8;
                d12 += d15 * d10 + d16 * d11;
            }
            case 4: {
                this.m02 = d9;
                this.m12 = d12;
                double d15 = this.m10;
                this.m00 = d15 * d8;
                this.m10 = d15 * d11;
                d15 = this.m01;
                this.m01 = d15 * d7;
                this.m11 = d15 * d10;
                break;
            }
            case 3: {
                double d17 = this.m02;
                double d18 = this.m12;
                d9 += d17 * d7 + d18 * d8;
                d12 += d17 * d10 + d18 * d11;
            }
            case 2: {
                this.m02 = d9;
                this.m12 = d12;
                double d17 = this.m00;
                this.m00 = d17 * d7;
                this.m10 = d17 * d10;
                d17 = this.m11;
                this.m01 = d17 * d8;
                this.m11 = d17 * d11;
                break;
            }
            case 1: {
                double d19 = this.m02;
                double d20 = this.m12;
                d9 += d19 * d7 + d20 * d8;
                d12 += d19 * d10 + d20 * d11;
            }
            case 0: {
                this.m02 = d9;
                this.m12 = d12;
                this.m00 = d7;
                this.m10 = d10;
                this.m01 = d8;
                this.m11 = d11;
                this.state = n2 | n3;
                this.type = -1;
                return;
            }
        }
        this.updateState();
    }

    public AffineTransform createInverse() throws NoninvertibleTransformException {
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double d2 = this.m00 * this.m11 - this.m01 * this.m10;
                if (Math.abs(d2) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d2);
                }
                return new AffineTransform(this.m11 / d2, -this.m10 / d2, -this.m01 / d2, this.m00 / d2, (this.m01 * this.m12 - this.m11 * this.m02) / d2, (this.m10 * this.m02 - this.m00 * this.m12) / d2, 7);
            }
            case 6: {
                double d3 = this.m00 * this.m11 - this.m01 * this.m10;
                if (Math.abs(d3) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d3);
                }
                return new AffineTransform(this.m11 / d3, -this.m10 / d3, -this.m01 / d3, this.m00 / d3, 0.0, 0.0, 6);
            }
            case 5: {
                if (this.m01 == 0.0 || this.m10 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new AffineTransform(0.0, 1.0 / this.m01, 1.0 / this.m10, 0.0, -this.m12 / this.m10, -this.m02 / this.m01, 5);
            }
            case 4: {
                if (this.m01 == 0.0 || this.m10 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new AffineTransform(0.0, 1.0 / this.m01, 1.0 / this.m10, 0.0, 0.0, 0.0, 4);
            }
            case 3: {
                if (this.m00 == 0.0 || this.m11 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new AffineTransform(1.0 / this.m00, 0.0, 0.0, 1.0 / this.m11, -this.m02 / this.m00, -this.m12 / this.m11, 3);
            }
            case 2: {
                if (this.m00 == 0.0 || this.m11 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new AffineTransform(1.0 / this.m00, 0.0, 0.0, 1.0 / this.m11, 0.0, 0.0, 2);
            }
            case 1: {
                return new AffineTransform(1.0, 0.0, 0.0, 1.0, -this.m02, -this.m12, 1);
            }
            case 0: 
        }
        return new AffineTransform();
    }

    public Point2D transform(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = point2D instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                point2D2.setLocation(d2 * this.m00 + d3 * this.m01 + this.m02, d2 * this.m10 + d3 * this.m11 + this.m12);
                return point2D2;
            }
            case 6: {
                point2D2.setLocation(d2 * this.m00 + d3 * this.m01, d2 * this.m10 + d3 * this.m11);
                return point2D2;
            }
            case 5: {
                point2D2.setLocation(d3 * this.m01 + this.m02, d2 * this.m10 + this.m12);
                return point2D2;
            }
            case 4: {
                point2D2.setLocation(d3 * this.m01, d2 * this.m10);
                return point2D2;
            }
            case 3: {
                point2D2.setLocation(d2 * this.m00 + this.m02, d3 * this.m11 + this.m12);
                return point2D2;
            }
            case 2: {
                point2D2.setLocation(d2 * this.m00, d3 * this.m11);
                return point2D2;
            }
            case 1: {
                point2D2.setLocation(d2 + this.m02, d3 + this.m12);
                return point2D2;
            }
            case 0: 
        }
        point2D2.setLocation(d2, d3);
        return point2D2;
    }

    public void transform(Point2D[] point2DArray, int n2, Point2D[] point2DArray2, int n3, int n4) {
        int n5 = this.state;
        block10: while (--n4 >= 0) {
            Point2D point2D;
            Point2D point2D2 = point2DArray[n2++];
            double d2 = point2D2.getX();
            double d3 = point2D2.getY();
            if ((point2D = point2DArray2[n3++]) == null) {
                point2D = point2D2 instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
                point2DArray2[n3 - 1] = point2D;
            }
            switch (n5) {
                default: {
                    this.stateError();
                }
                case 7: {
                    point2D.setLocation(d2 * this.m00 + d3 * this.m01 + this.m02, d2 * this.m10 + d3 * this.m11 + this.m12);
                    continue block10;
                }
                case 6: {
                    point2D.setLocation(d2 * this.m00 + d3 * this.m01, d2 * this.m10 + d3 * this.m11);
                    continue block10;
                }
                case 5: {
                    point2D.setLocation(d3 * this.m01 + this.m02, d2 * this.m10 + this.m12);
                    continue block10;
                }
                case 4: {
                    point2D.setLocation(d3 * this.m01, d2 * this.m10);
                    continue block10;
                }
                case 3: {
                    point2D.setLocation(d2 * this.m00 + this.m02, d3 * this.m11 + this.m12);
                    continue block10;
                }
                case 2: {
                    point2D.setLocation(d2 * this.m00, d3 * this.m11);
                    continue block10;
                }
                case 1: {
                    point2D.setLocation(d2 + this.m02, d3 + this.m12);
                    continue block10;
                }
                case 0: 
            }
            point2D.setLocation(d2, d3);
        }
    }

    public void transform(float[] fArray, int n2, float[] fArray2, int n3, int n4) {
        if (fArray2 == fArray && n3 > n2 && n3 < n2 + n4 * 2) {
            System.arraycopy(fArray, n2, fArray2, n3, n4 * 2);
            n2 = n3;
        }
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double d2 = this.m00;
                double d3 = this.m01;
                double d4 = this.m02;
                double d5 = this.m10;
                double d6 = this.m11;
                double d7 = this.m12;
                while (--n4 >= 0) {
                    double d8 = fArray[n2++];
                    double d9 = fArray[n2++];
                    fArray2[n3++] = (float)(d2 * d8 + d3 * d9 + d4);
                    fArray2[n3++] = (float)(d5 * d8 + d6 * d9 + d7);
                }
                return;
            }
            case 6: {
                double d10 = this.m00;
                double d11 = this.m01;
                double d12 = this.m10;
                double d13 = this.m11;
                while (--n4 >= 0) {
                    double d14 = fArray[n2++];
                    double d15 = fArray[n2++];
                    fArray2[n3++] = (float)(d10 * d14 + d11 * d15);
                    fArray2[n3++] = (float)(d12 * d14 + d13 * d15);
                }
                return;
            }
            case 5: {
                double d16 = this.m01;
                double d17 = this.m02;
                double d18 = this.m10;
                double d19 = this.m12;
                while (--n4 >= 0) {
                    double d20 = fArray[n2++];
                    fArray2[n3++] = (float)(d16 * (double)fArray[n2++] + d17);
                    fArray2[n3++] = (float)(d18 * d20 + d19);
                }
                return;
            }
            case 4: {
                double d21 = this.m01;
                double d22 = this.m10;
                while (--n4 >= 0) {
                    double d23 = fArray[n2++];
                    fArray2[n3++] = (float)(d21 * (double)fArray[n2++]);
                    fArray2[n3++] = (float)(d22 * d23);
                }
                return;
            }
            case 3: {
                double d24 = this.m00;
                double d25 = this.m02;
                double d26 = this.m11;
                double d27 = this.m12;
                while (--n4 >= 0) {
                    fArray2[n3++] = (float)(d24 * (double)fArray[n2++] + d25);
                    fArray2[n3++] = (float)(d26 * (double)fArray[n2++] + d27);
                }
                return;
            }
            case 2: {
                double d28 = this.m00;
                double d29 = this.m11;
                while (--n4 >= 0) {
                    fArray2[n3++] = (float)(d28 * (double)fArray[n2++]);
                    fArray2[n3++] = (float)(d29 * (double)fArray[n2++]);
                }
                return;
            }
            case 1: {
                double d30 = this.m02;
                double d31 = this.m12;
                while (--n4 >= 0) {
                    fArray2[n3++] = (float)((double)fArray[n2++] + d30);
                    fArray2[n3++] = (float)((double)fArray[n2++] + d31);
                }
                return;
            }
            case 0: 
        }
        if (fArray != fArray2 || n2 != n3) {
            System.arraycopy(fArray, n2, fArray2, n3, n4 * 2);
        }
    }

    public void transform(double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        if (dArray2 == dArray && n3 > n2 && n3 < n2 + n4 * 2) {
            System.arraycopy(dArray, n2, dArray2, n3, n4 * 2);
            n2 = n3;
        }
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double d2 = this.m00;
                double d3 = this.m01;
                double d4 = this.m02;
                double d5 = this.m10;
                double d6 = this.m11;
                double d7 = this.m12;
                while (--n4 >= 0) {
                    double d8 = dArray[n2++];
                    double d9 = dArray[n2++];
                    dArray2[n3++] = d2 * d8 + d3 * d9 + d4;
                    dArray2[n3++] = d5 * d8 + d6 * d9 + d7;
                }
                return;
            }
            case 6: {
                double d10 = this.m00;
                double d11 = this.m01;
                double d12 = this.m10;
                double d13 = this.m11;
                while (--n4 >= 0) {
                    double d14 = dArray[n2++];
                    double d15 = dArray[n2++];
                    dArray2[n3++] = d10 * d14 + d11 * d15;
                    dArray2[n3++] = d12 * d14 + d13 * d15;
                }
                return;
            }
            case 5: {
                double d16 = this.m01;
                double d17 = this.m02;
                double d18 = this.m10;
                double d19 = this.m12;
                while (--n4 >= 0) {
                    double d20 = dArray[n2++];
                    dArray2[n3++] = d16 * dArray[n2++] + d17;
                    dArray2[n3++] = d18 * d20 + d19;
                }
                return;
            }
            case 4: {
                double d21 = this.m01;
                double d22 = this.m10;
                while (--n4 >= 0) {
                    double d23 = dArray[n2++];
                    dArray2[n3++] = d21 * dArray[n2++];
                    dArray2[n3++] = d22 * d23;
                }
                return;
            }
            case 3: {
                double d24 = this.m00;
                double d25 = this.m02;
                double d26 = this.m11;
                double d27 = this.m12;
                while (--n4 >= 0) {
                    dArray2[n3++] = d24 * dArray[n2++] + d25;
                    dArray2[n3++] = d26 * dArray[n2++] + d27;
                }
                return;
            }
            case 2: {
                double d28 = this.m00;
                double d29 = this.m11;
                while (--n4 >= 0) {
                    dArray2[n3++] = d28 * dArray[n2++];
                    dArray2[n3++] = d29 * dArray[n2++];
                }
                return;
            }
            case 1: {
                double d30 = this.m02;
                double d31 = this.m12;
                while (--n4 >= 0) {
                    dArray2[n3++] = dArray[n2++] + d30;
                    dArray2[n3++] = dArray[n2++] + d31;
                }
                return;
            }
            case 0: 
        }
        if (dArray != dArray2 || n2 != n3) {
            System.arraycopy(dArray, n2, dArray2, n3, n4 * 2);
        }
    }

    public void transform(float[] fArray, int n2, double[] dArray, int n3, int n4) {
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double d2 = this.m00;
                double d3 = this.m01;
                double d4 = this.m02;
                double d5 = this.m10;
                double d6 = this.m11;
                double d7 = this.m12;
                while (--n4 >= 0) {
                    double d8 = fArray[n2++];
                    double d9 = fArray[n2++];
                    dArray[n3++] = d2 * d8 + d3 * d9 + d4;
                    dArray[n3++] = d5 * d8 + d6 * d9 + d7;
                }
                return;
            }
            case 6: {
                double d10 = this.m00;
                double d11 = this.m01;
                double d12 = this.m10;
                double d13 = this.m11;
                while (--n4 >= 0) {
                    double d14 = fArray[n2++];
                    double d15 = fArray[n2++];
                    dArray[n3++] = d10 * d14 + d11 * d15;
                    dArray[n3++] = d12 * d14 + d13 * d15;
                }
                return;
            }
            case 5: {
                double d16 = this.m01;
                double d17 = this.m02;
                double d18 = this.m10;
                double d19 = this.m12;
                while (--n4 >= 0) {
                    double d20 = fArray[n2++];
                    dArray[n3++] = d16 * (double)fArray[n2++] + d17;
                    dArray[n3++] = d18 * d20 + d19;
                }
                return;
            }
            case 4: {
                double d21 = this.m01;
                double d22 = this.m10;
                while (--n4 >= 0) {
                    double d23 = fArray[n2++];
                    dArray[n3++] = d21 * (double)fArray[n2++];
                    dArray[n3++] = d22 * d23;
                }
                return;
            }
            case 3: {
                double d24 = this.m00;
                double d25 = this.m02;
                double d26 = this.m11;
                double d27 = this.m12;
                while (--n4 >= 0) {
                    dArray[n3++] = d24 * (double)fArray[n2++] + d25;
                    dArray[n3++] = d26 * (double)fArray[n2++] + d27;
                }
                return;
            }
            case 2: {
                double d28 = this.m00;
                double d29 = this.m11;
                while (--n4 >= 0) {
                    dArray[n3++] = d28 * (double)fArray[n2++];
                    dArray[n3++] = d29 * (double)fArray[n2++];
                }
                return;
            }
            case 1: {
                double d30 = this.m02;
                double d31 = this.m12;
                while (--n4 >= 0) {
                    dArray[n3++] = (double)fArray[n2++] + d30;
                    dArray[n3++] = (double)fArray[n2++] + d31;
                }
                return;
            }
            case 0: 
        }
        while (--n4 >= 0) {
            dArray[n3++] = fArray[n2++];
            dArray[n3++] = fArray[n2++];
        }
    }

    public void transform(double[] dArray, int n2, float[] fArray, int n3, int n4) {
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double d2 = this.m00;
                double d3 = this.m01;
                double d4 = this.m02;
                double d5 = this.m10;
                double d6 = this.m11;
                double d7 = this.m12;
                while (--n4 >= 0) {
                    double d8 = dArray[n2++];
                    double d9 = dArray[n2++];
                    fArray[n3++] = (float)(d2 * d8 + d3 * d9 + d4);
                    fArray[n3++] = (float)(d5 * d8 + d6 * d9 + d7);
                }
                return;
            }
            case 6: {
                double d10 = this.m00;
                double d11 = this.m01;
                double d12 = this.m10;
                double d13 = this.m11;
                while (--n4 >= 0) {
                    double d14 = dArray[n2++];
                    double d15 = dArray[n2++];
                    fArray[n3++] = (float)(d10 * d14 + d11 * d15);
                    fArray[n3++] = (float)(d12 * d14 + d13 * d15);
                }
                return;
            }
            case 5: {
                double d16 = this.m01;
                double d17 = this.m02;
                double d18 = this.m10;
                double d19 = this.m12;
                while (--n4 >= 0) {
                    double d20 = dArray[n2++];
                    fArray[n3++] = (float)(d16 * dArray[n2++] + d17);
                    fArray[n3++] = (float)(d18 * d20 + d19);
                }
                return;
            }
            case 4: {
                double d21 = this.m01;
                double d22 = this.m10;
                while (--n4 >= 0) {
                    double d23 = dArray[n2++];
                    fArray[n3++] = (float)(d21 * dArray[n2++]);
                    fArray[n3++] = (float)(d22 * d23);
                }
                return;
            }
            case 3: {
                double d24 = this.m00;
                double d25 = this.m02;
                double d26 = this.m11;
                double d27 = this.m12;
                while (--n4 >= 0) {
                    fArray[n3++] = (float)(d24 * dArray[n2++] + d25);
                    fArray[n3++] = (float)(d26 * dArray[n2++] + d27);
                }
                return;
            }
            case 2: {
                double d28 = this.m00;
                double d29 = this.m11;
                while (--n4 >= 0) {
                    fArray[n3++] = (float)(d28 * dArray[n2++]);
                    fArray[n3++] = (float)(d29 * dArray[n2++]);
                }
                return;
            }
            case 1: {
                double d30 = this.m02;
                double d31 = this.m12;
                while (--n4 >= 0) {
                    fArray[n3++] = (float)(dArray[n2++] + d30);
                    fArray[n3++] = (float)(dArray[n2++] + d31);
                }
                return;
            }
            case 0: 
        }
        while (--n4 >= 0) {
            fArray[n3++] = (float)dArray[n2++];
            fArray[n3++] = (float)dArray[n2++];
        }
    }

    public Point2D inverseTransform(Point2D point2D, Point2D point2D2) throws NoninvertibleTransformException {
        if (point2D2 == null) {
            point2D2 = point2D instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                d2 -= this.m02;
                d3 -= this.m12;
            }
            case 6: {
                double d4 = this.m00 * this.m11 - this.m01 * this.m10;
                if (Math.abs(d4) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d4);
                }
                point2D2.setLocation((d2 * this.m11 - d3 * this.m01) / d4, (d3 * this.m00 - d2 * this.m10) / d4);
                return point2D2;
            }
            case 5: {
                d2 -= this.m02;
                d3 -= this.m12;
            }
            case 4: {
                if (this.m01 == 0.0 || this.m10 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                point2D2.setLocation(d3 / this.m10, d2 / this.m01);
                return point2D2;
            }
            case 3: {
                d2 -= this.m02;
                d3 -= this.m12;
            }
            case 2: {
                if (this.m00 == 0.0 || this.m11 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                point2D2.setLocation(d2 / this.m00, d3 / this.m11);
                return point2D2;
            }
            case 1: {
                point2D2.setLocation(d2 - this.m02, d3 - this.m12);
                return point2D2;
            }
            case 0: 
        }
        point2D2.setLocation(d2, d3);
        return point2D2;
    }

    public void inverseTransform(double[] dArray, int n2, double[] dArray2, int n3, int n4) throws NoninvertibleTransformException {
        if (dArray2 == dArray && n3 > n2 && n3 < n2 + n4 * 2) {
            System.arraycopy(dArray, n2, dArray2, n3, n4 * 2);
            n2 = n3;
        }
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double d2 = this.m00;
                double d3 = this.m01;
                double d4 = this.m02;
                double d5 = this.m10;
                double d6 = this.m11;
                double d7 = this.m12;
                double d8 = d2 * d6 - d3 * d5;
                if (Math.abs(d8) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d8);
                }
                while (--n4 >= 0) {
                    double d9 = dArray[n2++] - d4;
                    double d10 = dArray[n2++] - d7;
                    dArray2[n3++] = (d9 * d6 - d10 * d3) / d8;
                    dArray2[n3++] = (d10 * d2 - d9 * d5) / d8;
                }
                return;
            }
            case 6: {
                double d11 = this.m00;
                double d12 = this.m01;
                double d13 = this.m10;
                double d14 = this.m11;
                double d15 = d11 * d14 - d12 * d13;
                if (Math.abs(d15) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d15);
                }
                while (--n4 >= 0) {
                    double d16 = dArray[n2++];
                    double d17 = dArray[n2++];
                    dArray2[n3++] = (d16 * d14 - d17 * d12) / d15;
                    dArray2[n3++] = (d17 * d11 - d16 * d13) / d15;
                }
                return;
            }
            case 5: {
                double d18 = this.m01;
                double d19 = this.m02;
                double d20 = this.m10;
                double d21 = this.m12;
                if (d18 == 0.0 || d20 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--n4 >= 0) {
                    double d22 = dArray[n2++] - d19;
                    dArray2[n3++] = (dArray[n2++] - d21) / d20;
                    dArray2[n3++] = d22 / d18;
                }
                return;
            }
            case 4: {
                double d23 = this.m01;
                double d24 = this.m10;
                if (d23 == 0.0 || d24 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--n4 >= 0) {
                    double d25 = dArray[n2++];
                    dArray2[n3++] = dArray[n2++] / d24;
                    dArray2[n3++] = d25 / d23;
                }
                return;
            }
            case 3: {
                double d26 = this.m00;
                double d27 = this.m02;
                double d28 = this.m11;
                double d29 = this.m12;
                if (d26 == 0.0 || d28 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--n4 >= 0) {
                    dArray2[n3++] = (dArray[n2++] - d27) / d26;
                    dArray2[n3++] = (dArray[n2++] - d29) / d28;
                }
                return;
            }
            case 2: {
                double d30 = this.m00;
                double d31 = this.m11;
                if (d30 == 0.0 || d31 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--n4 >= 0) {
                    dArray2[n3++] = dArray[n2++] / d30;
                    dArray2[n3++] = dArray[n2++] / d31;
                }
                return;
            }
            case 1: {
                double d32 = this.m02;
                double d33 = this.m12;
                while (--n4 >= 0) {
                    dArray2[n3++] = dArray[n2++] - d32;
                    dArray2[n3++] = dArray[n2++] - d33;
                }
                return;
            }
            case 0: 
        }
        if (dArray != dArray2 || n2 != n3) {
            System.arraycopy(dArray, n2, dArray2, n3, n4 * 2);
        }
    }

    public Point2D deltaTransform(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = point2D instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 6: 
            case 7: {
                point2D2.setLocation(d2 * this.m00 + d3 * this.m01, d2 * this.m10 + d3 * this.m11);
                return point2D2;
            }
            case 4: 
            case 5: {
                point2D2.setLocation(d3 * this.m01, d2 * this.m10);
                return point2D2;
            }
            case 2: 
            case 3: {
                point2D2.setLocation(d2 * this.m00, d3 * this.m11);
                return point2D2;
            }
            case 0: 
            case 1: 
        }
        point2D2.setLocation(d2, d3);
        return point2D2;
    }

    public void deltaTransform(double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        if (dArray2 == dArray && n3 > n2 && n3 < n2 + n4 * 2) {
            System.arraycopy(dArray, n2, dArray2, n3, n4 * 2);
            n2 = n3;
        }
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 6: 
            case 7: {
                double d2 = this.m00;
                double d3 = this.m01;
                double d4 = this.m10;
                double d5 = this.m11;
                while (--n4 >= 0) {
                    double d6 = dArray[n2++];
                    double d7 = dArray[n2++];
                    dArray2[n3++] = d6 * d2 + d7 * d3;
                    dArray2[n3++] = d6 * d4 + d7 * d5;
                }
                return;
            }
            case 4: 
            case 5: {
                double d8 = this.m01;
                double d9 = this.m10;
                while (--n4 >= 0) {
                    double d10 = dArray[n2++];
                    dArray2[n3++] = dArray[n2++] * d8;
                    dArray2[n3++] = d10 * d9;
                }
                return;
            }
            case 2: 
            case 3: {
                double d11 = this.m00;
                double d12 = this.m11;
                while (--n4 >= 0) {
                    dArray2[n3++] = dArray[n2++] * d11;
                    dArray2[n3++] = dArray[n2++] * d12;
                }
                return;
            }
            case 0: 
            case 1: 
        }
        if (dArray != dArray2 || n2 != n3) {
            System.arraycopy(dArray, n2, dArray2, n3, n4 * 2);
        }
    }

    public Shape createTransformedShape(Shape shape) {
        if (shape == null) {
            return null;
        }
        if (shape instanceof GeneralPath) {
            return ((GeneralPath)shape).createTransformedShape(this);
        }
        PathIterator pathIterator = shape.getPathIterator(this);
        GeneralPath generalPath = new GeneralPath(pathIterator.getWindingRule());
        generalPath.append(pathIterator, false);
        return generalPath;
    }

    private static double _matround(double d2) {
        return Math.rint(d2 * 1.0E15) / 1.0E15;
    }

    public String toString() {
        return "AffineTransform[[" + AffineTransform._matround(this.m00) + ", " + AffineTransform._matround(this.m01) + ", " + AffineTransform._matround(this.m02) + "], [" + AffineTransform._matround(this.m10) + ", " + AffineTransform._matround(this.m11) + ", " + AffineTransform._matround(this.m12) + "]]";
    }

    public boolean isIdentity() {
        return this.state == 0 || this.getType() == 0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.m00);
        l2 = l2 * 31L + Double.doubleToLongBits(this.m01);
        l2 = l2 * 31L + Double.doubleToLongBits(this.m02);
        l2 = l2 * 31L + Double.doubleToLongBits(this.m10);
        l2 = l2 * 31L + Double.doubleToLongBits(this.m11);
        l2 = l2 * 31L + Double.doubleToLongBits(this.m12);
        return (int)l2 ^ (int)(l2 >> 32);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AffineTransform)) {
            return false;
        }
        AffineTransform affineTransform = (AffineTransform)object;
        return this.m00 == affineTransform.m00 && this.m01 == affineTransform.m01 && this.m02 == affineTransform.m02 && this.m10 == affineTransform.m10 && this.m11 == affineTransform.m11 && this.m12 == affineTransform.m12;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.updateState();
    }
}

