/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class PushbackReader
extends FilterReader {
    private char[] buf;
    private int pos;

    public PushbackReader(Reader reader, int n2) {
        super(reader);
        if (n2 <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.buf = new char[n2];
        this.pos = n2;
    }

    public PushbackReader(Reader reader) {
        this(reader, 1);
    }

    private void ensureOpen() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.pos < this.buf.length) {
                return this.buf[this.pos++];
            }
            return super.read();
        }
    }

    public int read(char[] cArray, int n2, int n3) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            try {
                if (n3 <= 0) {
                    if (n3 < 0) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (n2 < 0 || n2 > cArray.length) {
                        throw new IndexOutOfBoundsException();
                    }
                    return 0;
                }
                int n4 = this.buf.length - this.pos;
                if (n4 > 0) {
                    if (n3 < n4) {
                        n4 = n3;
                    }
                    System.arraycopy(this.buf, this.pos, cArray, n2, n4);
                    this.pos += n4;
                    n2 += n4;
                    n3 -= n4;
                }
                if (n3 > 0) {
                    if ((n3 = super.read(cArray, n2, n3)) == -1) {
                        return n4 == 0 ? -1 : n4;
                    }
                    return n4 + n3;
                }
                return n4;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unread(int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.pos == 0) {
                throw new IOException("Pushback buffer overflow");
            }
            this.buf[--this.pos] = (char)n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unread(char[] cArray, int n2, int n3) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n3 > this.pos) {
                throw new IOException("Pushback buffer overflow");
            }
            this.pos -= n3;
            System.arraycopy(cArray, n2, this.buf, this.pos, n3);
        }
    }

    public void unread(char[] cArray) throws IOException {
        this.unread(cArray, 0, cArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.pos < this.buf.length || super.ready();
        }
    }

    public void mark(int n2) throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public void close() throws IOException {
        super.close();
        this.buf = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            int n2 = this.buf.length - this.pos;
            if (n2 > 0) {
                if (l2 <= (long)n2) {
                    this.pos = (int)((long)this.pos + l2);
                    return l2;
                }
                this.pos = this.buf.length;
                l2 -= (long)n2;
            }
            return (long)n2 + super.skip(l2);
        }
    }
}

