/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public class InetSocketAddress
extends SocketAddress {
    private String hostname = null;
    private InetAddress addr = null;
    private int port;
    private static final long serialVersionUID = 5076001401234631237L;

    private InetSocketAddress() {
    }

    public InetSocketAddress(int n2) {
        this(InetAddress.anyLocalAddress(), n2);
    }

    public InetSocketAddress(InetAddress inetAddress, int n2) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("port out of range:" + n2);
        }
        this.port = n2;
        this.addr = inetAddress == null ? InetAddress.anyLocalAddress() : inetAddress;
    }

    public InetSocketAddress(String string, int n2) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("port out of range:" + n2);
        }
        if (string == null) {
            throw new IllegalArgumentException("hostname can't be null");
        }
        try {
            this.addr = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            this.hostname = string;
            this.addr = null;
        }
        this.port = n2;
    }

    public static InetSocketAddress createUnresolved(String string, int n2) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("port out of range:" + n2);
        }
        if (string == null) {
            throw new IllegalArgumentException("hostname can't be null");
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress();
        inetSocketAddress.port = n2;
        inetSocketAddress.hostname = string;
        inetSocketAddress.addr = null;
        return inetSocketAddress;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.port < 0 || this.port > 65535) {
            throw new InvalidObjectException("port out of range:" + this.port);
        }
        if (this.hostname == null && this.addr == null) {
            throw new InvalidObjectException("hostname and addr can't both be null");
        }
    }

    public final int getPort() {
        return this.port;
    }

    public final InetAddress getAddress() {
        return this.addr;
    }

    public final String getHostName() {
        if (this.hostname != null) {
            return this.hostname;
        }
        if (this.addr != null) {
            return this.addr.getHostName();
        }
        return null;
    }

    final String getHostString() {
        if (this.hostname != null) {
            return this.hostname;
        }
        if (this.addr != null) {
            if (this.addr.hostName != null) {
                return this.addr.hostName;
            }
            return this.addr.getHostAddress();
        }
        return null;
    }

    public final boolean isUnresolved() {
        return this.addr == null;
    }

    public String toString() {
        if (this.isUnresolved()) {
            return this.hostname + ":" + this.port;
        }
        return this.addr.toString() + ":" + this.port;
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof InetSocketAddress)) {
            return false;
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)object;
        boolean bl2 = false;
        bl2 = this.addr != null ? this.addr.equals(inetSocketAddress.addr) : (this.hostname != null ? inetSocketAddress.addr == null && this.hostname.equals(inetSocketAddress.hostname) : inetSocketAddress.addr == null && inetSocketAddress.hostname == null);
        return bl2 && this.port == inetSocketAddress.port;
    }

    public final int hashCode() {
        if (this.addr != null) {
            return this.addr.hashCode() + this.port;
        }
        if (this.hostname != null) {
            return this.hostname.hashCode() + this.port;
        }
        return this.port;
    }
}

