/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.BreakIterator;
import java.util.MissingResourceException;
import sun.text.CompactByteArray;
import sun.text.SupplementaryCharacterData;

class BreakDictionary {
    private static int supportedVersion = 1;
    private CompactByteArray columnMap = null;
    private SupplementaryCharacterData supplementaryCharColumnMap = null;
    private int numCols;
    private int numColGroups;
    private short[] table = null;
    private short[] rowIndex = null;
    private int[] rowIndexFlags = null;
    private short[] rowIndexFlagsIndex = null;
    private byte[] rowIndexShifts = null;

    public BreakDictionary(String string) throws IOException, MissingResourceException {
        this.readDictionaryFile(string);
    }

    private void readDictionaryFile(final String string) throws IOException, MissingResourceException {
        BufferedInputStream bufferedInputStream;
        try {
            bufferedInputStream = (BufferedInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new BufferedInputStream(this.getClass().getResourceAsStream("/sun/text/resources/" + string));
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new InternalError(privilegedActionException.toString());
        }
        byte[] byArray = new byte[8];
        if (bufferedInputStream.read(byArray) != 8) {
            throw new MissingResourceException("Wrong data length", string, "");
        }
        int n2 = BreakIterator.getInt(byArray, 0);
        if (n2 != supportedVersion) {
            throw new MissingResourceException("Dictionary version(" + n2 + ") is unsupported", string, "");
        }
        int n3 = BreakIterator.getInt(byArray, 4);
        if (bufferedInputStream.read(byArray = new byte[n3]) != n3) {
            throw new MissingResourceException("Wrong data length", string, "");
        }
        bufferedInputStream.close();
        int n4 = 0;
        int n5 = BreakIterator.getInt(byArray, n4);
        n4 += 4;
        short[] sArray = new short[n5];
        int n6 = 0;
        while (n6 < n5) {
            sArray[n6] = BreakIterator.getShort(byArray, n4);
            ++n6;
            n4 += 2;
        }
        n5 = BreakIterator.getInt(byArray, n4);
        n4 += 4;
        byte[] byArray2 = new byte[n5];
        int n7 = 0;
        while (n7 < n5) {
            byArray2[n7] = byArray[n4];
            ++n7;
            ++n4;
        }
        this.columnMap = new CompactByteArray(sArray, byArray2);
        this.numCols = BreakIterator.getInt(byArray, n4);
        this.numColGroups = BreakIterator.getInt(byArray, n4 += 4);
        n5 = BreakIterator.getInt(byArray, n4 += 4);
        n4 += 4;
        this.rowIndex = new short[n5];
        n7 = 0;
        while (n7 < n5) {
            this.rowIndex[n7] = BreakIterator.getShort(byArray, n4);
            ++n7;
            n4 += 2;
        }
        n5 = BreakIterator.getInt(byArray, n4);
        n4 += 4;
        this.rowIndexFlagsIndex = new short[n5];
        n7 = 0;
        while (n7 < n5) {
            this.rowIndexFlagsIndex[n7] = BreakIterator.getShort(byArray, n4);
            ++n7;
            n4 += 2;
        }
        n5 = BreakIterator.getInt(byArray, n4);
        n4 += 4;
        this.rowIndexFlags = new int[n5];
        n7 = 0;
        while (n7 < n5) {
            this.rowIndexFlags[n7] = BreakIterator.getInt(byArray, n4);
            ++n7;
            n4 += 4;
        }
        n5 = BreakIterator.getInt(byArray, n4);
        n4 += 4;
        this.rowIndexShifts = new byte[n5];
        n7 = 0;
        while (n7 < n5) {
            this.rowIndexShifts[n7] = byArray[n4];
            ++n7;
            ++n4;
        }
        n5 = BreakIterator.getInt(byArray, n4);
        n4 += 4;
        this.table = new short[n5];
        n7 = 0;
        while (n7 < n5) {
            this.table[n7] = BreakIterator.getShort(byArray, n4);
            ++n7;
            n4 += 2;
        }
        n5 = BreakIterator.getInt(byArray, n4);
        n4 += 4;
        int[] nArray = new int[n5];
        int n8 = 0;
        while (n8 < n5) {
            nArray[n8] = BreakIterator.getInt(byArray, n4);
            ++n8;
            n4 += 4;
        }
        this.supplementaryCharColumnMap = new SupplementaryCharacterData(nArray);
    }

    public final short getNextStateFromCharacter(int n2, int n3) {
        int n4 = n3 < 65536 ? (int)this.columnMap.elementAt((char)n3) : this.supplementaryCharColumnMap.getValue(n3);
        return this.getNextState(n2, n4);
    }

    public final short getNextState(int n2, int n3) {
        if (this.cellIsPopulated(n2, n3)) {
            return this.internalAt(this.rowIndex[n2], n3 + this.rowIndexShifts[n2]);
        }
        return 0;
    }

    private final boolean cellIsPopulated(int n2, int n3) {
        if (this.rowIndexFlagsIndex[n2] < 0) {
            return n3 == -this.rowIndexFlagsIndex[n2];
        }
        int n4 = this.rowIndexFlags[this.rowIndexFlagsIndex[n2] + (n3 >> 5)];
        return (n4 & 1 << (n3 & 0x1F)) != 0;
    }

    private final short internalAt(int n2, int n3) {
        return this.table[n2 * this.numCols + n3];
    }
}

