/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;
import java.text.EntryPair;
import java.text.RBCollationTables;
import java.text.RuleBasedCollator;
import java.util.Vector;
import sun.text.Normalizer;
import sun.text.NormalizerUtilities;

public final class CollationElementIterator {
    public static final int NULLORDER = -1;
    static final int UNMAPPEDCHARVALUE = 0x7FFF0000;
    private Normalizer text = null;
    private int[] buffer = null;
    private int expIndex = 0;
    private StringBuffer key = new StringBuffer(5);
    private int swapOrder = 0;
    private RBCollationTables ordering;
    private RuleBasedCollator owner;

    CollationElementIterator(String string, RuleBasedCollator ruleBasedCollator) {
        this.owner = ruleBasedCollator;
        this.ordering = ruleBasedCollator.getTables();
        if (string.length() != 0) {
            Normalizer.Mode mode = NormalizerUtilities.toNormalizerMode(ruleBasedCollator.getDecomposition());
            this.text = new Normalizer(string, mode);
        }
    }

    CollationElementIterator(CharacterIterator characterIterator, RuleBasedCollator ruleBasedCollator) {
        this.owner = ruleBasedCollator;
        this.ordering = ruleBasedCollator.getTables();
        Normalizer.Mode mode = NormalizerUtilities.toNormalizerMode(ruleBasedCollator.getDecomposition());
        this.text = new Normalizer(characterIterator, mode);
    }

    public void reset() {
        if (this.text != null) {
            this.text.reset();
            Normalizer.Mode mode = NormalizerUtilities.toNormalizerMode(this.owner.getDecomposition());
            this.text.setMode(mode);
        }
        this.buffer = null;
        this.expIndex = 0;
        this.swapOrder = 0;
    }

    public int next() {
        Normalizer.Mode mode;
        if (this.text == null) {
            return -1;
        }
        Normalizer.Mode mode2 = this.text.getMode();
        if (mode2 != (mode = NormalizerUtilities.toNormalizerMode(this.owner.getDecomposition()))) {
            this.text.setMode(mode);
        }
        if (this.buffer != null) {
            if (this.expIndex < this.buffer.length) {
                return this.strengthOrder(this.buffer[this.expIndex++]);
            }
            this.buffer = null;
            this.expIndex = 0;
        } else if (this.swapOrder != 0) {
            if (Character.isSupplementaryCodePoint(this.swapOrder)) {
                char[] cArray = Character.toChars(this.swapOrder);
                this.swapOrder = cArray[1];
                return cArray[0] << 16;
            }
            int n2 = this.swapOrder << 16;
            this.swapOrder = 0;
            return n2;
        }
        int n3 = this.text.next();
        if (n3 == -1) {
            return -1;
        }
        int n4 = this.ordering.getUnicodeOrder(n3);
        if (n4 == -1) {
            this.swapOrder = n3;
            return 0x7FFF0000;
        }
        if (n4 >= 0x7F000000) {
            n4 = this.nextContractChar(n3);
        }
        if (n4 >= 0x7E000000) {
            this.buffer = this.ordering.getExpandValueList(n4);
            this.expIndex = 0;
            n4 = this.buffer[this.expIndex++];
        }
        if (this.ordering.isSEAsianSwapping()) {
            int n5;
            if (CollationElementIterator.isThaiPreVowel(n3)) {
                n5 = this.text.next();
                if (CollationElementIterator.isThaiBaseConsonant(n5)) {
                    this.buffer = this.makeReorderedBuffer(n5, n4, this.buffer, true);
                    n4 = this.buffer[0];
                    this.expIndex = 1;
                } else {
                    this.text.previous();
                }
            }
            if (CollationElementIterator.isLaoPreVowel(n3)) {
                n5 = this.text.next();
                if (CollationElementIterator.isLaoBaseConsonant(n5)) {
                    this.buffer = this.makeReorderedBuffer(n5, n4, this.buffer, true);
                    n4 = this.buffer[0];
                    this.expIndex = 1;
                } else {
                    this.text.previous();
                }
            }
        }
        return this.strengthOrder(n4);
    }

    public int previous() {
        Normalizer.Mode mode;
        if (this.text == null) {
            return -1;
        }
        Normalizer.Mode mode2 = this.text.getMode();
        if (mode2 != (mode = NormalizerUtilities.toNormalizerMode(this.owner.getDecomposition()))) {
            this.text.setMode(mode);
        }
        if (this.buffer != null) {
            if (this.expIndex > 0) {
                return this.strengthOrder(this.buffer[--this.expIndex]);
            }
            this.buffer = null;
            this.expIndex = 0;
        } else if (this.swapOrder != 0) {
            if (Character.isSupplementaryCodePoint(this.swapOrder)) {
                char[] cArray = Character.toChars(this.swapOrder);
                this.swapOrder = cArray[1];
                return cArray[0] << 16;
            }
            int n2 = this.swapOrder << 16;
            this.swapOrder = 0;
            return n2;
        }
        int n3 = this.text.previous();
        if (n3 == -1) {
            return -1;
        }
        int n4 = this.ordering.getUnicodeOrder(n3);
        if (n4 == -1) {
            this.swapOrder = 0x7FFF0000;
            return n3;
        }
        if (n4 >= 0x7F000000) {
            n4 = this.prevContractChar(n3);
        }
        if (n4 >= 0x7E000000) {
            this.buffer = this.ordering.getExpandValueList(n4);
            this.expIndex = this.buffer.length;
            n4 = this.buffer[--this.expIndex];
        }
        if (this.ordering.isSEAsianSwapping()) {
            int n5;
            if (CollationElementIterator.isThaiBaseConsonant(n3)) {
                n5 = this.text.previous();
                if (CollationElementIterator.isThaiPreVowel(n5)) {
                    this.buffer = this.makeReorderedBuffer(n5, n4, this.buffer, false);
                    this.expIndex = this.buffer.length - 1;
                    n4 = this.buffer[this.expIndex];
                } else {
                    this.text.next();
                }
            }
            if (CollationElementIterator.isLaoBaseConsonant(n3)) {
                n5 = this.text.previous();
                if (CollationElementIterator.isLaoPreVowel(n5)) {
                    this.buffer = this.makeReorderedBuffer(n5, n4, this.buffer, false);
                    this.expIndex = this.buffer.length - 1;
                    n4 = this.buffer[this.expIndex];
                } else {
                    this.text.next();
                }
            }
        }
        return this.strengthOrder(n4);
    }

    public static final int primaryOrder(int n2) {
        return (n2 &= 0xFFFF0000) >>> 16;
    }

    public static final short secondaryOrder(int n2) {
        return (short)((n2 &= 0xFF00) >> 8);
    }

    public static final short tertiaryOrder(int n2) {
        return (short)(n2 &= 0xFF);
    }

    final int strengthOrder(int n2) {
        int n3 = this.owner.getStrength();
        if (n3 == 0) {
            n2 &= 0xFFFF0000;
        } else if (n3 == 1) {
            n2 &= 0xFFFFFF00;
        }
        return n2;
    }

    public void setOffset(int n2) {
        if (this.text != null) {
            if (n2 < this.text.getBeginIndex() || n2 >= this.text.getEndIndex()) {
                this.text.setIndexOnly(n2);
            } else {
                int n3 = this.text.setIndex(n2);
                if (this.ordering.usedInContractSeq(n3)) {
                    while (this.ordering.usedInContractSeq(n3)) {
                        n3 = this.text.previous();
                    }
                    int n4 = this.text.getIndex();
                    while (this.text.getIndex() <= n2) {
                        n4 = this.text.getIndex();
                        this.next();
                    }
                    this.text.setIndexOnly(n4);
                }
            }
        }
        this.buffer = null;
        this.expIndex = 0;
        this.swapOrder = 0;
    }

    public int getOffset() {
        return this.text != null ? this.text.getIndex() : 0;
    }

    public int getMaxExpansion(int n2) {
        return this.ordering.getMaxExpansion(n2);
    }

    public void setText(String string) {
        this.buffer = null;
        this.swapOrder = 0;
        this.expIndex = 0;
        Normalizer.Mode mode = NormalizerUtilities.toNormalizerMode(this.owner.getDecomposition());
        if (this.text == null) {
            this.text = new Normalizer(string, mode);
        } else {
            this.text.setMode(mode);
            this.text.setText(string);
        }
    }

    public void setText(CharacterIterator characterIterator) {
        this.buffer = null;
        this.swapOrder = 0;
        this.expIndex = 0;
        Normalizer.Mode mode = NormalizerUtilities.toNormalizerMode(this.owner.getDecomposition());
        if (this.text == null) {
            this.text = new Normalizer(characterIterator, mode);
        } else {
            this.text.setMode(mode);
            this.text.setText(characterIterator);
        }
    }

    private static final boolean isThaiPreVowel(int n2) {
        return n2 >= 3648 && n2 <= 3652;
    }

    private static final boolean isThaiBaseConsonant(int n2) {
        return n2 >= 3585 && n2 <= 3630;
    }

    private static final boolean isLaoPreVowel(int n2) {
        return n2 >= 3776 && n2 <= 3780;
    }

    private static final boolean isLaoBaseConsonant(int n2) {
        return n2 >= 3713 && n2 <= 3758;
    }

    private int[] makeReorderedBuffer(int n2, int n3, int[] nArray, boolean bl2) {
        int[] nArray2;
        int n4;
        int n5 = this.ordering.getUnicodeOrder(n2);
        if (n5 >= 0x7F000000) {
            n5 = bl2 ? this.nextContractChar(n2) : this.prevContractChar(n2);
        }
        int[] nArray3 = null;
        if (n5 >= 0x7E000000) {
            nArray3 = this.ordering.getExpandValueList(n5);
        }
        if (!bl2) {
            n4 = n5;
            n5 = n3;
            n3 = n4;
            int[] nArray4 = nArray3;
            nArray3 = nArray;
            nArray = nArray4;
        }
        if (nArray3 == null && nArray == null) {
            nArray2 = new int[]{n5, n3};
        } else {
            n4 = nArray3 == null ? 1 : nArray3.length;
            int n6 = nArray == null ? 1 : nArray.length;
            nArray2 = new int[n4 + n6];
            if (nArray3 == null) {
                nArray2[0] = n5;
            } else {
                System.arraycopy(nArray3, 0, nArray2, 0, n4);
            }
            if (nArray == null) {
                nArray2[n4] = n3;
            } else {
                System.arraycopy(nArray, 0, nArray2, n4, n6);
            }
        }
        return nArray2;
    }

    static final boolean isIgnorable(int n2) {
        return CollationElementIterator.primaryOrder(n2) == 0;
    }

    private int nextContractChar(int n2) {
        Vector vector = this.ordering.getContractValues(n2);
        EntryPair entryPair = (EntryPair)vector.firstElement();
        int n3 = entryPair.value;
        entryPair = (EntryPair)vector.lastElement();
        int n4 = entryPair.entryName.length();
        Normalizer normalizer = (Normalizer)this.text.clone();
        normalizer.previous();
        this.key.setLength(0);
        int n5 = normalizer.next();
        while (n4 > 0 && n5 != -1) {
            if (Character.isSupplementaryCodePoint(n5)) {
                this.key.append(Character.toChars(n5));
                n4 -= 2;
            } else {
                this.key.append((char)n5);
                --n4;
            }
            n5 = normalizer.next();
        }
        String string = this.key.toString();
        n4 = 1;
        for (int i2 = vector.size() - 1; i2 > 0; --i2) {
            entryPair = (EntryPair)vector.elementAt(i2);
            if (!entryPair.fwd || !string.startsWith(entryPair.entryName) || entryPair.entryName.length() <= n4) continue;
            n4 = entryPair.entryName.length();
            n3 = entryPair.value;
        }
        while (n4 > 1) {
            n5 = this.text.next();
            n4 -= Character.charCount(n5);
        }
        return n3;
    }

    private int prevContractChar(int n2) {
        Vector vector = this.ordering.getContractValues(n2);
        EntryPair entryPair = (EntryPair)vector.firstElement();
        int n3 = entryPair.value;
        entryPair = (EntryPair)vector.lastElement();
        int n4 = entryPair.entryName.length();
        Normalizer normalizer = (Normalizer)this.text.clone();
        normalizer.next();
        this.key.setLength(0);
        int n5 = normalizer.previous();
        while (n4 > 0 && n5 != -1) {
            if (Character.isSupplementaryCodePoint(n5)) {
                this.key.append(Character.toChars(n5));
                n4 -= 2;
            } else {
                this.key.append((char)n5);
                --n4;
            }
            n5 = normalizer.previous();
        }
        String string = this.key.toString();
        n4 = 1;
        for (int i2 = vector.size() - 1; i2 > 0; --i2) {
            entryPair = (EntryPair)vector.elementAt(i2);
            if (entryPair.fwd || !string.startsWith(entryPair.entryName) || entryPair.entryName.length() <= n4) continue;
            n4 = entryPair.entryName.length();
            n3 = entryPair.value;
        }
        while (n4 > 1) {
            n5 = this.text.previous();
            n4 -= Character.charCount(n5);
        }
        return n3;
    }
}

