/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Currency;
import java.util.Hashtable;
import java.util.Locale;
import sun.text.resources.LocaleData;

public final class DecimalFormatSymbols
implements Cloneable,
Serializable {
    private char zeroDigit;
    private char groupingSeparator;
    private char decimalSeparator;
    private char perMill;
    private char percent;
    private char digit;
    private char patternSeparator;
    private String infinity;
    private String NaN;
    private char minusSign;
    private String currencySymbol;
    private String intlCurrencySymbol;
    private char monetarySeparator;
    private char exponential;
    private Locale locale;
    private transient Currency currency;
    static final long serialVersionUID = 5772796243397350300L;
    private static final int currentSerialVersion = 2;
    private int serialVersionOnStream = 2;
    private static final Hashtable cachedLocaleData = new Hashtable(3);

    public DecimalFormatSymbols() {
        this.initialize(Locale.getDefault());
    }

    public DecimalFormatSymbols(Locale locale) {
        this.initialize(locale);
    }

    public char getZeroDigit() {
        return this.zeroDigit;
    }

    public void setZeroDigit(char c2) {
        this.zeroDigit = c2;
    }

    public char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public void setGroupingSeparator(char c2) {
        this.groupingSeparator = c2;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(char c2) {
        this.decimalSeparator = c2;
    }

    public char getPerMill() {
        return this.perMill;
    }

    public void setPerMill(char c2) {
        this.perMill = c2;
    }

    public char getPercent() {
        return this.percent;
    }

    public void setPercent(char c2) {
        this.percent = c2;
    }

    public char getDigit() {
        return this.digit;
    }

    public void setDigit(char c2) {
        this.digit = c2;
    }

    public char getPatternSeparator() {
        return this.patternSeparator;
    }

    public void setPatternSeparator(char c2) {
        this.patternSeparator = c2;
    }

    public String getInfinity() {
        return this.infinity;
    }

    public void setInfinity(String string) {
        this.infinity = string;
    }

    public String getNaN() {
        return this.NaN;
    }

    public void setNaN(String string) {
        this.NaN = string;
    }

    public char getMinusSign() {
        return this.minusSign;
    }

    public void setMinusSign(char c2) {
        this.minusSign = c2;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String string) {
        this.currencySymbol = string;
    }

    public String getInternationalCurrencySymbol() {
        return this.intlCurrencySymbol;
    }

    public void setInternationalCurrencySymbol(String string) {
        this.intlCurrencySymbol = string;
        this.currency = null;
        if (string != null) {
            try {
                this.currency = Currency.getInstance(string);
                this.currencySymbol = this.currency.getSymbol();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        if (currency == null) {
            throw new NullPointerException();
        }
        this.currency = currency;
        this.intlCurrencySymbol = currency.getCurrencyCode();
        this.currencySymbol = currency.getSymbol(this.locale);
    }

    public char getMonetaryDecimalSeparator() {
        return this.monetarySeparator;
    }

    public void setMonetaryDecimalSeparator(char c2) {
        this.monetarySeparator = c2;
    }

    char getExponentialSymbol() {
        return this.exponential;
    }

    void setExponentialSymbol(char c2) {
        this.exponential = c2;
    }

    public Object clone() {
        try {
            return (DecimalFormatSymbols)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DecimalFormatSymbols decimalFormatSymbols = (DecimalFormatSymbols)object;
        return this.zeroDigit == decimalFormatSymbols.zeroDigit && this.groupingSeparator == decimalFormatSymbols.groupingSeparator && this.decimalSeparator == decimalFormatSymbols.decimalSeparator && this.percent == decimalFormatSymbols.percent && this.perMill == decimalFormatSymbols.perMill && this.digit == decimalFormatSymbols.digit && this.minusSign == decimalFormatSymbols.minusSign && this.patternSeparator == decimalFormatSymbols.patternSeparator && this.infinity.equals(decimalFormatSymbols.infinity) && this.NaN.equals(decimalFormatSymbols.NaN) && this.currencySymbol.equals(decimalFormatSymbols.currencySymbol) && this.intlCurrencySymbol.equals(decimalFormatSymbols.intlCurrencySymbol) && this.currency == decimalFormatSymbols.currency && this.monetarySeparator == decimalFormatSymbols.monetarySeparator && this.locale.equals(decimalFormatSymbols.locale);
    }

    public int hashCode() {
        int n2 = this.zeroDigit;
        n2 = n2 * 37 + this.groupingSeparator;
        n2 = n2 * 37 + this.decimalSeparator;
        return n2;
    }

    private void initialize(Locale locale) {
        String[] stringArray;
        this.locale = locale;
        boolean bl2 = false;
        Object[] objectArray = (Object[])cachedLocaleData.get(locale);
        if (objectArray == null) {
            objectArray = new Object[3];
            stringArray = LocaleData.getLocaleElements(locale);
            objectArray[0] = stringArray.getStringArray("NumberElements");
            bl2 = true;
        }
        stringArray = (String[])objectArray[0];
        this.decimalSeparator = stringArray[0].charAt(0);
        this.groupingSeparator = stringArray[1].charAt(0);
        this.patternSeparator = stringArray[2].charAt(0);
        this.percent = stringArray[3].charAt(0);
        this.zeroDigit = stringArray[4].charAt(0);
        this.digit = stringArray[5].charAt(0);
        this.minusSign = stringArray[6].charAt(0);
        this.exponential = stringArray[7].charAt(0);
        this.perMill = stringArray[8].charAt(0);
        this.infinity = stringArray[9];
        this.NaN = stringArray[10];
        if (!"".equals(locale.getCountry())) {
            try {
                this.currency = Currency.getInstance(locale);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.currency != null) {
            this.intlCurrencySymbol = this.currency.getCurrencyCode();
            if (objectArray[1] != null && objectArray[1] == this.intlCurrencySymbol) {
                this.currencySymbol = (String)objectArray[2];
            } else {
                this.currencySymbol = this.currency.getSymbol(locale);
                objectArray[1] = this.intlCurrencySymbol;
                objectArray[2] = this.currencySymbol;
                bl2 = true;
            }
        } else {
            this.intlCurrencySymbol = "XXX";
            try {
                this.currency = Currency.getInstance(this.intlCurrencySymbol);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.currencySymbol = "\u00a4";
        }
        this.monetarySeparator = this.decimalSeparator;
        if (bl2) {
            cachedLocaleData.put(locale, objectArray);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.monetarySeparator = this.decimalSeparator;
            this.exponential = (char)69;
        }
        if (this.serialVersionOnStream < 2) {
            this.locale = new Locale("");
        }
        this.serialVersionOnStream = 2;
        if (this.intlCurrencySymbol != null) {
            try {
                this.currency = Currency.getInstance(this.intlCurrencySymbol);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

