/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class CountDownLatch {
    private final Sync sync;

    public CountDownLatch(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        this.sync = new Sync(n2);
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean await(long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, timeUnit.toNanos(l2));
    }

    public void countDown() {
        this.sync.releaseShared(1);
    }

    public long getCount() {
        return this.sync.getCount();
    }

    public String toString() {
        return super.toString() + "[Count = " + this.sync.getCount() + "]";
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        Sync(int n2) {
            this.setState(n2);
        }

        int getCount() {
            return this.getState();
        }

        public int tryAcquireShared(int n2) {
            return this.getState() == 0 ? 1 : -1;
        }

        public boolean tryReleaseShared(int n2) {
            int n3;
            int n4;
            do {
                if ((n4 = this.getState()) != 0) continue;
                return false;
            } while (!this.compareAndSetState(n4, n3 = n4 - 1));
            return n3 == 0;
        }
    }
}

