/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import sun.misc.ASCIICaseInsensitiveComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attributes
implements Map<Object, Object>,
Cloneable {
    protected Map<Object, Object> map;

    public Attributes() {
        this(11);
    }

    public Attributes(int n2) {
        this.map = new HashMap<Object, Object>(n2);
    }

    public Attributes(Attributes attributes) {
        this.map = new HashMap<Object, Object>(attributes);
    }

    @Override
    public Object get(Object object) {
        return this.map.get(object);
    }

    public String getValue(String string) {
        return (String)this.get(new Name(string));
    }

    public String getValue(Name name) {
        return (String)this.get(name);
    }

    @Override
    public Object put(Object object, Object object2) {
        return this.map.put((Name)object, (String)object2);
    }

    public String putValue(String string, String string2) {
        return (String)this.put(new Name(string), string2);
    }

    @Override
    public Object remove(Object object) {
        return this.map.remove(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public void putAll(Map<?, ?> map) {
        if (!Attributes.class.isInstance(map)) {
            throw new ClassCastException();
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<Object> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object object) {
        return ((Object)this.map).equals(object);
    }

    @Override
    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public Object clone() {
        return new Attributes(this);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            StringBuffer stringBuffer = new StringBuffer(((Name)entry.getKey()).toString());
            stringBuffer.append(": ");
            String string = (String)entry.getValue();
            if (string != null) {
                byte[] byArray = string.getBytes("UTF8");
                string = new String(byArray, 0, 0, byArray.length);
            }
            stringBuffer.append(string);
            stringBuffer.append("\r\n");
            Manifest.make72Safe(stringBuffer);
            dataOutputStream.writeBytes(stringBuffer.toString());
        }
        dataOutputStream.writeBytes("\r\n");
    }

    void writeMain(DataOutputStream dataOutputStream) throws IOException {
        String string = Name.MANIFEST_VERSION.toString();
        String string2 = this.getValue(string);
        if (string2 == null) {
            string = Name.SIGNATURE_VERSION.toString();
            string2 = this.getValue(string);
        }
        if (string2 != null) {
            dataOutputStream.writeBytes(string + ": " + string2 + "\r\n");
        }
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String string3 = ((Name)entry.getKey()).toString();
            if (string2 == null || string3.equalsIgnoreCase(string)) continue;
            StringBuffer stringBuffer = new StringBuffer(string3);
            stringBuffer.append(": ");
            String string4 = (String)entry.getValue();
            if (string4 != null) {
                byte[] byArray = string4.getBytes("UTF8");
                string4 = new String(byArray, 0, 0, byArray.length);
            }
            stringBuffer.append(string4);
            stringBuffer.append("\r\n");
            Manifest.make72Safe(stringBuffer);
            dataOutputStream.writeBytes(stringBuffer.toString());
        }
        dataOutputStream.writeBytes("\r\n");
    }

    void read(Manifest.FastInputStream fastInputStream, byte[] byArray) throws IOException {
        int n2;
        String string = null;
        String string2 = null;
        byte[] byArray2 = null;
        while ((n2 = fastInputStream.readLine(byArray)) != -1) {
            boolean bl2 = false;
            if (byArray[--n2] != 10) {
                throw new IOException("line too long");
            }
            if (n2 > 0 && byArray[n2 - 1] == 13) {
                --n2;
            }
            if (n2 == 0) break;
            int n3 = 0;
            if (byArray[0] == 32) {
                if (string == null) {
                    throw new IOException("misplaced continuation line");
                }
                bl2 = true;
                byte[] byArray3 = new byte[byArray2.length + n2 - 1];
                System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                System.arraycopy(byArray, 1, byArray3, byArray2.length, n2 - 1);
                if (fastInputStream.peek() == 32) {
                    byArray2 = byArray3;
                    continue;
                }
                string2 = new String(byArray3, 0, byArray3.length, "UTF8");
                byArray2 = null;
            } else {
                while (byArray[n3++] != 58) {
                    if (n3 < n2) continue;
                    throw new IOException("invalid header field");
                }
                if (byArray[n3++] != 32) {
                    throw new IOException("invalid header field");
                }
                string = new String(byArray, 0, 0, n3 - 2);
                if (fastInputStream.peek() == 32) {
                    byArray2 = new byte[n2 - n3];
                    System.arraycopy(byArray, n3, byArray2, 0, n2 - n3);
                    continue;
                }
                string2 = new String(byArray, n3, n2 - n3, "UTF8");
            }
            try {
                if (this.putValue(string, string2) == null || bl2) continue;
                Logger.getLogger("java.util.jar").warning("Duplicate name in Manifest: " + string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("invalid header field name: " + string);
            }
        }
    }

    public static class Name {
        private String name;
        private int hashCode = -1;
        public static final Name MANIFEST_VERSION = new Name("Manifest-Version");
        public static final Name SIGNATURE_VERSION = new Name("Signature-Version");
        public static final Name CONTENT_TYPE = new Name("Content-Type");
        public static final Name CLASS_PATH = new Name("Class-Path");
        public static final Name MAIN_CLASS = new Name("Main-Class");
        public static final Name SEALED = new Name("Sealed");
        public static final Name EXTENSION_LIST = new Name("Extension-List");
        public static final Name EXTENSION_NAME = new Name("Extension-Name");
        public static final Name EXTENSION_INSTALLATION = new Name("Extension-Installation");
        public static final Name IMPLEMENTATION_TITLE = new Name("Implementation-Title");
        public static final Name IMPLEMENTATION_VERSION = new Name("Implementation-Version");
        public static final Name IMPLEMENTATION_VENDOR = new Name("Implementation-Vendor");
        public static final Name IMPLEMENTATION_VENDOR_ID = new Name("Implementation-Vendor-Id");
        public static final Name IMPLEMENTATION_URL = new Name("Implementation-URL");
        public static final Name SPECIFICATION_TITLE = new Name("Specification-Title");
        public static final Name SPECIFICATION_VERSION = new Name("Specification-Version");
        public static final Name SPECIFICATION_VENDOR = new Name("Specification-Vendor");

        public Name(String string) {
            if (string == null) {
                throw new NullPointerException("name");
            }
            if (!Name.isValid(string)) {
                throw new IllegalArgumentException(string);
            }
            this.name = string.intern();
        }

        private static boolean isValid(String string) {
            int n2 = string.length();
            if (n2 > 70 || n2 == 0) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (Name.isValid(string.charAt(i2))) continue;
                return false;
            }
            return true;
        }

        private static boolean isValid(char c2) {
            return Name.isAlpha(c2) || Name.isDigit(c2) || c2 == '_' || c2 == '-';
        }

        private static boolean isAlpha(char c2) {
            return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z';
        }

        private static boolean isDigit(char c2) {
            return c2 >= '0' && c2 <= '9';
        }

        public boolean equals(Object object) {
            if (object instanceof Name) {
                Comparator comparator = ASCIICaseInsensitiveComparator.CASE_INSENSITIVE_ORDER;
                return comparator.compare(this.name, ((Name)object).name) == 0;
            }
            return false;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = ASCIICaseInsensitiveComparator.lowerCaseHashCode(this.name);
            }
            return this.hashCode;
        }

        public String toString() {
            return this.name;
        }
    }
}

