/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.DataFormatException;

public class Inflater {
    private long strm;
    private byte[] buf = new byte[0];
    private int off;
    private int len;
    private boolean finished;
    private boolean needDict;

    public Inflater(boolean bl2) {
        this.strm = Inflater.init(bl2);
    }

    public Inflater() {
        this(false);
    }

    public synchronized void setInput(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n2 > byArray.length - n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.buf = byArray;
        this.off = n2;
        this.len = n3;
    }

    public void setInput(byte[] byArray) {
        this.setInput(byArray, 0, byArray.length);
    }

    public synchronized void setDictionary(byte[] byArray, int n2, int n3) {
        if (this.strm == 0L || byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n2 > byArray.length - n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Inflater.setDictionary(this.strm, byArray, n2, n3);
        this.needDict = false;
    }

    public void setDictionary(byte[] byArray) {
        this.setDictionary(byArray, 0, byArray.length);
    }

    public synchronized int getRemaining() {
        return this.len;
    }

    public synchronized boolean needsInput() {
        return this.len <= 0;
    }

    public synchronized boolean needsDictionary() {
        return this.needDict;
    }

    public synchronized boolean finished() {
        return this.finished;
    }

    public synchronized int inflate(byte[] byArray, int n2, int n3) throws DataFormatException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n2 > byArray.length - n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.inflateBytes(byArray, n2, n3);
    }

    public int inflate(byte[] byArray) throws DataFormatException {
        return this.inflate(byArray, 0, byArray.length);
    }

    public synchronized int getAdler() {
        this.ensureOpen();
        return Inflater.getAdler(this.strm);
    }

    public int getTotalIn() {
        return (int)this.getBytesRead();
    }

    public synchronized long getBytesRead() {
        this.ensureOpen();
        return Inflater.getBytesRead(this.strm);
    }

    public int getTotalOut() {
        return (int)this.getBytesWritten();
    }

    public synchronized long getBytesWritten() {
        this.ensureOpen();
        return Inflater.getBytesWritten(this.strm);
    }

    public synchronized void reset() {
        this.ensureOpen();
        Inflater.reset(this.strm);
        this.finished = false;
        this.needDict = false;
        this.len = 0;
        this.off = 0;
    }

    public synchronized void end() {
        if (this.strm != 0L) {
            Inflater.end(this.strm);
            this.strm = 0L;
        }
    }

    protected void finalize() {
        this.end();
    }

    private void ensureOpen() {
        if (this.strm == 0L) {
            throw new NullPointerException();
        }
    }

    private static native void initIDs();

    private static native long init(boolean var0);

    private static native void setDictionary(long var0, byte[] var2, int var3, int var4);

    private native int inflateBytes(byte[] var1, int var2, int var3) throws DataFormatException;

    private static native int getAdler(long var0);

    private static native long getBytesRead(long var0);

    private static native long getBytesWritten(long var0);

    private static native void reset(long var0);

    private static native void end(long var0);

    static {
        Inflater.initIDs();
    }
}

