/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;

public class TabularType
extends OpenType
implements Serializable {
    static final long serialVersionUID = 6554071860220659261L;
    private CompositeType rowType;
    private List indexNames;
    private transient Integer myHashCode = null;
    private transient String myToString = null;

    public TabularType(String string, String string2, CompositeType compositeType, String[] stringArray) throws OpenDataException {
        super(TabularData.class.getName(), string, string2);
        if (compositeType == null) {
            throw new IllegalArgumentException("Argument rowType cannot be null.");
        }
        TabularType.checkForNullElement(stringArray, "indexNames");
        TabularType.checkForEmptyString(stringArray, "indexNames");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (compositeType.containsKey(stringArray[i2])) continue;
            throw new OpenDataException("Argument's element value indexNames[" + i2 + "]=\"" + stringArray[i2] + "\" is not a valid item name for rowType.");
        }
        this.rowType = compositeType;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length + 1);
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            arrayList.add(stringArray[i3]);
        }
        this.indexNames = Collections.unmodifiableList(arrayList);
    }

    private static void checkForNullElement(Object[] objectArray, String string) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("Argument " + string + "[] cannot be null or empty.");
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] != null) continue;
            throw new IllegalArgumentException("Argument's element " + string + "[" + i2 + "] cannot be null.");
        }
    }

    private static void checkForEmptyString(String[] stringArray, String string) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].trim().equals("")) continue;
            throw new IllegalArgumentException("Argument's element " + string + "[" + i2 + "] cannot be an empty string.");
        }
    }

    public CompositeType getRowType() {
        return this.rowType;
    }

    public List getIndexNames() {
        return this.indexNames;
    }

    public boolean isValue(Object object) {
        TabularData tabularData;
        if (object == null) {
            return false;
        }
        try {
            tabularData = (TabularData)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.equals(tabularData.getTabularType());
    }

    public boolean equals(Object object) {
        TabularType tabularType;
        if (object == null) {
            return false;
        }
        try {
            tabularType = (TabularType)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (!this.getTypeName().equals(tabularType.getTypeName())) {
            return false;
        }
        if (!this.rowType.equals(tabularType.rowType)) {
            return false;
        }
        return ((Object)this.indexNames).equals(tabularType.indexNames);
    }

    public int hashCode() {
        if (this.myHashCode == null) {
            int n2 = 0;
            n2 += this.getTypeName().hashCode();
            n2 += this.rowType.hashCode();
            Iterator iterator = this.indexNames.iterator();
            while (iterator.hasNext()) {
                n2 += iterator.next().hashCode();
            }
            this.myHashCode = new Integer(n2);
        }
        return this.myHashCode;
    }

    public String toString() {
        if (this.myToString == null) {
            StringBuffer stringBuffer = new StringBuffer().append(this.getClass().getName()).append("(name=").append(this.getTypeName()).append(",rowType=").append(this.rowType.toString()).append(",indexNames=(");
            int n2 = 0;
            Iterator iterator = this.indexNames.iterator();
            while (iterator.hasNext()) {
                if (n2 > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(iterator.next().toString());
                ++n2;
            }
            stringBuffer.append("))");
            this.myToString = stringBuffer.toString();
        }
        return this.myToString;
    }
}

