/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLInputImpl
implements SQLInput {
    private boolean lastValueWasNull;
    private int idx;
    private Object[] attrib;
    private Map map;

    public SQLInputImpl(Object[] objectArray, Map<String, Class<?>> map) throws SQLException {
        if (objectArray == null || map == null) {
            throw new SQLException("Cannot instantiate a SQLInputImpl object with null parameters");
        }
        this.attrib = objectArray;
        this.idx = -1;
        this.map = map;
    }

    private Object getNextAttribute() throws SQLException {
        if (++this.idx >= this.attrib.length) {
            throw new SQLException("SQLInputImpl exception: Invalid read position");
        }
        return this.attrib[this.idx];
    }

    @Override
    public String readString() throws SQLException {
        String string = (String)this.getNextAttribute();
        if (string == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return string;
    }

    @Override
    public boolean readBoolean() throws SQLException {
        Boolean bl2 = (Boolean)this.getNextAttribute();
        if (bl2 == null) {
            this.lastValueWasNull = true;
            return false;
        }
        this.lastValueWasNull = false;
        return bl2;
    }

    @Override
    public byte readByte() throws SQLException {
        Byte by = (Byte)this.getNextAttribute();
        if (by == null) {
            this.lastValueWasNull = true;
            return 0;
        }
        this.lastValueWasNull = false;
        return by;
    }

    @Override
    public short readShort() throws SQLException {
        Short s2 = (Short)this.getNextAttribute();
        if (s2 == null) {
            this.lastValueWasNull = true;
            return 0;
        }
        this.lastValueWasNull = false;
        return s2;
    }

    @Override
    public int readInt() throws SQLException {
        Integer n2 = (Integer)this.getNextAttribute();
        if (n2 == null) {
            this.lastValueWasNull = true;
            return 0;
        }
        this.lastValueWasNull = false;
        return n2;
    }

    @Override
    public long readLong() throws SQLException {
        Long l2 = (Long)this.getNextAttribute();
        if (l2 == null) {
            this.lastValueWasNull = true;
            return 0L;
        }
        this.lastValueWasNull = false;
        return l2;
    }

    @Override
    public float readFloat() throws SQLException {
        Float f2 = (Float)this.getNextAttribute();
        if (f2 == null) {
            this.lastValueWasNull = true;
            return 0.0f;
        }
        this.lastValueWasNull = false;
        return f2.floatValue();
    }

    @Override
    public double readDouble() throws SQLException {
        Double d2 = (Double)this.getNextAttribute();
        if (d2 == null) {
            this.lastValueWasNull = true;
            return 0.0;
        }
        this.lastValueWasNull = false;
        return d2;
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        BigDecimal bigDecimal = (BigDecimal)this.getNextAttribute();
        if (bigDecimal == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return bigDecimal;
    }

    @Override
    public byte[] readBytes() throws SQLException {
        byte[] byArray = (byte[])this.getNextAttribute();
        if (byArray == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return byArray;
    }

    @Override
    public Date readDate() throws SQLException {
        Date date = (Date)this.getNextAttribute();
        if (date == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return date;
    }

    @Override
    public Time readTime() throws SQLException {
        Time time = (Time)this.getNextAttribute();
        if (time == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return time;
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        Timestamp timestamp = (Timestamp)this.getNextAttribute();
        if (timestamp == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return timestamp;
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        Reader reader = (Reader)this.getNextAttribute();
        if (reader == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return reader;
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        InputStream inputStream = (InputStream)this.getNextAttribute();
        if (inputStream == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return inputStream;
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        InputStream inputStream = (InputStream)this.getNextAttribute();
        if (inputStream == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return inputStream;
    }

    @Override
    public Object readObject() throws SQLException {
        Struct struct;
        Class clazz;
        Object object = this.getNextAttribute();
        if (object == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        if (object instanceof Struct && (clazz = (Class)this.map.get((struct = (Struct)object).getSQLTypeName())) != null) {
            SQLData sQLData = null;
            try {
                sQLData = (SQLData)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new SQLException("Unable to instantiate: " + instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SQLException("Unable to instantiate: " + illegalAccessException.getMessage());
            }
            Object[] objectArray = struct.getAttributes(this.map);
            SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, this.map);
            sQLData.readSQL(sQLInputImpl, struct.getSQLTypeName());
            return sQLData;
        }
        return object;
    }

    @Override
    public Ref readRef() throws SQLException {
        Ref ref = (Ref)this.getNextAttribute();
        if (ref == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return ref;
    }

    @Override
    public Blob readBlob() throws SQLException {
        Blob blob = (Blob)this.getNextAttribute();
        if (blob == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return blob;
    }

    @Override
    public Clob readClob() throws SQLException {
        Clob clob = (Clob)this.getNextAttribute();
        if (clob == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return clob;
    }

    @Override
    public Array readArray() throws SQLException {
        Array array = (Array)this.getNextAttribute();
        if (array == null) {
            this.lastValueWasNull = true;
            return null;
        }
        this.lastValueWasNull = false;
        return array;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastValueWasNull;
    }

    @Override
    public URL readURL() throws SQLException {
        throw new SQLException("Operation not supported");
    }
}

