/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.EventListener;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBoundedRangeModel
implements BoundedRangeModel,
Serializable {
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    private int value = 0;
    private int extent = 0;
    private int min = 0;
    private int max = 100;
    private boolean isAdjusting = false;

    public DefaultBoundedRangeModel() {
    }

    public DefaultBoundedRangeModel(int n2, int n3, int n4, int n5) {
        if (n5 < n4 || n2 < n4 || n2 + n3 < n2 || n2 + n3 > n5) {
            throw new IllegalArgumentException("invalid range properties");
        }
        this.value = n2;
        this.extent = n3;
        this.min = n4;
        this.max = n5;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public int getExtent() {
        return this.extent;
    }

    @Override
    public int getMinimum() {
        return this.min;
    }

    @Override
    public int getMaximum() {
        return this.max;
    }

    @Override
    public void setValue(int n2) {
        int n3 = Math.max(n2 = Math.min(n2, Integer.MAX_VALUE - this.extent), this.min);
        if (n3 + this.extent > this.max) {
            n3 = this.max - this.extent;
        }
        this.setRangeProperties(n3, this.extent, this.min, this.max, this.isAdjusting);
    }

    @Override
    public void setExtent(int n2) {
        int n3 = Math.max(0, n2);
        if (this.value + n3 > this.max) {
            n3 = this.max - this.value;
        }
        this.setRangeProperties(this.value, n3, this.min, this.max, this.isAdjusting);
    }

    @Override
    public void setMinimum(int n2) {
        int n3 = Math.max(n2, this.max);
        int n4 = Math.max(n2, this.value);
        int n5 = Math.min(n3 - n4, this.extent);
        this.setRangeProperties(n4, n5, n2, n3, this.isAdjusting);
    }

    @Override
    public void setMaximum(int n2) {
        int n3 = Math.min(n2, this.min);
        int n4 = Math.min(n2 - n3, this.extent);
        int n5 = Math.min(n2 - n4, this.value);
        this.setRangeProperties(n5, n4, n3, n2, this.isAdjusting);
    }

    @Override
    public void setValueIsAdjusting(boolean bl2) {
        this.setRangeProperties(this.value, this.extent, this.min, this.max, bl2);
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    @Override
    public void setRangeProperties(int n2, int n3, int n4, int n5, boolean bl2) {
        boolean bl3;
        if (n4 > n5) {
            n4 = n5;
        }
        if (n2 > n5) {
            n5 = n2;
        }
        if (n2 < n4) {
            n4 = n2;
        }
        if ((long)n3 + (long)n2 > (long)n5) {
            n3 = n5 - n2;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        boolean bl4 = bl3 = n2 != this.value || n3 != this.extent || n4 != this.min || n5 != this.max || bl2 != this.isAdjusting;
        if (bl3) {
            this.value = n2;
            this.extent = n3;
            this.min = n4;
            this.max = n5;
            this.isAdjusting = bl2;
            this.fireStateChanged();
        }
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i2 + 1]).stateChanged(this.changeEvent);
        }
    }

    public String toString() {
        String string = "value=" + this.getValue() + ", " + "extent=" + this.getExtent() + ", " + "min=" + this.getMinimum() + ", " + "max=" + this.getMaximum() + ", " + "adj=" + this.getValueIsAdjusting();
        return this.getClass().getName() + "[" + string + "]";
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return this.listenerList.getListeners(clazz);
    }
}

