/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import sun.reflect.misc.MethodUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIDefaults
extends Hashtable<Object, Object> {
    private static final Object PENDING = new String("Pending");
    private SwingPropertyChangeSupport changeSupport;
    private Vector resourceBundles;
    private Locale defaultLocale = Locale.getDefault();
    private Map resourceCache;

    public UIDefaults() {
        super(700, 0.75f);
        this.resourceCache = new HashMap();
    }

    public UIDefaults(Object[] objectArray) {
        super(objectArray.length / 2);
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            super.put(objectArray[i2], objectArray[i2 + 1]);
        }
    }

    @Override
    public Object get(Object object) {
        Object object2 = this.getFromHashtable(object);
        return object2 != null ? object2 : this.getFromResourceBundle(object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFromHashtable(Object object) {
        Object object2 = super.get(object);
        if (object2 != PENDING && !(object2 instanceof ActiveValue) && !(object2 instanceof LazyValue)) {
            return object2;
        }
        UIDefaults uIDefaults = this;
        synchronized (uIDefaults) {
            object2 = super.get(object);
            if (object2 == PENDING) {
                do {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while ((object2 = super.get(object)) == PENDING);
                return object2;
            }
            if (object2 instanceof LazyValue) {
                super.put(object, PENDING);
            } else if (!(object2 instanceof ActiveValue)) {
                return object2;
            }
        }
        if (object2 instanceof LazyValue) {
            try {
                object2 = ((LazyValue)object2).createValue(this);
            }
            finally {
                uIDefaults = this;
                synchronized (uIDefaults) {
                    if (object2 == null) {
                        super.remove(object);
                    } else {
                        super.put(object, object2);
                    }
                    this.notifyAll();
                }
            }
        }
        object2 = ((ActiveValue)object2).createValue(this);
        return object2;
    }

    public Object get(Object object, Locale locale) {
        Object object2 = this.getFromHashtable(object);
        return object2 != null ? object2 : this.getFromResourceBundle(object, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFromResourceBundle(Object object, Locale locale) {
        if (this.resourceBundles == null || this.resourceBundles.isEmpty() || !(object instanceof String)) {
            return null;
        }
        if (locale == null) {
            if (this.defaultLocale == null) {
                return null;
            }
            locale = this.defaultLocale;
        }
        UIDefaults uIDefaults = this;
        synchronized (uIDefaults) {
            return this.getResourceCache(locale).get((String)object);
        }
    }

    private Map getResourceCache(Locale locale) {
        HashMap<String, Object> hashMap = (HashMap<String, Object>)this.resourceCache.get(locale);
        if (hashMap == null) {
            hashMap = new HashMap<String, Object>();
            for (int i2 = this.resourceBundles.size() - 1; i2 >= 0; --i2) {
                String string = (String)this.resourceBundles.get(i2);
                try {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
                    Enumeration<String> enumeration = resourceBundle.getKeys();
                    while (enumeration.hasMoreElements()) {
                        String string2 = enumeration.nextElement();
                        if (hashMap.get(string2) != null) continue;
                        Object object = resourceBundle.getObject(string2);
                        hashMap.put(string2, object);
                    }
                    continue;
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            this.resourceCache.put(locale, hashMap);
        }
        return hashMap;
    }

    @Override
    public Object put(Object object, Object object2) {
        Object object3;
        Object object4 = object3 = object2 == null ? super.remove(object) : super.put(object, object2);
        if (object instanceof String) {
            this.firePropertyChange((String)object, object3, object2);
        }
        return object3;
    }

    public void putDefaults(Object[] objectArray) {
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            Object object = objectArray[i2 + 1];
            if (object == null) {
                super.remove(objectArray[i2]);
                continue;
            }
            super.put(objectArray[i2], object);
        }
        this.firePropertyChange("UIDefaults", null, null);
    }

    public Font getFont(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Font ? (Font)object2 : null;
    }

    public Font getFont(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Font ? (Font)object2 : null;
    }

    public Color getColor(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Color ? (Color)object2 : null;
    }

    public Color getColor(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Color ? (Color)object2 : null;
    }

    public Icon getIcon(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Icon ? (Icon)object2 : null;
    }

    public Icon getIcon(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Icon ? (Icon)object2 : null;
    }

    public Border getBorder(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Border ? (Border)object2 : null;
    }

    public Border getBorder(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Border ? (Border)object2 : null;
    }

    public String getString(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof String ? (String)object2 : null;
    }

    public String getString(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof String ? (String)object2 : null;
    }

    public int getInt(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Integer ? (Integer)object2 : 0;
    }

    public int getInt(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Integer ? (Integer)object2 : 0;
    }

    public boolean getBoolean(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Boolean ? (Boolean)object2 : false;
    }

    public boolean getBoolean(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Boolean ? (Boolean)object2 : false;
    }

    public Insets getInsets(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Insets ? (Insets)object2 : null;
    }

    public Insets getInsets(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Insets ? (Insets)object2 : null;
    }

    public Dimension getDimension(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Dimension ? (Dimension)object2 : null;
    }

    public Dimension getDimension(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Dimension ? (Dimension)object2 : null;
    }

    public Class<? extends ComponentUI> getUIClass(String string, ClassLoader classLoader) {
        try {
            String string2 = (String)this.get(string);
            if (string2 != null) {
                Class<Object> clazz = (Class<?>)this.get(string2);
                if (clazz == null && (clazz = classLoader == null ? SwingUtilities.loadSystemClass(string2) : classLoader.loadClass(string2)) != null) {
                    this.put(string2, clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        return null;
    }

    public Class<? extends ComponentUI> getUIClass(String string) {
        return this.getUIClass(string, null);
    }

    protected void getUIError(String string) {
        System.err.println("UIDefaults.getUI() failed: " + string);
        try {
            throw new Error();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public ComponentUI getUI(JComponent jComponent) {
        Object object = this.get("ClassLoader");
        ClassLoader classLoader = object != null ? (ClassLoader)object : jComponent.getClass().getClassLoader();
        Class<? extends ComponentUI> clazz = this.getUIClass(jComponent.getUIClassID(), classLoader);
        Object object2 = null;
        if (clazz == null) {
            this.getUIError("no ComponentUI class for: " + jComponent);
        } else {
            try {
                Method method = (Method)this.get(clazz);
                if (method == null) {
                    Class<JComponent> clazz2 = JComponent.class;
                    method = clazz.getMethod("createUI", clazz2);
                    this.put(clazz, method);
                }
                object2 = MethodUtil.invoke(method, null, new Object[]{jComponent});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.getUIError("static createUI() method not found in " + clazz);
            }
            catch (Exception exception) {
                this.getUIError("createUI() failed for " + jComponent + " " + exception);
            }
        }
        return (ComponentUI)object2;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    public synchronized void addResourceBundle(String string) {
        if (string == null) {
            return;
        }
        if (this.resourceBundles == null) {
            this.resourceBundles = new Vector(5);
        }
        if (!this.resourceBundles.contains(string)) {
            this.resourceBundles.add(string);
            this.resourceCache.clear();
        }
    }

    public synchronized void removeResourceBundle(String string) {
        if (this.resourceBundles != null) {
            this.resourceBundles.remove(string);
        }
        this.resourceCache.clear();
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = locale;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public static interface ActiveValue {
        public Object createValue(UIDefaults var1);
    }

    public static class LazyInputMap
    implements LazyValue {
        private Object[] bindings;

        public LazyInputMap(Object[] objectArray) {
            this.bindings = objectArray;
        }

        public Object createValue(UIDefaults uIDefaults) {
            if (this.bindings != null) {
                InputMap inputMap = LookAndFeel.makeInputMap(this.bindings);
                return inputMap;
            }
            return null;
        }
    }

    public static interface LazyValue {
        public Object createValue(UIDefaults var1);
    }

    public static class ProxyLazyValue
    implements LazyValue {
        private AccessControlContext acc = AccessController.getContext();
        private String className;
        private String methodName;
        private Object[] args;

        public ProxyLazyValue(String string) {
            this(string, (String)null);
        }

        public ProxyLazyValue(String string, String string2) {
            this(string, string2, null);
        }

        public ProxyLazyValue(String string, Object[] objectArray) {
            this(string, null, objectArray);
        }

        public ProxyLazyValue(String string, String string2, Object[] objectArray) {
            this.className = string;
            this.methodName = string2;
            if (objectArray != null) {
                this.args = (Object[])objectArray.clone();
            }
        }

        public Object createValue(final UIDefaults uIDefaults) {
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Object object;
                        if (!(uIDefaults != null && (object = uIDefaults.get("ClassLoader")) instanceof ClassLoader || (object = Thread.currentThread().getContextClassLoader()) != null)) {
                            object = ClassLoader.getSystemClassLoader();
                        }
                        Class<?> clazz = Class.forName(ProxyLazyValue.this.className, true, (ClassLoader)object);
                        if (ProxyLazyValue.this.methodName != null) {
                            Class[] classArray = ProxyLazyValue.this.getClassArray(ProxyLazyValue.this.args);
                            Method method = clazz.getMethod(ProxyLazyValue.this.methodName, classArray);
                            return MethodUtil.invoke(method, clazz, ProxyLazyValue.this.args);
                        }
                        Class[] classArray = ProxyLazyValue.this.getClassArray(ProxyLazyValue.this.args);
                        Constructor<?> constructor = clazz.getConstructor(classArray);
                        return constructor.newInstance(ProxyLazyValue.this.args);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            }, this.acc);
        }

        private Class[] getClassArray(Object[] objectArray) {
            Class[] classArray = null;
            if (objectArray != null) {
                classArray = new Class[objectArray.length];
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    classArray[i2] = objectArray[i2] instanceof Integer ? Integer.TYPE : (objectArray[i2] instanceof Boolean ? Boolean.TYPE : (objectArray[i2] instanceof ColorUIResource ? Color.class : objectArray[i2].getClass()));
                }
            }
            return classArray;
        }

        private String printArgs(Object[] objectArray) {
            String string = "{";
            if (objectArray != null) {
                for (int i2 = 0; i2 < objectArray.length - 1; ++i2) {
                    string = string.concat(objectArray[i2] + ",");
                }
                string = string.concat(objectArray[objectArray.length - 1] + "}");
            } else {
                string = string.concat("}");
            }
            return string;
        }
    }
}

