/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Point;
import java.io.IOException;
import sun.awt.X11.MotifDnDConstants;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDropTargetEventProcessor;
import sun.awt.X11.XDropTargetProtocol;
import sun.awt.X11.XDropTargetProtocolListener;
import sun.awt.X11.XDropTargetRegistry;
import sun.awt.X11.XException;
import sun.awt.X11.XSelection;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

class MotifDnDDropTargetProtocol
extends XDropTargetProtocol {
    private static final Unsafe unsafe = XlibWrapper.unsafe;
    private long sourceWindow = 0L;
    private long sourceWindowMask = 0L;
    private int sourceProtocolVersion = 0;
    private int sourceActions = 0;
    private long[] sourceFormats = null;
    private long sourceAtom = 0L;
    private int userAction = 0;
    private int sourceX = 0;
    private int sourceY = 0;
    private XWindow targetXWindow = null;
    private boolean topLevelLeavePostponed = false;

    protected MotifDnDDropTargetProtocol(XDropTargetProtocolListener xDropTargetProtocolListener) {
        super(xDropTargetProtocolListener);
    }

    static XDropTargetProtocol createInstance(XDropTargetProtocolListener xDropTargetProtocolListener) {
        return new MotifDnDDropTargetProtocol(xDropTargetProtocolListener);
    }

    public void registerDropTarget(long l2) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        MotifDnDConstants.writeDragReceiverInfoStruct(l2);
    }

    public void unregisterDropTarget(long l2) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        MotifDnDConstants.XA_MOTIF_ATOM_0.DeleteProperty(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEmbedderDropSite(long l2) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        boolean bl2 = false;
        int n2 = 0;
        long l3 = 0L;
        long l4 = XDropTargetRegistry.getDnDProxyWindow();
        int n3 = 0;
        long l5 = 0L;
        int n4 = 16;
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l2, MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO, 0L, 65535L, false, 0L);
        try {
            n3 = windowPropertyGetter.execute(XToolkit.IgnoreBadWindowHandler);
            if (n3 == 0 && windowPropertyGetter.getData() != 0L && windowPropertyGetter.getActualType() != 0L && windowPropertyGetter.getActualFormat() == 8 && windowPropertyGetter.getNumberOfItems() >= 16) {
                bl2 = true;
                l5 = windowPropertyGetter.getData();
                n4 = windowPropertyGetter.getNumberOfItems();
                byte by = unsafe.getByte(l5);
                int n5 = unsafe.getInt(l5 + 4L);
                if (by != MotifDnDConstants.getByteOrderByte()) {
                    n5 = MotifDnDConstants.Swapper.swap(n5);
                }
                if ((l3 = (long)n5) == l4) {
                    return;
                }
                n5 = (int)l4;
                if (by != MotifDnDConstants.getByteOrderByte()) {
                    n5 = MotifDnDConstants.Swapper.swap(n5);
                }
                unsafe.putInt(l5 + 4L, n5);
            } else {
                l5 = unsafe.allocateMemory(n4);
                unsafe.putByte(l5, MotifDnDConstants.getByteOrderByte());
                unsafe.putByte(l5 + 1L, (byte)0);
                unsafe.putByte(l5 + 2L, (byte)5);
                unsafe.putByte(l5 + 3L, (byte)0);
                unsafe.putInt(l5 + 4L, (int)l4);
                unsafe.putShort(l5 + 8L, (short)0);
                unsafe.putShort(l5 + 10L, (short)0);
                unsafe.putInt(l5 + 12L, n4);
            }
            XToolkit.WITH_XERROR_HANDLER(XWM.VerifyChangePropertyHandler);
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l2, MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO.getAtom(), MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO.getAtom(), 8, 0, l5, n4);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write Motif receiver info property");
            }
        }
        finally {
            if (!bl2) {
                unsafe.freeMemory(l5);
                l5 = 0L;
            }
            windowPropertyGetter.dispose();
        }
        this.putEmbedderRegistryEntry(l2, bl2, n2, l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unregisterEmbedderDropSite(long l2) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        XDropTargetProtocol.EmbedderRegistryEntry embedderRegistryEntry = this.getEmbedderRegistryEntry(l2);
        assert (embedderRegistryEntry != null);
        if (embedderRegistryEntry == null) {
            return;
        }
        if (embedderRegistryEntry.isOverriden()) {
            int n2 = 0;
            WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l2, MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO, 0L, 65535L, false, 0L);
            try {
                n2 = windowPropertyGetter.execute(XToolkit.IgnoreBadWindowHandler);
                if (n2 != 0 || windowPropertyGetter.getData() == 0L || windowPropertyGetter.getActualType() == 0L || windowPropertyGetter.getActualFormat() != 8 || windowPropertyGetter.getNumberOfItems() < 16) return;
                int n3 = 16;
                long l3 = windowPropertyGetter.getData();
                byte by = unsafe.getByte(l3);
                int n4 = (int)embedderRegistryEntry.getProxy();
                if (MotifDnDConstants.getByteOrderByte() != by) {
                    n4 = MotifDnDConstants.Swapper.swap(n4);
                }
                unsafe.putInt(l3 + 4L, n4);
                XToolkit.WITH_XERROR_HANDLER(XWM.VerifyChangePropertyHandler);
                XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l2, MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO.getAtom(), MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO.getAtom(), 8, 0, l3, n3);
                XToolkit.RESTORE_XERROR_HANDLER();
                if (XToolkit.saved_error == null || XToolkit.saved_error.get_error_code() == 0) return;
                throw new XException("Cannot write Motif receiver info property");
            }
            finally {
                windowPropertyGetter.dispose();
            }
        } else {
            MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO.DeleteProperty(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProtocolSupported(long l2) {
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l2, MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO, 0L, 65535L, false, 0L);
        try {
            int n2 = windowPropertyGetter.execute(XToolkit.IgnoreBadWindowHandler);
            if (n2 == 0 && windowPropertyGetter.getData() != 0L && windowPropertyGetter.getActualType() != 0L && windowPropertyGetter.getActualFormat() == 8 && windowPropertyGetter.getNumberOfItems() >= 16) {
                boolean bl2 = true;
                return bl2;
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            windowPropertyGetter.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processTopLevelEnter(XClientMessageEvent xClientMessageEvent) {
        int n2;
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        if (this.targetXWindow != null || this.sourceWindow != 0L) {
            return false;
        }
        if (!(XToolkit.windowToXWindow(xClientMessageEvent.get_window()) instanceof XWindow) && this.getEmbedderRegistryEntry(xClientMessageEvent.get_window()) == null) {
            return false;
        }
        long l2 = 0L;
        long l3 = 0L;
        byte by = 0;
        long l4 = 0L;
        long[] lArray = null;
        long l5 = xClientMessageEvent.get_data();
        byte by2 = unsafe.getByte(l5 + 1L);
        l2 = MotifDnDConstants.Swapper.getInt(l5 + 8L, by2);
        l4 = MotifDnDConstants.Swapper.getInt(l5 + 12L, by2);
        Object object = new WindowPropertyGetter(l2, XAtom.get(l4), 0L, 65535L, false, MotifDnDConstants.XA_MOTIF_DRAG_INITIATOR_INFO.getAtom());
        try {
            n2 = ((WindowPropertyGetter)object).execute(XToolkit.IgnoreBadWindowHandler);
            if (n2 == 0 && ((WindowPropertyGetter)object).getData() != 0L && ((WindowPropertyGetter)object).getActualType() == MotifDnDConstants.XA_MOTIF_DRAG_INITIATOR_INFO.getAtom() && ((WindowPropertyGetter)object).getActualFormat() == 8 && ((WindowPropertyGetter)object).getNumberOfItems() == 8) {
                long l6 = ((WindowPropertyGetter)object).getData();
                byte by3 = unsafe.getByte(l6);
                by = unsafe.getByte(l6 + 1L);
                if (by != 0) {
                    boolean bl2 = false;
                    return bl2;
                }
                short s2 = MotifDnDConstants.Swapper.getShort(l6 + 2L, by3);
                lArray = MotifDnDConstants.getTargetListForIndex(s2);
            } else {
                lArray = new long[]{};
            }
        }
        finally {
            ((WindowPropertyGetter)object).dispose();
        }
        object = new XWindowAttributes();
        try {
            XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
            n2 = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l2, ((XWindowAttributes)object).pData);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (n2 == 0 || XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("XGetWindowAttributes failed");
            }
            l3 = ((XWindowAttributes)object).get_your_event_mask();
        }
        finally {
            ((XWindowAttributes)object).dispose();
        }
        XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
        XlibWrapper.XSelectInput(XToolkit.getDisplay(), l2, l3 | 0x20000L);
        XToolkit.RESTORE_XERROR_HANDLER();
        if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
            throw new XException("XSelectInput failed");
        }
        this.sourceWindow = l2;
        this.sourceWindowMask = l3;
        this.sourceProtocolVersion = by;
        this.sourceActions = 0;
        this.sourceFormats = lArray;
        this.sourceAtom = l4;
        return true;
    }

    private boolean processDragMotion(XClientMessageEvent xClientMessageEvent) {
        long l2 = xClientMessageEvent.get_data();
        byte by = unsafe.getByte(l2 + 1L);
        byte by2 = (byte)(unsafe.getByte(l2) & 0x7F);
        int n2 = 0;
        int n3 = 0;
        short s2 = MotifDnDConstants.Swapper.getShort(l2 + 2L, by);
        int n4 = (s2 & 0xF) >> 0;
        int n5 = (s2 & 0xF00) >> 8;
        int n6 = MotifDnDConstants.getJavaActionsForMotifActions(n4);
        int n7 = MotifDnDConstants.getJavaActionsForMotifActions(n5);
        int n8 = (int)this.sourceWindow;
        if (by != MotifDnDConstants.getByteOrderByte()) {
            n8 = MotifDnDConstants.Swapper.swap(n8);
        }
        unsafe.putInt(l2 + 12L, n8);
        XWindow xWindow = null;
        Object object = XToolkit.windowToXWindow(xClientMessageEvent.get_window());
        if (object instanceof XWindow) {
            xWindow = (XWindow)object;
        }
        if (by2 == 8) {
            n2 = this.sourceX;
            n3 = this.sourceY;
            if (xWindow == null) {
                xWindow = this.targetXWindow;
            }
        } else {
            XBaseWindow xBaseWindow;
            long l3;
            n2 = MotifDnDConstants.Swapper.getShort(l2 + 8L, by);
            n3 = MotifDnDConstants.Swapper.getShort(l2 + 10L, by);
            if (xWindow == null && (l3 = XDropTargetRegistry.getRegistry().getEmbeddedDropSite(xClientMessageEvent.get_window(), n2, n3)) != 0L && (xBaseWindow = XToolkit.windowToXWindow(l3)) instanceof XWindow) {
                xWindow = (XWindow)xBaseWindow;
            }
            if (xWindow != null) {
                object = xWindow.toLocal(n2, n3);
                n2 = ((Point)object).x;
                n3 = ((Point)object).y;
            }
        }
        if (xWindow == null) {
            if (this.targetXWindow != null) {
                this.getProtocolListener().handleDropTargetNotification(this.targetXWindow, n2, n3, 0, n7, this.sourceFormats, xClientMessageEvent.pData, 505);
            }
        } else {
            int n9 = 0;
            n9 = this.targetXWindow == null ? 504 : 506;
            this.getProtocolListener().handleDropTargetNotification(xWindow, n2, n3, n6, n7, this.sourceFormats, xClientMessageEvent.pData, n9);
        }
        this.sourceActions = n7;
        this.userAction = n6;
        this.sourceX = n2;
        this.sourceY = n3;
        this.targetXWindow = xWindow;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processTopLevelLeave(XClientMessageEvent xClientMessageEvent) {
        byte by;
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        long l2 = xClientMessageEvent.get_data();
        long l3 = MotifDnDConstants.Swapper.getInt(l2 + 8L, by = unsafe.getByte(l2 + 1L));
        if (l3 != this.sourceWindow) {
            return false;
        }
        this.topLevelLeavePostponed = true;
        long l4 = this.getEmbedderRegistryEntry(xClientMessageEvent.get_window()) != null ? XDropTargetRegistry.getDnDProxyWindow() : xClientMessageEvent.get_window();
        XClientMessageEvent xClientMessageEvent2 = new XClientMessageEvent();
        try {
            xClientMessageEvent2.set_type(33);
            xClientMessageEvent2.set_window(xClientMessageEvent.get_window());
            xClientMessageEvent2.set_format(32);
            xClientMessageEvent2.set_message_type(0L);
            xClientMessageEvent2.set_data(0, 0L);
            xClientMessageEvent2.set_data(1, 0L);
            xClientMessageEvent2.set_data(2, 0L);
            xClientMessageEvent2.set_data(3, 0L);
            xClientMessageEvent2.set_data(4, 0L);
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), l4, false, 0L, xClientMessageEvent2.pData);
        }
        finally {
            xClientMessageEvent2.dispose();
        }
        return true;
    }

    private boolean processDropStart(XClientMessageEvent xClientMessageEvent) {
        XBaseWindow xBaseWindow;
        long l2;
        byte by;
        long l3 = xClientMessageEvent.get_data();
        long l4 = MotifDnDConstants.Swapper.getInt(l3 + 16L, by = unsafe.getByte(l3 + 1L));
        if (l4 != this.sourceWindow) {
            return false;
        }
        long l5 = MotifDnDConstants.Swapper.getInt(l3 + 12L, by);
        short s2 = MotifDnDConstants.Swapper.getShort(l3 + 2L, by);
        int n2 = (s2 & 0xF) >> 0;
        int n3 = (s2 & 0xF00) >> 8;
        int n4 = MotifDnDConstants.getJavaActionsForMotifActions(n2);
        int n5 = MotifDnDConstants.getJavaActionsForMotifActions(n3);
        int n6 = MotifDnDConstants.Swapper.getShort(l3 + 8L, by);
        int n7 = MotifDnDConstants.Swapper.getShort(l3 + 10L, by);
        XWindow xWindow = null;
        Object object = XToolkit.windowToXWindow(xClientMessageEvent.get_window());
        if (object instanceof XWindow) {
            xWindow = (XWindow)object;
        }
        if (xWindow == null && (l2 = XDropTargetRegistry.getRegistry().getEmbeddedDropSite(xClientMessageEvent.get_window(), n6, n7)) != 0L && (xBaseWindow = XToolkit.windowToXWindow(l2)) instanceof XWindow) {
            xWindow = (XWindow)xBaseWindow;
        }
        if (xWindow != null) {
            object = xWindow.toLocal(n6, n7);
            n6 = ((Point)object).x;
            n7 = ((Point)object).y;
        }
        if (xWindow != null) {
            this.getProtocolListener().handleDropTargetNotification(xWindow, n6, n7, n4, n5, this.sourceFormats, xClientMessageEvent.pData, 502);
        } else if (this.targetXWindow != null) {
            this.getProtocolListener().handleDropTargetNotification(this.targetXWindow, n6, n7, 0, n5, this.sourceFormats, xClientMessageEvent.pData, 505);
        }
        return true;
    }

    public int getMessageType(XClientMessageEvent xClientMessageEvent) {
        if (xClientMessageEvent.get_message_type() != MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom()) {
            return 0;
        }
        long l2 = xClientMessageEvent.get_data();
        byte by = (byte)(unsafe.getByte(l2) & 0x7F);
        switch (by) {
            case 0: {
                return 1;
            }
            case 2: 
            case 8: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 5: {
                return 4;
            }
        }
        return 0;
    }

    protected boolean processClientMessageImpl(XClientMessageEvent xClientMessageEvent) {
        if (xClientMessageEvent.get_message_type() != MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom()) {
            if (this.topLevelLeavePostponed) {
                this.topLevelLeavePostponed = false;
                this.cleanup();
            }
            return false;
        }
        long l2 = xClientMessageEvent.get_data();
        byte by = (byte)(unsafe.getByte(l2) & 0x7F);
        byte by2 = (byte)(unsafe.getByte(l2) & 0xFFFFFF80);
        if (this.topLevelLeavePostponed) {
            this.topLevelLeavePostponed = false;
            if (by != 5) {
                this.cleanup();
            }
        }
        if (by2 != 0) {
            return false;
        }
        switch (by) {
            case 0: {
                return this.processTopLevelEnter(xClientMessageEvent);
            }
            case 2: 
            case 8: {
                return this.processDragMotion(xClientMessageEvent);
            }
            case 1: {
                return this.processTopLevelLeave(xClientMessageEvent);
            }
            case 5: {
                return this.processDropStart(xClientMessageEvent);
            }
        }
        return false;
    }

    protected void sendEnterMessageToToplevel(long l2, XClientMessageEvent xClientMessageEvent) {
        throw new Error("UNIMPLEMENTED");
    }

    protected void sendLeaveMessageToToplevel(long l2, XClientMessageEvent xClientMessageEvent) {
        throw new Error("UNIMPLEMENTED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendResponse(long l2, int n2, int n3) {
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent(l2);
        if (xClientMessageEvent.get_message_type() != MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom()) {
            return false;
        }
        long l3 = xClientMessageEvent.get_data();
        int n4 = unsafe.getByte(l3) & 0x7F;
        byte by = (byte)(unsafe.getByte(l3) & 0xFFFFFF80);
        byte by2 = unsafe.getByte(l3 + 1L);
        int n5 = 0;
        if (by != 0) {
            return false;
        }
        switch (n4) {
            case 0: 
            case 1: {
                return false;
            }
            case 2: {
                switch (n2) {
                    case 504: {
                        n5 = 3;
                        break;
                    }
                    case 506: {
                        n5 = 2;
                        break;
                    }
                    case 505: {
                        n5 = 4;
                    }
                }
                break;
            }
            case 5: 
            case 8: {
                n5 = n4;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        XClientMessageEvent xClientMessageEvent2 = new XClientMessageEvent();
        try {
            short s2;
            int n6;
            xClientMessageEvent2.set_type(33);
            xClientMessageEvent2.set_window(MotifDnDConstants.Swapper.getInt(l3 + 12L, by2));
            xClientMessageEvent2.set_format(8);
            xClientMessageEvent2.set_message_type(MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom());
            long l4 = xClientMessageEvent2.get_data();
            unsafe.putByte(l4, (byte)(n5 | 0xFFFFFF80));
            unsafe.putByte(l4 + 1L, MotifDnDConstants.getByteOrderByte());
            int n7 = 0;
            if (n5 != 4) {
                n6 = MotifDnDConstants.Swapper.getShort(l3 + 2L, by2);
                s2 = n3 == 0 ? (short)2 : 3;
                n7 = n6 & 0xFFFFFFF0 & 0xFFFFFF0F;
                n7 |= MotifDnDConstants.getMotifActionsForJavaActions(n3) << 0;
                n7 |= s2 << 4;
            } else {
                n7 = 0;
            }
            unsafe.putShort(l4 + 2L, (short)n7);
            n6 = MotifDnDConstants.Swapper.getInt(l3 + 4L, by2);
            unsafe.putInt(l4 + 4L, n6);
            if (n5 != 4) {
                s2 = MotifDnDConstants.Swapper.getShort(l3 + 8L, by2);
                short s3 = MotifDnDConstants.Swapper.getShort(l3 + 10L, by2);
                unsafe.putShort(l4 + 8L, s2);
                unsafe.putShort(l4 + 10L, s3);
            } else {
                unsafe.putShort(l4 + 8L, (short)0);
                unsafe.putShort(l4 + 10L, (short)0);
            }
            Object object = XToolkit.getAWTLock();
            synchronized (object) {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), xClientMessageEvent2.get_window(), false, 0L, xClientMessageEvent2.pData);
            }
        }
        finally {
            xClientMessageEvent2.dispose();
        }
        return true;
    }

    public Object getData(long l2, long l3) throws IllegalArgumentException, IOException {
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent(l2);
        if (xClientMessageEvent.get_message_type() != MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom()) {
            throw new IllegalArgumentException();
        }
        long l4 = xClientMessageEvent.get_data();
        byte by = (byte)(unsafe.getByte(l4) & 0x7F);
        byte by2 = (byte)(unsafe.getByte(l4) & 0xFFFFFF80);
        byte by3 = unsafe.getByte(l4 + 1L);
        if (by2 != 0) {
            throw new IOException("Cannot get data: corrupted context");
        }
        long l5 = 0L;
        switch (by) {
            case 2: 
            case 8: {
                l5 = this.sourceAtom;
                break;
            }
            case 5: {
                l5 = MotifDnDConstants.Swapper.getInt(l4 + 12L, by3);
                break;
            }
            default: {
                throw new IOException("Cannot get data: invalid message reason");
            }
        }
        if (l5 == 0L) {
            throw new IOException("Cannot get data: drag source property atom unavailable");
        }
        long l6 = MotifDnDConstants.Swapper.getInt(l4 + 4L, by3);
        XAtom xAtom = XAtom.get(l5);
        XSelection xSelection = XSelection.getSelection(xAtom);
        if (xSelection == null) {
            xSelection = new XSelection(xAtom, null);
        }
        return xSelection.getData(l3, l6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendDropDone(long l2, boolean bl2, int n2) {
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent(l2);
        if (xClientMessageEvent.get_message_type() != MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom()) {
            return false;
        }
        long l3 = xClientMessageEvent.get_data();
        byte by = (byte)(unsafe.getByte(l3) & 0x7F);
        byte by2 = (byte)(unsafe.getByte(l3) & 0xFFFFFF80);
        byte by3 = unsafe.getByte(l3 + 1L);
        if (by2 != 0) {
            return false;
        }
        if (by != 5) {
            return false;
        }
        long l4 = MotifDnDConstants.Swapper.getInt(l3 + 4L, by3);
        long l5 = MotifDnDConstants.Swapper.getInt(l3 + 12L, by3);
        long l6 = 0L;
        l6 = bl2 ? MotifDnDConstants.XA_XmTRANSFER_SUCCESS.getAtom() : MotifDnDConstants.XA_XmTRANSFER_FAILURE.getAtom();
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            XlibWrapper.XConvertSelection(XToolkit.getDisplay(), l5, l6, MotifDnDConstants.XA_MOTIF_ATOM_0.getAtom(), XWindow.getXAWTRootWindow().getWindow(), l4);
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
        this.targetXWindow = null;
        this.cleanup();
        return true;
    }

    public final long getSourceWindow() {
        return this.sourceWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        XDropTargetEventProcessor.reset();
        if (this.targetXWindow != null) {
            this.getProtocolListener().handleDropTargetNotification(this.targetXWindow, 0, 0, 0, this.sourceActions, this.sourceFormats, 0L, 505);
        }
        if (this.sourceWindow != 0L) {
            Object object = XToolkit.getAWTLock();
            synchronized (object) {
                XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
                XlibWrapper.XSelectInput(XToolkit.getDisplay(), this.sourceWindow, this.sourceWindowMask);
                XToolkit.RESTORE_XERROR_HANDLER();
            }
        }
        this.sourceWindow = 0L;
        this.sourceWindowMask = 0L;
        this.sourceProtocolVersion = 0;
        this.sourceActions = 0;
        this.sourceFormats = null;
        this.sourceAtom = 0L;
        this.userAction = 0;
        this.sourceX = 0;
        this.sourceY = 0;
        this.targetXWindow = null;
        this.topLevelLeavePostponed = false;
    }

    public boolean isDragOverComponent() {
        return this.targetXWindow != null;
    }
}

