/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.InvalidDnDOperationException;
import java.util.Map;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDnDConstants;
import sun.awt.X11.XDragSourceProtocol;
import sun.awt.X11.XDragSourceProtocolListener;
import sun.awt.X11.XException;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWM;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

class XDnDDragSourceProtocol
extends XDragSourceProtocol {
    private static final Unsafe unsafe = XlibWrapper.unsafe;

    protected XDnDDragSourceProtocol(XDragSourceProtocolListener xDragSourceProtocolListener) {
        super(xDragSourceProtocolListener);
    }

    static XDragSourceProtocol createInstance(XDragSourceProtocolListener xDragSourceProtocolListener) {
        return new XDnDDragSourceProtocol(xDragSourceProtocolListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeDragImpl(int n2, Transferable transferable, Map map, long[] lArray) throws InvalidDnDOperationException, IllegalArgumentException, XException {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        long l2 = XDragSourceProtocol.getDragSourceWindow();
        long l3 = Native.allocateLongArray(3);
        int n3 = 0;
        try {
            if ((n2 & 1) != 0) {
                Native.putLong(l3, n3, XDnDConstants.XA_XdndActionCopy.getAtom());
                ++n3;
            }
            if ((n2 & 2) != 0) {
                Native.putLong(l3, n3, XDnDConstants.XA_XdndActionMove.getAtom());
                ++n3;
            }
            if ((n2 & 0x40000000) != 0) {
                Native.putLong(l3, n3, XDnDConstants.XA_XdndActionLink.getAtom());
                ++n3;
            }
            XToolkit.WITH_XERROR_HANDLER(XWM.VerifyChangePropertyHandler);
            XDnDConstants.XA_XdndActionList.setAtomData(l2, 4L, l3, n3);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                this.cleanup();
                throw new XException("Cannot write XdndActionList property");
            }
        }
        finally {
            unsafe.freeMemory(l3);
            l3 = 0L;
        }
        l3 = Native.allocateLongArray(lArray.length);
        try {
            Native.put(l3, lArray);
            XToolkit.WITH_XERROR_HANDLER(XWM.VerifyChangePropertyHandler);
            XDnDConstants.XA_XdndTypeList.setAtomData(l2, 4L, l3, lArray.length);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                this.cleanup();
                throw new XException("Cannot write XdndActionList property");
            }
        }
        finally {
            unsafe.freeMemory(l3);
            l3 = 0L;
        }
        if (!XDnDConstants.XDnDSelection.setOwner(transferable, map, lArray, 0L)) {
            this.cleanup();
            throw new InvalidDnDOperationException("Cannot acquire selection ownership");
        }
    }

    private boolean processXdndStatus(XClientMessageEvent xClientMessageEvent) {
        int n2 = 0;
        if (xClientMessageEvent.get_data(0) != this.getTargetWindow()) {
            return true;
        }
        if ((xClientMessageEvent.get_data(1) & 1L) != 0L) {
            n2 = XDnDConstants.getJavaActionForXDnDAction(xClientMessageEvent.get_data(4));
        }
        this.getProtocolListener().handleDragReply(n2);
        return true;
    }

    private boolean processXdndFinished(XClientMessageEvent xClientMessageEvent) {
        if (xClientMessageEvent.get_data(0) != this.getTargetWindow()) {
            return true;
        }
        if (this.getTargetProtocolVersion() >= 5) {
            boolean bl2 = (xClientMessageEvent.get_data(1) & 1L) != 0L;
            int n2 = XDnDConstants.getJavaActionForXDnDAction(xClientMessageEvent.get_data(2));
            this.getProtocolListener().handleDragFinished(bl2, n2);
        } else {
            this.getProtocolListener().handleDragFinished();
        }
        this.finalizeDrop();
        return true;
    }

    public boolean processClientMessage(XClientMessageEvent xClientMessageEvent) {
        if (xClientMessageEvent.get_message_type() == XDnDConstants.XA_XdndStatus.getAtom()) {
            return this.processXdndStatus(xClientMessageEvent);
        }
        if (xClientMessageEvent.get_message_type() == XDnDConstants.XA_XdndFinished.getAtom()) {
            return this.processXdndFinished(xClientMessageEvent);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attachTargetWindow(long l2, long l3) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l2, XDnDConstants.XA_XdndAware, 0L, 1L, false, 0L);
        int n2 = windowPropertyGetter.execute(XToolkit.IgnoreBadWindowHandler);
        if (n2 == 0 && windowPropertyGetter.getData() != 0L && windowPropertyGetter.getActualType() == 4L) {
            int n3 = (int)Native.getLong(windowPropertyGetter.getData());
            windowPropertyGetter.dispose();
            if (n3 >= 3) {
                int n4;
                long l4;
                block18: {
                    l4 = 0L;
                    n4 = n3 < 5 ? n3 : 5;
                    WindowPropertyGetter windowPropertyGetter2 = new WindowPropertyGetter(l2, XDnDConstants.XA_XdndProxy, 0L, 1L, false, 33L);
                    try {
                        n2 = windowPropertyGetter2.execute(XToolkit.IgnoreBadWindowHandler);
                        if (n2 == 0 && windowPropertyGetter2.getData() != 0L && windowPropertyGetter2.getActualType() == 33L) {
                            l4 = Native.getLong(windowPropertyGetter2.getData());
                        }
                    }
                    finally {
                        windowPropertyGetter2.dispose();
                    }
                    if (l4 != 0L) {
                        WindowPropertyGetter windowPropertyGetter3 = new WindowPropertyGetter(l4, XDnDConstants.XA_XdndProxy, 0L, 1L, false, 33L);
                        try {
                            n2 = windowPropertyGetter3.execute(XToolkit.IgnoreBadWindowHandler);
                            if (n2 != 0 || windowPropertyGetter3.getData() == 0L || windowPropertyGetter3.getActualType() != 33L || Native.getLong(windowPropertyGetter3.getData()) != l4) {
                                l4 = 0L;
                                break block18;
                            }
                            WindowPropertyGetter windowPropertyGetter4 = new WindowPropertyGetter(l4, XDnDConstants.XA_XdndAware, 0L, 1L, false, 0L);
                            try {
                                n2 = windowPropertyGetter4.execute(XToolkit.IgnoreBadWindowHandler);
                                if (n2 != 0 || windowPropertyGetter4.getData() == 0L || windowPropertyGetter4.getActualType() != 4L) {
                                    l4 = 0L;
                                }
                            }
                            finally {
                                windowPropertyGetter4.dispose();
                            }
                        }
                        finally {
                            windowPropertyGetter3.dispose();
                        }
                    }
                }
                this.setTargetWindow(l2);
                this.setTargetProxyWindow(l4);
                this.setTargetProtocolVersion(n4);
                return true;
            }
        } else {
            windowPropertyGetter.dispose();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEnterMessage(long[] lArray, int n2, int n3, long l2) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        assert (this.getTargetWindow() != 0L);
        assert (lArray != null);
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(this.getTargetWindow());
            xClientMessageEvent.set_format(32);
            xClientMessageEvent.set_message_type(XDnDConstants.XA_XdndEnter.getAtom());
            xClientMessageEvent.set_data(0, XDragSourceProtocol.getDragSourceWindow());
            long l3 = this.getTargetProtocolVersion() << 24;
            xClientMessageEvent.set_data(1, l3 |= lArray.length > 3 ? 1L : 0L);
            xClientMessageEvent.set_data(2, lArray.length > 0 ? lArray[0] : 0L);
            xClientMessageEvent.set_data(3, lArray.length > 1 ? lArray[1] : 0L);
            xClientMessageEvent.set_data(4, lArray.length > 2 ? lArray[2] : 0L);
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, xClientMessageEvent.pData);
        }
        finally {
            xClientMessageEvent.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMoveMessage(int n2, int n3, int n4, int n5, long l2) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        assert (this.getTargetWindow() != 0L);
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(this.getTargetWindow());
            xClientMessageEvent.set_format(32);
            xClientMessageEvent.set_message_type(XDnDConstants.XA_XdndPosition.getAtom());
            xClientMessageEvent.set_data(0, XDragSourceProtocol.getDragSourceWindow());
            xClientMessageEvent.set_data(1, 0L);
            xClientMessageEvent.set_data(2, n2 << 16 | n3);
            xClientMessageEvent.set_data(3, l2);
            xClientMessageEvent.set_data(4, XDnDConstants.getXDnDActionForJavaAction(n4));
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, xClientMessageEvent.pData);
        }
        finally {
            xClientMessageEvent.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendLeaveMessage(long l2) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        assert (this.getTargetWindow() != 0L);
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(this.getTargetWindow());
            xClientMessageEvent.set_format(32);
            xClientMessageEvent.set_message_type(XDnDConstants.XA_XdndLeave.getAtom());
            xClientMessageEvent.set_data(0, XDragSourceProtocol.getDragSourceWindow());
            xClientMessageEvent.set_data(1, 0L);
            xClientMessageEvent.set_data(2, 0L);
            xClientMessageEvent.set_data(3, 0L);
            xClientMessageEvent.set_data(4, 0L);
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, xClientMessageEvent.pData);
        }
        finally {
            xClientMessageEvent.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDropMessage(int n2, int n3, int n4, int n5, long l2) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        assert (this.getTargetWindow() != 0L);
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(this.getTargetWindow());
            xClientMessageEvent.set_format(32);
            xClientMessageEvent.set_message_type(XDnDConstants.XA_XdndDrop.getAtom());
            xClientMessageEvent.set_data(0, XDragSourceProtocol.getDragSourceWindow());
            xClientMessageEvent.set_data(1, 0L);
            xClientMessageEvent.set_data(2, l2);
            xClientMessageEvent.set_data(3, 0L);
            xClientMessageEvent.set_data(4, 0L);
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, xClientMessageEvent.pData);
        }
        finally {
            xClientMessageEvent.dispose();
        }
    }

    public void run() {
        this.cleanup();
    }
}

