/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.BufferedImageGraphicsConfig;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.BytePackedRaster;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.image.ShortComponentRaster;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;

public class BufImgSurfaceData
extends SurfaceData {
    BufferedImage bufImg;
    private BufferedImageGraphicsConfig graphicsConfig;
    RenderLoops solidloops;
    private static final int DCM_RGBX_RED_MASK = -16777216;
    private static final int DCM_RGBX_GREEN_MASK = 0xFF0000;
    private static final int DCM_RGBX_BLUE_MASK = 65280;
    private static final int DCM_555X_RED_MASK = 63488;
    private static final int DCM_555X_GREEN_MASK = 1984;
    private static final int DCM_555X_BLUE_MASK = 62;
    private static final int DCM_4444_RED_MASK = 3840;
    private static final int DCM_4444_GREEN_MASK = 240;
    private static final int DCM_4444_BLUE_MASK = 15;
    private static final int DCM_4444_ALPHA_MASK = 61440;
    private static final int DCM_ARGBBM_ALPHA_MASK = 0x1000000;
    private static final int DCM_ARGBBM_RED_MASK = 0xFF0000;
    private static final int DCM_ARGBBM_GREEN_MASK = 65280;
    private static final int DCM_ARGBBM_BLUE_MASK = 255;
    private static final int CACHE_SIZE = 5;
    private static RenderLoops[] loopcache;
    private static SurfaceType[] typecache;

    private static native void initIDs();

    public static SurfaceData createData(BufferedImage bufferedImage) {
        SurfaceData surfaceData;
        if (bufferedImage == null) {
            throw new NullPointerException("BufferedImage cannot be null");
        }
        ColorModel colorModel = bufferedImage.getColorModel();
        int n2 = bufferedImage.getType();
        switch (n2) {
            case 4: {
                surfaceData = BufImgSurfaceData.createDataIC(bufferedImage, SurfaceType.IntBgr);
                break;
            }
            case 1: {
                surfaceData = BufImgSurfaceData.createDataIC(bufferedImage, SurfaceType.IntRgb);
                break;
            }
            case 2: {
                surfaceData = BufImgSurfaceData.createDataIC(bufferedImage, SurfaceType.IntArgb);
                break;
            }
            case 3: {
                surfaceData = BufImgSurfaceData.createDataIC(bufferedImage, SurfaceType.IntArgbPre);
                break;
            }
            case 5: {
                surfaceData = BufImgSurfaceData.createDataBC(bufferedImage, SurfaceType.ThreeByteBgr, 2);
                break;
            }
            case 6: {
                surfaceData = BufImgSurfaceData.createDataBC(bufferedImage, SurfaceType.FourByteAbgr, 3);
                break;
            }
            case 7: {
                surfaceData = BufImgSurfaceData.createDataBC(bufferedImage, SurfaceType.FourByteAbgrPre, 3);
                break;
            }
            case 8: {
                surfaceData = BufImgSurfaceData.createDataSC(bufferedImage, SurfaceType.Ushort565Rgb, null);
                break;
            }
            case 9: {
                surfaceData = BufImgSurfaceData.createDataSC(bufferedImage, SurfaceType.Ushort555Rgb, null);
                break;
            }
            case 13: {
                SurfaceType surfaceType;
                switch (colorModel.getTransparency()) {
                    case 1: {
                        if (BufImgSurfaceData.isOpaqueGray((IndexColorModel)colorModel)) {
                            surfaceType = SurfaceType.Index8Gray;
                            break;
                        }
                        surfaceType = SurfaceType.ByteIndexedOpaque;
                        break;
                    }
                    case 2: {
                        surfaceType = SurfaceType.ByteIndexedBm;
                        break;
                    }
                    case 3: {
                        surfaceType = SurfaceType.ByteIndexed;
                        break;
                    }
                    default: {
                        throw new InternalError("Unrecognized transparency");
                    }
                }
                surfaceData = BufImgSurfaceData.createDataBC(bufferedImage, surfaceType, 0);
                break;
            }
            case 10: {
                surfaceData = BufImgSurfaceData.createDataBC(bufferedImage, SurfaceType.ByteGray, 0);
                break;
            }
            case 11: {
                surfaceData = BufImgSurfaceData.createDataSC(bufferedImage, SurfaceType.UshortGray, null);
                break;
            }
            case 12: {
                SurfaceType surfaceType;
                SampleModel sampleModel = bufferedImage.getRaster().getSampleModel();
                switch (sampleModel.getSampleSize(0)) {
                    case 1: {
                        surfaceType = SurfaceType.ByteBinary1Bit;
                        break;
                    }
                    case 2: {
                        surfaceType = SurfaceType.ByteBinary2Bit;
                        break;
                    }
                    case 4: {
                        surfaceType = SurfaceType.ByteBinary4Bit;
                        break;
                    }
                    default: {
                        throw new InternalError("Unrecognized pixel size");
                    }
                }
                surfaceData = BufImgSurfaceData.createDataBP(bufferedImage, surfaceType);
                break;
            }
            default: {
                WritableRaster writableRaster = bufferedImage.getRaster();
                int n3 = writableRaster.getNumBands();
                if (writableRaster instanceof IntegerComponentRaster && writableRaster.getNumDataElements() == 1 && ((IntegerComponentRaster)writableRaster).getPixelStride() == 1) {
                    SurfaceType surfaceType = SurfaceType.AnyInt;
                    if (colorModel instanceof DirectColorModel) {
                        DirectColorModel directColorModel = (DirectColorModel)colorModel;
                        int n4 = directColorModel.getAlphaMask();
                        int n5 = directColorModel.getRedMask();
                        int n6 = directColorModel.getGreenMask();
                        int n7 = directColorModel.getBlueMask();
                        surfaceType = n3 == 3 && n4 == 0 && n5 == -16777216 && n6 == 0xFF0000 && n7 == 65280 ? SurfaceType.IntRgbx : (n3 == 4 && n4 == 0x1000000 && n5 == 0xFF0000 && n6 == 65280 && n7 == 255 ? SurfaceType.IntArgbBm : SurfaceType.AnyDcm);
                    }
                    surfaceData = BufImgSurfaceData.createDataIC(bufferedImage, surfaceType);
                    break;
                }
                if (writableRaster instanceof ShortComponentRaster && writableRaster.getNumDataElements() == 1 && ((ShortComponentRaster)writableRaster).getPixelStride() == 1) {
                    SurfaceType surfaceType = SurfaceType.AnyShort;
                    IndexColorModel indexColorModel = null;
                    if (colorModel instanceof DirectColorModel) {
                        DirectColorModel directColorModel = (DirectColorModel)colorModel;
                        int n8 = directColorModel.getAlphaMask();
                        int n9 = directColorModel.getRedMask();
                        int n10 = directColorModel.getGreenMask();
                        int n11 = directColorModel.getBlueMask();
                        if (n3 == 3 && n8 == 0 && n9 == 63488 && n10 == 1984 && n11 == 62) {
                            surfaceType = SurfaceType.Ushort555Rgbx;
                        } else if (n3 == 4 && n8 == 61440 && n9 == 3840 && n10 == 240 && n11 == 15) {
                            surfaceType = SurfaceType.Ushort4444Argb;
                        }
                    } else if (colorModel instanceof IndexColorModel) {
                        indexColorModel = (IndexColorModel)colorModel;
                        if (indexColorModel.getPixelSize() == 12) {
                            surfaceType = BufImgSurfaceData.isOpaqueGray(indexColorModel) ? SurfaceType.Index12Gray : SurfaceType.UshortIndexed;
                        } else {
                            indexColorModel = null;
                        }
                    }
                    surfaceData = BufImgSurfaceData.createDataSC(bufferedImage, surfaceType, indexColorModel);
                    break;
                }
                surfaceData = new BufImgSurfaceData(bufferedImage, SurfaceType.Custom);
            }
        }
        ((BufImgSurfaceData)surfaceData).initSolidLoops();
        return surfaceData;
    }

    public static SurfaceData createData(Raster raster, ColorModel colorModel) {
        throw new InternalError("SurfaceData not implemented for Raster/CM");
    }

    public static SurfaceData createDataIC(BufferedImage bufferedImage, SurfaceType surfaceType) {
        BufImgSurfaceData bufImgSurfaceData = new BufImgSurfaceData(bufferedImage, surfaceType);
        IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)bufferedImage.getRaster();
        bufImgSurfaceData.initRaster(integerComponentRaster.getDataStorage(), integerComponentRaster.getDataOffset(0) * 4, integerComponentRaster.getWidth(), integerComponentRaster.getHeight(), integerComponentRaster.getPixelStride() * 4, integerComponentRaster.getScanlineStride() * 4, null);
        return bufImgSurfaceData;
    }

    public static SurfaceData createDataSC(BufferedImage bufferedImage, SurfaceType surfaceType, IndexColorModel indexColorModel) {
        BufImgSurfaceData bufImgSurfaceData = new BufImgSurfaceData(bufferedImage, surfaceType);
        ShortComponentRaster shortComponentRaster = (ShortComponentRaster)bufferedImage.getRaster();
        bufImgSurfaceData.initRaster(shortComponentRaster.getDataStorage(), shortComponentRaster.getDataOffset(0) * 2, shortComponentRaster.getWidth(), shortComponentRaster.getHeight(), shortComponentRaster.getPixelStride() * 2, shortComponentRaster.getScanlineStride() * 2, indexColorModel);
        return bufImgSurfaceData;
    }

    public static SurfaceData createDataBC(BufferedImage bufferedImage, SurfaceType surfaceType, int n2) {
        BufImgSurfaceData bufImgSurfaceData = new BufImgSurfaceData(bufferedImage, surfaceType);
        ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage.getRaster();
        ColorModel colorModel = bufferedImage.getColorModel();
        IndexColorModel indexColorModel = colorModel instanceof IndexColorModel ? (IndexColorModel)colorModel : null;
        bufImgSurfaceData.initRaster(byteComponentRaster.getDataStorage(), byteComponentRaster.getDataOffset(n2), byteComponentRaster.getWidth(), byteComponentRaster.getHeight(), byteComponentRaster.getPixelStride(), byteComponentRaster.getScanlineStride(), indexColorModel);
        return bufImgSurfaceData;
    }

    public static SurfaceData createDataBP(BufferedImage bufferedImage, SurfaceType surfaceType) {
        BufImgSurfaceData bufImgSurfaceData = new BufImgSurfaceData(bufferedImage, surfaceType);
        BytePackedRaster bytePackedRaster = (BytePackedRaster)bufferedImage.getRaster();
        ColorModel colorModel = bufferedImage.getColorModel();
        IndexColorModel indexColorModel = colorModel instanceof IndexColorModel ? (IndexColorModel)colorModel : null;
        bufImgSurfaceData.initRaster(bytePackedRaster.getDataStorage(), bytePackedRaster.getDataBitOffset() / 8, bytePackedRaster.getWidth(), bytePackedRaster.getHeight(), 0, bytePackedRaster.getScanlineStride(), indexColorModel);
        return bufImgSurfaceData;
    }

    public void lock() {
    }

    public void unlock() {
    }

    public RenderLoops getRenderLoops(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.paintState == 0) {
            if (sunGraphics2D.compositeState == 0) {
                return this.solidloops;
            }
        }
        return super.getRenderLoops(sunGraphics2D);
    }

    public Raster getRaster(int n2, int n3, int n4, int n5) {
        return this.bufImg.getRaster();
    }

    protected native void initRaster(Object var1, int var2, int var3, int var4, int var5, int var6, IndexColorModel var7);

    public BufImgSurfaceData(BufferedImage bufferedImage, SurfaceType surfaceType) {
        super(surfaceType, bufferedImage.getColorModel());
        this.bufImg = bufferedImage;
    }

    public void initSolidLoops() {
        this.solidloops = BufImgSurfaceData.getSolidLoops(this.getSurfaceType());
    }

    public static synchronized RenderLoops getSolidLoops(SurfaceType surfaceType) {
        for (int i2 = 4; i2 >= 0; --i2) {
            SurfaceType surfaceType2 = typecache[i2];
            if (surfaceType2 == surfaceType) {
                return loopcache[i2];
            }
            if (surfaceType2 == null) break;
        }
        RenderLoops renderLoops = BufImgSurfaceData.makeRenderLoops(SurfaceType.OpaqueColor, CompositeType.SrcNoEa, surfaceType);
        System.arraycopy(loopcache, 1, loopcache, 0, 4);
        System.arraycopy(typecache, 1, typecache, 0, 4);
        BufImgSurfaceData.loopcache[4] = renderLoops;
        BufImgSurfaceData.typecache[4] = surfaceType;
        return renderLoops;
    }

    public SurfaceData getReplacement() {
        return BufImgSurfaceData.restoreContents(this.bufImg);
    }

    public synchronized GraphicsConfiguration getDeviceConfiguration() {
        if (this.graphicsConfig == null) {
            this.graphicsConfig = BufferedImageGraphicsConfig.getConfig(this.bufImg);
        }
        return this.graphicsConfig;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.bufImg.getWidth(), this.bufImg.getHeight());
    }

    protected void checkCustomComposite() {
    }

    public static native void freeNativeICMData(IndexColorModel var0);

    static {
        BufImgSurfaceData.initIDs();
        loopcache = new RenderLoops[5];
        typecache = new SurfaceType[5];
    }
}

