/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image.codec;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RescaleOp;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import sun.awt.image.codec.JPEGParam;
import sun.security.action.LoadLibraryAction;

public class JPEGImageEncoderImpl
implements JPEGImageEncoder {
    private OutputStream outStream = null;
    private JPEGParam param = null;
    private boolean pack = false;
    private static final Class OutputStreamClass = OutputStream.class;

    public JPEGImageEncoderImpl(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("OutputStream is null.");
        }
        this.outStream = outputStream;
        this.initEncoder(OutputStreamClass);
    }

    public JPEGImageEncoderImpl(OutputStream outputStream, JPEGEncodeParam jPEGEncodeParam) {
        this(outputStream);
        this.setJPEGEncodeParam(jPEGEncodeParam);
    }

    public int getDefaultColorId(ColorModel colorModel) {
        boolean bl2 = colorModel.hasAlpha();
        ColorSpace colorSpace = colorModel.getColorSpace();
        ColorSpace colorSpace2 = null;
        switch (colorSpace.getType()) {
            case 6: {
                return 1;
            }
            case 5: {
                if (bl2) {
                    return 7;
                }
                return 3;
            }
            case 3: {
                if (colorSpace2 == null) {
                    try {
                        colorSpace2 = ColorSpace.getInstance(1002);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (colorSpace == colorSpace2) {
                    return bl2 ? 10 : 5;
                }
                return bl2 ? 7 : 3;
            }
            case 9: {
                return 4;
            }
        }
        return 0;
    }

    public synchronized OutputStream getOutputStream() {
        return this.outStream;
    }

    public synchronized void setJPEGEncodeParam(JPEGEncodeParam jPEGEncodeParam) {
        this.param = new JPEGParam(jPEGEncodeParam);
    }

    public synchronized JPEGEncodeParam getJPEGEncodeParam() {
        return (JPEGEncodeParam)this.param.clone();
    }

    public JPEGEncodeParam getDefaultJPEGEncodeParam(Raster raster, int n2) {
        JPEGParam jPEGParam = new JPEGParam(n2, raster.getNumBands());
        jPEGParam.setWidth(raster.getWidth());
        jPEGParam.setHeight(raster.getHeight());
        return jPEGParam;
    }

    public JPEGEncodeParam getDefaultJPEGEncodeParam(BufferedImage bufferedImage) {
        ColorModel colorModel = bufferedImage.getColorModel();
        int n2 = this.getDefaultColorId(colorModel);
        if (!(colorModel instanceof IndexColorModel)) {
            return this.getDefaultJPEGEncodeParam(bufferedImage.getRaster(), n2);
        }
        JPEGParam jPEGParam = colorModel.hasAlpha() ? new JPEGParam(n2, 4) : new JPEGParam(n2, 3);
        jPEGParam.setWidth(bufferedImage.getWidth());
        jPEGParam.setHeight(bufferedImage.getHeight());
        return jPEGParam;
    }

    public JPEGEncodeParam getDefaultJPEGEncodeParam(int n2, int n3) {
        return new JPEGParam(n3, n2);
    }

    public JPEGEncodeParam getDefaultJPEGEncodeParam(JPEGDecodeParam jPEGDecodeParam) throws ImageFormatException {
        return new JPEGParam(jPEGDecodeParam);
    }

    public synchronized void encode(BufferedImage bufferedImage) throws IOException, ImageFormatException {
        if (this.param == null) {
            this.setJPEGEncodeParam(this.getDefaultJPEGEncodeParam(bufferedImage));
        }
        if (bufferedImage.getWidth() != this.param.getWidth() || bufferedImage.getHeight() != this.param.getHeight()) {
            throw new ImageFormatException("Param block's width/height doesn't match the BufferedImage");
        }
        if (this.param.getEncodedColorID() != this.getDefaultColorId(bufferedImage.getColorModel())) {
            throw new ImageFormatException("The encoded COLOR_ID doesn't match the BufferedImage");
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        ColorModel colorModel = bufferedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            bufferedImage = indexColorModel.convertToIntDiscrete(writableRaster, false);
            writableRaster = bufferedImage.getRaster();
            colorModel = bufferedImage.getColorModel();
        }
        this.encode((Raster)writableRaster, colorModel);
    }

    public synchronized void encode(BufferedImage bufferedImage, JPEGEncodeParam jPEGEncodeParam) throws IOException, ImageFormatException {
        this.setJPEGEncodeParam(jPEGEncodeParam);
        this.encode(bufferedImage);
    }

    public void encode(Raster raster) throws IOException, ImageFormatException {
        if (this.param == null) {
            this.setJPEGEncodeParam(this.getDefaultJPEGEncodeParam(raster, 0));
        }
        if (raster.getWidth() != this.param.getWidth() || raster.getHeight() != this.param.getHeight()) {
            throw new ImageFormatException("Param block's width/height doesn't match the Raster");
        }
        if (this.param.getEncodedColorID() != 0 && this.param.getNumComponents() != raster.getNumBands()) {
            throw new ImageFormatException("Param block's COLOR_ID doesn't match the Raster.");
        }
        this.encode(raster, (ColorModel)null);
    }

    public void encode(Raster raster, JPEGEncodeParam jPEGEncodeParam) throws IOException, ImageFormatException {
        this.setJPEGEncodeParam(jPEGEncodeParam);
        this.encode(raster);
    }

    private boolean useGiven(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel();
        if (sampleModel.getDataType() != 0) {
            return false;
        }
        if (!(sampleModel instanceof ComponentSampleModel)) {
            return false;
        }
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
        if (componentSampleModel.getPixelStride() != sampleModel.getNumBands()) {
            return false;
        }
        int[] nArray = componentSampleModel.getBandOffsets();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] == i2) continue;
            return false;
        }
        return true;
    }

    private boolean canPack(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel();
        if (sampleModel.getDataType() != 3) {
            return false;
        }
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
        int[] nArray = new int[]{0xFF0000, 65280, 255, -16777216};
        int[] nArray2 = singlePixelPackedSampleModel.getBitMasks();
        if (nArray2.length != 3 && nArray2.length != 4) {
            return false;
        }
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            if (nArray2[i2] == nArray[i2]) continue;
            return false;
        }
        return true;
    }

    private void encode(Raster raster, ColorModel colorModel) throws IOException, ImageFormatException {
        Object[] objectArray;
        int n2;
        int n3;
        int n4;
        SampleModel sampleModel = raster.getSampleModel();
        int n5 = sampleModel.getNumBands();
        if (colorModel == null) {
            for (n4 = 0; n4 < n5; ++n4) {
                if (sampleModel.getSampleSize(n4) <= 8) continue;
                throw new ImageFormatException("JPEG encoder can only accept 8 bit data.");
            }
        }
        int n6 = this.param.getEncodedColorID();
        switch (this.param.getNumComponents()) {
            case 1: {
                if (n6 == 1 || n6 == 0 || this.param.findAPP0() == null) break;
                throw new ImageFormatException("1 band JFIF files imply Y or unknown encoding.\nParam block indicates alternate encoding.");
            }
            case 3: {
                if (n6 == 3 || this.param.findAPP0() == null) break;
                throw new ImageFormatException("3 band JFIF files imply YCbCr encoding.\nParam block indicates alternate encoding.");
            }
            case 4: {
                if (n6 == 4 || this.param.findAPP0() == null) break;
                throw new ImageFormatException("4 band JFIF files imply CMYK encoding.\nParam block indicates alternate encoding.");
            }
        }
        if (!this.param.isImageInfoValid()) {
            this.writeJPEGStream(this.param, colorModel, this.outStream, null, 0, 0);
            return;
        }
        DataBuffer dataBuffer = raster.getDataBuffer();
        boolean bl2 = false;
        boolean bl3 = true;
        int[] nArray = null;
        if (colorModel != null) {
            if (colorModel.hasAlpha() && colorModel.isAlphaPremultiplied()) {
                bl2 = true;
                bl3 = false;
            }
            nArray = colorModel.getComponentSize();
            for (n4 = 0; n4 < n5; ++n4) {
                if (nArray[n4] == 8) continue;
                bl3 = false;
            }
        }
        this.pack = false;
        if (bl3 && this.useGiven(raster)) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            n3 = dataBuffer.getOffset() + componentSampleModel.getOffset(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY());
            n2 = componentSampleModel.getScanlineStride();
            objectArray = ((DataBufferByte)dataBuffer).getData();
        } else if (bl3 && this.canPack(raster)) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            n3 = dataBuffer.getOffset() + singlePixelPackedSampleModel.getOffset(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY());
            n2 = singlePixelPackedSampleModel.getScanlineStride();
            objectArray = ((DataBufferInt)dataBuffer).getData();
            this.pack = true;
        } else {
            int[] nArray2 = new int[n5];
            float[] fArray = new float[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                nArray2[n4] = n4;
                if (bl3) continue;
                fArray[n4] = nArray[n4] != 8 ? 255.0f / (float)((1 << nArray[n4]) - 1) : 1.0f;
            }
            ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, raster.getWidth(), raster.getHeight(), n5, n5 * raster.getWidth(), nArray2);
            WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, new Point(raster.getMinX(), raster.getMinY()));
            if (bl3) {
                writableRaster.setRect(raster);
            } else {
                float[] fArray2 = new float[n5];
                RescaleOp rescaleOp = new RescaleOp(fArray, fArray2, null);
                rescaleOp.filter(raster, writableRaster);
                if (bl2) {
                    int[] nArray3 = new int[n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        nArray3[n4] = 8;
                    }
                    ComponentColorModel componentColorModel = new ComponentColorModel(colorModel.getColorSpace(), nArray3, true, true, 3, 0);
                    componentColorModel.coerceData(writableRaster, false);
                }
            }
            dataBuffer = writableRaster.getDataBuffer();
            objectArray = ((DataBufferByte)dataBuffer).getData();
            n3 = dataBuffer.getOffset() + componentSampleModel.getOffset(0, 0);
            n2 = componentSampleModel.getScanlineStride();
        }
        this.writeJPEGStream(this.param, colorModel, this.outStream, objectArray, n3, n2);
    }

    private int getNearestColorId(ColorModel colorModel) {
        ColorSpace colorSpace = colorModel.getColorSpace();
        switch (colorSpace.getType()) {
            case 5: {
                if (colorModel.hasAlpha()) {
                    return 6;
                }
                return 2;
            }
        }
        return this.getDefaultColorId(colorModel);
    }

    private native void initEncoder(Class var1);

    private synchronized native void writeJPEGStream(JPEGEncodeParam var1, ColorModel var2, OutputStream var3, Object var4, int var5, int var6) throws IOException, ImageFormatException;

    static {
        AccessController.doPrivileged(new LoadLibraryAction("jpeg"));
    }
}

