/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import java.security.AccessController;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.security.action.GetPropertyAction;

public class CharToByteUnicode
extends CharToByteConverter {
    static final char BYTE_ORDER_MARK = '\ufeff';
    protected boolean usesMark = true;
    private boolean markWritten = false;
    static final int UNKNOWN = 0;
    static final int BIG = 1;
    static final int LITTLE = 2;
    protected int byteOrder = 0;

    public CharToByteUnicode() {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.io.unicode.encoding", "UnicodeBig"));
        this.byteOrder = string.equals("UnicodeBig") ? 1 : (string.equals("UnicodeLittle") ? 2 : 1);
    }

    public CharToByteUnicode(int n2, boolean bl2) {
        this.byteOrder = n2;
        this.usesMark = bl2;
    }

    public CharToByteUnicode(boolean bl2) {
        this();
        this.usesMark = bl2;
    }

    public String getCharacterEncoding() {
        switch (this.byteOrder) {
            case 1: {
                return this.usesMark ? "UnicodeBig" : "UnicodeBigUnmarked";
            }
            case 2: {
                return this.usesMark ? "UnicodeLittle" : "UnicodeLittleUnmarked";
            }
        }
        return "UnicodeUnknown";
    }

    public int convert(char[] cArray, int n2, int n3, byte[] byArray, int n4, int n5) throws ConversionBufferFullException, MalformedInputException {
        this.charOff = n2;
        this.byteOff = n4;
        if (n2 >= n3) {
            return 0;
        }
        int n6 = n2;
        int n7 = n4;
        int n8 = n5 - 2;
        if (this.usesMark && !this.markWritten) {
            if (n7 > n8) {
                throw new ConversionBufferFullException();
            }
            if (this.byteOrder == 1) {
                byArray[n7++] = -2;
                byArray[n7++] = -1;
            } else {
                byArray[n7++] = -1;
                byArray[n7++] = -2;
            }
            this.markWritten = true;
        }
        if (this.byteOrder == 1) {
            while (n6 < n3) {
                if (n7 > n8) {
                    this.charOff = n6;
                    this.byteOff = n7;
                    throw new ConversionBufferFullException();
                }
                char c2 = cArray[n6++];
                byArray[n7++] = (byte)(c2 >> 8);
                byArray[n7++] = (byte)(c2 & 0xFF);
            }
        } else {
            while (n6 < n3) {
                if (n7 > n8) {
                    this.charOff = n6;
                    this.byteOff = n7;
                    throw new ConversionBufferFullException();
                }
                char c3 = cArray[n6++];
                byArray[n7++] = (byte)(c3 & 0xFF);
                byArray[n7++] = (byte)(c3 >> 8);
            }
        }
        this.charOff = n6;
        this.byteOff = n7;
        return n7 - n4;
    }

    public int flush(byte[] byArray, int n2, int n3) {
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.markWritten = false;
    }

    public int getMaxBytesPerChar() {
        return 4;
    }
}

