/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Transparency;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImagingOpException;
import java.awt.image.IndexColorModel;
import java.awt.image.VolatileImage;
import sun.awt.image.BytePackedRaster;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.RemoteOffScreenImage;
import sun.awt.image.ToolkitImage;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.BlitBg;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.ScaledBlit;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.DrawImagePipe;
import sun.java2d.pipe.Region;

public class DrawImage
implements DrawImagePipe {
    private static final double MAX_TX_ERROR = 1.0E-4;

    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, Color color) {
        int n4 = image.getWidth(null);
        int n5 = image.getHeight(null);
        if (DrawImage.isSimpleTranslate(sunGraphics2D)) {
            return this.renderImageCopy(sunGraphics2D, image, color, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, 0, 0, n4, n5);
        }
        AffineTransform affineTransform = sunGraphics2D.transform;
        if ((n2 | n3) != 0) {
            affineTransform = new AffineTransform(affineTransform);
            affineTransform.translate(n2, n3);
        }
        this.transformImage(sunGraphics2D, image, affineTransform, sunGraphics2D.interpolationType, 0, 0, n4, n5, color);
        return true;
    }

    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, int n4, int n5, int n6, int n7, Color color) {
        if (DrawImage.isSimpleTranslate(sunGraphics2D)) {
            return this.renderImageCopy(sunGraphics2D, image, color, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, n4, n5, n6, n7);
        }
        this.scaleImage(sunGraphics2D, image, n2, n3, n2 + n6, n3 + n7, n4, n5, n4 + n6, n5 + n7, color);
        return true;
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, int n4, int n5, Color color) {
        double d2;
        double d3;
        double d4;
        double d5;
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        if (n4 > 0 && n5 > 0 && DrawImage.isSimpleTranslate(sunGraphics2D) && this.renderImageScale(sunGraphics2D, image, color, sunGraphics2D.interpolationType, 0, 0, n6, n7, d5 = (double)(n2 + sunGraphics2D.transX), d4 = (double)(n3 + sunGraphics2D.transY), d3 = d5 + (double)n4, d2 = d4 + (double)n5)) {
            return true;
        }
        AffineTransform affineTransform = sunGraphics2D.transform;
        if ((n2 | n3) != 0 || n4 != n6 || n5 != n7) {
            affineTransform = new AffineTransform(affineTransform);
            affineTransform.translate(n2, n3);
            affineTransform.scale((double)n4 / (double)n6, (double)n5 / (double)n7);
        }
        this.transformImage(sunGraphics2D, image, affineTransform, sunGraphics2D.interpolationType, 0, 0, n6, n7, color);
        return true;
    }

    protected void transformImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, AffineTransform affineTransform, int n4) {
        boolean bl2;
        int n5 = affineTransform.getType();
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        if (sunGraphics2D.transformState <= 2 && (n5 == 0 || n5 == 1)) {
            double d2 = affineTransform.getTranslateX();
            double d3 = affineTransform.getTranslateY();
            int n8 = (int)Math.floor((d2 += sunGraphics2D.transform.getTranslateX()) + 0.5);
            int n9 = (int)Math.floor((d3 += sunGraphics2D.transform.getTranslateY()) + 0.5);
            if (n4 == 1 || DrawImage.closeToInteger(n8, d2) && DrawImage.closeToInteger(n9, d3)) {
                this.renderImageCopy(sunGraphics2D, image, null, n2 + n8, n3 + n9, 0, 0, n6, n7);
                return;
            }
            bl2 = false;
        } else if (sunGraphics2D.transformState <= 3 && (n5 & 0x78) == 0) {
            double[] dArray = new double[]{0.0, 0.0, n6, n7};
            affineTransform.transform(dArray, 0, dArray, 0, 2);
            dArray[0] = dArray[0] + (double)n2;
            dArray[1] = dArray[1] + (double)n3;
            dArray[2] = dArray[2] + (double)n2;
            dArray[3] = dArray[3] + (double)n3;
            sunGraphics2D.transform.transform(dArray, 0, dArray, 0, 2);
            if (this.tryCopyOrScale(sunGraphics2D, image, 0, 0, n6, n7, null, n4, dArray)) {
                return;
            }
            bl2 = false;
        } else {
            bl2 = true;
        }
        AffineTransform affineTransform2 = new AffineTransform(sunGraphics2D.transform);
        affineTransform2.translate(n2, n3);
        affineTransform2.concatenate(affineTransform);
        if (bl2) {
            this.transformImage(sunGraphics2D, image, affineTransform2, n4, 0, 0, n6, n7, null);
        } else {
            this.renderImageXform(sunGraphics2D, image, affineTransform2, n4, 0, 0, n6, n7, null);
        }
    }

    protected void transformImage(SunGraphics2D sunGraphics2D, Image image, AffineTransform affineTransform, int n2, int n3, int n4, int n5, int n6, Color color) {
        double[] dArray = new double[6];
        dArray[2] = n5 - n3;
        dArray[3] = dArray[5] = (double)(n6 - n4);
        affineTransform.transform(dArray, 0, dArray, 0, 3);
        if (Math.abs(dArray[0] - dArray[4]) < 1.0E-4 && Math.abs(dArray[3] - dArray[5]) < 1.0E-4 && this.tryCopyOrScale(sunGraphics2D, image, n3, n4, n5, n6, color, n2, dArray)) {
            return;
        }
        this.renderImageXform(sunGraphics2D, image, affineTransform, n2, n3, n4, n5, n6, color);
    }

    protected boolean tryCopyOrScale(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, int n4, int n5, Color color, int n6, double[] dArray) {
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2] - d2;
        double d5 = dArray[3] - d3;
        if (DrawImage.closeToInteger(n4 - n2, d4) && DrawImage.closeToInteger(n5 - n3, d5)) {
            int n7 = (int)Math.floor(d2 + 0.5);
            int n8 = (int)Math.floor(d3 + 0.5);
            if (n6 == 1 || DrawImage.closeToInteger(n7, d2) && DrawImage.closeToInteger(n8, d3)) {
                this.renderImageCopy(sunGraphics2D, image, color, n7, n8, n2, n3, n4 - n2, n5 - n3);
                return true;
            }
        }
        return d4 > 0.0 && d5 > 0.0 && this.renderImageScale(sunGraphics2D, image, color, n6, n2, n3, n4, n5, dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderImageXform(SunGraphics2D sunGraphics2D, Image image, AffineTransform affineTransform, int n2, int n3, int n4, int n5, int n6, Color color) {
        Object object;
        Object object2;
        Transparency transparency;
        Transparency transparency2 = this.getBufferedImage(image);
        int n7 = ((BufferedImage)transparency2).getWidth();
        int n8 = ((BufferedImage)transparency2).getHeight();
        if ((n3 | n4) != 0 || n5 < n7 || n6 < n8) {
            n5 -= n3;
            n6 -= n4;
            n3 += ((BufferedImage)transparency2).getMinX();
            n4 += ((BufferedImage)transparency2).getMinY();
            transparency2 = ((BufferedImage)transparency2).getSubimage(n3, n4, n5, n6);
            n7 = n5;
            n8 = n6;
        }
        Region region = sunGraphics2D.getCompClip();
        if (n2 != 1 && ((BufferedImage)transparency2).getColorModel() instanceof IndexColorModel) {
            transparency = new BufferedImage(n7, n8, 3);
            object2 = ((BufferedImage)transparency).createGraphics();
            try {
                ((Graphics2D)object2).setComposite(AlphaComposite.Src);
                ((Graphics)object2).drawImage((Image)((Object)transparency2), 0, 0, null);
            }
            finally {
                ((Graphics)object2).dispose();
            }
            transparency2 = transparency;
        }
        transparency = this.getTransformColorModel(sunGraphics2D, (BufferedImage)transparency2, affineTransform);
        try {
            object2 = new AffineTransformOp(affineTransform, n2);
        }
        catch (ImagingOpException imagingOpException) {
            return;
        }
        Rectangle rectangle = ((AffineTransformOp)object2).getBounds2D((BufferedImage)transparency2).getBounds();
        region = region.getBoundsIntersection(rectangle);
        if (region.isEmpty()) {
            return;
        }
        int n9 = region.getLoX();
        int n10 = region.getLoY();
        n7 = region.getWidth();
        n8 = region.getHeight();
        if ((n9 | n10) != 0) {
            object = AffineTransform.getTranslateInstance(-n9, -n10);
            ((AffineTransform)object).concatenate(affineTransform);
            try {
                object2 = new AffineTransformOp((AffineTransform)object, n2);
            }
            catch (ImagingOpException imagingOpException) {
                return;
            }
        }
        if ((transparency2 = ((AffineTransformOp)object2).filter((BufferedImage)transparency2, (BufferedImage)(object = transparency == ((BufferedImage)transparency2).getColorModel() ? new BufferedImage((ColorModel)transparency, ((BufferedImage)transparency2).getRaster().createCompatibleWritableRaster(n7, n8), ((ColorModel)transparency).isAlphaPremultiplied(), null) : new BufferedImage((ColorModel)transparency, ((ColorModel)transparency).createCompatibleWritableRaster(n7, n8), ((ColorModel)transparency).isAlphaPremultiplied(), null)))) == null) {
            return;
        }
        this.renderImageCopy(sunGraphics2D, (Image)((Object)transparency2), color, region.getLoX(), region.getLoY(), 0, 0, region.getWidth(), region.getHeight());
    }

    protected boolean renderImageCopy(SunGraphics2D sunGraphics2D, Image image, Color color, int n2, int n3, int n4, int n5, int n6, int n7) {
        Region region = sunGraphics2D.getCompClip();
        SurfaceData surfaceData = SurfaceData.getSourceSurfaceData(image, sunGraphics2D.surfaceData, sunGraphics2D.imageComp, color, false);
        if (surfaceData == null) {
            return false;
        }
        int n8 = 0;
        while (true) {
            try {
                SurfaceType surfaceType = surfaceData.getSurfaceType();
                SurfaceType surfaceType2 = sunGraphics2D.surfaceData.getSurfaceType();
                this.blitSurfaceData(sunGraphics2D, region, surfaceData, sunGraphics2D.surfaceData, surfaceType, surfaceType2, n4, n5, n2, n3, n6, n7, color);
                return true;
            }
            catch (NullPointerException nullPointerException) {
                if (!SurfaceData.isNull(sunGraphics2D.surfaceData) && !SurfaceData.isNull(surfaceData)) {
                    throw nullPointerException;
                }
                return false;
            }
            catch (InvalidPipeException invalidPipeException) {
                surfaceData = surfaceData.getReplacement();
                region = sunGraphics2D.getCompClip();
                if (!SurfaceData.isNull(sunGraphics2D.surfaceData) && !SurfaceData.isNull(surfaceData) && ++n8 <= 1) continue;
                return false;
            }
            break;
        }
    }

    protected boolean renderImageScale(SunGraphics2D sunGraphics2D, Image image, Color color, int n2, int n3, int n4, int n5, int n6, double d2, double d3, double d4, double d5) {
        if (n2 != 1) {
            return false;
        }
        Region region = sunGraphics2D.getCompClip();
        SurfaceData surfaceData = SurfaceData.getSourceSurfaceData(image, sunGraphics2D.surfaceData, sunGraphics2D.imageComp, color, true);
        if (surfaceData == null || DrawImage.isBgOperation(surfaceData, color)) {
            return false;
        }
        int n7 = 0;
        while (true) {
            try {
                SurfaceType surfaceType = surfaceData.getSurfaceType();
                SurfaceType surfaceType2 = sunGraphics2D.surfaceData.getSurfaceType();
                return this.scaleSurfaceData(sunGraphics2D, region, surfaceData, sunGraphics2D.surfaceData, surfaceType, surfaceType2, n3, n4, n5, n6, d2, d3, d4, d5);
            }
            catch (NullPointerException nullPointerException) {
                if (!SurfaceData.isNull(sunGraphics2D.surfaceData)) {
                    throw nullPointerException;
                }
                return false;
            }
            catch (InvalidPipeException invalidPipeException) {
                surfaceData = surfaceData.getReplacement();
                region = sunGraphics2D.getCompClip();
                if (!SurfaceData.isNull(sunGraphics2D.surfaceData) && !SurfaceData.isNull(surfaceData) && ++n7 <= 1) continue;
                return false;
            }
            break;
        }
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color) {
        double d2;
        double d3;
        double d4;
        double d5;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (n8 > n6) {
            n17 = n8 - n6;
            n16 = n6;
        } else {
            bl2 = true;
            n17 = n6 - n8;
            n16 = n8;
        }
        if (n9 > n7) {
            n15 = n9 - n7;
            n14 = n7;
        } else {
            bl3 = true;
            n15 = n7 - n9;
            n14 = n9;
        }
        if (n4 > n2) {
            n13 = n4 - n2;
            n12 = n2;
        } else {
            n13 = n2 - n4;
            bl4 = true;
            n12 = n4;
        }
        if (n5 > n3) {
            n11 = n5 - n3;
            n10 = n3;
        } else {
            n11 = n3 - n5;
            bl5 = true;
            n10 = n5;
        }
        if (n17 <= 0 || n15 <= 0) {
            return true;
        }
        if (bl2 == bl4 && bl3 == bl5 && DrawImage.isSimpleTranslate(sunGraphics2D) && this.renderImageScale(sunGraphics2D, image, color, sunGraphics2D.interpolationType, n16, n14, n16 + n17, n14 + n15, d5 = (double)(n12 + sunGraphics2D.transX), d4 = (double)(n10 + sunGraphics2D.transY), d3 = d5 + (double)n13, d2 = d4 + (double)n11)) {
            return true;
        }
        AffineTransform affineTransform = new AffineTransform(sunGraphics2D.transform);
        affineTransform.translate(n2, n3);
        double d6 = (double)(n4 - n2) / (double)(n8 - n6);
        double d7 = (double)(n5 - n3) / (double)(n9 - n7);
        affineTransform.scale(d6, d7);
        affineTransform.translate(n16 - n6, n14 - n7);
        int n18 = image.getWidth(null);
        int n19 = image.getHeight(null);
        n15 += n14;
        if ((n17 += n16) > n18) {
            n17 = n18;
        }
        if (n15 > n19) {
            n15 = n19;
        }
        if (n16 < 0) {
            affineTransform.translate(-n16, 0.0);
            n16 = 0;
        }
        if (n14 < 0) {
            affineTransform.translate(0.0, -n14);
            n14 = 0;
        }
        if (n16 >= n17 || n14 >= n15) {
            return true;
        }
        this.transformImage(sunGraphics2D, image, affineTransform, sunGraphics2D.interpolationType, n16, n14, n17, n15, color);
        return true;
    }

    public static boolean closeToInteger(int n2, double d2) {
        return Math.abs(d2 - (double)n2) < 1.0E-4;
    }

    public static boolean isSimpleTranslate(SunGraphics2D sunGraphics2D) {
        int n2 = sunGraphics2D.transformState;
        if (n2 <= 1) {
            return true;
        }
        if (n2 >= 3) {
            return false;
        }
        return sunGraphics2D.interpolationType == 1;
    }

    protected static boolean isBgOperation(SurfaceData surfaceData, Color color) {
        return surfaceData == null || color != null && surfaceData.getTransparency() != 1;
    }

    protected BufferedImage getBufferedImage(Image image) {
        if (image instanceof RemoteOffScreenImage) {
            return ((RemoteOffScreenImage)image).getSnapshot();
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        return ((VolatileImage)image).getSnapshot();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ColorModel getTransformColorModel(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, AffineTransform affineTransform) {
        Object object;
        boolean bl2;
        ColorModel colorModel;
        ColorModel colorModel2 = colorModel = bufferedImage.getColorModel();
        if (affineTransform.isIdentity()) {
            return colorModel2;
        }
        int n2 = affineTransform.getType();
        boolean bl3 = bl2 = (n2 & (0x18 | 0x20)) != 0;
        if (!bl2) {
            if (n2 != 1) {
                if (n2 != 0) {
                    object = new double[4];
                    affineTransform.getMatrix((double[])object);
                    boolean bl4 = bl2 = object[0] != (double)((int)object[0]) || object[3] != (double)((int)object[3]);
                }
            }
        }
        if (sunGraphics2D.renderHint != 2) {
            if (colorModel instanceof IndexColorModel) {
                object = bufferedImage.getRaster();
                IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                if (!bl2) return colorModel2;
                if (colorModel.getTransparency() != 1) return colorModel2;
                if (object instanceof BytePackedRaster) {
                    return ColorModel.getRGBdefault();
                }
                double[] dArray = new double[6];
                affineTransform.getMatrix(dArray);
                if (dArray[1] == 0.0 && dArray[2] == 0.0 && dArray[4] == 0.0 && dArray[5] == 0.0) return colorModel2;
                int n3 = indexColorModel.getMapSize();
                if (n3 >= 256) return ColorModel.getRGBdefault();
                int[] nArray = new int[n3 + 1];
                indexColorModel.getRGBs(nArray);
                nArray[n3] = 0;
                return new IndexColorModel(indexColorModel.getPixelSize(), n3 + 1, nArray, 0, true, n3, 0);
            }
            if (!bl2) return colorModel2;
            if (colorModel.getTransparency() != 1) return colorModel2;
            return ColorModel.getRGBdefault();
        }
        if (colorModel instanceof IndexColorModel) return ColorModel.getRGBdefault();
        if (!bl2) return colorModel2;
        if (colorModel.getTransparency() != 1) return colorModel2;
        return ColorModel.getRGBdefault();
    }

    protected void blitSurfaceData(SunGraphics2D sunGraphics2D, Region region, SurfaceData surfaceData, SurfaceData surfaceData2, SurfaceType surfaceType, SurfaceType surfaceType2, int n2, int n3, int n4, int n5, int n6, int n7, Color color) {
        if (n6 <= 0 || n7 <= 0) {
            return;
        }
        CompositeType compositeType = sunGraphics2D.imageComp;
        if (CompositeType.SrcOverNoEa.equals(compositeType) && (surfaceData.getTransparency() == 1 || color != null && color.getTransparency() == 1)) {
            compositeType = CompositeType.SrcNoEa;
        }
        if (!DrawImage.isBgOperation(surfaceData, color)) {
            Blit blit = Blit.getFromCache(surfaceType, compositeType, surfaceType2);
            blit.Blit(surfaceData, surfaceData2, sunGraphics2D.composite, region, n2, n3, n4, n5, n6, n7);
        } else {
            BlitBg blitBg = BlitBg.getFromCache(surfaceType, compositeType, surfaceType2);
            blitBg.BlitBg(surfaceData, surfaceData2, sunGraphics2D.composite, region, color, n2, n3, n4, n5, n6, n7);
        }
    }

    protected boolean scaleSurfaceData(SunGraphics2D sunGraphics2D, Region region, SurfaceData surfaceData, SurfaceData surfaceData2, SurfaceType surfaceType, SurfaceType surfaceType2, int n2, int n3, int n4, int n5, double d2, double d3, double d4, double d5) {
        ScaledBlit scaledBlit;
        CompositeType compositeType = sunGraphics2D.imageComp;
        if (CompositeType.SrcOverNoEa.equals(compositeType) && surfaceData.getTransparency() == 1) {
            compositeType = CompositeType.SrcNoEa;
        }
        if ((scaledBlit = ScaledBlit.getFromCache(surfaceType, compositeType, surfaceType2)) != null) {
            scaledBlit.Scale(surfaceData, surfaceData2, sunGraphics2D.composite, region, n2, n3, n4, n5, d2, d3, d4, d5);
            return true;
        }
        return false;
    }

    protected static boolean imageReady(ToolkitImage toolkitImage, ImageObserver imageObserver) {
        if (toolkitImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(toolkitImage, 192, -1, -1, -1, -1);
            }
            return false;
        }
        return true;
    }

    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        if (!(image instanceof ToolkitImage)) {
            return this.copyImage(sunGraphics2D, image, n2, n3, color);
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        if (!DrawImage.imageReady(toolkitImage, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = toolkitImage.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, toolkitImage, n2, n3, color, imageObserver);
    }

    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, int n4, int n5, int n6, int n7, Color color, ImageObserver imageObserver) {
        if (!(image instanceof ToolkitImage)) {
            return this.copyImage(sunGraphics2D, image, n2, n3, n4, n5, n6, n7, color);
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        if (!DrawImage.imageReady(toolkitImage, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = toolkitImage.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, toolkitImage, n2, n3, n2 + n6, n3 + n7, n4, n5, n4 + n6, n5 + n7, color, imageObserver);
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        if (!(image instanceof ToolkitImage)) {
            return this.scaleImage(sunGraphics2D, image, n2, n3, n4, n5, color);
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        if (!DrawImage.imageReady(toolkitImage, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = toolkitImage.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, toolkitImage, n2, n3, n4, n5, color, imageObserver);
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        if (!(image instanceof ToolkitImage)) {
            return this.scaleImage(sunGraphics2D, image, n2, n3, n4, n5, n6, n7, n8, n9, color);
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        if (!DrawImage.imageReady(toolkitImage, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = toolkitImage.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, toolkitImage, n2, n3, n4, n5, n6, n7, n8, n9, color, imageObserver);
    }

    public boolean transformImage(SunGraphics2D sunGraphics2D, Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        if (!(image instanceof ToolkitImage)) {
            this.transformImage(sunGraphics2D, image, 0, 0, affineTransform, sunGraphics2D.interpolationType);
            return true;
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        if (!DrawImage.imageReady(toolkitImage, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = toolkitImage.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, toolkitImage, affineTransform, imageObserver);
    }

    public void transformImage(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
        if (bufferedImageOp != null) {
            if (bufferedImageOp instanceof AffineTransformOp) {
                AffineTransformOp affineTransformOp = (AffineTransformOp)bufferedImageOp;
                this.transformImage(sunGraphics2D, bufferedImage, n2, n3, affineTransformOp.getTransform(), affineTransformOp.getInterpolationType());
                return;
            }
            bufferedImage = bufferedImageOp.filter(bufferedImage, null);
        }
        this.copyImage(sunGraphics2D, bufferedImage, n2, n3, null);
    }
}

