/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import sun.dc.path.PathConsumer;
import sun.dc.path.PathException;
import sun.dc.pr.PRException;
import sun.dc.pr.PathDasher;
import sun.dc.pr.PathStroker;
import sun.dc.pr.Rasterizer;

public class DuctusRenderer {
    public static final float PenUnits = 0.01f;
    public static final int MinPenUnits = 100;
    public static final int MinPenUnitsAA = 20;
    public static final float MinPenSizeAA = 0.19999999f;
    static final int[] RasterizerCaps = new int[]{30, 10, 20};
    static final int[] RasterizerCorners = new int[]{50, 10, 40};
    private static Rasterizer theRasterizer;
    private static byte[] theTile;
    static final float UPPER_BND = 1.7014117E38f;
    static final float LOWER_BND = -1.7014117E38f;

    public static synchronized Rasterizer getRasterizer() {
        Rasterizer rasterizer = theRasterizer;
        if (rasterizer == null) {
            rasterizer = new Rasterizer();
        } else {
            theRasterizer = null;
        }
        return rasterizer;
    }

    public static synchronized void dropRasterizer(Rasterizer rasterizer) {
        rasterizer.reset();
        theRasterizer = rasterizer;
    }

    public static synchronized byte[] getAlphaTile() {
        byte[] byArray = theTile;
        if (byArray == null) {
            int n2 = Rasterizer.TILE_SIZE;
            byArray = new byte[n2 * n2];
        } else {
            theTile = null;
        }
        return byArray;
    }

    public static synchronized void dropAlphaTile(byte[] byArray) {
        theTile = byArray;
    }

    public static synchronized void getAlpha(Rasterizer rasterizer, byte[] byArray, int n2, int n3, int n4) throws PRException {
        try {
            rasterizer.writeAlpha(byArray, n2, n3, n4);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static PathConsumer createStroker(PathConsumer pathConsumer, BasicStroke basicStroke, boolean bl2, AffineTransform affineTransform) {
        PathStroker pathStroker = new PathStroker(pathConsumer);
        pathConsumer = pathStroker;
        float[] fArray = null;
        if (!bl2) {
            pathStroker.setPenDiameter(basicStroke.getLineWidth());
            if (affineTransform != null) {
                fArray = DuctusRenderer.getTransformMatrix(affineTransform);
            }
            pathStroker.setPenT4(fArray);
            pathStroker.setPenFitting(0.01f, 100);
        }
        pathStroker.setCaps(RasterizerCaps[basicStroke.getEndCap()]);
        pathStroker.setCorners(RasterizerCorners[basicStroke.getLineJoin()], basicStroke.getMiterLimit());
        float[] fArray2 = basicStroke.getDashArray();
        if (fArray2 != null) {
            PathDasher pathDasher = new PathDasher(pathStroker);
            pathDasher.setDash(fArray2, basicStroke.getDashPhase());
            if (affineTransform != null && fArray == null) {
                fArray = DuctusRenderer.getTransformMatrix(affineTransform);
            }
            pathDasher.setDashT4(fArray);
            pathConsumer = pathDasher;
        }
        return pathConsumer;
    }

    static float[] getTransformMatrix(AffineTransform affineTransform) {
        float[] fArray = new float[4];
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        for (int i2 = 0; i2 < 4; ++i2) {
            fArray[i2] = (float)dArray[i2];
        }
        return fArray;
    }

    public static void disposeStroker(PathConsumer pathConsumer, PathConsumer pathConsumer2) {
        while (pathConsumer != null && pathConsumer != pathConsumer2) {
            PathConsumer pathConsumer3 = pathConsumer.getConsumer();
            pathConsumer.dispose();
            pathConsumer = pathConsumer3;
        }
    }

    public static void feedConsumer(PathIterator pathIterator, PathConsumer pathConsumer, boolean bl2, float f2) throws PathException {
        pathConsumer.beginPath();
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float[] fArray = new float[6];
        float f5 = 0.5f - f2;
        float f6 = 0.0f;
        float f7 = 0.0f;
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(fArray);
            if (bl3) {
                bl3 = false;
                if (n2 != 0) {
                    pathConsumer.beginSubpath(f3, f4);
                    bl5 = true;
                }
            }
            if (bl2) {
                int n3;
                switch (n2) {
                    case 3: {
                        n3 = 4;
                        break;
                    }
                    case 2: {
                        n3 = 2;
                        break;
                    }
                    case 0: 
                    case 1: {
                        n3 = 0;
                        break;
                    }
                    default: {
                        n3 = -1;
                    }
                }
                if (n3 >= 0) {
                    float f8 = fArray[n3];
                    float f9 = fArray[n3 + 1];
                    float f10 = (float)Math.floor(f8 + f5) + f2;
                    float f11 = (float)Math.floor(f9 + f5) + f2;
                    fArray[n3] = f10;
                    fArray[n3 + 1] = f11;
                    f10 -= f8;
                    f11 -= f9;
                    switch (n2) {
                        case 3: {
                            fArray[0] = fArray[0] + f6;
                            fArray[1] = fArray[1] + f7;
                            fArray[2] = fArray[2] + f10;
                            fArray[3] = fArray[3] + f11;
                            break;
                        }
                        case 2: {
                            fArray[0] = fArray[0] + (f10 + f6) / 2.0f;
                            fArray[1] = fArray[1] + (f11 + f7) / 2.0f;
                            break;
                        }
                    }
                    f6 = f10;
                    f7 = f11;
                }
            }
            switch (n2) {
                case 0: {
                    if (fArray[0] < 1.7014117E38f && fArray[0] > -1.7014117E38f && fArray[1] < 1.7014117E38f && fArray[1] > -1.7014117E38f) {
                        f3 = fArray[0];
                        f4 = fArray[1];
                        pathConsumer.beginSubpath(f3, f4);
                        bl5 = true;
                        bl4 = false;
                        break;
                    }
                    bl4 = true;
                    break;
                }
                case 1: {
                    if (!(fArray[0] < 1.7014117E38f) || !(fArray[0] > -1.7014117E38f) || !(fArray[1] < 1.7014117E38f) || !(fArray[1] > -1.7014117E38f)) break;
                    if (bl4) {
                        pathConsumer.beginSubpath(fArray[0], fArray[1]);
                        bl5 = true;
                        bl4 = false;
                        break;
                    }
                    pathConsumer.appendLine(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    if (!(fArray[2] < 1.7014117E38f) || !(fArray[2] > -1.7014117E38f) || !(fArray[3] < 1.7014117E38f) || !(fArray[3] > -1.7014117E38f)) break;
                    if (bl4) {
                        pathConsumer.beginSubpath(fArray[2], fArray[3]);
                        bl5 = true;
                        bl4 = false;
                        break;
                    }
                    if (fArray[0] < 1.7014117E38f && fArray[0] > -1.7014117E38f && fArray[1] < 1.7014117E38f && fArray[1] > -1.7014117E38f) {
                        pathConsumer.appendQuadratic(fArray[0], fArray[1], fArray[2], fArray[3]);
                        break;
                    }
                    pathConsumer.appendLine(fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    if (!(fArray[4] < 1.7014117E38f) || !(fArray[4] > -1.7014117E38f) || !(fArray[5] < 1.7014117E38f) || !(fArray[5] > -1.7014117E38f)) break;
                    if (bl4) {
                        pathConsumer.beginSubpath(fArray[4], fArray[5]);
                        bl5 = true;
                        bl4 = false;
                        break;
                    }
                    if (fArray[0] < 1.7014117E38f && fArray[0] > -1.7014117E38f && fArray[1] < 1.7014117E38f && fArray[1] > -1.7014117E38f && fArray[2] < 1.7014117E38f && fArray[2] > -1.7014117E38f && fArray[3] < 1.7014117E38f && fArray[3] > -1.7014117E38f) {
                        pathConsumer.appendCubic(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        break;
                    }
                    pathConsumer.appendLine(fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    if (!bl5) break;
                    pathConsumer.closedSubpath();
                    bl5 = false;
                    bl3 = true;
                }
            }
            pathIterator.next();
        }
        pathConsumer.endPath();
    }

    public static Rasterizer createShapeRasterizer(PathIterator pathIterator, AffineTransform affineTransform, BasicStroke basicStroke, boolean bl2, boolean bl3, float f2) {
        Rasterizer rasterizer = DuctusRenderer.getRasterizer();
        if (basicStroke != null) {
            float[] fArray = null;
            rasterizer.setUsage(3);
            if (bl2) {
                rasterizer.setPenDiameter(0.19999999f);
            } else {
                rasterizer.setPenDiameter(basicStroke.getLineWidth());
                if (affineTransform != null) {
                    fArray = DuctusRenderer.getTransformMatrix(affineTransform);
                    rasterizer.setPenT4(fArray);
                }
                rasterizer.setPenFitting(0.01f, 20);
            }
            rasterizer.setCaps(RasterizerCaps[basicStroke.getEndCap()]);
            rasterizer.setCorners(RasterizerCorners[basicStroke.getLineJoin()], basicStroke.getMiterLimit());
            float[] fArray2 = basicStroke.getDashArray();
            if (fArray2 != null) {
                rasterizer.setDash(fArray2, basicStroke.getDashPhase());
                if (affineTransform != null && fArray == null) {
                    fArray = DuctusRenderer.getTransformMatrix(affineTransform);
                }
                rasterizer.setDashT4(fArray);
            }
        } else {
            rasterizer.setUsage(pathIterator.getWindingRule() == 0 ? 1 : 2);
        }
        rasterizer.beginPath();
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float[] fArray = new float[6];
        float f5 = 0.5f - f2;
        float f6 = 0.0f;
        float f7 = 0.0f;
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(fArray);
            if (bl4) {
                bl4 = false;
                if (n2 != 0) {
                    rasterizer.beginSubpath(f3, f4);
                    bl6 = true;
                }
            }
            if (bl3) {
                int n3;
                switch (n2) {
                    case 3: {
                        n3 = 4;
                        break;
                    }
                    case 2: {
                        n3 = 2;
                        break;
                    }
                    case 0: 
                    case 1: {
                        n3 = 0;
                        break;
                    }
                    default: {
                        n3 = -1;
                    }
                }
                if (n3 >= 0) {
                    float f8 = fArray[n3];
                    float f9 = fArray[n3 + 1];
                    float f10 = (float)Math.floor(f8 + f5) + f2;
                    float f11 = (float)Math.floor(f9 + f5) + f2;
                    fArray[n3] = f10;
                    fArray[n3 + 1] = f11;
                    f10 -= f8;
                    f11 -= f9;
                    switch (n2) {
                        case 3: {
                            fArray[0] = fArray[0] + f6;
                            fArray[1] = fArray[1] + f7;
                            fArray[2] = fArray[2] + f10;
                            fArray[3] = fArray[3] + f11;
                            break;
                        }
                        case 2: {
                            fArray[0] = fArray[0] + (f10 + f6) / 2.0f;
                            fArray[1] = fArray[1] + (f11 + f7) / 2.0f;
                            break;
                        }
                    }
                    f6 = f10;
                    f7 = f11;
                }
            }
            switch (n2) {
                case 0: {
                    if (fArray[0] < 1.7014117E38f && fArray[0] > -1.7014117E38f && fArray[1] < 1.7014117E38f && fArray[1] > -1.7014117E38f) {
                        f3 = fArray[0];
                        f4 = fArray[1];
                        rasterizer.beginSubpath(f3, f4);
                        bl6 = true;
                        bl5 = false;
                        break;
                    }
                    bl5 = true;
                    break;
                }
                case 1: {
                    if (!(fArray[0] < 1.7014117E38f) || !(fArray[0] > -1.7014117E38f) || !(fArray[1] < 1.7014117E38f) || !(fArray[1] > -1.7014117E38f)) break;
                    if (bl5) {
                        rasterizer.beginSubpath(fArray[0], fArray[1]);
                        bl6 = true;
                        bl5 = false;
                        break;
                    }
                    rasterizer.appendLine(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    if (!(fArray[2] < 1.7014117E38f) || !(fArray[2] > -1.7014117E38f) || !(fArray[3] < 1.7014117E38f) || !(fArray[3] > -1.7014117E38f)) break;
                    if (bl5) {
                        rasterizer.beginSubpath(fArray[2], fArray[3]);
                        bl6 = true;
                        bl5 = false;
                        break;
                    }
                    if (fArray[0] < 1.7014117E38f && fArray[0] > -1.7014117E38f && fArray[1] < 1.7014117E38f && fArray[1] > -1.7014117E38f) {
                        rasterizer.appendQuadratic(fArray[0], fArray[1], fArray[2], fArray[3]);
                        break;
                    }
                    rasterizer.appendLine(fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    if (!(fArray[4] < 1.7014117E38f) || !(fArray[4] > -1.7014117E38f) || !(fArray[5] < 1.7014117E38f) || !(fArray[5] > -1.7014117E38f)) break;
                    if (bl5) {
                        rasterizer.beginSubpath(fArray[4], fArray[5]);
                        bl6 = true;
                        bl5 = false;
                        break;
                    }
                    if (fArray[0] < 1.7014117E38f && fArray[0] > -1.7014117E38f && fArray[1] < 1.7014117E38f && fArray[1] > -1.7014117E38f && fArray[2] < 1.7014117E38f && fArray[2] > -1.7014117E38f && fArray[3] < 1.7014117E38f && fArray[3] > -1.7014117E38f) {
                        rasterizer.appendCubic(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        break;
                    }
                    rasterizer.appendLine(fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    if (!bl6) break;
                    rasterizer.closedSubpath();
                    bl6 = false;
                    bl4 = true;
                }
            }
            pathIterator.next();
        }
        try {
            rasterizer.endPath();
        }
        catch (PRException pRException) {
            System.err.println("DuctusRenderer.createShapeRasterizer: " + pRException);
        }
        return rasterizer;
    }
}

