/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;
import sun.jdbc.odbc.JdbcOdbcStatement;

public class JdbcOdbcInputStream
extends InputStream {
    protected JdbcOdbc OdbcApi;
    protected long hStmt;
    protected int column;
    protected short type;
    public static final short ASCII = 1;
    public static final short UNICODE = 2;
    public static final short BINARY = 3;
    public static final short LOCAL = 4;
    public static final short CHARACTER = 5;
    protected byte[] localByteArray;
    protected int localOffset;
    protected boolean invalid;
    protected boolean highRead;
    protected int sqlType;
    protected byte[] buf;
    public static final int MAX_BUF_LEN = 5120;
    protected int convertType;
    public static final int CONVERT_NONE = 0;
    public static final int CONVERT_UNICODE = 1;
    public static final int CONVERT_ASCII = 2;
    public static final int CONVERT_BOTH = 3;
    protected int convertMultiplier;
    protected int bytesInBuf;
    protected int bufOffset;
    protected Statement ownerStatement;

    public JdbcOdbcInputStream(JdbcOdbc jdbcOdbc, long l2, int n2, short s2, int n3, Statement statement) {
        this.OdbcApi = jdbcOdbc;
        this.hStmt = l2;
        this.column = n2;
        this.type = s2;
        this.invalid = false;
        this.ownerStatement = statement;
        this.sqlType = -2;
        switch (n3) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                this.sqlType = 1;
            }
        }
        this.convertMultiplier = 1;
        this.convertType = 0;
        switch (this.type) {
            case 1: {
                if (this.sqlType != -2) break;
                this.convertMultiplier = 2;
                this.convertType = 2;
                break;
            }
            case 2: {
                if (this.sqlType == -2) {
                    this.convertType = 3;
                    this.convertMultiplier = 4;
                    break;
                }
                this.convertType = 1;
                this.convertMultiplier = 2;
                break;
            }
            case 5: {
                this.convertType = 0;
                this.convertMultiplier = 1;
            }
        }
        this.buf = new byte[5120 * this.convertMultiplier];
        this.bytesInBuf = 0;
        this.bufOffset = 0;
    }

    public JdbcOdbcInputStream(JdbcOdbc jdbcOdbc, long l2, int n2, byte[] byArray) {
        this.OdbcApi = jdbcOdbc;
        this.hStmt = l2;
        this.column = n2;
        this.type = (short)4;
        this.localByteArray = byArray;
        this.localOffset = 0;
        this.invalid = false;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray);
        if (n2 != -1) {
            n2 = byArray[0] & 0xFF;
        }
        return n2;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public byte[] readAllData() throws IOException {
        byte[] byArray;
        int n2 = 0;
        if (this.invalid) {
            throw new IOException("InputStream is no longer valid - the Statement has been closed, or the cursor has been moved");
        }
        switch (this.type) {
            case 4: {
                if (this.localOffset + n2 > this.localByteArray.length) {
                    n2 = this.localByteArray.length - this.localOffset;
                }
                byArray = new byte[this.localByteArray.length];
                if (n2 == 0) {
                    n2 = -1;
                    break;
                }
                System.arraycopy(this.localByteArray, this.localOffset, byArray, this.localOffset, n2);
                this.localOffset += n2;
                break;
            }
            default: {
                byArray = this.readData();
            }
        }
        return byArray;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return -1;
        }
        int n4 = 0;
        if (this.invalid) {
            throw new IOException("InputStream is no longer valid - the Statement has been closed, or the cursor has been moved");
        }
        switch (this.type) {
            case 4: {
                n4 = n3;
                if (this.localOffset + n4 > this.localByteArray.length) {
                    n4 = this.localByteArray.length - this.localOffset;
                }
                if (n4 == 0) {
                    n4 = -1;
                    break;
                }
                for (int i2 = n2; i2 < n4; ++i2) {
                    byArray[i2] = this.localByteArray[this.localOffset + i2];
                }
                this.localOffset += n4;
                break;
            }
            default: {
                n4 = this.readData(byArray, n2, n3);
            }
        }
        return n4;
    }

    public int available() throws IOException {
        throw new IOException();
    }

    public void invalidate() {
        this.invalid = true;
    }

    public byte[] readData() throws IOException {
        byte[] byArray = null;
        int n2 = 0;
        while (true) {
            this.bytesInBuf = this.readBinaryData(this.buf, 5120);
            this.bytesInBuf = this.convertData(this.buf, this.bytesInBuf);
            if (this.bytesInBuf == -1) {
                return byArray;
            }
            try {
                if (byArray == null) {
                    byArray = new byte[this.bytesInBuf];
                } else {
                    byte[] byArray2 = new byte[n2 + this.bytesInBuf];
                    System.arraycopy(byArray, 0, byArray2, 0, n2);
                    byArray = byArray2;
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                ((JdbcOdbcStatement)this.ownerStatement).setWarning(new SQLWarning("Data has been truncated. " + outOfMemoryError.getMessage()));
                return byArray;
            }
            System.arraycopy(this.buf, 0, byArray, n2, this.bytesInBuf);
            n2 += this.bytesInBuf;
        }
    }

    protected int readData(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = -1;
        int n5 = n2;
        while (this.bytesInBuf != -1 && n5 - n2 < n3) {
            if (this.bufOffset >= this.bytesInBuf) {
                this.bytesInBuf = this.readBinaryData(this.buf, 5120);
                this.bytesInBuf = this.convertData(this.buf, this.bytesInBuf);
                this.bufOffset = 0;
                continue;
            }
            byArray[n5] = this.buf[this.bufOffset];
            ++n5;
            ++this.bufOffset;
        }
        if (n5 > n2) {
            n4 = n5;
        }
        return n4;
    }

    protected int readBinaryData(byte[] byArray, int n2) throws IOException {
        int n3 = 0;
        try {
            n3 = this.OdbcApi.SQLGetDataBinary(this.hStmt, this.column, -2, byArray, n2);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            Integer n4 = (Integer)jdbcOdbcSQLWarning.value;
            n3 = n4;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
        return n3;
    }

    protected int convertData(byte[] byArray, int n2) {
        if (this.convertType == 0) {
            return n2;
        }
        String string = "0123456789ABCDEF";
        if (n2 <= 0) {
            return n2;
        }
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            if (this.convertType == 3) {
                byArray[i2 * 4 + 3] = (byte)string.charAt(byArray[i2] & 0xF);
                byArray[i2 * 4 + 2] = 0;
                byArray[i2 * 4 + 1] = (byte)string.charAt(byArray[i2] >> 4 & 0xF);
                byArray[i2 * 4] = 0;
                continue;
            }
            if (this.convertType == 2) {
                byArray[i2 * 2 + 1] = (byte)string.charAt(byArray[i2] & 0xF);
                byArray[i2 * 2] = (byte)string.charAt(byArray[i2] >> 4 & 0xF);
                continue;
            }
            byArray[i2 * 2 + 1] = byArray[i2];
            byArray[i2 * 2] = 0;
        }
        return n2 * this.convertMultiplier;
    }
}

