/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.text.CharTrie;
import sun.text.IntTrie;
import sun.text.Normalizer;
import sun.text.NormalizerDataReader;
import sun.text.Trie;

public final class NormalizerImpl {
    static final NormalizerImpl IMPL;
    static final int UNSIGNED_BYTE_MASK = 255;
    static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;
    private static final String DATA_FILE_NAME = "resources/unorm.icu";
    static final int QC_NFC = 17;
    static final int QC_NFKC = 34;
    static final int QC_NFD = 4;
    static final int QC_NFKD = 8;
    static final int QC_MASK = 63;
    private static final int QC_ANY_NO = 15;
    private static final int COMBINES_FWD = 64;
    private static final int COMBINES_BACK = 128;
    private static final int COMBINES_ANY = 192;
    private static final int CC_SHIFT = 8;
    static final int CC_MASK = 65280;
    private static final int EXTRA_SHIFT = 16;
    private static final long MIN_SPECIAL = 0xFC000000L;
    private static final long SURROGATES_TOP = 0xFFF00000L;
    private static final long MIN_HANGUL = 0xFFF00000L;
    private static final long JAMO_V_TOP = 0xFFF30000L;
    private static final int INDEX_TRIE_SIZE = 0;
    private static final int INDEX_CHAR_COUNT = 1;
    private static final int INDEX_COMBINE_DATA_COUNT = 2;
    private static final int INDEX_COMBINE_FWD_COUNT = 3;
    private static final int INDEX_COMBINE_BOTH_COUNT = 4;
    private static final int INDEX_COMBINE_BACK_COUNT = 5;
    static final int INDEX_MIN_NFC_NO_MAYBE = 6;
    static final int INDEX_MIN_NFKC_NO_MAYBE = 7;
    static final int INDEX_MIN_NFD_NO_MAYBE = 8;
    static final int INDEX_MIN_NFKD_NO_MAYBE = 9;
    private static final int INDEX_FCD_TRIE_SIZE = 10;
    private static final int INDEX_AUX_TRIE_SIZE = 11;
    private static final int INDEX_CANON_SET_COUNT = 12;
    private static final int INDEX_TOP = 32;
    private static final int MAX_BUFFER_SIZE = 20;
    private static FCDTrieImpl fcdTrieImpl;
    private static NormTrieImpl normTrieImpl;
    private static int[] indexes;
    private static char[] combiningTable;
    private static char[] extraData;
    private static boolean isDataLoaded;
    private static final int DATA_BUFFER_SIZE = 25000;
    static final int MIN_WITH_LEAD_CC = 768;
    private static final int DECOMP_FLAG_LENGTH_HAS_CC = 128;
    private static final int DECOMP_LENGTH_MASK = 127;
    private static final int BMP_INDEX_LENGTH = 2048;
    private static final int SURROGATE_BLOCK_BITS = 5;
    private static final int JAMO_L_BASE = 4352;
    private static final int JAMO_V_BASE = 4449;
    private static final int JAMO_T_BASE = 4519;
    private static final int HANGUL_BASE = 44032;
    private static final int JAMO_L_COUNT = 19;
    private static final int JAMO_V_COUNT = 21;
    private static final int JAMO_T_COUNT = 28;
    private static final int HANGUL_COUNT = 11172;

    static int getFromIndexesArr(int n2) {
        return indexes[n2];
    }

    private NormalizerImpl() throws Exception {
        Object t2;
        if (!isDataLoaded && (t2 = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    InputStream inputStream = this.getClass().getResourceAsStream(NormalizerImpl.DATA_FILE_NAME);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 25000);
                    NormalizerDataReader normalizerDataReader = new NormalizerDataReader(bufferedInputStream);
                    NormalizerImpl.access$002(normalizerDataReader.readIndexes(32));
                    byte[] byArray = new byte[indexes[0]];
                    int n2 = indexes[2];
                    NormalizerImpl.access$102(new char[n2]);
                    int n3 = indexes[1];
                    NormalizerImpl.access$202(new char[n3]);
                    byte[] byArray2 = new byte[indexes[10]];
                    fcdTrieImpl = new FCDTrieImpl();
                    NormalizerImpl.normTrieImpl = new NormTrieImpl();
                    normalizerDataReader.read(byArray, byArray2, null, extraData, combiningTable, null);
                    NormTrieImpl.normTrie = new IntTrie(new ByteArrayInputStream(byArray), normTrieImpl);
                    FCDTrieImpl.fcdTrie = new CharTrie(new ByteArrayInputStream(byArray2), fcdTrieImpl);
                    isDataLoaded = true;
                    bufferedInputStream.close();
                    inputStream.close();
                    return null;
                }
                catch (Exception exception) {
                    return exception;
                }
            }
        })) instanceof Exception) {
            throw (Exception)t2;
        }
    }

    private static boolean isHangulWithoutJamoT(char c2) {
        return (c2 = (char)(c2 - 44032)) < '\u2ba4' && c2 % 28 == 0;
    }

    private static boolean isNorm32Regular(long l2) {
        return l2 < 0xFC000000L;
    }

    private static boolean isNorm32LeadSurrogate(long l2) {
        return 0xFC000000L <= l2 && l2 < 0xFFF00000L;
    }

    static boolean isNorm32HangulOrJamo(long l2) {
        return l2 >= 0xFFF00000L;
    }

    private static boolean isJamoVTNorm32JamoV(long l2) {
        return l2 < 0xFFF30000L;
    }

    static long getNorm32(char c2) {
        return 0xFFFFFFFFL & (long)NormTrieImpl.normTrie.getLeadValue(c2);
    }

    static long getNorm32FromSurrogatePair(long l2, char c2) {
        return 0xFFFFFFFFL & (long)NormTrieImpl.normTrie.getTrailValue((int)l2, c2);
    }

    private static long getNorm32(int n2) {
        return 0xFFFFFFFFL & (long)NormTrieImpl.normTrie.getCodePointValue(n2);
    }

    private static long getNorm32(char[] cArray, int n2, int n3) {
        long l2 = NormalizerImpl.getNorm32(cArray[n2]);
        if ((l2 & (long)n3) > 0L && NormalizerImpl.isNorm32LeadSurrogate(l2)) {
            l2 = NormalizerImpl.getNorm32FromSurrogatePair(l2, cArray[n2 + 1]);
        }
        return l2;
    }

    public static char getFCD16(char c2) {
        return FCDTrieImpl.fcdTrie.getLeadValue(c2);
    }

    public static char getFCD16FromSurrogatePair(char c2, char c3) {
        return FCDTrieImpl.fcdTrie.getTrailValue(c2, c3);
    }

    private static int getExtraDataIndex(long l2) {
        return (int)(l2 >> 16);
    }

    private static int decompose(long l2, int n2, DecomposeArgs decomposeArgs) {
        int n3 = NormalizerImpl.getExtraDataIndex(l2);
        decomposeArgs.length = extraData[n3++];
        if ((l2 & (long)n2 & 8L) != 0L && decomposeArgs.length >= 256) {
            n3 += (decomposeArgs.length >> 7 & 1) + (decomposeArgs.length & 0x7F);
            decomposeArgs.length >>= 8;
        }
        if ((decomposeArgs.length & 0x80) > 0) {
            char c2 = extraData[n3++];
            decomposeArgs.cc = 0xFF & c2 >> 8;
            decomposeArgs.trailCC = 0xFF & c2;
        } else {
            decomposeArgs.trailCC = 0;
            decomposeArgs.cc = 0;
        }
        decomposeArgs.length &= 0x7F;
        return n3;
    }

    private static int decompose(long l2, DecomposeArgs decomposeArgs) {
        int n2 = NormalizerImpl.getExtraDataIndex(l2);
        decomposeArgs.length = extraData[n2++];
        if ((decomposeArgs.length & 0x80) > 0) {
            char c2 = extraData[n2++];
            decomposeArgs.cc = 0xFF & c2 >> 8;
            decomposeArgs.trailCC = 0xFF & c2;
        } else {
            decomposeArgs.trailCC = 0;
            decomposeArgs.cc = 0;
        }
        decomposeArgs.length &= 0x7F;
        return n2;
    }

    private static int getNextCC(NextCCArgs nextCCArgs) {
        nextCCArgs.c = nextCCArgs.source[nextCCArgs.next++];
        long l2 = NormalizerImpl.getNorm32(nextCCArgs.c);
        if ((l2 & 0xFF00L) == 0L) {
            nextCCArgs.c2 = '\u0000';
            return 0;
        }
        if (!NormalizerImpl.isNorm32LeadSurrogate(l2)) {
            nextCCArgs.c2 = '\u0000';
        } else if (nextCCArgs.next != nextCCArgs.limit && Character.isLowSurrogate(nextCCArgs.c2 = nextCCArgs.source[nextCCArgs.next])) {
            ++nextCCArgs.next;
            l2 = NormalizerImpl.getNorm32FromSurrogatePair(l2, nextCCArgs.c2);
        } else {
            nextCCArgs.c2 = '\u0000';
            return 0;
        }
        return (int)(0xFFL & l2 >> 8);
    }

    private static long getPrevNorm32(PrevArgs prevArgs, int n2, int n3) {
        prevArgs.c = prevArgs.src[--prevArgs.current];
        prevArgs.c2 = '\u0000';
        if (prevArgs.c < n2) {
            return 0L;
        }
        if (prevArgs.c < '\ud800' || prevArgs.c > '\udfff') {
            return NormalizerImpl.getNorm32(prevArgs.c);
        }
        if (Character.isHighSurrogate(prevArgs.c)) {
            return 0L;
        }
        if (prevArgs.current != prevArgs.start && Character.isHighSurrogate(prevArgs.c2 = prevArgs.src[prevArgs.current - 1])) {
            --prevArgs.current;
            long l2 = NormalizerImpl.getNorm32(prevArgs.c2);
            if ((l2 & (long)n3) == 0L) {
                return 0L;
            }
            return NormalizerImpl.getNorm32FromSurrogatePair(l2, prevArgs.c);
        }
        prevArgs.c2 = '\u0000';
        return 0L;
    }

    private static int getPrevCC(PrevArgs prevArgs) {
        return (int)(0xFFL & NormalizerImpl.getPrevNorm32(prevArgs, 768, 65280) >> 8);
    }

    static boolean isNFDSafe(long l2, int n2, int n3) {
        if ((l2 & (long)n2) == 0L) {
            return true;
        }
        if (NormalizerImpl.isNorm32Regular(l2) && (l2 & (long)n3) != 0L) {
            DecomposeArgs decomposeArgs = new DecomposeArgs();
            NormalizerImpl.decompose(l2, n3, decomposeArgs);
            return decomposeArgs.cc == 0;
        }
        return (l2 & 0xFF00L) == 0L;
    }

    static boolean isTrueStarter(long l2, int n2, int n3) {
        if ((l2 & (long)n2) == 0L) {
            return true;
        }
        if ((l2 & (long)n3) != 0L) {
            int n4;
            DecomposeArgs decomposeArgs = new DecomposeArgs();
            int n5 = NormalizerImpl.decompose(l2, n3, decomposeArgs);
            if (decomposeArgs.cc == 0 && (NormalizerImpl.getNorm32(extraData, n5, n4 = n2 & 0x3F) & (long)n4) == 0L) {
                return true;
            }
        }
        return false;
    }

    private static int insertOrdered(char[] cArray, int n2, int n3, int n4, char c2, char c3, int n5) {
        int n6 = n5;
        if (n2 < n3 && n5 != 0) {
            int n7;
            int n8 = n7 = n3;
            PrevArgs prevArgs = new PrevArgs();
            prevArgs.current = n3;
            prevArgs.start = n2;
            prevArgs.src = cArray;
            int n9 = NormalizerImpl.getPrevCC(prevArgs);
            n8 = prevArgs.current;
            if (n5 < n9) {
                n6 = n9;
                n7 = n8;
                while (n2 < n8) {
                    n9 = NormalizerImpl.getPrevCC(prevArgs);
                    n8 = prevArgs.current;
                    if (n5 >= n9) break;
                    n7 = n8;
                }
                int n10 = n4;
                do {
                    cArray[--n10] = cArray[--n3];
                } while (n7 != n3);
            }
        }
        cArray[n3] = c2;
        if (c3 != '\u0000') {
            cArray[n3 + 1] = c3;
        }
        return n6;
    }

    private static int mergeOrdered(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, boolean bl2) {
        int n6 = 0;
        boolean bl3 = n3 == n4;
        NextCCArgs nextCCArgs = new NextCCArgs();
        nextCCArgs.source = cArray2;
        nextCCArgs.next = n4;
        nextCCArgs.limit = n5;
        if (n2 != n3 || !bl2) {
            while (nextCCArgs.next < nextCCArgs.limit) {
                int n7 = NormalizerImpl.getNextCC(nextCCArgs);
                if (n7 == 0) {
                    n6 = 0;
                    if (bl3) {
                        n3 = nextCCArgs.next;
                    } else {
                        cArray2[n3++] = nextCCArgs.c;
                        if (nextCCArgs.c2 != '\u0000') {
                            cArray2[n3++] = nextCCArgs.c2;
                        }
                    }
                    if (bl2) break;
                    n2 = n3;
                    continue;
                }
                int n8 = n3 + (nextCCArgs.c2 == '\u0000' ? 1 : 2);
                n6 = NormalizerImpl.insertOrdered(cArray, n2, n3, n8, nextCCArgs.c, nextCCArgs.c2, n7);
                n3 = n8;
            }
        }
        if (nextCCArgs.next == nextCCArgs.limit) {
            return n6;
        }
        if (!bl3) {
            do {
                cArray[n3++] = cArray2[nextCCArgs.next++];
            } while (nextCCArgs.next != nextCCArgs.limit);
            nextCCArgs.limit = n3;
        }
        PrevArgs prevArgs = new PrevArgs();
        prevArgs.src = cArray2;
        prevArgs.start = n2;
        prevArgs.current = nextCCArgs.limit;
        return NormalizerImpl.getPrevCC(prevArgs);
    }

    private static int mergeOrdered(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5) {
        return NormalizerImpl.mergeOrdered(cArray, n2, n3, cArray2, n4, n5, true);
    }

    static boolean checkFCD(char[] cArray, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = n2;
        int n7 = n3;
        while (n6 != n7) {
            char c2;
            int n8;
            if ((n8 = cArray[n6++]) < 768) {
                n5 = -n8;
                continue;
            }
            char c3 = NormalizerImpl.getFCD16((char)n8);
            if (c3 == '\u0000') {
                n5 = 0;
                continue;
            }
            if (Character.isHighSurrogate((char)n8)) {
                if (n6 != n7 && Character.isLowSurrogate(c2 = cArray[n6])) {
                    ++n6;
                    c3 = NormalizerImpl.getFCD16FromSurrogatePair(c3, c2);
                } else {
                    c2 = '\u0000';
                    c3 = '\u0000';
                }
            } else {
                c2 = '\u0000';
            }
            if (NormalizerImpl.nx_contains(n4, (char)n8, c2)) {
                n5 = 0;
                continue;
            }
            int n9 = c3 >> 8;
            if (n9 != 0) {
                if (n5 < 0) {
                    n5 = !NormalizerImpl.nx_contains(n4, -n5) ? FCDTrieImpl.fcdTrie.getBMPValue((char)(-n5)) & 0xFF : 0;
                }
                if (n9 < n5) {
                    return false;
                }
            }
            n5 = c3 & 0xFF;
        }
        return true;
    }

    static Normalizer.QuickCheckResult quickCheck(char[] cArray, int n2, int n3, int n4, int n5, boolean bl2, int n6) {
        Normalizer.QuickCheckResult quickCheckResult;
        block13: {
            ComposePartArgs composePartArgs = new ComposePartArgs();
            int n7 = n2;
            if (!isDataLoaded) {
                return Normalizer.MAYBE;
            }
            int n8 = 0xFF00 | n5;
            quickCheckResult = Normalizer.YES;
            char c2 = '\u0000';
            while (true) {
                char c3;
                char c4;
                long l2;
                char c5;
                if (n2 == n3) {
                    return quickCheckResult;
                }
                if ((c5 = cArray[n2++]) < n4 || ((l2 = NormalizerImpl.getNorm32(c5)) & (long)n8) == 0L) {
                    c2 = '\u0000';
                    continue;
                }
                if (NormalizerImpl.isNorm32LeadSurrogate(l2)) {
                    if (n2 != n3 && Character.isLowSurrogate(c4 = cArray[n2])) {
                        ++n2;
                        l2 = NormalizerImpl.getNorm32FromSurrogatePair(l2, c4);
                    } else {
                        l2 = 0L;
                        c4 = '\u0000';
                    }
                } else {
                    c4 = '\u0000';
                }
                if (NormalizerImpl.nx_contains(n6, c5, c4)) {
                    l2 = 0L;
                }
                if ((c3 = (char)(l2 >> 8 & 0xFFL)) != '\u0000' && c3 < c2) {
                    return Normalizer.NO;
                }
                c2 = c3;
                long l3 = l2 & (long)n5;
                if ((l3 & 0xFL) >= 1L) {
                    quickCheckResult = Normalizer.NO;
                    break block13;
                }
                if (l3 == 0L) continue;
                if (bl2) {
                    quickCheckResult = Normalizer.MAYBE;
                    continue;
                }
                int n9 = n5 << 2 & 0xF;
                int n10 = n2 - 1;
                if (Character.isLowSurrogate(cArray[n10])) {
                    --n10;
                }
                n10 = NormalizerImpl.findPreviousStarter(cArray, n7, n10, n8, n9, (char)n4);
                n2 = NormalizerImpl.findNextStarter(cArray, n2, n3, n5, n9, (char)n4);
                composePartArgs.prevCC = c2;
                char[] cArray2 = NormalizerImpl.composePart(composePartArgs, n10, cArray, n2, n3, n5, n6);
                if (0 != NormalizerImpl.strCompare(cArray2, 0, composePartArgs.length, cArray, n10, n2 - n10, false)) break;
            }
            quickCheckResult = Normalizer.NO;
        }
        return quickCheckResult;
    }

    private static boolean needSingleQuotation(char c2) {
        return c2 >= '\t' && c2 <= '\r' || c2 >= ' ' && c2 <= '/' || c2 >= ':' && c2 <= '@' || c2 >= '[' && c2 <= '`' || c2 >= '{' && c2 <= '~';
    }

    public static String canonicalDecomposeWithSingleQuotation(String string) {
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = cArray.length;
        Object object = new char[cArray.length * 3];
        int n4 = 0;
        int n5 = ((char[])object).length;
        char[] cArray2 = new char[3];
        int n6 = 4;
        char c2 = (char)indexes[8];
        int n7 = 0xFF00 | n6;
        int n8 = 0;
        int n9 = 0;
        long l2 = 0L;
        char c3 = '\u0000';
        int n10 = 0;
        int n11 = -1;
        int n12 = -1;
        while (true) {
            Object object2;
            char[] cArray3;
            char c4;
            int n13;
            int n14 = n2;
            while (n2 != n3 && ((c3 = cArray[n2]) < c2 || ((l2 = NormalizerImpl.getNorm32(c3)) & (long)n7) == 0L || c3 >= '\uac00' && c3 <= '\ud7a3')) {
                n9 = 0;
                ++n2;
            }
            if (n2 != n14) {
                n13 = n2 - n14;
                if (n4 + n13 <= n5) {
                    System.arraycopy(cArray, n14, object, n4, n13);
                }
                n8 = n4 += n13;
            }
            if (n2 == n3) break;
            ++n2;
            if (NormalizerImpl.isNorm32Regular(l2)) {
                c4 = '\u0000';
                n13 = 1;
            } else if (n2 != n3 && Character.isLowSurrogate(c4 = cArray[n2])) {
                ++n2;
                n13 = 2;
                l2 = NormalizerImpl.getNorm32FromSurrogatePair(l2, c4);
            } else {
                c4 = '\u0000';
                n13 = 1;
                l2 = 0L;
            }
            if ((l2 & (long)n6) == 0L) {
                n12 = n11 = (int)(0xFFL & l2 >> 8);
                cArray3 = null;
                n10 = -1;
            } else {
                object2 = new DecomposeArgs();
                n10 = NormalizerImpl.decompose(l2, n6, (DecomposeArgs)object2);
                cArray3 = extraData;
                n13 = ((DecomposeArgs)object2).length;
                n12 = ((DecomposeArgs)object2).cc;
                n11 = ((DecomposeArgs)object2).trailCC;
                if (n13 == 1) {
                    c3 = cArray3[n10];
                    c4 = '\u0000';
                    cArray3 = null;
                    n10 = -1;
                }
            }
            if (n4 + n13 * 3 >= n5) {
                object2 = new char[n5 * 2];
                System.arraycopy(object, 0, object2, 0, n4);
                object = object2;
                n5 = ((char[])object).length;
            }
            int n15 = n4;
            if (cArray3 == null) {
                if (NormalizerImpl.needSingleQuotation(c3)) {
                    object[n4++] = 39;
                    object[n4++] = c3;
                    object[n4++] = 39;
                    n11 = 0;
                } else if (n12 != 0 && n12 < n9) {
                    n11 = NormalizerImpl.insertOrdered(object, n8, n15, n4 += n13, c3, c4, n12);
                } else {
                    object[n4++] = c3;
                    if (c4 != '\u0000') {
                        object[n4++] = c4;
                    }
                }
            } else if (NormalizerImpl.needSingleQuotation(cArray3[n10])) {
                object[n4++] = 39;
                object[n4++] = cArray3[n10++];
                object[n4++] = 39;
                --n13;
                do {
                    object[n4++] = cArray3[n10++];
                } while (--n13 > 0);
            } else if (n12 != 0 && n12 < n9) {
                n4 += n13;
                n11 = NormalizerImpl.mergeOrdered(object, n8, n15, cArray3, n10, n10 + n13);
            } else {
                do {
                    object[n4++] = cArray3[n10++];
                } while (--n13 > 0);
            }
            if ((n9 = n11) != 0) continue;
            n8 = n4;
        }
        return new String((char[])object, 0, n4);
    }

    static int decompose(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, boolean bl2, int[] nArray, int n6) {
        int n7;
        char c2;
        char[] cArray3 = new char[3];
        if (!bl2) {
            c2 = (char)indexes[8];
            n7 = 4;
        } else {
            c2 = (char)indexes[9];
            n7 = 8;
        }
        int n8 = 0xFF00 | n7;
        int n9 = 0;
        int n10 = 0;
        long l2 = 0L;
        char c3 = '\u0000';
        int n11 = 0;
        int n12 = -1;
        int n13 = -1;
        while (true) {
            char[] cArray4;
            char c4;
            int n14;
            int n15 = n2;
            while (n2 != n3 && ((c3 = cArray[n2]) < c2 || ((l2 = NormalizerImpl.getNorm32(c3)) & (long)n8) == 0L)) {
                n10 = 0;
                ++n2;
            }
            if (n2 != n15) {
                n14 = n2 - n15;
                if (n4 + n14 <= n5) {
                    System.arraycopy(cArray, n15, cArray2, n4, n14);
                }
                n9 = n4 += n14;
            }
            if (n2 == n3) break;
            ++n2;
            if (NormalizerImpl.isNorm32HangulOrJamo(l2)) {
                if (NormalizerImpl.nx_contains(n6, c3)) {
                    c4 = '\u0000';
                    cArray4 = null;
                    n14 = 1;
                } else {
                    cArray4 = cArray3;
                    n11 = 0;
                    n12 = 0;
                    n13 = 0;
                    c3 = (char)(c3 - 44032);
                    c4 = (char)(c3 % 28);
                    c3 = (char)(c3 / 28);
                    if (c4 > '\u0000') {
                        cArray3[2] = (char)(4519 + c4);
                        n14 = 3;
                    } else {
                        n14 = 2;
                    }
                    cArray3[1] = (char)(4449 + c3 % 21);
                    cArray3[0] = (char)(4352 + c3 / 21);
                }
            } else {
                if (NormalizerImpl.isNorm32Regular(l2)) {
                    c4 = '\u0000';
                    n14 = 1;
                } else if (n2 != n3 && Character.isLowSurrogate(c4 = cArray[n2])) {
                    ++n2;
                    n14 = 2;
                    l2 = NormalizerImpl.getNorm32FromSurrogatePair(l2, c4);
                } else {
                    c4 = '\u0000';
                    n14 = 1;
                    l2 = 0L;
                }
                if (NormalizerImpl.nx_contains(n6, c3, c4)) {
                    n12 = 0;
                    n13 = 0;
                    cArray4 = null;
                } else if ((l2 & (long)n7) == 0L) {
                    n13 = n12 = (int)(0xFFL & l2 >> 8);
                    cArray4 = null;
                    n11 = -1;
                } else {
                    DecomposeArgs decomposeArgs = new DecomposeArgs();
                    n11 = NormalizerImpl.decompose(l2, n7, decomposeArgs);
                    cArray4 = extraData;
                    n14 = decomposeArgs.length;
                    n13 = decomposeArgs.cc;
                    n12 = decomposeArgs.trailCC;
                    if (n14 == 1) {
                        c3 = cArray4[n11];
                        c4 = '\u0000';
                        cArray4 = null;
                        n11 = -1;
                    }
                }
            }
            if (n4 + n14 <= n5) {
                int n16 = n4;
                if (cArray4 == null) {
                    if (n13 != 0 && n13 < n10) {
                        n12 = NormalizerImpl.insertOrdered(cArray2, n9, n16, n4 += n14, c3, c4, n13);
                    } else {
                        cArray2[n4++] = c3;
                        if (c4 != '\u0000') {
                            cArray2[n4++] = c4;
                        }
                    }
                } else if (n13 != 0 && n13 < n10) {
                    n4 += n14;
                    n12 = NormalizerImpl.mergeOrdered(cArray2, n9, n16, cArray4, n11, n11 + n14);
                } else {
                    do {
                        cArray2[n4++] = cArray4[n11++];
                    } while (--n14 > 0);
                }
            } else {
                n4 += n14;
            }
            if ((n10 = n12) != 0) continue;
            n9 = n4;
        }
        nArray[0] = n10;
        return n4;
    }

    private static int getNextCombining(NextCombiningArgs nextCombiningArgs, int n2, int n3) {
        nextCombiningArgs.c = nextCombiningArgs.source[nextCombiningArgs.start++];
        long l2 = NormalizerImpl.getNorm32(nextCombiningArgs.c);
        nextCombiningArgs.c2 = '\u0000';
        nextCombiningArgs.combiningIndex = 0;
        nextCombiningArgs.cc = '\u0000';
        if ((l2 & 0xFFC0L) == 0L) {
            return 0;
        }
        if (!NormalizerImpl.isNorm32Regular(l2)) {
            if (NormalizerImpl.isNorm32HangulOrJamo(l2)) {
                nextCombiningArgs.combiningIndex = (int)(0xFFFFFFFFL & (0xFFF0L | l2 >> 16));
                return (int)(l2 & 0xC0L);
            }
            if (nextCombiningArgs.start != n2 && Character.isLowSurrogate(nextCombiningArgs.c2 = nextCombiningArgs.source[nextCombiningArgs.start])) {
                ++nextCombiningArgs.start;
                l2 = NormalizerImpl.getNorm32FromSurrogatePair(l2, nextCombiningArgs.c2);
            } else {
                nextCombiningArgs.c2 = '\u0000';
                return 0;
            }
        }
        if (NormalizerImpl.nx_contains(n3, nextCombiningArgs.c, nextCombiningArgs.c2)) {
            return 0;
        }
        nextCombiningArgs.cc = (char)(l2 >> 8);
        int n4 = (int)(l2 & 0xC0L);
        if (n4 != 0) {
            int n5 = NormalizerImpl.getExtraDataIndex(l2);
            nextCombiningArgs.combiningIndex = n5 > 0 ? extraData[n5 - 1] : 0;
        }
        return n4;
    }

    private static int getCombiningIndexFromStarter(char c2, char c3) {
        long l2 = NormalizerImpl.getNorm32(c2);
        if (c3 != '\u0000') {
            l2 = NormalizerImpl.getNorm32FromSurrogatePair(l2, c3);
        }
        return extraData[NormalizerImpl.getExtraDataIndex(l2) - 1];
    }

    private static int combine(char[] cArray, int n2, int n3, int[] nArray) {
        int n4;
        if (nArray.length < 2) {
            throw new IllegalArgumentException();
        }
        while ((n4 = cArray[n2++]) < n3) {
            n2 += (cArray[n2] & 0x8000) != 0 ? 2 : 1;
        }
        if ((n4 & Short.MAX_VALUE) == n3) {
            int n5;
            int n6 = cArray[n2];
            n4 = (int)(0xFFFFFFFFL & (long)((n6 & 0x2000) + 1));
            if ((n6 & 0x8000) != 0) {
                if ((n6 & 0x4000) != 0) {
                    n6 = (int)(0xFFFFFFFFL & (long)(n6 & 0x3FF | 0xD800));
                    n5 = cArray[n2 + 1];
                } else {
                    n6 = cArray[n2 + 1];
                    n5 = 0;
                }
            } else {
                n6 &= 0x1FFF;
                n5 = 0;
            }
            nArray[0] = n6;
            nArray[1] = n5;
            return n4;
        }
        return 0;
    }

    private static char recompose(RecomposeArgs recomposeArgs, int n2) {
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[2];
        int n5 = -1;
        int n6 = 0;
        boolean bl2 = false;
        char c2 = '\u0000';
        NextCombiningArgs nextCombiningArgs = new NextCombiningArgs();
        nextCombiningArgs.source = recomposeArgs.source;
        nextCombiningArgs.cc = '\u0000';
        nextCombiningArgs.c2 = '\u0000';
        while (true) {
            nextCombiningArgs.start = recomposeArgs.start;
            int n7 = NormalizerImpl.getNextCombining(nextCombiningArgs, recomposeArgs.limit, n2);
            int n8 = nextCombiningArgs.combiningIndex;
            recomposeArgs.start = nextCombiningArgs.start;
            if ((n7 & 0x80) != 0 && n5 != -1) {
                int n9;
                int n10;
                int n11;
                int n12;
                if ((n8 & 0x8000) != 0) {
                    n12 = -1;
                    nextCombiningArgs.c2 = recomposeArgs.source[n5];
                    if (n8 == 65522) {
                        nextCombiningArgs.c2 = (char)(nextCombiningArgs.c2 - 4352);
                        if (nextCombiningArgs.c2 < '\u0013') {
                            n12 = recomposeArgs.start - 1;
                            nextCombiningArgs.c = (char)(44032 + (nextCombiningArgs.c2 * 21 + (nextCombiningArgs.c - 4449)) * 28);
                            if (recomposeArgs.start != recomposeArgs.limit && (nextCombiningArgs.c2 = (char)(recomposeArgs.source[recomposeArgs.start] - 4519)) < '\u001c') {
                                ++recomposeArgs.start;
                                nextCombiningArgs.c = (char)(nextCombiningArgs.c + nextCombiningArgs.c2);
                            }
                            if (!NormalizerImpl.nx_contains(n2, nextCombiningArgs.c)) {
                                recomposeArgs.source[n5] = nextCombiningArgs.c;
                            } else {
                                if (!NormalizerImpl.isHangulWithoutJamoT(nextCombiningArgs.c)) {
                                    --recomposeArgs.start;
                                }
                                n12 = recomposeArgs.start;
                            }
                        }
                    }
                    if (n12 != -1) {
                        n11 = n12;
                        n10 = recomposeArgs.start;
                        while (n10 < recomposeArgs.limit) {
                            recomposeArgs.source[n11++] = recomposeArgs.source[n10++];
                        }
                        recomposeArgs.start = n12;
                        recomposeArgs.limit = n11;
                    }
                    nextCombiningArgs.c2 = '\u0000';
                } else if (!((n6 & 0x8000) != 0 || c2 >= nextCombiningArgs.cc && c2 != '\u0000' || 0 == (n9 = NormalizerImpl.combine(combiningTable, n6, n8, nArray)) || NormalizerImpl.nx_contains(n2, (char)n3, (char)n4))) {
                    n3 = nArray[0];
                    n4 = nArray[1];
                    n12 = nextCombiningArgs.c2 == '\u0000' ? recomposeArgs.start - 1 : recomposeArgs.start - 2;
                    recomposeArgs.source[n5] = (char)n3;
                    if (bl2) {
                        if (n4 != 0) {
                            recomposeArgs.source[n5 + 1] = (char)n4;
                        } else {
                            bl2 = false;
                            n11 = n5 + 1;
                            n10 = n11 + 1;
                            while (n10 < n12) {
                                recomposeArgs.source[n11++] = recomposeArgs.source[n10++];
                            }
                            --n12;
                        }
                    } else if (n4 != 0) {
                        bl2 = true;
                        ++n5;
                        n11 = n12++;
                        n10 = n12;
                        while (n5 < n11) {
                            recomposeArgs.source[--n10] = recomposeArgs.source[--n11];
                        }
                        recomposeArgs.source[n5] = (char)n4;
                        --n5;
                    }
                    if (n12 < recomposeArgs.start) {
                        n11 = n12;
                        n10 = recomposeArgs.start;
                        while (n10 < recomposeArgs.limit) {
                            recomposeArgs.source[n11++] = recomposeArgs.source[n10++];
                        }
                        recomposeArgs.start = n12;
                        recomposeArgs.limit = n11;
                    }
                    if (recomposeArgs.start == recomposeArgs.limit) {
                        return c2;
                    }
                    if (n9 > 1) {
                        n6 = NormalizerImpl.getCombiningIndexFromStarter((char)n3, (char)n4);
                        continue;
                    }
                    n5 = -1;
                    continue;
                }
            }
            c2 = nextCombiningArgs.cc;
            if (recomposeArgs.start == recomposeArgs.limit) {
                return c2;
            }
            if (nextCombiningArgs.cc != '\u0000') continue;
            if ((n7 & 0x40) != 0) {
                if (nextCombiningArgs.c2 == '\u0000') {
                    bl2 = false;
                    n5 = recomposeArgs.start - 1;
                } else {
                    bl2 = false;
                    n5 = recomposeArgs.start - 2;
                }
                n6 = n8;
                continue;
            }
            n5 = -1;
        }
    }

    private static int findPreviousStarter(char[] cArray, int n2, int n3, int n4, int n5, char c2) {
        long l2;
        PrevArgs prevArgs = new PrevArgs();
        prevArgs.src = cArray;
        prevArgs.start = n2;
        prevArgs.current = n3;
        while (prevArgs.start < prevArgs.current && !NormalizerImpl.isTrueStarter(l2 = NormalizerImpl.getPrevNorm32(prevArgs, c2, n4 | n5), n4, n5)) {
        }
        return prevArgs.current;
    }

    private static int findNextStarter(char[] cArray, int n2, int n3, int n4, int n5, char c2) {
        long l2;
        char c3;
        int n6 = 0xFF00 | n4;
        DecomposeArgs decomposeArgs = new DecomposeArgs();
        while (n2 != n3 && (c3 = cArray[n2]) >= c2 && ((l2 = NormalizerImpl.getNorm32(c3)) & (long)n6) != 0L) {
            char c4;
            if (NormalizerImpl.isNorm32LeadSurrogate(l2)) {
                if (n2 + 1 == n3 || !Character.isLowSurrogate(c4 = cArray[n2 + 1]) || ((l2 = NormalizerImpl.getNorm32FromSurrogatePair(l2, c4)) & (long)n6) == 0L) {
                    break;
                }
            } else {
                c4 = '\u0000';
            }
            if ((l2 & (long)n5) != 0L) {
                int n7 = NormalizerImpl.decompose(l2, n5, decomposeArgs);
                if (decomposeArgs.cc == 0 && (NormalizerImpl.getNorm32(extraData, n7, n4) & (long)n4) == 0L) break;
            }
            n2 += c4 == '\u0000' ? 1 : 2;
        }
        return n2;
    }

    private static char[] composePart(ComposePartArgs composePartArgs, int n2, char[] cArray, int n3, int n4, int n5, int n6) {
        boolean bl2 = (n5 & 0x22) != 0;
        int[] nArray = new int[1];
        char[] cArray2 = new char[(n4 - n2) * 20];
        while (true) {
            composePartArgs.length = NormalizerImpl.decompose(cArray, n2, n3, cArray2, 0, cArray2.length, bl2, nArray, n6);
            if (composePartArgs.length <= cArray2.length) break;
            cArray2 = new char[composePartArgs.length];
        }
        int n7 = composePartArgs.length;
        if (composePartArgs.length >= 2) {
            RecomposeArgs recomposeArgs = new RecomposeArgs();
            recomposeArgs.source = cArray2;
            recomposeArgs.start = 0;
            recomposeArgs.limit = n7;
            composePartArgs.prevCC = NormalizerImpl.recompose(recomposeArgs, n6);
            n7 = recomposeArgs.limit;
        }
        composePartArgs.length = n7;
        return cArray2;
    }

    private static boolean composeHangul(char c2, char c3, long l2, char[] cArray, int[] nArray, int n2, boolean bl2, char[] cArray2, int n3, int n4) {
        int n5 = nArray[0];
        if (NormalizerImpl.isJamoVTNorm32JamoV(l2)) {
            if ((c2 = (char)(c2 - 4352)) < '\u0013') {
                c3 = (char)(44032 + (c2 * 21 + (c3 - 4449)) * 28);
                if (n5 != n2) {
                    char c4 = cArray[n5];
                    char c5 = (char)(c4 - 4519);
                    if (c5 < '\u001c') {
                        ++n5;
                        c3 = (char)(c3 + c5);
                    } else if (bl2 && NormalizerImpl.isNorm32Regular(l2 = NormalizerImpl.getNorm32(c4)) && (l2 & 8L) != 0L) {
                        DecomposeArgs decomposeArgs = new DecomposeArgs();
                        int n6 = NormalizerImpl.decompose(l2, 8, decomposeArgs);
                        if (decomposeArgs.length == 1 && (c5 = (char)(extraData[n6] - 4519)) < '\u001c') {
                            ++n5;
                            c3 = (char)(c3 + c5);
                        }
                    }
                }
                if (NormalizerImpl.nx_contains(n4, c3)) {
                    if (!NormalizerImpl.isHangulWithoutJamoT(c3)) {
                        --n5;
                    }
                    return false;
                }
                cArray2[n3] = c3;
                nArray[0] = n5;
                return true;
            }
        } else if (NormalizerImpl.isHangulWithoutJamoT(c2)) {
            if (NormalizerImpl.nx_contains(n4, c3 = (char)(c2 + (c3 - 4519)))) {
                return false;
            }
            cArray2[n3] = c3;
            nArray[0] = n5;
            return true;
        }
        return false;
    }

    static int compose(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, boolean bl2, int n6) {
        int n7;
        char c2;
        int[] nArray = new int[1];
        if (!bl2) {
            c2 = (char)indexes[6];
            n7 = 17;
        } else {
            c2 = (char)indexes[7];
            n7 = 34;
        }
        int n8 = n2;
        int n9 = 0xFF00 | n7;
        int n10 = 0;
        int n11 = 0;
        long l2 = 0L;
        char c3 = '\u0000';
        while (true) {
            char c4;
            int n12;
            int n13;
            int n14 = n2;
            while (n2 != n3 && ((c3 = cArray[n2]) < c2 || ((l2 = NormalizerImpl.getNorm32(c3)) & (long)n9) == 0L)) {
                n11 = 0;
                ++n2;
            }
            if (n2 != n14) {
                n13 = n2 - n14;
                if (n4 + n13 <= n5) {
                    System.arraycopy(cArray, n14, cArray2, n4, n13);
                }
                n10 = n4 += n13;
                n8 = n2 - 1;
                if (Character.isLowSurrogate(cArray[n8]) && n14 < n8 && Character.isHighSurrogate(cArray[n8 - 1])) {
                    --n8;
                }
                n14 = n2;
            }
            if (n2 == n3) break;
            ++n2;
            if (NormalizerImpl.isNorm32HangulOrJamo(l2)) {
                n12 = 0;
                n11 = 0;
                n10 = n4;
                nArray[0] = n2;
                if (n4 > 0 && NormalizerImpl.composeHangul(cArray[n14 - 1], c3, l2, cArray, nArray, n3, bl2, cArray2, n4 <= n5 ? n4 - 1 : 0, n6)) {
                    n8 = n2 = nArray[0];
                    continue;
                }
                n2 = nArray[0];
                c4 = '\u0000';
                n13 = 1;
                n8 = n14;
            } else {
                if (NormalizerImpl.isNorm32Regular(l2)) {
                    c4 = '\u0000';
                    n13 = 1;
                } else if (n2 != n3 && Character.isLowSurrogate(c4 = cArray[n2])) {
                    ++n2;
                    n13 = 2;
                    l2 = NormalizerImpl.getNorm32FromSurrogatePair(l2, c4);
                } else {
                    c4 = '\u0000';
                    n13 = 1;
                    l2 = 0L;
                }
                ComposePartArgs composePartArgs = new ComposePartArgs();
                if (NormalizerImpl.nx_contains(n6, c3, c4)) {
                    n12 = 0;
                } else if ((l2 & (long)n7) == 0L) {
                    n12 = (int)(0xFFL & l2 >> 8);
                } else {
                    int n15 = n7 << 2 & 0xF;
                    if (NormalizerImpl.isTrueStarter(l2, 0xFF00 | n7, n15)) {
                        n8 = n14;
                    } else {
                        n4 -= n14 - n8;
                    }
                    n2 = NormalizerImpl.findNextStarter(cArray, n2, n3, n7, n15, c2);
                    composePartArgs.prevCC = n11;
                    composePartArgs.length = n13;
                    char[] cArray3 = NormalizerImpl.composePart(composePartArgs, n8, cArray, n2, n3, n7, n6);
                    if (cArray3 == null) break;
                    n11 = composePartArgs.prevCC;
                    n13 = composePartArgs.length;
                    if (n4 + composePartArgs.length <= n5) {
                        int n16 = 0;
                        while (n16 < composePartArgs.length) {
                            cArray2[n4++] = cArray3[n16++];
                            --n13;
                        }
                    } else {
                        n4 += n13;
                    }
                    n8 = n2;
                    continue;
                }
            }
            if (n4 + n13 <= n5) {
                if (n12 != 0 && n12 < n11) {
                    int n17 = n4;
                    n11 = NormalizerImpl.insertOrdered(cArray2, n10, n17, n4 += n13, c3, c4, n12);
                    continue;
                }
                cArray2[n4++] = c3;
                if (c4 != '\u0000') {
                    cArray2[n4++] = c4;
                }
                n11 = n12;
                continue;
            }
            n4 += n13;
            n11 = n12;
        }
        return n4;
    }

    public static int getCombiningClass(int n2) {
        long l2 = NormalizerImpl.getNorm32(n2);
        return (char)(l2 >> 8 & 0xFFL);
    }

    static int getDecompose(int[] nArray, String[] stringArray) {
        DecomposeArgs decomposeArgs = new DecomposeArgs();
        boolean bl2 = false;
        long l2 = 0L;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        while (++n2 < 195102) {
            if (n2 == 12543) {
                n2 = 63744;
            } else if (n2 == 65536) {
                n2 = 119134;
            } else if (n2 == 119233) {
                n2 = 194560;
            }
            if (((l2 = NormalizerImpl.getNorm32(n2)) & 4L) == 0L || n4 >= nArray.length) continue;
            nArray[n4] = n2;
            n3 = NormalizerImpl.decompose(l2, decomposeArgs);
            stringArray[n4++] = new String(extraData, n3, decomposeArgs.length);
        }
        return n4;
    }

    private static int strCompare(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, boolean bl2) {
        char c2;
        char c3;
        int n6;
        int n7;
        int n8 = n2;
        int n9 = n4;
        int n10 = n3 - n2;
        int n11 = n5 - n4;
        if (n10 < n11) {
            n7 = -1;
            n6 = n8 + n10;
        } else if (n10 == n11) {
            n7 = 0;
            n6 = n8 + n10;
        } else {
            n7 = 1;
            n6 = n8 + n11;
        }
        if (cArray == cArray2) {
            return n7;
        }
        while (true) {
            if (n2 == n6) {
                return n7;
            }
            c3 = cArray[n2];
            c2 = cArray2[n4];
            if (c3 != c2) break;
            ++n2;
            ++n4;
        }
        n6 = n8 + n10;
        int n12 = n9 + n11;
        if (c3 >= '\ud800' && c2 >= '\ud800' && bl2) {
            if (!(c3 <= '\udbff' && n2 + 1 != n6 && Character.isLowSurrogate(cArray[n2 + 1]) || Character.isLowSurrogate(c3) && n8 != n2 && Character.isHighSurrogate(cArray[n2 - 1]))) {
                c3 = (char)(c3 - 10240);
            }
            if (!(c2 <= '\udbff' && n4 + 1 != n12 && Character.isLowSurrogate(cArray2[n4 + 1]) || Character.isLowSurrogate(c2) && n9 != n4 && Character.isHighSurrogate(cArray2[n4 - 1]))) {
                c2 = (char)(c2 - 10240);
            }
        }
        return c3 - c2;
    }

    private static final boolean nx_contains(int n2, int n3) {
        if (n2 != 1) {
            return false;
        }
        return n3 >= 44032 && n3 <= 55203;
    }

    private static final boolean nx_contains(int n2, char c2, char c3) {
        if (n2 != 1) {
            return false;
        }
        return c3 == '\u0000' && c2 >= '\uac00' && c2 <= '\ud7a3';
    }

    static /* synthetic */ int[] access$002(int[] nArray) {
        indexes = nArray;
        return nArray;
    }

    static /* synthetic */ char[] access$102(char[] cArray) {
        combiningTable = cArray;
        return cArray;
    }

    static /* synthetic */ char[] access$202(char[] cArray) {
        extraData = cArray;
        return cArray;
    }

    static {
        try {
            IMPL = new NormalizerImpl();
        }
        catch (Exception exception) {
            RuntimeException runtimeException = new RuntimeException(exception.getMessage());
            runtimeException.initCause(exception);
            throw runtimeException;
        }
    }

    private static final class ComposePartArgs {
        int prevCC;
        int length;

        private ComposePartArgs() {
        }
    }

    private static final class DecomposeArgs {
        int cc;
        int trailCC;
        int length;

        private DecomposeArgs() {
        }
    }

    private static final class FCDTrieImpl
    implements Trie.DataManipulate {
        static CharTrie fcdTrie = null;

        private FCDTrieImpl() {
        }

        public int getFoldingOffset(int n2) {
            return n2;
        }
    }

    private static final class NextCCArgs {
        char[] source;
        int next;
        int limit;
        char c;
        char c2;

        private NextCCArgs() {
        }
    }

    private static final class NextCombiningArgs {
        char[] source;
        int start;
        char c;
        char c2;
        int combiningIndex;
        char cc;

        private NextCombiningArgs() {
        }
    }

    private static final class NormTrieImpl
    implements Trie.DataManipulate {
        static IntTrie normTrie = null;

        private NormTrieImpl() {
        }

        public int getFoldingOffset(int n2) {
            return 2048 + (n2 >> 11 & 0x7FE0);
        }
    }

    private static final class PrevArgs {
        char[] src;
        int start;
        int current;
        char c;
        char c2;

        private PrevArgs() {
        }
    }

    private static final class RecomposeArgs {
        char[] source;
        int start;
        int limit;

        private RecomposeArgs() {
        }
    }
}

