/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.eclipse.core.internal.resources.IMarkerSetElement;
import org.eclipse.core.internal.resources.MarkerAttributeMap;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.IStringPoolParticipant;
import org.eclipse.core.internal.utils.StringPool;

public class MarkerInfo
implements IMarkerSetElement,
Cloneable,
IStringPoolParticipant {
    protected static final long UNDEFINED_ID = -1L;
    protected Map attributes = null;
    protected long creationTime = 0L;
    protected long id = -1L;
    protected String type = null;

    protected static void checkValidAttribute(Object value) {
        byte[] bytes;
        boolean isString = value instanceof String;
        Assert.isTrue(value == null || isString || value instanceof Integer || value instanceof Boolean);
        if (!isString) {
            return;
        }
        String valueString = (String)value;
        if (valueString.length() < 21000) {
            return;
        }
        try {
            bytes = valueString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
        if (bytes.length > 65535) {
            String msg = "Marker property value is too long: " + valueString.substring(0, 10000);
            Assert.isTrue(false, msg);
        }
    }

    public Object clone() {
        try {
            MarkerInfo copy = (MarkerInfo)super.clone();
            copy.attributes = this.getAttributes(true);
            return copy;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Object getAttribute(String attributeName) {
        return this.attributes == null ? null : this.attributes.get(attributeName);
    }

    public Map getAttributes() {
        return this.getAttributes(true);
    }

    public Map getAttributes(boolean makeCopy) {
        if (this.attributes == null) {
            return null;
        }
        return makeCopy ? new MarkerAttributeMap(this.attributes) : this.attributes;
    }

    public Object[] getAttributes(String[] attributeNames) {
        Object[] result = new Object[attributeNames.length];
        int i = 0;
        while (i < attributeNames.length) {
            result[i] = this.getAttribute(attributeNames[i]);
            ++i;
        }
        return result;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public void internalSetAttributes(Map map) {
        this.attributes = (MarkerAttributeMap)map;
    }

    public void setAttribute(String attributeName, Object value) {
        MarkerInfo.checkValidAttribute(value);
        if (this.attributes == null) {
            if (value == null) {
                return;
            }
            this.attributes = new MarkerAttributeMap();
            this.attributes.put(attributeName, value);
        } else if (value == null) {
            this.attributes.remove(attributeName);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        } else {
            this.attributes.put(attributeName, value);
        }
    }

    public void setAttributes(Map map) {
        this.attributes = map == null ? null : new MarkerAttributeMap(map);
    }

    public void setAttributes(String[] attributeNames, Object[] values) {
        Assert.isTrue(attributeNames.length == values.length);
        int i = 0;
        while (i < attributeNames.length) {
            this.setAttribute(attributeNames[i], values[i]);
            ++i;
        }
    }

    public void setCreationTime(long value) {
        this.creationTime = value;
    }

    public void setId(long value) {
        this.id = value;
    }

    public void setType(String value) {
        this.type = value;
    }

    public void shareStrings(StringPool set) {
        this.type = set.add(this.type);
        Map map = this.attributes;
        if (map instanceof IStringPoolParticipant) {
            ((IStringPoolParticipant)((Object)map)).shareStrings(set);
        }
    }
}

