/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.monitor.action.GetEventListTableDefine;
import com.clustercontrol.monitor.action.GetFilterEvent;
import com.clustercontrol.monitor.dialog.EventInfoDialog;
import com.clustercontrol.util.Messages;
import java.rmi.AccessException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class EventListComposite
extends Composite {
    private CommonTableViewer tableViewer = null;
    private Label criticalLabel = null;
    private Label warningLabel = null;
    private Label infoLabel = null;
    private Label unknownLabel = null;
    private Label totalLabel = null;
    private Shell m_shell = null;
    private boolean openAccessInformation = false;
    private boolean openInformation = false;

    public EventListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
        this.m_shell = this.getShell();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(5, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Table table = new Table((Composite)this, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        table.setLayoutData((Object)gridData);
        this.criticalLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.criticalLabel.setLayoutData((Object)gridData);
        this.criticalLabel.setBackground(this.getDisplay().getSystemColor(3));
        this.warningLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.warningLabel.setLayoutData((Object)gridData);
        this.warningLabel.setBackground(this.getDisplay().getSystemColor(7));
        this.infoLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.infoLabel.setLayoutData((Object)gridData);
        this.infoLabel.setBackground(this.getDisplay().getSystemColor(5));
        this.unknownLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.unknownLabel.setLayoutData((Object)gridData);
        this.unknownLabel.setBackground(new Color(null, 128, 192, 255));
        this.totalLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.totalLabel.setLayoutData((Object)gridData);
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetEventListTableDefine.get(), 1, -1);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                List list = (List)((StructuredSelection)event.getSelection()).getFirstElement();
                EventInfoDialog dialog = new EventInfoDialog(EventListComposite.this.m_shell, list);
                dialog.open();
            }
        });
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    public void update(String facilityId) {
        ArrayList infoList;
        block5: {
            super.update();
            infoList = null;
            try {
                infoList = new GetFilterEvent().getFilterInfo(facilityId);
            }
            catch (AccessException accessException) {
                if (!this.openAccessInformation) {
                    this.openAccessInformation = true;
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (this.openInformation) break block5;
                this.openInformation = true;
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.monitor.12"));
                this.openInformation = false;
            }
        }
        if (infoList == null) {
            infoList = new ArrayList();
        }
        this.updateStatus(infoList);
        Object[] args = new Object[]{this.totalLabel.getText()};
        this.totalLabel.setText(Messages.getString((String)"records", (Object[])args));
        this.tableViewer.setInput(infoList);
    }

    public void update(String facilityId, Property condition) {
        ArrayList infoList;
        block5: {
            super.update();
            infoList = null;
            try {
                infoList = new GetFilterEvent().getFilterInfo(facilityId, condition);
            }
            catch (AccessException accessException) {
                if (!this.openAccessInformation) {
                    this.openAccessInformation = true;
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (this.openInformation) break block5;
                this.openInformation = true;
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.monitor.12"));
                this.openInformation = false;
            }
        }
        if (infoList == null) {
            infoList = new ArrayList();
        }
        this.updateStatus(infoList);
        Object[] args = new Object[]{this.totalLabel.getText()};
        this.totalLabel.setText(Messages.getString((String)"filtered.records", (Object[])args));
        this.tableViewer.setInput(infoList);
    }

    protected void updateStatus(ArrayList list) {
        int[] status = new int[4];
        if (list != null) {
            int count = list.size();
            int i = 0;
            while (i < count) {
                ArrayList data = (ArrayList)list.get(i);
                int value = (Integer)data.get(0);
                switch (value) {
                    case 0: {
                        status[0] = status[0] + 1;
                        break;
                    }
                    case 2: {
                        status[1] = status[1] + 1;
                        break;
                    }
                    case 3: {
                        status[2] = status[2] + 1;
                        break;
                    }
                    case 1: {
                        status[3] = status[3] + 1;
                    }
                }
                ++i;
            }
        }
        this.criticalLabel.setText(String.valueOf(status[0]));
        this.warningLabel.setText(String.valueOf(status[1]));
        this.infoLabel.setText(String.valueOf(status[2]));
        this.unknownLabel.setText(String.valueOf(status[3]));
        int total = status[0] + status[1] + status[2] + status[3];
        this.totalLabel.setText(String.valueOf(total));
    }
}

