/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.ejb.session;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.performanceMGR.bean.CollectedDataInfo;
import com.clustercontrol.performanceMGR.bean.CollectedDataSet;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.bean.CollectorLockKey;
import com.clustercontrol.performanceMGR.bean.CollectorProperty;
import com.clustercontrol.performanceMGR.bean.DeviceData;
import com.clustercontrol.performanceMGR.bean.DeviceDataSet;
import com.clustercontrol.performanceMGR.dao.CalculatedDataDAO;
import com.clustercontrol.performanceMGR.dao.CollectorItemDAO;
import com.clustercontrol.performanceMGR.dao.DeviceDAO;
import com.clustercontrol.performanceMGR.ejb.bmp.Collector;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorHome;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorPK;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorUtil;
import com.clustercontrol.performanceMGR.ejb.bmp.RecordCollectorData;
import com.clustercontrol.performanceMGR.util.FacilityTreeDB;
import com.clustercontrol.performanceMGR.util.JNDIConnectionManager;
import com.clustercontrol.performanceMGR.util.LockManager;
import com.clustercontrol.performanceMGR.util.Messages;
import com.clustercontrol.performanceMGR.util.Repository;
import com.clustercontrol.performanceMGR.util.code.CollectorItemCodeTable;
import com.clustercontrol.performanceMGR.util.code.CollectorItemTreeItem;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectorControllerBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(CollectorControllerBean.class);
    public static final int CURRENT_SCOPE = 0;
    public static final int SUB_SCOPE = 1;
    private String m_collectorID;
    private int m_collectorType;
    static /* synthetic */ Class class$0;

    public void ejbCreate() throws CreateException {
        this.m_collectorType = 0;
    }

    public void ejbRemove() {
        m_log.debug((Object)("ejbRemove() start : " + this.m_collectorID));
        if (this.m_collectorType == 1) {
            try {
                CollectorHome home = JNDIConnectionManager.getCollectorHome();
                Collector myBean = home.findByPrimaryKey(new CollectorPK(this.m_collectorID));
                myBean.stopCollect();
                myBean.remove();
            }
            catch (FinderException e) {
                throw new EJBException(e.getMessage(), (Exception)((Object)e));
            }
            catch (NamingException e) {
                throw new EJBException(e.getMessage(), (Exception)e);
            }
            catch (EJBException e) {
                throw new EJBException(e.getMessage(), (Exception)((Object)e));
            }
            catch (RemoveException e) {
                throw new EJBException(e.getMessage(), (Exception)((Object)e));
            }
            catch (RemoteException e) {
                throw new EJBException(e.getMessage(), (Exception)e);
            }
        }
        m_log.debug((Object)("ejbRemove() end : " + this.m_collectorID));
    }

    public void ejbPassivate() {
    }

    public void createRealtimeColletor(String facilityID, int interval, List colletorItemList) {
        this.m_collectorType = 1;
        this.m_collectorID = CollectorUtil.generateGUID((Object)this);
        m_log.debug((Object)("createRealtimeColletor() start : " + Thread.currentThread().getName() + "\t" + this.m_collectorID));
        try {
            RecordCollectorData data = new RecordCollectorData();
            data.setCollectorID(this.m_collectorID);
            data.setCollectorType(1);
            data.setLabel(Thread.currentThread().getName());
            data.setFacilityID(facilityID);
            data.setInterval(interval);
            data.setPeriod(-1);
            Repository repository = new Repository();
            FacilityTreeItem facilityTree = repository.getFacilityTree(facilityID);
            data.setFacilityTree(facilityTree);
            if (facilityTree == null) {
                return;
            }
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            Collector myBean = home.create(data, colletorItemList);
            myBean.startCollect();
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        m_log.debug((Object)("createRealtimeColletor() end : " + Thread.currentThread().getName() + "\t" + this.m_collectorID));
    }

    public Collection getRealtimeCollectedData(String facilityID, int itemID, int option) {
        try {
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            Collector myBean = home.findByPrimaryKey(new CollectorPK(this.m_collectorID));
            if (option == 0) {
                CollectedDataInfo data = myBean.getValue(facilityID, itemID);
                ArrayList<CollectedDataInfo> ret = new ArrayList<CollectedDataInfo>();
                ret.add(data);
                return ret;
            }
            if (option == 1) {
                return myBean.getSubScopeValues(facilityID, itemID);
            }
            return null;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
    }

    public Collection getRealtimeCollectedData(String facilityID, int[] itemIDs) {
        try {
            ArrayList<CollectedDataInfo> ret = new ArrayList<CollectedDataInfo>();
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            Collector myBean = home.findByPrimaryKey(new CollectorPK(this.m_collectorID));
            int i = 0;
            while (i < itemIDs.length) {
                ret.add(myBean.getValue(facilityID, itemIDs[i]));
                ++i;
            }
            return ret;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
    }

    public Collection getRealtimeCollectedDataAll(String facilityID) {
        try {
            CollectedDataInfo[] returnData = null;
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            Collector myBean = home.findByPrimaryKey(new CollectorPK(this.m_collectorID));
            returnData = myBean.getValueAll(facilityID);
            return Arrays.asList(returnData);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
    }

    public CollectorProperty getCollectorProperty(String collectorID) {
        this.m_collectorID = collectorID;
        CollectorProperty property = new CollectorProperty();
        RecordCollectorData collectorData = null;
        try {
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            Collector myBean = home.findByPrimaryKey(new CollectorPK(collectorID));
            collectorData = myBean.getRecordColletorData();
            property.setDeviceSet(this.getDeviceSet(collectorID));
            collectorData.setFacilityTree(this.getFacilityTree(collectorID));
            property.setCollectorData(collectorData);
            CollectorItemDAO dao = new CollectorItemDAO();
            ArrayList itemList = new ArrayList(dao.selectCollectorItemByCollectorID(collectorID));
            property.setItemList(itemList);
            return property;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
    }

    public void createRecordColletor(CollectorProperty collectorDef) throws DuplicateKeyException {
        m_log.debug((Object)("createRecordColletor() start : " + Thread.currentThread().getName() + "\t" + this.m_collectorID));
        this.m_collectorType = 2;
        this.m_collectorID = collectorDef.getCollectorData().getCollectorID();
        RecordCollectorData collectorData = collectorDef.getCollectorData();
        collectorData.setCollectorType(this.m_collectorType);
        try {
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            Collector collector = home.create(collectorData, (List)collectorDef.getItemList());
            collector.startCollect();
        }
        catch (DuplicateKeyException e) {
            throw e;
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        m_log.debug((Object)("createRecordColletor() end : " + Thread.currentThread().getName() + "\t" + this.m_collectorID));
    }

    public void stopRecordCollector(String collectorID) {
        try {
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            Collector myBean = home.findByPrimaryKey(new CollectorPK(collectorID));
            myBean.stopCollect();
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
    }

    public List getRecordCollectedData(CollectorItemInfo item, String facilityID, Date startDate, Date endDate) {
        m_log.debug((Object)("getRecordCollectedData() " + facilityID));
        CalculatedDataDAO dao = new CalculatedDataDAO();
        List data = dao.select(item.getCollectorID(), item.getCollectorItemCode(), item.getDeviceIndex(), facilityID, startDate, endDate);
        return data;
    }

    public CollectedDataSet getRecordCollectedData(CollectorItemInfo[] items, String[] facilityIDs, Date startDate, Date endDate) {
        CollectedDataSet ret = new CollectedDataSet();
        int j = 0;
        while (j < facilityIDs.length) {
            int i = 0;
            while (i < items.length) {
                List dataList = this.getRecordCollectedData(items[i], facilityIDs[j], startDate, endDate);
                ret.setCollectedDataList(facilityIDs[j], items[i].getCollectorItemID(), dataList);
                ++i;
            }
            ++j;
        }
        return ret;
    }

    public CollectedDataSet getRecordCollectedData(String collectorID, String[] facilityIDs, int[] itemID, Date startDate, Date endDate) {
        CollectedDataSet ret = new CollectedDataSet();
        CollectorItemDAO dao = new CollectorItemDAO();
        int j = 0;
        while (j < facilityIDs.length) {
            int i = 0;
            while (i < itemID.length) {
                CollectorItemInfo item = dao.selectCollectorItem(collectorID, itemID[i]);
                List dataList = this.getRecordCollectedData(item, facilityIDs[j], startDate, endDate);
                ret.setCollectedDataList(facilityIDs[j], item.getCollectorItemID(), dataList);
                ++i;
            }
            ++j;
        }
        return ret;
    }

    public void deleteRecordCollector(String collectorID) throws RemoveException {
        m_log.debug((Object)("deleteRecordCollector() start : " + Thread.currentThread().getName() + "\t" + this.m_collectorID));
        if (LockManager.isLocked((String)collectorID)) {
            m_log.debug((Object)("deleteRecordCollector()  : " + collectorID + " is locked."));
            throw new RemoveException(String.valueOf(collectorID) + " is locked.");
        }
        try {
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            Collector myBean = home.findByPrimaryKey(new CollectorPK(collectorID));
            if (myBean.getStatus() == 100) {
                m_log.debug((Object)("deleteRecordCollector()  : " + collectorID + " is running."));
                throw new RemoveException(String.valueOf(collectorID) + " is running.");
            }
            myBean.remove();
        }
        catch (FinderException e) {
            throw new RemoveException(e.getMessage());
        }
        catch (NamingException e) {
            throw new RemoveException(e.getMessage());
        }
        catch (RemoveException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw new RemoveException(e.getMessage());
        }
        m_log.debug((Object)("deleteRecordCollector() end : " + Thread.currentThread().getName() + "\t" + this.m_collectorID));
    }

    public FacilityTreeItem getFacilityTree(String collectorID) {
        return new FacilityTreeDB().getFacilityTree(collectorID);
    }

    public DeviceDataSet getCurrentDeviceSet(String facilityID) {
        DeviceDataSet dataSet = new DeviceDataSet();
        Repository repository = new Repository();
        List deviceList = repository.getDeviceList(facilityID);
        Iterator itr = deviceList.iterator();
        while (itr.hasNext()) {
            dataSet.putDeviceList((DeviceData)itr.next());
        }
        return dataSet;
    }

    public DeviceDataSet getDeviceSet(String collectorID) throws FinderException, NamingException {
        DeviceDataSet dataSet = new DeviceDataSet();
        DeviceDAO dao = new DeviceDAO();
        Collection devicList = dao.selectDeviceByCollectorID(collectorID);
        Iterator itr = devicList.iterator();
        while (itr.hasNext()) {
            dataSet.putDeviceList((DeviceData)itr.next());
        }
        return dataSet;
    }

    public void lock(String collectorID, CollectorLockKey key) {
        LockManager.lock((String)collectorID, (CollectorLockKey)key);
    }

    public void unlock(CollectorLockKey key) {
        LockManager.unlock((CollectorLockKey)key);
    }

    public ArrayList getCollectionListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"run.status", (Locale)locale), 0, 70, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"error.status", (Locale)locale), 11, 70, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"collector.id", (Locale)locale), -1, 200, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"description", (Locale)locale), -1, 220, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"scope", (Locale)locale), 2, 220, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"start.date", (Locale)locale), -1, 150, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"stop.date", (Locale)locale), -1, 150, 16384));
        tableDefine.add(7, new TableColumnInfo(Messages.getString((String)"interval", (Locale)locale), -1, 70, 16384));
        tableDefine.add(8, new TableColumnInfo(Messages.getString((String)"count", (Locale)locale), -1, 70, 16384));
        return tableDefine;
    }

    public ArrayList getCollectionList() {
        m_log.debug((Object)"getCollectionList() start : ");
        ArrayList list = new ArrayList();
        try {
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            Collection myBeans = home.findByCollectorType(2);
            for (Collector myBean : myBeans) {
                RecordCollectorData data = myBean.getRecordColletorData();
                ArrayList<Object> info = new ArrayList<Object>();
                info.add(new Integer(data.getStatus()));
                info.add(new Integer(data.getEndStatus()));
                info.add(data.getCollectorID());
                info.add(data.getLabel());
                info.add(data.getScopePath());
                info.add(data.getStartDate());
                info.add(data.getStopDate());
                info.add(data.getInterval());
                info.add(new Integer(data.getCount()));
                list.add(info);
            }
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        m_log.debug((Object)"getCollectionList() end   : ");
        return list;
    }

    public HashMap<String, CollectorItemTreeItem> getItemCodeMap() {
        return CollectorItemCodeTable.getItemCodeMap();
    }

    public CollectorItemTreeItem[] getCollectorTree(String facilityId, String collectorId) {
        return CollectorItemCodeTable.getCollectorTree(facilityId, collectorId);
    }

    public List getAvailableCollectorItemList(String facilityId) {
        return CollectorItemCodeTable.getAvailableCollectorItemList(facilityId);
    }

    public boolean checkPermissionRead() {
        return true;
    }

    public boolean checkPerformanceWrite() {
        return true;
    }

    public boolean checkPermissionExecute() {
        return true;
    }
}

