/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logagent;

import com.clustercontrol.logagent.SendQueue;
import com.clustercontrol.logagent.TransferLogThread;
import com.clustercontrol.logagent.util.EjbConnectionManager;
import com.clustercontrol.logtransfer.bean.LogTransferFileInfo;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferLogManager {
    private Hashtable<String, LogThreadManageInfo> m_runTransferLog = null;
    private SendQueue m_sendQueue;
    private Properties m_props;
    private EjbConnectionManager m_ejbConnectionManager;
    private Log log = LogFactory.getLog(TransferLogManager.class);

    public TransferLogManager(EjbConnectionManager ejbConnectionManager, SendQueue sendQueue, Properties props) {
        this.m_ejbConnectionManager = ejbConnectionManager;
        this.m_sendQueue = sendQueue;
        this.m_props = props;
        this.m_runTransferLog = new Hashtable();
    }

    public void removeTransferLogInfo(String facilityId) {
        HashSet<String> keySet = new HashSet<String>(this.m_runTransferLog.keySet());
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            int runInterval = Integer.MAX_VALUE;
            int existenceFlg = 0;
            String logName = (String)iter.next();
            LogThreadManageInfo info = this.m_runTransferLog.get(logName);
            if (info == null) continue;
            Iterator<LogTransferFileInfoFacility> iterator = info.iterator();
            while (iterator.hasNext()) {
                LogTransferFileInfoFacility logInfo = iterator.next();
                if (facilityId.equals(logInfo.getFacilityId())) {
                    info.remove((Object)logInfo);
                    continue;
                }
                int tmpRunInterval = logInfo.getRunInterval();
                if (tmpRunInterval < runInterval) {
                    runInterval = tmpRunInterval;
                }
                int tmpExistenceFlg = logInfo.getExistenceFlg();
                if (existenceFlg != 0) continue;
                existenceFlg = tmpExistenceFlg;
            }
            TransferLogThread thread = info.getThread();
            if (info.size() == 0) {
                thread.requestStop();
                this.m_runTransferLog.remove(logName);
                continue;
            }
            thread.setCondition(existenceFlg, runInterval);
        }
    }

    public void setTransferLogInfo(String facilityId, ArrayList<LogTransferFileInfo> loglist) {
        Iterator<LogTransferFileInfo> iter = loglist.iterator();
        while (iter.hasNext()) {
            TransferLogThread thread;
            LogThreadManageInfo logMnginfo;
            int runInterval = Integer.MAX_VALUE;
            int existenceFlg = 0;
            LogTransferFileInfo logInfo = iter.next();
            String filePath = logInfo.getFilePath();
            if (logInfo.getValid() == 0) {
                logMnginfo = this.m_runTransferLog.get(filePath);
                if (logMnginfo == null) continue;
                Iterator<LogTransferFileInfoFacility> iterator = logMnginfo.iterator();
                while (iterator.hasNext()) {
                    LogTransferFileInfoFacility logInfoFacility = iterator.next();
                    if (facilityId.equals(logInfoFacility.getFacilityId()) && logInfo.getTransferId().equals(logInfoFacility.getTransferId())) {
                        logMnginfo.remove((Object)logInfoFacility);
                        continue;
                    }
                    int tmpRunInterval = logInfoFacility.getRunInterval();
                    if (tmpRunInterval < runInterval) {
                        runInterval = tmpRunInterval;
                    }
                    int tmpExistenceFlg = logInfoFacility.getExistenceFlg();
                    if (existenceFlg != 0) continue;
                    existenceFlg = tmpExistenceFlg;
                }
                TransferLogThread thread2 = logMnginfo.getThread();
                if (logMnginfo.size() == 0) {
                    thread2.requestStop();
                    this.m_runTransferLog.remove(filePath);
                    continue;
                }
                thread2.setCondition(existenceFlg, runInterval);
                continue;
            }
            logMnginfo = this.m_runTransferLog.get(filePath);
            if (logMnginfo == null) {
                logMnginfo = new LogThreadManageInfo(filePath);
                String facilityPath = "";
                try {
                    RepositoryController repository = this.m_ejbConnectionManager.getRepositoryController();
                    facilityPath = repository.getFacilityPath(facilityId, null);
                }
                catch (Exception e) {
                    this.log.error((Object)("setTransferLogInfo(): \u30d5\u30a1\u30b7\u30ea\u30c6\u30a3\u30d1\u30b9\u53d6\u5f97\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + e.getMessage()));
                }
                logMnginfo.add(facilityId, facilityPath, logInfo);
                thread = new TransferLogThread(this, this.m_props, filePath, logInfo.getRunInterval(), logInfo.getExistenceFlg());
                thread.start();
                logMnginfo.setThread(thread);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("put " + filePath + " : "));
                    Iterator<LogTransferFileInfoFacility> itr = logMnginfo.iterator();
                    while (itr.hasNext()) {
                        LogTransferFileInfoFacility info = itr.next();
                        this.log.debug((Object)("  " + info.getTransferId() + ", " + info.getFacilityId() + ", " + info.getFacilityPath()));
                    }
                }
                this.m_runTransferLog.put(filePath, logMnginfo);
                continue;
            }
            runInterval = logInfo.getRunInterval();
            existenceFlg = logInfo.getExistenceFlg();
            boolean add = true;
            Iterator<LogTransferFileInfoFacility> iterator = logMnginfo.iterator();
            while (iterator.hasNext()) {
                int tmpRunInterval;
                LogTransferFileInfoFacility logInfoFacility = iterator.next();
                if (facilityId.equals(logInfoFacility.getFacilityId()) && logInfo.getTransferId().equals(logInfoFacility.getTransferId())) {
                    logInfoFacility.setExistenceFlg(logInfo.getExistenceFlg());
                    logInfoFacility.setRunInterval(logInfo.getRunInterval());
                    add = false;
                }
                if ((tmpRunInterval = logInfoFacility.getRunInterval()) < runInterval) {
                    runInterval = tmpRunInterval;
                }
                int tmpExistenceFlg = logInfoFacility.getExistenceFlg();
                if (existenceFlg != 0) continue;
                existenceFlg = tmpExistenceFlg;
            }
            if (add) {
                String facilityPath = "";
                try {
                    RepositoryController repository = this.m_ejbConnectionManager.getRepositoryController();
                    facilityPath = repository.getFacilityPath(facilityId, null);
                }
                catch (Exception e) {
                    this.log.error((Object)("setTransferLogInfo(): \u30d5\u30a1\u30b7\u30ea\u30c6\u30a3\u30d1\u30b9\u53d6\u5f97\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + e.getMessage()));
                }
                logMnginfo.add(facilityId, facilityPath, logInfo);
            }
            thread = logMnginfo.getThread();
            thread.setCondition(existenceFlg, runInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTransfer() {
        Hashtable<String, LogThreadManageInfo> hashtable = this.m_runTransferLog;
        synchronized (hashtable) {
            Set<String> keySet = this.m_runTransferLog.keySet();
            for (String filePath : keySet) {
                LogThreadManageInfo info = this.m_runTransferLog.get(filePath);
                if (info == null) continue;
                TransferLogThread thread = info.getThread();
                thread.requestStop();
            }
            this.m_runTransferLog.clear();
        }
    }

    public void sendMessage(String filePath, int priority, String app, String msgId, String msg, String msgOrg) {
        LogThreadManageInfo info = this.m_runTransferLog.get(filePath);
        if (info == null) {
            this.log.error((Object)(filePath + "\u30a8\u30e9\u30fc\u767a\u751f\u9001\u4fe1\u5931\u6557"));
            return;
        }
        LogOutputInfo logOutput = new LogOutputInfo();
        logOutput.setPluginId("LOGAGENT");
        logOutput.setPriority(priority);
        logOutput.setApplication(app);
        logOutput.setMessageId(msgId);
        logOutput.setMessage(msg);
        logOutput.setMessageOrg(msgOrg);
        logOutput.setConfirmFlg(0);
        logOutput.setGenerationDate(new Date());
        logOutput.setEventLogFlg(true);
        logOutput.setStatusInfoFlg(false);
        Iterator<LogTransferFileInfoFacility> iter = info.iterator();
        while (iter.hasNext()) {
            LogTransferFileInfoFacility logInfo = iter.next();
            logOutput.setMonitorId(logInfo.getTransferId());
            logOutput.setFacilityId(logInfo.getFacilityId());
            logOutput.setScopeText(logInfo.getFacilityPath());
            this.m_sendQueue.put(logOutput);
        }
    }

    class LogTransferFileInfoFacility
    extends LogTransferFileInfo {
        private static final long serialVersionUID = 1L;
        String m_facilityId;
        String m_facilityPath;
        LogTransferFileInfo m_fileInfo;

        public LogTransferFileInfoFacility(String facilityId, String facilityPath, LogTransferFileInfo fileInfo) {
            this.m_facilityId = facilityId;
            this.m_facilityPath = facilityPath;
            this.m_fileInfo = fileInfo;
        }

        public int getExistenceFlg() {
            return this.m_fileInfo.getExistenceFlg();
        }

        public String getFilePath() {
            return this.m_fileInfo.getFilePath();
        }

        public int getRunInterval() {
            return this.m_fileInfo.getRunInterval();
        }

        public String getTransferId() {
            return this.m_fileInfo.getTransferId();
        }

        public int getValid() {
            return this.m_fileInfo.getValid();
        }

        public void setExistenceFlg(int arg0) {
            this.m_fileInfo.setExistenceFlg(arg0);
        }

        public void setFilePath(String arg0) {
            this.m_fileInfo.setFilePath(arg0);
        }

        public void setRunInterval(int arg0) {
            this.m_fileInfo.setRunInterval(arg0);
        }

        public void setTransferId(String arg0) {
            this.m_fileInfo.setTransferId(arg0);
        }

        public void setValid(int arg0) {
            this.m_fileInfo.setValid(arg0);
        }

        public String getFacilityId() {
            return this.m_facilityId;
        }

        public String getFacilityPath() {
            return this.m_facilityPath;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LogThreadManageInfo {
        String m_logName;
        TransferLogThread m_thread;
        CopyOnWriteArrayList<LogTransferFileInfoFacility> m_logInfoList;

        public String getLogName() {
            return this.m_logName;
        }

        public TransferLogThread getThread() {
            return this.m_thread;
        }

        public LogThreadManageInfo(String logName) {
            this.m_logName = logName;
            this.m_logInfoList = new CopyOnWriteArrayList();
        }

        public int size() {
            return this.m_logInfoList.size();
        }

        public void setLogInfoList(CopyOnWriteArrayList<LogTransferFileInfoFacility> logInfoList) {
            this.m_logInfoList = logInfoList;
        }

        public void setThread(TransferLogThread thread) {
            this.m_thread = thread;
        }

        public boolean add(String facilityId, String facilityPath, LogTransferFileInfo fileInfo) {
            return this.m_logInfoList.add(new LogTransferFileInfoFacility(facilityId, facilityPath, fileInfo));
        }

        public Iterator<LogTransferFileInfoFacility> iterator() {
            return this.m_logInfoList.iterator();
        }

        public boolean remove(Object arg0) {
            return this.m_logInfoList.remove(arg0);
        }
    }
}

