/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop.rmi;

import org.jboss.iiop.rmi.ClassAnalysis;

public class PrimitiveAnalysis
extends ClassAnalysis {
    public static PrimitiveAnalysis voidAnalysis = new PrimitiveAnalysis(Void.TYPE, "void", "void");
    public static PrimitiveAnalysis booleanAnalysis = new PrimitiveAnalysis(Boolean.TYPE, "boolean", "boolean");
    public static PrimitiveAnalysis charAnalysis = new PrimitiveAnalysis(Character.TYPE, "wchar", "char");
    public static PrimitiveAnalysis byteAnalysis = new PrimitiveAnalysis(Byte.TYPE, "octet", "byte");
    public static PrimitiveAnalysis shortAnalysis = new PrimitiveAnalysis(Short.TYPE, "short", "short");
    public static PrimitiveAnalysis intAnalysis = new PrimitiveAnalysis(Integer.TYPE, "long", "int");
    public static PrimitiveAnalysis longAnalysis = new PrimitiveAnalysis(Long.TYPE, "long_long", "long");
    public static PrimitiveAnalysis floatAnalysis = new PrimitiveAnalysis(Float.TYPE, "float", "float");
    public static PrimitiveAnalysis doubleAnalysis = new PrimitiveAnalysis(Double.TYPE, "double", "double");

    public static PrimitiveAnalysis getPrimitiveAnalysis(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("Null class");
        }
        if (cls == Void.TYPE) {
            return voidAnalysis;
        }
        if (cls == Boolean.TYPE) {
            return booleanAnalysis;
        }
        if (cls == Character.TYPE) {
            return charAnalysis;
        }
        if (cls == Byte.TYPE) {
            return byteAnalysis;
        }
        if (cls == Short.TYPE) {
            return shortAnalysis;
        }
        if (cls == Integer.TYPE) {
            return intAnalysis;
        }
        if (cls == Long.TYPE) {
            return longAnalysis;
        }
        if (cls == Float.TYPE) {
            return floatAnalysis;
        }
        if (cls == Double.TYPE) {
            return doubleAnalysis;
        }
        throw new IllegalArgumentException("Not a primitive type: " + cls.getName());
    }

    private PrimitiveAnalysis(Class cls, String idlName, String javaName) {
        super(cls, idlName, javaName);
    }
}

